/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.impl.IQUsageVersions;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMRBriefInformationMap
extends Metadata
implements BriefInformationMap,
MultiLocaleProperties {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = IQUsageVersions.VERSION_ZERO;
    public static final UsageVersion CURRENT_VERSION = IQUsageVersions.CURRENT_VERSION;
    private Transformation _transform;
    private InformationMapImpl2 _infoMap;
    private boolean _isLocalizationActive = false;
    private static final Logger _logger = LogManager.getLogger(OMRBriefInformationMap.class);

    public OMRBriefInformationMap() throws RemoteException {
    }

    public OMRBriefInformationMap(Transformation o) throws RemoteException {
        super((Object)o);
        this._transform = o;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRBriefInformationMap(TransformationImpl o) throws RemoteException {
        super((Object)o);
        this._transform = o;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRBriefInformationMap(TransformationImpl_Stub o) throws RemoteException {
        super((Object)o);
        this._transform = o;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public MetadataInterface copyTo(FolderInterface folder, String name) throws ServiceException, RemoteException {
        MetadataInterface mi;
        this.checkPulse(true);
        if (!this.isCompatible()) {
            this.versionNotCompatible();
        }
        if (!((mi = super.copyTo(folder, name)) instanceof OMRBriefInformationMap)) {
            Object[] args = new Object[]{mi == null ? "null" : mi.getClass().getName()};
            String msg = IQMetadataResourceBundle.getMessageString("OMRBriefInformationMap.CopiedObjectIsWrongType.fmt.txt", args);
            throw new ServiceException(msg);
        }
        OMRBriefInformationMap newBriefInfoMap = (OMRBriefInformationMap)mi;
        Transformation toTransform = newBriefInfoMap._transform;
        try {
            Transformation fromTransform = this._transform;
            List<TextStore> associationList = AssociationListUtil.filteredSnapshot(fromTransform.getSourceCodes(true), TextStore.class);
            if (associationList.size() > 0) {
                TextStore fromTextStore = associationList.get(0);
                RepositoryInterface repos = newBriefInfoMap.getRepository();
                MetadataInterface smartObject = repos.newMetadata((String)null, name, "TextStore");
                TextStore toTextStore = (TextStore)smartObject.getRepositoryEntity();
                toTextStore.setStoredText(fromTextStore.getStoredText());
                toTransform.setSourceCode((Text)toTextStore);
            }
            AssociationList transformationSources = fromTransform.getTransformationSources(true);
            toTransform.setTransformationSources(transformationSources);
        }
        catch (MdException e) {
            _logger.error("", (Throwable)e);
            throw new ServiceException((Throwable)e, null);
        }
        return newBriefInfoMap;
    }

    private void versionNotCompatible() throws VersionIncompatibleException {
        String name = "";
        try {
            name = this.getName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (_logger.isDebugEnabled()) {
            Object version = null;
            try {
                this.getUsageVersion();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            _logger.debug("Tried to operate on map named " + name + " but failed because it is version " + version + " and tried using it with software that recognizes version " + CURRENT_VERSION);
        }
        String msg = IQMetadataResourceBundle.getMessageString("OMRBriefInformationMap.SavedWithMoreRecentSoftware.fmt.txt", name);
        throw new VersionIncompatibleException(msg);
    }

    public String getType() throws RemoteException {
        this.checkPulse(true);
        String outType = this._transform == null ? "InformationMap" : (this.isOLAP() ? "InformationMap.OLAP" : "InformationMap.Relational");
        return outType;
    }

    public void delete() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this.isCompatible()) {
            this.versionNotCompatible();
        }
        if (this._transform == null) {
            super.delete();
        } else {
            try {
                ArrayList<Text> omrObjectsToDelete = new ArrayList<Text>();
                Text text = this._transform.getSourceCode();
                if (text != null) {
                    omrObjectsToDelete.add(text);
                }
                OMIRepositoryInterface repos = (OMIRepositoryInterface)this.getRepository();
                super.delete();
                repos.deleteEntities(omrObjectsToDelete);
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e, null);
            }
        }
    }

    public void superDelete() throws ServiceException, RemoteException {
    }

    @Override
    public StructureOfData getStructure() throws ServiceException, RemoteException {
        this.checkPulse(true);
        boolean olap = this.isOLAP();
        StructureOfData structure = new StructureOfData();
        structure.setIsRelational(!olap);
        structure.setIsOLAP(olap);
        return structure;
    }

    private boolean isOLAP() throws RemoteException {
        String publicType = this._transform.getPublicType();
        return "InformationMap.OLAP".equals(publicType);
    }

    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        UsageVersion usageVersion = this.getUsageVersion();
        if (usageVersion.compareTo((Object)IQUsageVersions.INFOMAP_UPGRADE_VERSION) < 0) {
            try {
                FolderInterface OwningFolder;
                HashMap<String, String> saveOptions;
                InformationMap map;
                block8: {
                    SessionContextInterface session = this._repository.getUserContext().getSessionContext();
                    map = InformationMapFactory.getInstance().newInformationMap(session, IntelligentQueryMetadataServiceFactory.newService(), this);
                    saveOptions = new HashMap<String, String>(3);
                    saveOptions.put("AllowMajorVersionIncrease", "true");
                    saveOptions.put("AllowMinorVersionIncrease", "true");
                    OwningFolder = null;
                    try {
                        OwningFolder = this.getParent();
                    }
                    catch (ServiceException e) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Problem getting parent folder for map " + map.getLabel() + " during upgrade from version " + usageVersion);
                        }
                    }
                    catch (RemoteException e) {
                        if (!_logger.isDebugEnabled()) break block8;
                        _logger.debug("Problem getting parent folder for map " + map.getLabel() + " during upgrade from version " + usageVersion);
                    }
                }
                if (OwningFolder == null) {
                    OwningFolder = FolderUtil.makeSharedDataFolder((MetadataInterface)this);
                    this.validateNameAndFolder(OwningFolder);
                }
                map.save(OwningFolder, "Version upgrade", saveOptions);
            }
            catch (MetadataException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    @Override
    public FolderInterface getOwningFolder() throws ServiceException, RemoteException {
        this.checkPulse(true);
        FolderInterface folder = null;
        Transformation t = (Transformation)this.getRepositoryEntity();
        try {
            t.getTrees(true);
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        List parentFolders = this.getParents();
        this.getContainer();
        if (parentFolders.size() != 1) {
            String reasonMsg = IQMetadataResourceBundle.getMessageString("InformationMapImpl2.NotExactlyOneFolderContainingMap.fmt.txt", Integer.toString(parentFolders.size()));
            throw new ServiceException(reasonMsg);
        }
        folder = (FolderInterface)parentFolders.get(0);
        return folder;
    }

    private void initializeInformationMap() {
        try {
            if (this._infoMap == null) {
                SessionContextInterface session = this._repository.getUserContext().getSessionContext();
                this._infoMap = (InformationMapImpl2)InformationMapFactory.getInstance().newInformationMap(session, IntelligentQueryMetadataServiceFactory.newService(), this);
            }
        }
        catch (RemoteException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        catch (MetadataException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        this.initializeInformationMap();
        this._isLocalizationActive = true;
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        this.initializeInformationMap();
        list = this._infoMap.getLocalizableProperties(locale);
        return list;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        if (this._isLocalizationActive) {
            this._infoMap.setLocalizableProperties(locale, map);
        } else {
            this.initializeInformationMap();
            this._infoMap.setLocalizableProperties(locale, map);
            this.endLocalization();
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getLocalizableProperties(null);
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setLocalizableProperties(null, map);
    }

    public Collection<Locale> getLocales() {
        this.initializeInformationMap();
        return this._infoMap.getLocales();
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        try {
            this._infoMap.save("Saved with Multi Locale Properties");
            this._isLocalizationActive = false;
        }
        catch (MetadataException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        finally {
            this._infoMap.dispose();
            this._infoMap = null;
        }
    }
}

