/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ChangeHistoryItem;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.iquery.metadata.business.LookupList;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.iquery.metadata.business.LookupValue;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.BusinessModelReferenceInfoImpl;
import com.sas.iquery.metadata.business.impl.CompoundFilterImpl;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.business.impl.DataItemReferenceImpl;
import com.sas.iquery.metadata.business.impl.DataSourceCubeImpl;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.DrillThroughToDetailImpl;
import com.sas.iquery.metadata.business.impl.FilterItemImpl;
import com.sas.iquery.metadata.business.impl.FilterSetImpl;
import com.sas.iquery.metadata.business.impl.FilterSetRuleItemsImpl;
import com.sas.iquery.metadata.business.impl.FilterSetRulesImpl;
import com.sas.iquery.metadata.business.impl.GoverningImpl;
import com.sas.iquery.metadata.business.impl.GroupImpl;
import com.sas.iquery.metadata.business.impl.JoinImpl;
import com.sas.iquery.metadata.business.impl.MapFolderImpl;
import com.sas.iquery.metadata.business.impl.PromptImpl;
import com.sas.iquery.metadata.business.impl.QualifiedColumnImpl;
import com.sas.iquery.metadata.business.impl.QualifiedLevelImpl;
import com.sas.iquery.metadata.business.impl.RequiredDataSourcesImpl;
import com.sas.iquery.metadata.business.impl.RunStoredProcessImpl;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.DateValueExpression;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.TimeValueExpression;
import com.sas.iquery.metadata.expr.TimestampValueExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression_Between;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.RelativeDateValueExpression;
import com.sas.iquery.metadata.expr.relational.RelativeTimestampValueExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.impl.XML;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMeasure;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMember;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.metadata.physical.oma.OMADatabaseSchema;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.metadata.physical.oma.OMALevel;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.metadata.physical.oma.OMANamedSet;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASASOlapServer;
import com.sas.iquery.metadata.physical.oma.OMASASWorkspaceServer;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.util.impl.MessageFormatter;
import java.lang.reflect.Field;
import java.util.HashMap;

public final class ModelItemReadFactory {
    private static final ModelItemReadFactory factorySingleton = new ModelItemReadFactory();
    private static final int CHANGE_HISTORY_ITEM = 0;
    private static final int COMPOUND_FILTER = 1;
    private static final int DATA_ITEM = 2;
    private static final int DATA_ITEM_REFERENCE = 3;
    private static final int DATA_SOURCE_CUBE = 4;
    private static final int DATA_SOURCE_TABLE = 5;
    private static final int DRILL_THROUGH_TO_DETAIL = 6;
    private static final int FILTER_ITEM = 7;
    private static final int GOVERNING = 8;
    private static final int JOIN = 9;
    private static final int LOOKUP_BY_DATA_ITEM = 10;
    private static final int LOOKUP_LIST = 11;
    private static final int LOOKUP_NOT_ALLOWED = 12;
    private static final int LOOKUP_VALUE = 13;
    private static final int MAP_FOLDER = 14;
    private static final int PROMPT = 15;
    private static final int QUALIFIED_COLUMN = 16;
    private static final int QUALIFIED_LEVEL = 17;
    private static final int RUN_STORED_PROCESS = 18;
    private static final int OMA_COLUMN = 19;
    private static final int OMA_SAS_LIBRARY = 20;
    private static final int OMA_DATABASE_SCHEMA = 21;
    private static final int OMA_SAS_WORKSPACE_SERVER = 22;
    private static final int OMA_TABLE = 23;
    private static final int OMA_SAS_OLAP_SERVER = 24;
    private static final int OMA_OLAP_SCHEMA = 25;
    private static final int OMA_CUBE = 26;
    private static final int OMA_DIMENSION = 27;
    private static final int OMA_HIERARCHY = 28;
    private static final int OMA_LEVEL = 29;
    private static final int OMA_MEASURE = 30;
    private static final int OMA_CALCULATED_MEASURE = 31;
    private static final int JFS_STORED_PROCESS = 32;
    private static final int EXPR_COMPOUND_CONDITIONAL = 33;
    private static final int EXPR_CONSTANT = 34;
    private static final int EXPR_DATE_VALUE = 35;
    private static final int EXPR_TIME_VALUE = 36;
    private static final int EXPR_TIMESTAMP_VALUE = 37;
    private static final int EXPR_FRACTION_OF_TOTAL = 38;
    private static final int EXPR_FUNCTION_CALL = 39;
    private static final int EXPR_MULTIPLE_CONDITIONAL = 40;
    private static final int EXPR_RASE = 41;
    private static final int EXPR_STRING_EXPRESSION = 42;
    private static final int OLAPEXPR_DATA_BASED_FILTER_BETWEEN = 43;
    private static final int OLAPEXPR_DATA_BASED_FILTER = 44;
    private static final int OLAPEXPR_MEMBER_FILTER = 45;
    private static final int RELEXPR_BETWEEN = 46;
    private static final int RELEXPR_COMPARISON = 47;
    private static final int RELEXPR_CONTAINS = 48;
    private static final int RELEXPR_IN = 49;
    private static final int RELEXPR_LIKE = 50;
    private static final int RELEXPR_TEST_FOR_NULL = 51;
    private static final int INMEMORY_TABLE = 52;
    private static final int INMEMORY_COLUMN = 53;
    private static final int BUSINESS_MODEL_REFERENCE_INFO = 54;
    private static final int RELATIONAL_DATA_ITEM_RANK_FILTER = 55;
    private static final int OLAP_BUSINESS_QUERY_DATA_BASED_FILTER = 56;
    private static final int OLAP_BUSINESS_QUERY_RANK_FILTER = 57;
    private static final int OLAP_DATA_ITEM_DATA_BASED_FILTER = 58;
    private static final int OLAP_DATA_ITEM_MEMBER_FILTER = 59;
    private static final int OLAP_DATA_ITEM_MEMBER_PROPERTIES_FILTER = 60;
    private static final int OLAP_DATA_ITEM_NAVIGATION_FILTER = 61;
    private static final int OLAP_DATA_ITEM_RANK_FILTER = 62;
    private static final int OLAP_DATA_ITEM_TIME_FIRST_LAST_PERIODS_FILTER = 63;
    private static final int OLAP_DATA_ITEM_TIME_NPARALLEL_PERIODS_FILTER = 64;
    private static final int OLAP_DATA_ITEM_TIME_NPERIODS_FILTER = 65;
    private static final int OLAP_DATA_ITEM_TIME_RANGE_FILTER = 66;
    private static final int OLAP_COMPOUND_STEP = 67;
    private static final int CONDITIONAL_EXPR_ADAPTER = 68;
    private static final int DATA_ITEM_FORMATTING_EXPRESSION = 69;
    private static final int RELATIVE_DATE_VALUE_EXPRESSION = 70;
    private static final int TIME_FIRST_LAST_PERIODS_FILTER_EXP = 71;
    private static final int TIME_N_PARELLEL_PERIODS_FILTER_EXP = 72;
    private static final int TIME_N_PERIODS_FILTER_EXP = 73;
    private static final int TIME_RANGE_FILTER_EXP = 74;
    private static final int OLAP_TIME_MEASURE = 75;
    private static final int RELATIVE_TIMESTAMP_VALUE_EXPRESSION = 76;
    private static final int REQUIRED_DATASOURCES = 77;
    private static final int FILTER_SET = 78;
    private static final int FILTERSET_RULES = 79;
    private static final int FILTERSETRULE_ITEMS = 80;
    private static final int OMA_CALCULATED_MEMBER = 81;
    private static final int OMA_NAMED_SET = 82;
    private static final int BUSINESS_GROUP_ITEM = 83;
    private static final HashMap<String, Integer> ITEM_ELEMENT_TO_SWITCH_VALUE = new HashMap(150);

    private ModelItemReadFactory() {
    }

    public static ModelItemReadFactory getInstance() {
        return factorySingleton;
    }

    public AbstractModelItem newItem(String elementName) throws MetadataException {
        return ModelItemReadFactory.pvtStaticNewItem(elementName);
    }

    private static AbstractModelItem pvtStaticNewItem(String elementName) throws MetadataException {
        Integer indexObj = ITEM_ELEMENT_TO_SWITCH_VALUE.get(elementName);
        if (indexObj == null) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("ModelItemReadFactory.UnrecognizedXML.fmt.txt", elementName);
            throw new MetadataException(errorMsg);
        }
        AbstractModelItem out = null;
        int switchValue = indexObj;
        switch (switchValue) {
            case 0: {
                out = new ChangeHistoryItem();
                break;
            }
            case 1: {
                out = new CompoundFilterImpl();
                break;
            }
            case 2: {
                out = new DataItemImpl();
                break;
            }
            case 3: {
                out = new DataItemReferenceImpl();
                break;
            }
            case 4: {
                out = new DataSourceCubeImpl();
                break;
            }
            case 5: {
                out = new DataSourceTableImpl2();
                break;
            }
            case 6: {
                out = new DrillThroughToDetailImpl();
                break;
            }
            case 7: {
                out = new FilterItemImpl();
                break;
            }
            case 8: {
                out = new GoverningImpl();
                break;
            }
            case 9: {
                out = new JoinImpl();
                break;
            }
            case 10: {
                out = LookupByDataItem.VALUE;
                break;
            }
            case 11: {
                out = new LookupList();
                break;
            }
            case 12: {
                out = new LookupNotAllowed();
                break;
            }
            case 13: {
                out = new LookupValue();
                break;
            }
            case 14: {
                out = new MapFolderImpl();
                break;
            }
            case 15: {
                out = new PromptImpl();
                break;
            }
            case 16: {
                out = new QualifiedColumnImpl();
                break;
            }
            case 17: {
                out = new QualifiedLevelImpl();
                break;
            }
            case 18: {
                out = new RunStoredProcessImpl();
                break;
            }
            case 19: {
                out = new OMAColumn();
                break;
            }
            case 20: {
                out = new OMASASLibrary();
                break;
            }
            case 21: {
                out = new OMADatabaseSchema();
                break;
            }
            case 22: {
                out = new OMASASWorkspaceServer();
                break;
            }
            case 23: {
                out = new OMATable();
                break;
            }
            case 24: {
                out = new OMASASOlapServer();
                break;
            }
            case 25: {
                out = new OMAOlapSchema();
                break;
            }
            case 26: {
                out = new OMACube();
                break;
            }
            case 27: {
                out = new OMADimension();
                break;
            }
            case 28: {
                out = new OMAHierarchy();
                break;
            }
            case 29: {
                out = new OMALevel();
                break;
            }
            case 30: {
                out = new OMAMeasure();
                break;
            }
            case 31: {
                out = new OMACalculatedMeasure();
                break;
            }
            case 81: {
                out = new OMACalculatedMember();
                break;
            }
            case 82: {
                out = new OMANamedSet();
                break;
            }
            case 32: {
                out = new JFSStoredProcess();
                break;
            }
            case 33: {
                out = new CompoundConditionalExpression();
                break;
            }
            case 34: {
                out = new ConstantExpression();
                break;
            }
            case 35: {
                out = new DateValueExpression();
                break;
            }
            case 36: {
                out = new TimeValueExpression();
                break;
            }
            case 37: {
                out = new TimestampValueExpression();
                break;
            }
            case 38: {
                out = new FractionOfTotalExpression();
                break;
            }
            case 39: {
                out = new FunctionCall();
                break;
            }
            case 40: {
                out = new MultipleConditionalExpression();
                break;
            }
            case 41: {
                out = new ResourceAwareStringExpression();
                break;
            }
            case 42: {
                out = new StringExpression();
                break;
            }
            case 43: {
                out = new DataBasedFilterExpression_Between();
                break;
            }
            case 44: {
                out = new DataBasedFilterExpression();
                break;
            }
            case 45: {
                out = new MemberFilterExpression();
                break;
            }
            case 46: {
                out = new SimpleConditionalExpression_Between();
                break;
            }
            case 47: {
                out = new SimpleConditionalExpression_Comparison();
                break;
            }
            case 48: {
                out = new SimpleConditionalExpression_Contains();
                break;
            }
            case 49: {
                out = new SimpleConditionalExpression_In();
                break;
            }
            case 50: {
                out = new SimpleConditionalExpression_Like();
                break;
            }
            case 51: {
                out = new SimpleConditionalExpression_TestForNull();
                break;
            }
            case 52: {
                out = new InMemoryTable();
                break;
            }
            case 53: {
                out = new InMemoryColumn();
                break;
            }
            case 54: {
                out = new BusinessModelReferenceInfoImpl();
                break;
            }
            case 55: {
                out = new DataItemRankFilter();
                break;
            }
            case 56: {
                out = new BusinessQueryDataBasedFilter();
                break;
            }
            case 57: {
                out = new BusinessQueryRankFilter();
                break;
            }
            case 58: {
                out = new DataItemDataBasedFilter();
                break;
            }
            case 59: {
                out = new DataItemMemberFilter();
                break;
            }
            case 60: {
                out = new DataItemMemberPropertiesFilter();
                break;
            }
            case 61: {
                out = new DataItemNavigationFilter();
                break;
            }
            case 62: {
                out = new com.sas.iquery.metadata.business.step.olap.DataItemRankFilter();
                break;
            }
            case 63: {
                out = new DataItemTimeFirstLastPeriodsFilter();
                break;
            }
            case 64: {
                out = new DataItemTimeNParallelPeriodsFilter();
                break;
            }
            case 65: {
                out = new DataItemTimeNPeriodsFilter();
                break;
            }
            case 66: {
                out = new DataItemTimeRangeFilter();
                break;
            }
            case 67: {
                out = new CompoundStep();
                break;
            }
            case 68: {
                out = new ConditionalExpressionAdapter();
                break;
            }
            case 69: {
                out = new DataItemFormattingExpression();
                break;
            }
            case 70: {
                out = new RelativeDateValueExpression();
                break;
            }
            case 76: {
                out = new RelativeTimestampValueExpression();
                break;
            }
            case 71: {
                out = new TimeFilterFirstLastPeriodsExpression();
                break;
            }
            case 72: {
                out = new TimeFilterNParallelPeriodsExpression();
                break;
            }
            case 73: {
                out = new TimeFilterNPeriodsExpression();
                break;
            }
            case 74: {
                out = new TimeRangeFilterExpression();
                break;
            }
            case 75: {
                out = new TimeExpressionMeasure();
                break;
            }
            case 77: {
                out = new RequiredDataSourcesImpl();
                break;
            }
            case 78: {
                out = new FilterSetImpl();
                break;
            }
            case 79: {
                out = new FilterSetRulesImpl();
                break;
            }
            case 80: {
                out = new FilterSetRuleItemsImpl();
                break;
            }
            case 83: {
                out = new GroupImpl();
                break;
            }
            default: {
                throw new IQueryServicesRuntimeException("Code bug in ModelItemReadFactory.  No logic for creating a model item for the element named \"" + elementName + "\" (switchValue=" + switchValue + ")");
            }
        }
        return out;
    }

    private static void verifyFactoryIntegrity() {
        int min = Integer.MAX_VALUE;
        int max = 0;
        HashMap<Integer, Integer> tempMap = new HashMap<Integer, Integer>(ITEM_ELEMENT_TO_SWITCH_VALUE.size() * 2);
        for (Integer valueObject : ITEM_ELEMENT_TO_SWITCH_VALUE.values()) {
            int value = valueObject;
            if (value < 0) {
                throw new IQueryServicesRuntimeException("Code bug in ModelItemReadFactory:  All switch values must be non-negative.  Found: " + value);
            }
            min = Math.min(value, min);
            max = Math.max(value, max);
            Integer previousKey = tempMap.put(valueObject, valueObject);
            if (previousKey == null) continue;
            throw new IQueryServicesRuntimeException("IQ code bug in the ModelItemReadFactory class:  More than one element name is mapped to the same integer value.  The integer value is: " + valueObject);
        }
        int span = max - min + 1;
        if (min != 0 || span != ITEM_ELEMENT_TO_SWITCH_VALUE.size()) {
            throw new IQueryServicesRuntimeException("IQ code bug in the ModelItemReadFactory class:  All switch values are not contiguous starting with 0.");
        }
        Field[] fields = XML.class.getDeclaredFields();
        int count = 0;
        for (int i = 0; i < fields.length; ++i) {
            Class<?> c;
            Field field = fields[i];
            String fieldName = field.getName();
            if (fieldName == null || !fieldName.startsWith("ITEM_ELEMENT_") || (c = field.getType()) == null || !c.equals(String.class)) continue;
            ++count;
            String elementName = null;
            try {
                elementName = (String)field.get(null);
            }
            catch (NullPointerException e) {
                MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IQueryMetadata.ReflectionStaticDeclarationFail.fmt.txt", field.getName());
                throw new IQueryServicesRuntimeException(formatter, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IQueryMetadata.ReflectionIllegalAccessFail.fmt.txt", field.getName());
                throw new IQueryServicesRuntimeException(formatter, (Throwable)e);
            }
            if (ITEM_ELEMENT_TO_SWITCH_VALUE.containsKey(elementName)) continue;
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IQueryMetadata.NameToIndexMappingMissing.fmt.txt", elementName, ModelItemReadFactory.class.getName());
            throw new IQueryServicesRuntimeException(formatter);
        }
        if (count == 0) {
            throw new IQueryServicesRuntimeException("Code bug in ModelItemReadFactory: integrity checking did not occur.");
        }
    }

    static {
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ChangeHistoryItem", 0);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("CompoundFilter", 1);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItem", 2);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemReference", 3);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataSourceCube", 4);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataSourceTable", 5);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DrillThroughToDetail", 6);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Filter", 7);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Governing", 8);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Join", 9);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("LookupByDataItem", 10);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("LookupList", 11);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("LookupNotAllowed", 12);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("LookupValue", 13);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("MapFolder", 14);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Prompt", 15);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("QualifiedColumn", 16);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("QualifiedLevel", 17);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("RunStoredProcess", 18);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposCalculatedMeasure", 31);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposColumn", 19);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposCube", 26);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposDatabaseSchema", 21);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposDimension", 27);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposHierarchy", 28);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposOlapSchema", 25);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposLevel", 29);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposMeasure", 30);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposSASLibrary", 20);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposSASOlapServer", 24);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposWorkspaceServer", 22);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposTable", 23);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("MetadataResourceStoredProcess", 32);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("InMemoryTable", 52);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("InMemoryColumn", 53);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("CompoundCond", 33);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Const", 34);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DateValueExpression", 35);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("TimeValueExpression", 36);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("TimestampValueExpression", 37);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("FractionOfTotalExpression", 38);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("TimeExpressionMeasure", 75);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("FtnCall", 39);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("MultipleCond", 40);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ResourceAwareStrExpr", 41);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("StrExpr", 42);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("OLAPBetweenExpr", 43);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataBasedFilterExp", 44);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("MemberFilterExp", 45);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Between", 46);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Compare", 47);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ContainsExpr", 48);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("In", 49);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("LikeExpr", 50);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("NullTest", 51);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("BusinessModelReferenceInformation", 54);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemRelationalRankFilter", 55);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("BusinessQueryDataBasedFilter", 56);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("BusinessQueryRankFilter", 57);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemDataBasedFilter", 58);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemMemberFilter", 59);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemMemberPropertiesFilter", 60);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemNavigationFilter", 61);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemOLAPRankFilter", 62);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemTimeFirstLastPeriodsFilter", 63);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemTimeNParallelPeriodsFilter", 64);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemTimeNPeriodsFilter", 65);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemTimeRangeFilter", 66);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("CompoundStep", 67);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ConditionalExprAdapter", 68);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("DataItemFormattingExpr", 69);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("RelativeDateValueExpr", 70);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("RelativeTimestampValueExpr", 76);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("TimeFirstLastPeriodsFilterExp", 71);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("TimeNParallelPeriodsFilterExp", 72);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("TimeNPeriodsFilterExp", 73);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("TimeRangeFilterExp", 74);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("RequiredDataSources", 77);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("FilterSet", 78);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("FilterSetRules", 79);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("FilterSetRuleItems", 80);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposCalculatedMember", 81);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("ReposNamedSet", 82);
        ITEM_ELEMENT_TO_SWITCH_VALUE.put("Group", 83);
        ModelItemReadFactory.verifyFactoryIntegrity();
    }
}

