/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl;

import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.EntityInterface;
import com.sas.entities.persist.EntityPersistenceUtility;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractEnumerationObject;
import com.sas.iquery.metadata.business.impl.CommaSeparatedString;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.FormatterExpressionizer;
import com.sas.iquery.metadata.expr.iqtextparser.FormatterFactory;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParser;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.impl.ObjectUtilities;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.metadata.serverprop.ParameterType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepository;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.InformationMapPathFilter;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathFilter;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IQModelImplUtilities {
    public static final boolean DEBUG_COMPILE_TIME_SWITCH = false;
    public static final String EMPTY_STRING = "";
    public static final String DOCUMENT_HEADER = "<?xml version='1.0' encoding='UTF-8'?>";
    private static final String LINE_END = "\n";
    private static final Logger _logger = LogManager.getLogger(IQModelImplUtilities.class);
    private static final Logger _persistLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist");
    private static final Logger _perfMSLogger = LogManager.getLogger((String)"com.sas.iquery.perf.MetadataServer");
    private static final String BOOLEAN_FALSE = "0";
    private static final String BOOLEAN_TRUE = "1";
    public static final String STR_EXP_TYPE_BOOLEAN = "boolean";
    public static final String STR_EXP_TYPE_CHARACTER = "char";
    public static final String STR_EXP_TYPE_NUMERIC = "numeric";
    public static final String STR_EXP_TYPE_DATE = "date";
    public static final String STR_EXP_TYPE_TIME = "time";
    public static final String STR_EXP_TYPE_TIMESTAMP = "timestamp";
    private static final String MULTI_VALUE_DELIMITER_TOKEN = ",next;";
    private static final String SPACE_CACHE = "                                                                                                      ";
    private static final String TAB_CACHE = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String LITERAL_LT = "<";
    private static final String LITERAL_GT = ">";
    private static final String ENCODED_AMPERSAND = "&amp;";
    private static final String ENCODED_LT = "&lt;";
    private static final String ENCODED_GT = "&gt;";
    private static final String ENCODED_SINGLE_QUOTE = "&apos;";
    private static final String ENCODED_DOUBLE_QUOTE = "&quot;";
    private static final Map<Integer, String> DEFAULT_FORMATS = new HashMap<Integer, String>();

    public static String getAttr(Element element, String attrName) {
        String outValue = null;
        Attr attrNode = element.getAttributeNode(attrName);
        if (attrNode != null) {
            outValue = attrNode.getValue();
        }
        return outValue;
    }

    public static String getAttrAndInternResult(Element element, String attrName) {
        String out = IQModelImplUtilities.getAttr(element, attrName);
        if (out != null) {
            out = out.intern();
        }
        return out;
    }

    public static int getIntAttr(Element element, String attrName, int defaultValue) {
        int outValue = defaultValue;
        String attrValue = IQModelImplUtilities.getAttr(element, attrName);
        if (attrValue != null) {
            try {
                outValue = Integer.parseInt(attrValue);
            }
            catch (NumberFormatException e) {
                IQModelImplUtilities.valueParsingError(element, attrName, attrValue);
            }
        }
        return outValue;
    }

    public static Long getLongAttr(Element element, String attrName) {
        Long outValue = null;
        String attrValue = IQModelImplUtilities.getAttr(element, attrName);
        if (attrValue != null) {
            try {
                long longValue = Long.parseLong(attrValue);
                outValue = longValue;
            }
            catch (NumberFormatException e) {
                IQModelImplUtilities.valueParsingError(element, attrName, attrValue);
            }
        }
        return outValue;
    }

    public static Double getDoubleAttr(Element element, String attrName) {
        Double outValue = null;
        String attrValue = IQModelImplUtilities.getAttr(element, attrName);
        if (attrValue != null) {
            try {
                double doubleValue = Double.parseDouble(attrValue);
                outValue = doubleValue;
            }
            catch (NumberFormatException e) {
                IQModelImplUtilities.valueParsingError(element, attrName, attrValue);
            }
        }
        return outValue;
    }

    public static boolean asBoolean(String attrValue, boolean defaultValue) throws SAXException {
        boolean outValue;
        if (attrValue == null) {
            outValue = defaultValue;
        } else if (attrValue.equals(BOOLEAN_TRUE)) {
            outValue = true;
        } else if (attrValue.equals(BOOLEAN_FALSE)) {
            outValue = false;
        } else {
            String msg = IQMetadataResourceBundle.getMessageString("IQModelImplUtilities.InvalidBooleanValue.fmt.txt", attrValue);
            throw new SAXException(msg);
        }
        return outValue;
    }

    public static int asInt(String attrValue, int defaultValue) throws SAXException {
        int outValue;
        try {
            outValue = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            String msg = IQMetadataResourceBundle.getMessageString("IQModelImplUtilities.InvalidIntegerValue.fmt.txt", attrValue);
            throw new SAXException(msg);
        }
        return outValue;
    }

    public static Date asTimestamp(String attrValue) throws SAXException {
        Date outValue = null;
        if (attrValue != null) {
            try {
                long longValue = Long.parseLong(attrValue);
                outValue = new Date(longValue);
            }
            catch (NumberFormatException e) {
                String msg = IQMetadataResourceBundle.getMessageString("IQModelImplUtilities.InvalidTimestampValue.fmt.txt", attrValue);
                throw new SAXException(msg);
            }
        }
        return outValue;
    }

    public static Boolean getBooleanAttr(Element element, String attrName) {
        Boolean outValue = null;
        String attrValue = IQModelImplUtilities.getAttr(element, attrName);
        if (attrValue != null) {
            if (attrValue.equals(BOOLEAN_TRUE)) {
                outValue = Boolean.TRUE;
            } else if (attrValue.equals(BOOLEAN_FALSE)) {
                outValue = Boolean.FALSE;
            } else {
                IQModelImplUtilities.valueParsingError(element, attrName, attrValue);
            }
        }
        return outValue;
    }

    public static boolean getBooleanAttr(Element element, String attrName, boolean defaultValue) {
        boolean outValue = defaultValue;
        Boolean value = IQModelImplUtilities.getBooleanAttr(element, attrName);
        if (value != null) {
            outValue = value;
        }
        return outValue;
    }

    public static Date getTimestampAttrV1(Element element, String attrName) {
        Date outValue = null;
        String attrValue = IQModelImplUtilities.getAttr(element, attrName);
        if (attrValue != null) {
            try {
                long longValue = Long.parseLong(attrValue);
                outValue = new Date(longValue);
            }
            catch (NumberFormatException e) {
                IQModelImplUtilities.valueParsingError(element, attrName, attrValue);
            }
        }
        return outValue;
    }

    public static EntityInterface getEntityAttr(Element element, String attrName) {
        EntityInterface entity;
        block2: {
            entity = null;
            try {
                String xmlEntity = IQModelImplUtilities.getAttr(element, attrName);
                entity = EntityPersistenceUtility.createEntityFromXML((String)xmlEntity);
            }
            catch (Exception entityException) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                String errMsg = IQModelImplUtilities.getMessage("EntityMsg.ErrorReadingEntity.txt", new Object[0]);
                _logger.error(errMsg, (Throwable)entityException);
            }
        }
        return entity;
    }

    public static boolean hasMeaningfulContent(EntityInterface entity) throws MetadataException {
        boolean out = false;
        try {
            if (entity != null) {
                AttributeDescriptor descriptor;
                AttributeDescriptorInterface[] attributeDescriptors = entity.getAttributeDescriptors();
                if (attributeDescriptors.length > 1) {
                    out = true;
                } else if (attributeDescriptors.length == 1 && !"entityKey".equalsIgnoreCase((descriptor = (AttributeDescriptor)attributeDescriptors[0]).getName())) {
                    out = true;
                }
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return out;
    }

    public static ModelVersion getModelVersionAttr(Element element, String attrName) {
        ModelVersion outValue = null;
        String attrValue = IQModelImplUtilities.getAttr(element, attrName);
        if (attrValue != null) {
            if ("5".equals(attrValue)) {
                outValue = ModelVersion.VERSION_912;
            } else {
                try {
                    outValue = new ModelVersion(attrValue);
                }
                catch (NumberFormatException e) {
                    IQModelImplUtilities.valueParsingError(element, attrName, attrValue);
                }
            }
        }
        return outValue;
    }

    private static void valueParsingError(Element element, String attrName, String attrValue) {
    }

    public static void setAttr(Element element, String attrName, String attrValue) {
        if (attrValue != null) {
            element.setAttribute(attrName, attrValue);
        }
    }

    public static void setAttrWithEmptyDefault(Element element, String attrName, String attrValue) {
        if (attrValue == null) {
            element.setAttribute(attrName, EMPTY_STRING);
        } else if (!EMPTY_STRING.equals(attrValue)) {
            element.setAttribute(attrName, attrValue);
        }
    }

    public static void setExpressionTypeAttr(Element element, String attrName, int attrValue) {
        if (attrValue == 9) {
            IQModelImplUtilities.setAttr(element, attrName, STR_EXP_TYPE_BOOLEAN);
        } else if (attrValue == 3) {
            IQModelImplUtilities.setAttr(element, attrName, STR_EXP_TYPE_CHARACTER);
        } else if (attrValue == 2) {
            IQModelImplUtilities.setAttr(element, attrName, STR_EXP_TYPE_NUMERIC);
        } else if (attrValue == 4) {
            IQModelImplUtilities.setAttr(element, attrName, STR_EXP_TYPE_DATE);
        } else if (attrValue == 5) {
            IQModelImplUtilities.setAttr(element, attrName, STR_EXP_TYPE_TIME);
        } else if (attrValue == 6) {
            IQModelImplUtilities.setAttr(element, attrName, STR_EXP_TYPE_TIMESTAMP);
        } else {
            IQModelImplUtilities.setIntAttr(element, attrName, attrValue);
        }
    }

    public static void setPrefixNAttrs(Element element, String prefix, String[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                IQModelImplUtilities.setAttr(element, prefix + (i + 1), value);
            }
        }
    }

    public static void setPrefixNAttrs(Element element, String prefix, List<String> values) {
        if (values != null) {
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String value = values.get(i);
                IQModelImplUtilities.setAttr(element, prefix + (i + 1), value);
            }
        }
    }

    public static void setIntAttr(Element element, String attrName, int attrValue) {
        IQModelImplUtilities.setAttr(element, attrName, Integer.toString(attrValue));
    }

    public static void setIntAttr(Element element, String attrName, int attrValue, int defaultPersistenceValue) {
        if (attrValue != defaultPersistenceValue) {
            IQModelImplUtilities.setAttr(element, attrName, Integer.toString(attrValue));
        }
    }

    public static void setLongAttr(Element element, String attrName, long attrValue) {
        IQModelImplUtilities.setAttr(element, attrName, Long.toString(attrValue));
    }

    public static void setDoubleAttr(Element element, String attrName, double attrValue) {
        IQModelImplUtilities.setAttr(element, attrName, Double.toString(attrValue));
    }

    public static void setBooleanAttr(Element element, String attrName, boolean attrValue) {
        IQModelImplUtilities.setAttr(element, attrName, attrValue ? BOOLEAN_TRUE : BOOLEAN_FALSE);
    }

    public static void setBooleanAttr(Element element, String attrName, boolean attrValue, boolean dontWriteValue) {
        if (attrValue != dontWriteValue) {
            IQModelImplUtilities.setBooleanAttr(element, attrName, attrValue);
        }
    }

    public static void setCharAttr(Element element, String attrName, Character attrValue) {
        if (attrValue != null) {
            IQModelImplUtilities.setAttr(element, attrName, attrValue.toString());
        }
    }

    public static void setCharAttr(Element element, String attrName, Character attrValue, Character defaultPersistenceValue) {
        if (!IQModelImplUtilities.same(attrValue, defaultPersistenceValue) && attrValue != null) {
            IQModelImplUtilities.setAttr(element, attrName, attrValue.toString());
        }
    }

    public static void setEntityAttr(Element element, String attrName, EntityInterface attrValue) {
        String xmlEntity = EntityPersistenceUtility.writeXMLToString((EntityInterface)attrValue, (boolean)true, (boolean)false);
        IQModelImplUtilities.setAttr(element, attrName, xmlEntity);
    }

    public static void setModelVersionAttr(Element element, String attrName, ModelVersion attrValue) {
        if (attrValue != null) {
            IQModelImplUtilities.setAttr(element, attrName, attrValue.toString());
        }
    }

    public static void setEnumAttr(Element element, String attrName, AbstractEnumerationObject obj) {
        IQModelImplUtilities.setEnumAttr(element, attrName, obj, null);
    }

    public static void setEnumAttr(Element element, String attrName, AbstractEnumerationObject obj, AbstractEnumerationObject defaultPersistenceValue) {
        if (obj != defaultPersistenceValue) {
            if (obj == null) {
                IQModelImplUtilities.setAttr(element, attrName, EMPTY_STRING);
            } else {
                IQModelImplUtilities.setAttr(element, attrName, obj.getV2PersistentForm());
            }
        }
    }

    public static void setCommaSeparatedStringAttr(Element element, String attrName, String[] values) {
        if (values != null) {
            String attrValue = CommaSeparatedString.combine(values);
            IQModelImplUtilities.setAttr(element, attrName, attrValue);
        }
    }

    public static void setCommaSeparatedStringAttr(Element element, String attrName, List<String> values) {
        if (values != null && values.size() > 0) {
            String attrValue = CommaSeparatedString.combine(values);
            IQModelImplUtilities.setAttr(element, attrName, attrValue);
        }
    }

    public static void setMultiValueAttr(Element element, String attrName, List<String> values) {
        String attrText = IQModelImplUtilities.determineMultiValueAttrText(values);
        IQModelImplUtilities.setAttr(element, attrName, attrText);
    }

    private static String determineMultiValueAttrText(List<String> values) {
        StringBuffer sb = new StringBuffer();
        boolean once = false;
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String string;
            String value = string = iterator.next();
            String encodedValue = IQModelImplUtilities.commaEncode(value);
            if (once) {
                sb.append(MULTI_VALUE_DELIMITER_TOKEN);
            }
            sb.append(encodedValue);
            once = true;
        }
        return sb.toString();
    }

    public static ArrayList<String> getMultiValueAttr(Element element, String attrName) {
        String attrText = IQModelImplUtilities.getAttr(element, attrName);
        return IQModelImplUtilities.parseMultiValueAttrText(attrText);
    }

    private static ArrayList<String> parseMultiValueAttrText(String attrText) {
        Pattern pattern;
        String[] values;
        ArrayList<String> out = new ArrayList<String>();
        if (attrText != null && attrText.length() != 0 && (values = (pattern = Pattern.compile(MULTI_VALUE_DELIMITER_TOKEN)).split(attrText)) != null) {
            for (String encodedValue : values) {
                String decodedValue = IQModelImplUtilities.commaDecode(encodedValue);
                out.add(decodedValue);
            }
        }
        return out;
    }

    private static String commaEncode(String value) {
        return value.replaceAll(",", ",comma;");
    }

    private static String commaDecode(String value) {
        return value.replaceAll(",comma;", ",");
    }

    public static DocumentBuilder getDOMParser() throws ParserConfigurationException {
        ExtraLoggingContexts.debugLogPersistence(">> IQModelImplUtilities.getDocumentBuilder():  being asked for a document builder");
        ExtraLoggingContexts.debugLogPersistence("begin getting DocumentBuilderFactory");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (_persistLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogPersistence("end   getting DocumentBuilderFactory");
            ExtraLoggingContexts.debugLogPersistence("got a document builder factory of type: " + (factory == null ? "null" : factory.getClass().toString()));
        }
        ExtraLoggingContexts.debugLogPersistence("begin getting DocumentBuilder");
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (_persistLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogPersistence("end   getting DocumentBuilderFactory");
            ExtraLoggingContexts.debugLogPersistence("<< IQModelImplUtilities.getDocumentBuilder():  returning document builder with following qualities:");
            ExtraLoggingContexts.debugLogPersistence("                                       DocumentBuilder class:  " + IQModelImplUtilities.toString(builder.getClass()));
        }
        return builder;
    }

    public static SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        ExtraLoggingContexts.debugLogReadFlowDetails("begin getting SAXParserFactory");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        ExtraLoggingContexts.debugLogReadFlowDetails("end   getting SAXParserFactory");
        ExtraLoggingContexts.debugLogReadFlowDetails("begin getting SAXParser from factory");
        SAXParser out = factory.newSAXParser();
        ExtraLoggingContexts.debugLogReadFlowDetails("end   getting SAXParser from factory");
        return out;
    }

    public static String toString(Object obj) {
        if (obj instanceof BusinessModelResource) {
            BusinessModelResource bmr = (BusinessModelResource)obj;
            return bmr.getIdentityString();
        }
        return String.valueOf(obj);
    }

    public static Document newDocument() throws MetadataException {
        Document doc = null;
        try {
            doc = IQModelImplUtilities.getDOMParser().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException(e);
        }
        return doc;
    }

    public static Document newDocument(String strXML) throws MetadataException {
        Document doc = null;
        try {
            StringReader strReader = new StringReader(strXML);
            InputSource inputSource = new InputSource(strReader);
            doc = IQModelImplUtilities.getDOMParser().parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException(e);
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
        catch (SAXException e) {
            throw new MetadataException(e);
        }
        return doc;
    }

    public static Element newDocumentWithElementName(String topElementName) throws MetadataException {
        Document doc = IQModelImplUtilities.newDocument();
        Element outElement = doc.createElement(topElementName);
        doc.appendChild(outElement);
        return outElement;
    }

    public static Document newDocument(InputStream dataStream) throws MetadataException {
        Document xmlDocument = null;
        try {
            xmlDocument = IQModelImplUtilities.getDOMParser().parse(dataStream);
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException(e);
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
        catch (SAXException e) {
            throw new MetadataException(e);
        }
        return xmlDocument;
    }

    public static Element newSubelement(Node parentNode, String newElementName) {
        Document doc = null;
        doc = parentNode instanceof Document ? (Document)parentNode : parentNode.getOwnerDocument();
        Element element = doc.createElement(newElementName);
        parentNode.appendChild(element);
        return element;
    }

    public static void removeAttr(Element element, String attrName) {
        element.removeAttribute(attrName);
    }

    public static void removeSubelement(Element element, String subelementName) throws MetadataException {
        Element subelement = IQModelImplUtilities.getFirstSubelementNamed(element, subelementName);
        if (subelement != null) {
            element.removeChild(subelement);
        }
    }

    public static List<Element> getSubelements(Node node) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList kids = node.getChildNodes();
        int kidCount = kids.getLength();
        for (int i = 0; i < kidCount; ++i) {
            Node kidNode = kids.item(i);
            if (!(kidNode instanceof Element)) continue;
            list.add((Element)kidNode);
        }
        return list;
    }

    @Nonnull
    public static List<Element> getSubelementsNamed(Node node, @Nonnull String subelementName) {
        ArrayList<Element> elements = new ArrayList<Element>(100);
        NodeList kids = node.getChildNodes();
        int length = kids.getLength();
        for (int i = 0; i < length; ++i) {
            Element subElement;
            Node kidNode = kids.item(i);
            if (!(kidNode instanceof Element) || !(subElement = (Element)kidNode).getTagName().equals(subelementName)) continue;
            elements.add(subElement);
        }
        elements.trimToSize();
        return elements;
    }

    public static Element getOnlySubelement(Node node) throws MetadataException {
        Element outElement = null;
        List<Element> kids = IQModelImplUtilities.getSubelements(node);
        int size = kids.size();
        if (size > 0) {
            outElement = kids.get(0);
            if (size > 1 && _logger.isEnabled(Level.WARN)) {
                String warnMsg = IQModelImplUtilities.getMessage("IQModelImplUtilities.MoreThenOneSubelements.fmt.txt", node.getNodeName());
                _logger.warn(warnMsg);
            }
        }
        return outElement;
    }

    public static Element getFirstSubelementNamed(Node node, String kidElementTagName) throws MetadataException {
        Element outElement = null;
        List<Element> kids = IQModelImplUtilities.getSubelements(node);
        for (int i = 0; i < kids.size(); ++i) {
            Element kidElement = kids.get(i);
            if (!kidElement.getTagName().equals(kidElementTagName)) continue;
            if (outElement == null) {
                outElement = kidElement;
                continue;
            }
            if (!_logger.isEnabled(Level.WARN)) continue;
            String warnMsg = IQModelImplUtilities.getMessage("IQModelImplUtilities.DuplicateSubelement.fmt.txt", kidElementTagName, node.getNodeName());
            _logger.warn(warnMsg);
        }
        return outElement;
    }

    public static String toString(Document doc) {
        return IQModelImplUtilities.docToString(doc, 0);
    }

    public static String toPrettyString(Document doc) {
        return IQModelImplUtilities.docToString(doc, 4);
    }

    public static String toPrettyString(Document doc, int spacesPerIdentation) {
        return IQModelImplUtilities.docToString(doc, spacesPerIdentation);
    }

    private static String docToString(Document doc, int spacesPerIdentation) {
        StringBuffer sb = new StringBuffer(DOCUMENT_HEADER);
        if (spacesPerIdentation != 0) {
            sb.append(LINE_END);
        }
        IQModelImplUtilities.toString(doc.getDocumentElement(), sb, spacesPerIdentation, 1);
        return sb.toString();
    }

    public static String toString(Element element) {
        StringBuffer sb = new StringBuffer();
        IQModelImplUtilities.toString(element, sb, 0, 0);
        return sb.toString();
    }

    public static String toPrettyString(Element element) {
        StringBuffer sb = new StringBuffer();
        IQModelImplUtilities.toString(element, sb, 4, 0);
        return sb.toString();
    }

    public static String toPrettyString(Element element, int spacesPerIndentation) {
        StringBuffer sb = new StringBuffer();
        IQModelImplUtilities.toString(element, sb, spacesPerIndentation, 0);
        return sb.toString();
    }

    private static List<Node> getChildNodesOfExpectedTypes(Node node) {
        NodeList nl = node.getChildNodes();
        int length = nl.getLength();
        ArrayList<Node> list = new ArrayList<Node>(length);
        for (int i = 0; i < length; ++i) {
            Node childNode = nl.item(i);
            if (childNode instanceof Element || childNode instanceof Text) {
                list.add(childNode);
                continue;
            }
            if (!_logger.isEnabled(Level.WARN)) continue;
            String warnMsg = IQModelImplUtilities.getMessage("IQModelImplUtilities.IgnoreChildNode.fmt.txt", node.getNodeName());
            _logger.warn(warnMsg);
        }
        list.trimToSize();
        return list;
    }

    private static void toString(Element element, StringBuffer sb, int spaceCountPerIndentation, int indentCount) {
        IQModelImplUtilities.toString(element, sb, spaceCountPerIndentation, indentCount, true);
    }

    private static void toString(Element element, StringBuffer sb, int spaceCountPerIndentation, int indentCount, boolean sort) {
        IQModelImplUtilities.toString(element, sb, spaceCountPerIndentation, indentCount, sort ? new AttrNameSorter() : null);
    }

    private static void toString(Element element, StringBuffer sb, int spaceCountPerIndentation, int indentCount, AttrNameSorter attrNameSorter) {
        String indentation;
        if (spaceCountPerIndentation != 0) {
            indentation = IQModelImplUtilities.getIndentationChars(spaceCountPerIndentation, indentCount);
            sb.append(indentation);
        } else {
            indentation = EMPTY_STRING;
        }
        sb.append(LITERAL_LT);
        String elementName = element.getTagName();
        sb.append(elementName);
        IQModelImplUtilities.appendAttrsString(element, sb, attrNameSorter);
        List<Node> childNodes = IQModelImplUtilities.getChildNodesOfExpectedTypes(element);
        int childNodesSize = childNodes.size();
        if (childNodesSize == 0) {
            sb.append("/>");
            if (spaceCountPerIndentation != 0) {
                sb.append(LINE_END);
            }
        } else {
            Node childNode;
            int i;
            sb.append(LITERAL_GT);
            boolean ignoreWhiteSpaceText = false;
            boolean textNodesOnly = true;
            if (spaceCountPerIndentation != 0) {
                for (i = 0; i < childNodesSize; ++i) {
                    childNode = childNodes.get(i);
                    if (childNode instanceof Text) continue;
                    if (!ignoreWhiteSpaceText) {
                        ignoreWhiteSpaceText = true;
                    }
                    textNodesOnly = false;
                }
            }
            if (spaceCountPerIndentation != 0) {
                Node childNode2 = childNodes.get(0);
                IQModelImplUtilities.addFormatText(sb, childNode2, ignoreWhiteSpaceText, LINE_END);
            }
            for (i = 0; i < childNodesSize; ++i) {
                childNode = childNodes.get(i);
                IQModelImplUtilities.addValueText(sb, childNode, ignoreWhiteSpaceText, spaceCountPerIndentation, indentCount, attrNameSorter);
            }
            if (!textNodesOnly) {
                Node childNode3 = childNodes.get(childNodesSize - 1);
                IQModelImplUtilities.addFormatText(sb, childNode3, ignoreWhiteSpaceText, indentation);
            }
            sb.append("</");
            sb.append(elementName);
            sb.append(LITERAL_GT);
            if (spaceCountPerIndentation != 0) {
                sb.append(LINE_END);
            }
        }
    }

    private static String getIndentationChars(int spaceCountPerIndentation, int indentCount) {
        String spaces;
        int spaceCount = spaceCountPerIndentation * indentCount;
        if (spaceCount > 0) {
            if (spaceCount < SPACE_CACHE.length()) {
                spaces = SPACE_CACHE.substring(0, spaceCount);
            } else {
                StringBuffer all = new StringBuffer(spaceCount);
                for (int i = 0; i < spaceCount; ++i) {
                    all.append(" ");
                }
                spaces = all.toString();
            }
        } else if (spaceCount < 0) {
            int tabCount = -1 * spaceCount;
            if (tabCount < TAB_CACHE.length()) {
                spaces = TAB_CACHE.substring(0, tabCount);
            } else {
                StringBuffer all = new StringBuffer(tabCount);
                for (int i = 0; i < tabCount; ++i) {
                    all.append("\t");
                }
                spaces = all.toString();
            }
        } else {
            spaces = EMPTY_STRING;
        }
        return spaces;
    }

    private static void addFormatText(StringBuffer sb, Node childNode, boolean ignoreWhiteSpaceText, String text) {
        if (childNode instanceof Text) {
            String value = childNode.getNodeValue();
            if (value != null) {
                boolean whitespaceOnly = value.matches("[\\s\\n\\t]*");
                if (ignoreWhiteSpaceText && whitespaceOnly) {
                    sb.append(text);
                }
            }
        } else {
            sb.append(text);
        }
    }

    private static void addValueText(StringBuffer sb, Node childNode, boolean ignoreWhiteSpaceText, int spaceCountPerIndentation, int indentCount, AttrNameSorter attrNameSorter) {
        if (childNode instanceof Text) {
            String value = childNode.getNodeValue();
            if (value != null) {
                boolean whitespaceOnly = value.matches("[\\s\\n\\t]*");
                if (!ignoreWhiteSpaceText || !whitespaceOnly) {
                    sb.append(IQModelImplUtilities.encodedAttrValueChars(value));
                }
            }
        } else {
            Element subElement = (Element)childNode;
            IQModelImplUtilities.toString(subElement, sb, spaceCountPerIndentation, indentCount + 1, attrNameSorter);
        }
    }

    private static void appendAttrsString(Element element, StringBuffer sb, AttrNameSorter attrNameSorter) {
        block3: {
            int count;
            NamedNodeMap nodeMap;
            block2: {
                nodeMap = element.getAttributes();
                count = nodeMap.getLength();
                if (attrNameSorter != null) break block2;
                for (int i = 0; i < count; ++i) {
                    Attr kid = (Attr)nodeMap.item(i);
                    String name = kid.getName();
                    String value = kid.getValue();
                    IQModelImplUtilities.writeAttrsValue(sb, name, value);
                }
                break block3;
            }
            if (count <= 0) break block3;
            String[] sortedAttrNames = attrNameSorter.trustedGetSortedNames(nodeMap);
            int index = 0;
            String name = sortedAttrNames[index++];
            while (name != null) {
                Node node = nodeMap.getNamedItem(name);
                String value = node.getNodeValue();
                IQModelImplUtilities.writeAttrsValue(sb, name, value);
                name = sortedAttrNames[index++];
            }
        }
    }

    private static void writeAttrsValue(StringBuffer sb, String name, String value) {
        if (value != null) {
            value = IQModelImplUtilities.encodedAttrValueChars(value);
            sb.append(' ');
            sb.append(name);
            sb.append("=\"");
            sb.append(value);
            sb.append('\"');
        }
    }

    private static String encodedAttrValueChars(String unencodedAttrValue) {
        String out = unencodedAttrValue;
        if (unencodedAttrValue != null) {
            int inlen = unencodedAttrValue.length();
            boolean needsEncoding = false;
            block11: for (int i = 0; i < inlen && !needsEncoding; ++i) {
                char c = unencodedAttrValue.charAt(i);
                switch (c) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': 
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '<': 
                    case '>': 
                    case '\\': 
                    case '\ufffe': 
                    case '\uffff': {
                        needsEncoding = true;
                        continue block11;
                    }
                }
            }
            if (needsEncoding) {
                StringBuffer buf = new StringBuffer(inlen + 25);
                block12: for (int i = 0; i < inlen; ++i) {
                    char c = unencodedAttrValue.charAt(i);
                    switch (c) {
                        case '\u0000': 
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': 
                        case '\u0004': 
                        case '\u0005': 
                        case '\u0006': 
                        case '\u0007': 
                        case '\b': 
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case '\u000e': 
                        case '\u000f': 
                        case '\u0010': 
                        case '\u0011': 
                        case '\u0012': 
                        case '\u0013': 
                        case '\u0014': 
                        case '\u0015': 
                        case '\u0016': 
                        case '\u0017': 
                        case '\u0018': 
                        case '\u0019': 
                        case '\u001a': 
                        case '\u001b': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': 
                        case '\\': 
                        case '\ufffe': 
                        case '\uffff': {
                            buf.append("&#");
                            buf.append(Integer.toString(c));
                            buf.append(';');
                            continue block12;
                        }
                        case '\"': {
                            buf.append(ENCODED_DOUBLE_QUOTE);
                            continue block12;
                        }
                        case '&': {
                            buf.append(ENCODED_AMPERSAND);
                            continue block12;
                        }
                        case '\'': {
                            buf.append(ENCODED_SINGLE_QUOTE);
                            continue block12;
                        }
                        case '<': {
                            buf.append(ENCODED_LT);
                            continue block12;
                        }
                        case '>': {
                            buf.append(ENCODED_GT);
                            continue block12;
                        }
                        default: {
                            buf.append(c);
                        }
                    }
                }
                out = buf.toString();
            }
        }
        return out;
    }

    public static String getMessage(String key, Object ... args) {
        return IQMetadataResourceBundle.getMessageString(key, args);
    }

    public static String getMessage(String key, Locale locale) {
        return IQMetadataResourceBundle.getStringResource(key, locale);
    }

    public static MessageFormatter getMessageFormatter(String key, Object ... args) {
        return IQMetadataResourceBundle.getMessageFormatter(key, args);
    }

    public static MessageFormatter getMessageFormatter(Throwable e) {
        return IQMetadataResourceBundle.getMessageFormatter("IQModelImplUtilities.GetThrowableLocalizedText.fmt.txt", e);
    }

    public static MessageFormatter getMessageFormatter(Reason reason) {
        MessageFormatter msg = reason.getNamedObject() == null ? IQMetadataResourceBundle.getMessageFormatter("IQModelImplUtilities.GetReasonLocalizedText.fmt.txt", reason, reason.getReason(), reason.getSubReason(), reason.getNamedObject()) : IQMetadataResourceBundle.getMessageFormatter("IQModelImplUtilities.GetReasonLocalizedTextWithObject.fmt.txt", reason, reason.getReason(), reason.getSubReason());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void fireChangeEvent(List listeners, Object objectThatChanged, String propertyName, Object newObject, Object oldObject) {
        if (listeners != null && listeners.size() > 0 && objectThatChanged != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(objectThatChanged, propertyName, newObject, oldObject);
            List list = listeners;
            synchronized (list) {
                for (Object obj : listeners) {
                    if (!(obj instanceof PropertyChangeListener)) continue;
                    PropertyChangeListener listener = (PropertyChangeListener)obj;
                    try {
                        listener.propertyChange(event);
                    }
                    catch (Exception e) {
                        if (!_logger.isEnabled(Level.ERROR)) continue;
                        _logger.error(IQModelImplUtilities.getMessage("Utils.ExceptionDuringListenerNotif.txt", new Object[0]), (Throwable)e);
                    }
                }
            }
        }
    }

    @Deprecated
    public static void addButNoDuplicates(List targetList, List sourceList) {
        if (targetList != null && sourceList != null) {
            for (Object obj : sourceList) {
                if (targetList.contains(obj)) continue;
                targetList.add(obj);
            }
        }
    }

    @Deprecated
    public static int addButNoDuplicates(List list, Object object) {
        int index = list.indexOf(object);
        if (index == -1) {
            index = list.size();
            list.add(object);
        }
        return index;
    }

    public static <T> List<T> filterByClass(List<? extends Object> inputList, @Nonnull Class<T> type) {
        assert (!(inputList instanceof AssociationList)) : "an association list is not safe for iteration";
        ArrayList<T> newList = new ArrayList<T>(inputList.size());
        for (Object object : inputList) {
            if (!type.isInstance(object)) continue;
            newList.add(type.cast(object));
        }
        newList.trimToSize();
        return newList;
    }

    @Deprecated
    public static List filterList(List inputList, Class returnOnlyOfThisType) {
        List outputList = ListUtils.newList(inputList);
        int size = outputList.size();
        for (int i = size - 1; i >= 0; --i) {
            Object obj = outputList.get(i);
            if (returnOnlyOfThisType.isInstance(obj)) continue;
            outputList.remove(i);
        }
        return outputList;
    }

    public static void filterListInPlace(List list, Class returnOnlyOfThisType) {
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            Object obj = list.get(i);
            if (returnOnlyOfThisType.isInstance(obj)) continue;
            list.remove(i);
        }
    }

    @Deprecated
    public static boolean hasDuplicates(List inputList) {
        boolean hasDupes = false;
        List list = ListUtils.newList(inputList);
        for (int i = 0; i < list.size() && !hasDupes; ++i) {
            Object obj = list.get(i);
            List testList = ListUtils.newList(inputList);
            testList.remove(i);
            if (!testList.contains(obj)) continue;
            hasDupes = true;
        }
        return hasDupes;
    }

    @Deprecated
    public static void removeDuplicates(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            int lastIndex = list.lastIndexOf(obj);
            while (lastIndex != i) {
                list.remove(lastIndex);
                lastIndex = list.lastIndexOf(obj);
            }
        }
    }

    public static int firstIndexOfUsingEqualsEquals(List list, Object obj) {
        int out = -1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (list.get(i) != obj) continue;
            out = i;
            break;
        }
        return out;
    }

    public static int referenceCount(Collection<?> c, Object o) {
        int count = 0;
        for (Object e : c) {
            if (e != o) continue;
            ++count;
        }
        return count;
    }

    public static boolean same(Object obj1, Object obj2) {
        boolean same = false;
        if (obj1 == null && obj2 == null || obj1 != null && obj2 != null && obj1.equals(obj2)) {
            same = true;
        }
        return same;
    }

    public static boolean sameIgnoreCase(String str1, String str2) {
        return str1 != null && str2 != null && str1.equalsIgnoreCase(str2) || str1 == null && str2 == null;
    }

    public static String replaceFirst(String input, String replaceFirstValue, String replaceWithThis) {
        String out = input;
        int index = input.indexOf(replaceFirstValue);
        if (index > -1) {
            out = input.substring(0, index) + replaceWithThis + input.substring(index + replaceFirstValue.length());
        }
        return out;
    }

    public static boolean different(Object obj1, Object obj2) {
        return !IQModelImplUtilities.same(obj1, obj2);
    }

    public static boolean objectsAreOfTypes(List objects, Class[] classes) {
        boolean ok = true;
        int listSize = objects.size();
        for (int i = 0; i < listSize && ok; ++i) {
            ok = IQModelImplUtilities.objectIsOneOfTheseTypes(objects.get(i), classes);
        }
        return ok;
    }

    @Deprecated
    public static boolean objectIsOneOfTheseTypes(Object obj, Class[] classes) {
        boolean ok = false;
        if (obj != null) {
            int classLength = classes.length;
            for (int i = 0; i < classLength && !ok; ++i) {
                ok = classes[i].isInstance(obj);
            }
        }
        return ok;
    }

    @Deprecated
    public static void ensureProperArgumentType(Object obj, Class[] classes) {
        Preconditions.ensureNonNull(obj);
        boolean ok = IQModelImplUtilities.objectIsOneOfTheseTypes(obj, classes);
        if (!ok) {
            String types = EMPTY_STRING;
            for (Class classe : classes) {
                if (types.length() != 0) {
                    types = types + ",";
                }
                types = types + classe.getName();
            }
            Object[] msgArgs = new Object[]{obj.getClass().getName(), types};
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.ImproperObjTypeSpecified.fmt.txt", msgArgs));
        }
    }

    @Deprecated
    public static void ensureProperArgumentTypes(List objects, Class[] classes) {
        Preconditions.ensureNonNull(objects);
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            IQModelImplUtilities.ensureProperArgumentType(objects.get(i), classes);
        }
    }

    public static RepositoryInterface connectToRepos(SessionContextInterface session, String reposName) throws ServiceException, MetadataException, RemoteException {
        UserContextInterface user = IQModelImplUtilities.getUser(session);
        InformationServiceInterface infoService = OMIRepository.getInformationService();
        RepositoryInterface repository = infoService.connectByName(user, reposName);
        if (repository == null) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("OMRUtilities.FailedToConnect.fmt.txt", reposName);
            throw new MetadataException(errorMsg);
        }
        if (!(repository instanceof OMIRepositoryInterface)) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("IntelligentQueryMetadataService.InvalidRepository.fmt.txt", reposName);
            throw new MetadataException(errorMsg);
        }
        return repository;
    }

    public static MetadataInterface pathUrlToMetadataInterface(SessionContextInterface session, PathUrl pathToObject) throws MetadataException {
        return IQModelImplUtilities.pathUrlToMetadataInterface(session, pathToObject, true);
    }

    public static MetadataInterface pathUrlToMetadataInterface(SessionContextInterface session, PathUrl pathToObject, boolean exceptionIfNotFound) throws MetadataException {
        MetadataInterface outSmartObject = null;
        if (session == null || pathToObject == null) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("IntelligentQueryMetadataService.NullArgSessionOrPathUrl.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        try {
            UserContextInterface user = IQModelImplUtilities.getUser(session);
            InformationServiceInterface infoSvc = IQModelImplUtilities.getInformationService();
            long start = 0L;
            if (_perfMSLogger.isDebugEnabled()) {
                start = System.currentTimeMillis();
                ExtraLoggingContexts.debugLogMetadataServerPerformance("> Getting object by path: " + pathToObject.toString());
            }
            outSmartObject = infoSvc.getObjectByPath(user, pathToObject);
            if (_perfMSLogger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                if (outSmartObject == null) {
                    ExtraLoggingContexts.debugLogMetadataServerPerformance("< done (" + (end - start) + "ms) : null returned");
                } else {
                    ExtraLoggingContexts.debugLogMetadataServerPerformance("< done (" + (end - start) + "ms) : an object was returned of type " + outSmartObject.getClass().getName());
                }
            }
            if (outSmartObject == null && exceptionIfNotFound) {
                IQModelImplUtilities.throwReasonPathURLObjectNotFound(pathToObject, user);
            }
        }
        catch (RemoteException e) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("IntelligentQueryMetadataService.FailedToGetMetadataInterface.fmt.txt", pathToObject.getAbsolutePath());
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(errorMsg.toString(), (Throwable)e);
            }
            throw new MetadataException(errorMsg, (Throwable)e);
        }
        catch (ServiceException e) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("IntelligentQueryMetadataService.FailedToGetMetadataInterface.fmt.txt", pathToObject.getAbsolutePath());
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(errorMsg.toString(), (Throwable)e);
            }
            throw new MetadataException(errorMsg, (Throwable)e);
        }
        return outSmartObject;
    }

    private static InformationServiceInterface getInformationService() throws MetadataException {
        InformationServiceInterface infoSvc = OMIRepository.getInformationService();
        if (infoSvc == null) {
            MessageFormatter mf = IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.CouldNotGetInformationService.txt", new Object[0]);
            throw new MetadataException(mf);
        }
        return infoSvc;
    }

    public static MetadataInterface absolutePathToMetadataInterface(SessionContextInterface session, String absolutePathWithinServer, ServerInterface omrServer, boolean exceptionIfNotFound) throws MetadataException {
        MetadataInterface outSmartObject = null;
        if (session == null || absolutePathWithinServer == null || omrServer == null) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.NullArgSessionPathOrServer.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        try {
            PathUrl fullPath = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)omrServer, (String)absolutePathWithinServer);
            long start = 0L;
            if (_perfMSLogger.isDebugEnabled()) {
                start = System.currentTimeMillis();
                ExtraLoggingContexts.debugLogMetadataServerPerformance("> Getting object by path: " + fullPath.toString());
            }
            outSmartObject = omrServer.getObjectByPath(fullPath);
            if (_perfMSLogger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                if (outSmartObject == null) {
                    ExtraLoggingContexts.debugLogMetadataServerPerformance("< done (" + (end - start) + "ms) : null returned");
                } else {
                    ExtraLoggingContexts.debugLogMetadataServerPerformance("< done (" + (end - start) + "ms) : an object was returned of type " + outSmartObject.getClass().getName());
                }
            }
            if (outSmartObject == null && exceptionIfNotFound) {
                IQModelImplUtilities.throwReasonPathURLObjectNotFound(fullPath, session.getUserContext());
            }
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("IntelligentQueryMetadataService.FailedToGetMetadataInterface.fmt.txt", absolutePathWithinServer);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(formatter.toString(), (Throwable)e);
            }
            throw new MetadataException(formatter, (Throwable)e);
        }
        catch (ServiceException e) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("IntelligentQueryMetadataService.FailedToGetMetadataInterface.fmt.txt", absolutePathWithinServer);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(formatter.toString(), (Throwable)e);
            }
            throw new MetadataException(formatter, (Throwable)e);
        }
        return outSmartObject;
    }

    private static List generalSearch(RepositoryInterface repos, int omrFlags, String template, String objectType, FilterComponent filterComponent) throws RemoteException, MetadataException, ServiceException {
        if (repos == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.NullReposInterface.txt", new Object[0]));
        }
        Filter filter = new Filter();
        filter.setOMRFlags(omrFlags | 4 | 0x80 | 0x100);
        filter.setOMRTemplate(template);
        filter.setType(objectType);
        filter.setFilterComponent(filterComponent);
        long start = 0L;
        if (_perfMSLogger.isDebugEnabled()) {
            start = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogMetadataServerPerformance("> General search of metadata server by repository.  Object type=" + objectType + ", omrFlags=" + omrFlags + ", template=" + template);
        }
        List outList = repos.search((FilterInterface)filter);
        if (_perfMSLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogMetadataServerPerformance("< done (" + (end - start) + "ms).  Results: " + String.valueOf(outList));
        }
        return outList;
    }

    public static List generalSearch(ServerInterface server, int omrFlags, String template, String objectType, FilterComponent filterComponent) throws RemoteException, MetadataException, ServiceException {
        if (server == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.NullServerInterface.txt", new Object[0]));
        }
        Filter filter = new Filter();
        filter.setOMRFlags(omrFlags | 4 | 0x80 | 0x100);
        filter.setOMRTemplate(template);
        filter.setType(objectType);
        filter.setFilterComponent(filterComponent);
        long start = 0L;
        if (_perfMSLogger.isDebugEnabled()) {
            start = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogMetadataServerPerformance("> General search of metadata server by server.  Object type=" + objectType + ", omrFlags=" + omrFlags + ", template=" + template);
        }
        List outList = server.search((FilterInterface)filter);
        if (_perfMSLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogMetadataServerPerformance("< done (" + (end - start) + "ms).  Results: " + String.valueOf(outList));
        }
        return outList;
    }

    public static Root reGetObjectWithTemplate(RepositoryInterface repos, Root jomaObject, String template, int inputOmrFlags) throws ServiceException, MetadataException, RemoteException {
        Object obj;
        String fqid;
        FilterComponent filterComponent;
        String objectType = jomaObject.getCMetadataType();
        List returnedObjects = IQModelImplUtilities.generalSearch(repos, inputOmrFlags, template, objectType, filterComponent = new FilterComponent("Id", 0, fqid = jomaObject.getFQID()));
        int count = returnedObjects.size();
        if (count > 1) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("OMRUtilities.UnexpectedConditionMultipleObjectsReturned.fmt.txt", objectType, fqid);
            throw new MetadataException(errorMsg);
        }
        Root outObject = null;
        if (count == 1 && (obj = returnedObjects.get(0)) instanceof MetadataInterface) {
            outObject = IQModelImplUtilities.unwrapOMRSmartObject((MetadataInterface)obj);
        }
        return outObject;
    }

    public static List reGetObjectsWithTemplate(RepositoryInterface repos, String objectType, String template, int inputOmrFlags, FilterComponent filterComponent) throws ServiceException, MetadataException, RemoteException {
        ArrayList<Root> returnedObjects = new ArrayList<Root>();
        List searchObjects = IQModelImplUtilities.generalSearch(repos, inputOmrFlags, template, objectType, filterComponent);
        returnedObjects.addAll(IQModelImplUtilities.unwrapOMRSmartObjects(searchObjects));
        return returnedObjects;
    }

    public static RepositoryInterface getRepositoryFromObject(CMetadata jomaObject, SessionContextInterface session) throws MetadataException {
        RepositoryInterface repository = null;
        try {
            repository = IQModelImplUtilities.getRepos(jomaObject, session);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        return repository;
    }

    public static RepositoryInterface getRepos(CMetadata jomaObject, SessionContextInterface session) throws RemoteException, ServiceException {
        MetadataInterface mi;
        ServerInterface server;
        RepositoryInterface repos = null;
        UserContextInterface user = session.getUserContext();
        if (user != null && (server = user.getAuthServer()) != null && (mi = server.factoryProcess((Object)jomaObject)) != null) {
            repos = mi.getRepository();
        }
        return repos;
    }

    public static List searchRepositoryForObjectsOfTypeWithTemplate(RepositoryInterface repos, String objectType, String template, int omrFlags) throws RemoteException, MetadataException, ServiceException {
        return IQModelImplUtilities.generalSearch(repos, omrFlags, template, objectType, null);
    }

    public static Root unwrapOMRSmartObject(MetadataInterface smartObject) throws ServiceException, RemoteException {
        Object reposEntity;
        Root outObject = null;
        if (smartObject != null && (reposEntity = smartObject.getRepositoryEntity()) instanceof Root) {
            outObject = (Root)reposEntity;
        }
        return outObject;
    }

    public static List<Root> unwrapOMRSmartObjects(List smartObjects) throws ServiceException, RemoteException {
        ArrayList<Root> outList = new ArrayList<Root>();
        if (smartObjects != null) {
            for (Object object : smartObjects) {
                MetadataInterface smartObject;
                Root root;
                if (!(object instanceof MetadataInterface) || (root = IQModelImplUtilities.unwrapOMRSmartObject(smartObject = (MetadataInterface)object)) == null) continue;
                outList.add(root);
            }
        }
        return outList;
    }

    public static String toString(@Nullable List<? extends Object> list) {
        String out = EMPTY_STRING;
        if (list != null) {
            out = "[";
            for (Object object : list) {
                if (out.length() > 1) {
                    out = out + ";";
                }
                out = out + IQModelImplUtilities.toString(object);
            }
        } else {
            return "null";
        }
        out = out + "]";
        return out;
    }

    public static List<Element> getKidElements(Element el) {
        ArrayList<Element> list = new ArrayList<Element>(100);
        NodeList kids = el.getChildNodes();
        int length = kids.getLength();
        for (int i = 0; i < length; ++i) {
            Node kidNode = kids.item(i);
            if (!(kidNode instanceof Element)) continue;
            Element element = (Element)kidNode;
            list.add(element);
        }
        list.trimToSize();
        return list;
    }

    public static Element getSpecificKidElement(Element el, String kidElementTagName) {
        Element outElement = null;
        for (Element kidElement : IQModelImplUtilities.getKidElements(el)) {
            if (!kidElement.getTagName().equals(kidElementTagName)) continue;
            outElement = kidElement;
            break;
        }
        return outElement;
    }

    public static String leftOfDot(String str) {
        String out = str;
        int dotIndex = str.indexOf(46);
        if (dotIndex != -1) {
            out = str.substring(0, dotIndex);
        }
        return out;
    }

    public static String rightOfDot(String str) {
        String out = EMPTY_STRING;
        int dotIndex = str.indexOf(46);
        if (dotIndex != -1) {
            out = str.substring(dotIndex + 1);
        }
        return out;
    }

    public static boolean isAggregationDefinedInExpression(DataItem di) {
        return ObjectUtilities.isAggregationDefinedInExpression(di);
    }

    public static void reorderMainSubelements(Element thisElement, String[] ORDER_OF_ELEMENTS) {
        HashMap<String, ArrayList<Element>> map = new HashMap<String, ArrayList<Element>>();
        List<Element> subelements = IQModelImplUtilities.getSubelements(thisElement);
        for (int i = 0; i < subelements.size(); ++i) {
            Element currentElement = subelements.get(i);
            String currentElementName = currentElement.getTagName();
            ArrayList<Element> list = (ArrayList<Element>)map.get(currentElementName);
            if (list == null) {
                list = new ArrayList<Element>();
                map.put(currentElementName, list);
            }
            list.add(currentElement);
        }
        int nextIndex = 0;
        for (String elementName : ORDER_OF_ELEMENTS) {
            List list = (List)map.get(elementName);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                List<Element> currentSubelements;
                Element beforeElement;
                Element nextElementToMove = (Element)list.get(j);
                if (nextElementToMove != (beforeElement = (currentSubelements = IQModelImplUtilities.getSubelements(thisElement)).get(nextIndex))) {
                    thisElement.insertBefore(nextElementToMove, beforeElement);
                }
                ++nextIndex;
            }
        }
    }

    public static List<StoredProcessInterface> getAvailableStoredProcesses(com.sas.services.information.metadata.ServerInterface computeLocation) throws RemoteException, ServiceException, MdException {
        ArrayList<StoredProcessInterface> returnList = new ArrayList<StoredProcessInterface>();
        if (computeLocation != null) {
            boolean isSTPServer = computeLocation.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
            List computeTasks = AssociationListUtil.getCopyIfASL(computeLocation.getComputeTasks(true));
            for (Object o : computeTasks) {
                if (!(o instanceof StoredProcessInterface)) continue;
                StoredProcessInterface stp = (StoredProcessInterface)o;
                try {
                    StoredProcessInterface.LogicalServerType type = stp.getLogicalServerType();
                    if (!isSTPServer && type != StoredProcessInterface.LogicalServerType.WORKSPACE && type != StoredProcessInterface.LogicalServerType.ANY) continue;
                    returnList.add(stp);
                }
                catch (ServiceException se) {
                    if (!_logger.isDebugEnabled()) continue;
                    _logger.debug("Skipping stored process " + stp.getName(), (Throwable)se);
                }
            }
        }
        return returnList;
    }

    public static Reason getReasonPathURLObjectNotFound(PathUrl pathToObject, UserContextInterface user) throws ServiceException, RemoteException, MetadataException {
        Reason out = null;
        InformationServiceInterface infoSvc = IQModelImplUtilities.getInformationService();
        ServerInterface server = infoSvc.getServerForPath(user, pathToObject);
        if (server instanceof MetadataServerInterface) {
            MetadataServerInterface metadataServer = (MetadataServerInterface)server;
            out = IQModelImplUtilities.getReasonForMissingObjectByPath(metadataServer, pathToObject);
        } else {
            out = new Reason((Object)pathToObject, 9, 230, "IntelligentQueryMetadataService.FailedToGetMetadataInterfaceServerNotFound.fmt.txt", pathToObject.getAbsolutePath(), pathToObject.getRepository());
        }
        return out;
    }

    private static void throwReasonPathURLObjectNotFound(PathUrl pathToObject, UserContextInterface user) throws RemoteException, ServiceException, MetadataException {
        Reason reason = IQModelImplUtilities.getReasonPathURLObjectNotFound(pathToObject, user);
        if (reason != null) {
            MetadataException me = new MetadataException(IQModelImplUtilities.getMessageFormatter(reason), Arrays.asList(reason));
            throw me;
        }
    }

    private static Reason getReasonForMissingObjectByPath(MetadataServerInterface metadataServer, PathUrl pathToObject) throws ServiceException, RemoteException {
        int port;
        String host;
        int countNoSecurity;
        Reason reason;
        block6: {
            reason = null;
            String objType = pathToObject.getType();
            countNoSecurity = 0;
            host = null;
            port = 0;
            try {
                if (objType != null && (objType.startsWith("InformationMap") || objType.equals("BriefInformationMap"))) {
                    InformationMapPathFilter infofilter = new InformationMapPathFilter(pathToObject);
                    countNoSecurity = metadataServer.getCountNoSecurity((Filter)infofilter, null);
                } else {
                    PathFilter filter = new PathFilter(pathToObject, metadataServer);
                    countNoSecurity = metadataServer.getCountNoSecurity((Filter)filter, null);
                }
                host = metadataServer.getHost();
                port = metadataServer.getPort();
            }
            catch (ServiceException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    Object[] args = new Object[]{pathToObject.getAbsolutePath()};
                    MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IQModelImplUtilities.FailedToGetHostOrPortFromPath.fmt.txt", args);
                    _logger.error(formatter.toString(), (Throwable)e);
                }
            }
            catch (RemoteException e) {
                if (!_logger.isEnabled(Level.ERROR)) break block6;
                Object[] args = new Object[]{pathToObject.getAbsolutePath()};
                MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("IQModelImplUtilities.FailedToGetHostOrPortFromPath.fmt.txt", args);
                _logger.error(formatter.toString(), (Throwable)e);
            }
        }
        Object[] args = new Object[]{pathToObject.getAbsolutePath(), host == null ? "-" : host, port == 0 ? "-" : Integer.toString(port)};
        reason = countNoSecurity <= 0 ? new Reason((Object)pathToObject, 9, 216, "IntelligentQueryMetadataService.FailedToGetMetadataInterfaceNotFound.fmt.txt", args) : (countNoSecurity == 1 ? new Reason((Object)pathToObject, 9, 215, "IntelligentQueryMetadataService.FailedToGetMetadataInterfaceNoPermission.fmt.txt", args) : new Reason((Object)pathToObject, 9, 217, "IntelligentQueryMetadataService.FailedToGetMetadataInterfaceMultiple.fmt.txt", args));
        return reason;
    }

    public static LocalizableString copyToLocalizablePersistableString(LocalizableString localizableString) {
        LocalizablePersistableString lps = new LocalizablePersistableString();
        for (Locale locale : localizableString.getLocales()) {
            String text = localizableString.getText(locale);
            lps.setText(text, locale);
        }
        lps.setDefaultLocale(localizableString.getDefaultLocale());
        return lps;
    }

    public static void setEnumListAttr(Element element, String attrName, List<AbstractEnumerationObject> enums) {
        if (!enums.isEmpty()) {
            AbstractEnumerationObject[] sortedEnums = AbstractEnumerationObject.sortByPersistedForm(enums);
            StringBuffer buf = new StringBuffer(20 * enums.size());
            boolean first = true;
            for (AbstractEnumerationObject enumObj : sortedEnums) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(enumObj.getV2PersistentForm());
            }
            IQModelImplUtilities.setAttr(element, attrName, buf.toString());
        }
    }

    public static String fullPathToAbsolutePath(String fullPath) {
        String out = fullPath;
        if (fullPath != null && fullPath.startsWith("SBIP://")) {
            PathUrl url = new PathUrl(fullPath);
            out = url.getAbsolutePath();
        }
        return out;
    }

    public static MetadataServerInterface getMetadataServerAuthenticatedWith(SessionContextInterface session) throws MetadataException, ServiceException, RemoteException {
        MetadataServerInterface msi = null;
        UserContextInterface user = IQModelImplUtilities.getUser(session);
        ServerInterface server = user.getAuthServer();
        if (!(server instanceof MetadataServerInterface)) {
            MessageFormatter mf = IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.AuthenticationServerNotSASMetadataServer.txt", new Object[0]);
            throw new MetadataException(mf);
        }
        msi = (MetadataServerInterface)server;
        return msi;
    }

    private static UserContextInterface getUser(SessionContextInterface session) throws RemoteException, MetadataException {
        UserContextInterface user = session.getUserContext();
        if (user == null) {
            MessageFormatter mf = IQModelImplUtilities.getMessageFormatter("OMRUtilities.FailedToGetUserFromSession.txt", new Object[0]);
            throw new MetadataException(mf);
        }
        return user;
    }

    public static int getExpressionTypeFactoringInAggregation(ExpressionInterface expression, DataItemActionType usage, Function aggregationFunction) {
        int result = 0;
        if (expression != null) {
            if (usage == DataItemActionType.USAGE_AGGREGATE && aggregationFunction != null) {
                FunctionSignature signature = aggregationFunction.getCompatibleSignature(Arrays.asList(expression));
                if (signature != null) {
                    ParameterType returnType = signature.getReturnType();
                    result = returnType.toExpressionType();
                } else {
                    result = expression.getExpressionType();
                }
            } else {
                result = expression.getExpressionType();
            }
        }
        return result;
    }

    public static String generateDefaultFormat(DataItem di) throws MetadataUnresolvedException {
        String format;
        int type = IQModelImplUtilities.getExpressionTypeFactoringInAggregation(di.getExpression(), di.getUsage(), di.getAggregationType());
        if (type == 0) {
            type = 3;
        }
        if ((format = DEFAULT_FORMATS.get(type)) == null) {
            format = DEFAULT_FORMATS.get(3);
        }
        return format;
    }

    public static ExpressionInterface newPredicate(BusinessModel model, String exprText, ResourceScope scope) throws MetadataException {
        boolean enableComments = true;
        boolean enableTuples = false;
        boolean enableSets = false;
        boolean enableObjRefs = false;
        boolean includeComments = true;
        boolean useFuncCallsFirst = false;
        return IQModelImplUtilities.parseText(exprText, true, 9, model, scope, enableComments, enableTuples, enableSets, enableObjRefs, includeComments, useFuncCallsFirst);
    }

    public static ExpressionInterface newCalculation(BusinessModel model, String exprText, ResourceScope scope, int expressionType) throws MetadataException {
        boolean enableComments = true;
        boolean enableTuples = false;
        boolean enableSets = false;
        boolean enableObjRefs = false;
        boolean includeComments = true;
        boolean useFuncCallsFirst = false;
        return IQModelImplUtilities.parseText(exprText, false, expressionType, model, scope, enableComments, enableTuples, enableSets, enableObjRefs, includeComments, useFuncCallsFirst);
    }

    public static ExpressionInterface parseText(String text, boolean parseAsPredicate, int expressionType, BusinessModel model, ResourceScope scope, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs, boolean includeComments, boolean useFuncCallsFirst) throws MetadataException {
        ExpressionInterface expr = null;
        try {
            NodeParser nodeParser = ParserUtil.newParser();
            ParsedNode exprNode = parseAsPredicate ? nodeParser.parsePredicate(text, enableComments, enableTuples, enableSets, enableObjRefs) : nodeParser.parseCalculation(text, enableComments, enableTuples, enableSets, enableObjRefs);
            FormatterExpressionizer iqFormatter = FormatterFactory.newExpressionInterfaceFormatter();
            expr = iqFormatter.newExpressionInterface(model, exprNode, includeComments, useFuncCallsFirst, scope);
        }
        catch (Throwable e) {
            e.printStackTrace();
            expr = StringExpressionUtil.getInstance().newExpression(model, text, expressionType, scope);
        }
        return expr;
    }

    public static int dataTypeFromString(String stringFormOfJavaSqlDataType) {
        int out = 1111;
        if (stringFormOfJavaSqlDataType.equals("ARRAY")) {
            out = 2003;
        } else if (stringFormOfJavaSqlDataType.equals("BIGINT")) {
            out = -5;
        } else if (stringFormOfJavaSqlDataType.equals("BINARY")) {
            out = -2;
        } else if (stringFormOfJavaSqlDataType.equals("BIT")) {
            out = -7;
        } else if (stringFormOfJavaSqlDataType.equals("BLOB")) {
            out = 2004;
        } else if (stringFormOfJavaSqlDataType.equals("CHAR")) {
            out = 1;
        } else if (stringFormOfJavaSqlDataType.equals("CLOB")) {
            out = 2005;
        } else if (stringFormOfJavaSqlDataType.equals("DATE")) {
            out = 91;
        } else if (stringFormOfJavaSqlDataType.equals("DECIMAL")) {
            out = 3;
        } else if (stringFormOfJavaSqlDataType.equals("DISTINCT")) {
            out = 2001;
        } else if (stringFormOfJavaSqlDataType.equals("DOUBLE")) {
            out = 8;
        } else if (stringFormOfJavaSqlDataType.equals("FLOAT")) {
            out = 6;
        } else if (stringFormOfJavaSqlDataType.equals("INTEGER")) {
            out = 4;
        } else if (stringFormOfJavaSqlDataType.equals("JAVA_OBJECT")) {
            out = 2000;
        } else if (stringFormOfJavaSqlDataType.equals("LONGVARBINARY")) {
            out = -4;
        } else if (stringFormOfJavaSqlDataType.equals("LONGVARCHAR")) {
            out = -1;
        } else if (stringFormOfJavaSqlDataType.equals("NULL")) {
            out = 0;
        } else if (stringFormOfJavaSqlDataType.equals("NUMERIC")) {
            out = 2;
        } else if (stringFormOfJavaSqlDataType.equals("OTHER")) {
            out = 1111;
        } else if (stringFormOfJavaSqlDataType.equals("REAL")) {
            out = 7;
        } else if (stringFormOfJavaSqlDataType.equals("REF")) {
            out = 2006;
        } else if (stringFormOfJavaSqlDataType.equals("SMALLINT")) {
            out = 5;
        } else if (stringFormOfJavaSqlDataType.equals("STRUCT")) {
            out = 2002;
        } else if (stringFormOfJavaSqlDataType.equals("TIME")) {
            out = 92;
        } else if (stringFormOfJavaSqlDataType.equals("TIMESTAMP")) {
            out = 93;
        } else if (stringFormOfJavaSqlDataType.equals("TINYINT")) {
            out = -6;
        } else if (stringFormOfJavaSqlDataType.equals("VARBINARY")) {
            out = -3;
        } else if (stringFormOfJavaSqlDataType.equals("VARCHAR")) {
            out = 12;
        }
        return out;
    }

    public static String dataTypeToString(int javaSqlDataType) {
        String out = "OTHER";
        if (javaSqlDataType == 2003) {
            out = "ARRAY";
        } else if (javaSqlDataType == -5) {
            out = "BIGINT";
        } else if (javaSqlDataType == -2) {
            out = "BINARY";
        } else if (javaSqlDataType == -7) {
            out = "BIT";
        } else if (javaSqlDataType == 2004) {
            out = "BLOB";
        } else if (javaSqlDataType == 1) {
            out = "CHAR";
        } else if (javaSqlDataType == 2005) {
            out = "CLOB";
        } else if (javaSqlDataType == 91) {
            out = "DATE";
        } else if (javaSqlDataType == 3) {
            out = "DECIMAL";
        } else if (javaSqlDataType == 2001) {
            out = "DISTINCT";
        } else if (javaSqlDataType == 8) {
            out = "DOUBLE";
        } else if (javaSqlDataType == 6) {
            out = "FLOAT";
        } else if (javaSqlDataType == 4) {
            out = "INTEGER";
        } else if (javaSqlDataType == 2000) {
            out = "JAVA_OBJECT";
        } else if (javaSqlDataType == -4) {
            out = "LONGVARBINARY";
        } else if (javaSqlDataType == -1) {
            out = "LONGVARCHAR";
        } else if (javaSqlDataType == 0) {
            out = "NULL";
        } else if (javaSqlDataType == 2) {
            out = "NUMERIC";
        } else if (javaSqlDataType == 1111) {
            out = "OTHER";
        } else if (javaSqlDataType == 7) {
            out = "REAL";
        } else if (javaSqlDataType == 2006) {
            out = "REF";
        } else if (javaSqlDataType == 5) {
            out = "SMALLINT";
        } else if (javaSqlDataType == 2002) {
            out = "STRUCT";
        } else if (javaSqlDataType == 92) {
            out = "TIME";
        } else if (javaSqlDataType == 93) {
            out = "TIMESTAMP";
        } else if (javaSqlDataType == -6) {
            out = "TINYINT";
        } else if (javaSqlDataType == -3) {
            out = "VARBINARY";
        } else if (javaSqlDataType == 12) {
            out = "VARCHAR";
        }
        return out;
    }

    public static CredentialResolver getResolver(BusinessModel model) throws ExecutionException {
        UserContextInterface resolver = null;
        try {
            resolver = model.getSession().getUserContext();
        }
        catch (IllegalStateException e) {
            throw new ExecutionException(e);
        }
        catch (RemoteException e) {
            throw new ExecutionException(e);
        }
        return resolver;
    }

    static {
        DEFAULT_FORMATS.put(2, "BEST.");
        DEFAULT_FORMATS.put(3, "$.");
        DEFAULT_FORMATS.put(4, "DATE.");
        DEFAULT_FORMATS.put(5, "TIME.");
        DEFAULT_FORMATS.put(6, "DATETIME.");
    }

    private static class AttrNameSorter {
        private String[] _sortedNames = new String[1];

        private AttrNameSorter() {
        }

        private String[] trustedGetSortedNames(NamedNodeMap domAttrs) {
            int attrCount = domAttrs.getLength();
            int sizeNeeded = attrCount + 1;
            if (sizeNeeded > this._sortedNames.length) {
                this._sortedNames = new String[sizeNeeded];
            }
            int nextFillIndex = 0;
            for (int i = 0; i < attrCount; ++i) {
                Attr kid = (Attr)domAttrs.item(i);
                String name = kid.getName();
                if (name == null) continue;
                this._sortedNames[nextFillIndex++] = name;
            }
            if (nextFillIndex > 1) {
                Arrays.sort(this._sortedNames, 0, nextFillIndex);
            }
            this._sortedNames[nextFillIndex] = null;
            return this._sortedNames;
        }
    }
}

