/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@SASScope(value="ALL")
@Immutable
public final class TimeShiftDirection {
    private static final String CURRENT_STRING = "current";
    private static final String NEXT_STRING = "next";
    private static final String PREVIOUS_STRING = "previous";
    public static final TimeShiftDirection CURRENT = new TimeShiftDirection("current");
    public static final TimeShiftDirection NEXT = new TimeShiftDirection("next");
    public static final TimeShiftDirection PREVIOUS = new TimeShiftDirection("previous");
    private final String _type;
    private static final Map<String, TimeShiftDirection> _supportedTypes;
    private static final Map<String, String> _displayText;

    private TimeShiftDirection(String current_value) {
        this._type = current_value;
    }

    public String toString() {
        String text = _displayText.get(this._type);
        assert (text != null);
        return text;
    }

    public int getValue() {
        return this._type.equals(CURRENT_STRING) ? 0 : (this._type.equals(NEXT_STRING) ? 1 : -1);
    }

    public static List<TimeShiftDirection> getValues() {
        ArrayList<TimeShiftDirection> types = new ArrayList<TimeShiftDirection>(_supportedTypes.values());
        return Collections.unmodifiableList(types);
    }

    public boolean equals(Object object2) {
        int value2;
        if (this == object2) {
            return true;
        }
        if (!(object2 instanceof TimeShiftDirection)) {
            return false;
        }
        TimeShiftDirection o2 = (TimeShiftDirection)object2;
        int value1 = this.getValue();
        return value1 == (value2 = o2.getValue());
    }

    @SASScope
    protected String getPersistentForm() {
        return this._type;
    }

    @Nullable
    @SASScope
    protected static TimeShiftDirection fromPersistentForm(String inValue) {
        if (CURRENT_STRING.equals(inValue)) {
            return CURRENT;
        }
        if (PREVIOUS_STRING.equals(inValue)) {
            return PREVIOUS;
        }
        if (NEXT_STRING.equals(inValue)) {
            return NEXT;
        }
        return null;
    }

    public int hashCode() {
        int result = 179;
        result = 37 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 37 * result + 13;
        return result;
    }

    static {
        HashMap<String, TimeShiftDirection> mutable = new HashMap<String, TimeShiftDirection>(8);
        mutable.put(CURRENT_STRING, CURRENT);
        mutable.put(NEXT_STRING, NEXT);
        mutable.put(PREVIOUS_STRING, PREVIOUS);
        _supportedTypes = Collections.unmodifiableMap(mutable);
        HashMap<String, String> tempDisplayText = new HashMap<String, String>(4);
        tempDisplayText.put(CURRENT_STRING, "Current");
        tempDisplayText.put(NEXT_STRING, "Next");
        tempDisplayText.put(PREVIOUS_STRING, "Previous");
        _displayText = Collections.unmodifiableMap(tempDisplayText);
    }
}

