/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.RelationalConditionalExpression;
import com.sas.iquery.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class SimpleConditionalExpression_In
extends RelationalConditionalExpression
implements BusinessModelResourceReferencer {
    public static final String EVENT_WHAT_TO_COMPARE_CHANGED = "What to compare changed";
    public static final String EVENT_COMPARISON_LIST_CHANGED = "Comparison list changed";
    private ExpressionInterface _whatToCompare;
    @Nonnull
    private List<ExpressionInterface> _comparisonList = new ArrayList<ExpressionInterface>(4);

    public void setWhatToCompare(ExpressionInterface expr) {
        this.moveListeningTo(this._whatToCompare, expr);
        this._whatToCompare = expr;
        this.fireChangeEvent(EVENT_WHAT_TO_COMPARE_CHANGED);
    }

    public ExpressionInterface getWhatToCompare() {
        return this._whatToCompare;
    }

    public void setComparisonList(@Nonnull List<? extends ExpressionInterface> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        ArrayList<? extends ExpressionInterface> copy = new ArrayList<ExpressionInterface>(values);
        Preconditions.ensureNonNullTypedElements(copy, ExpressionInterface.class);
        this.removeListeningTo(this._comparisonList);
        this.listenTo(copy);
        this._comparisonList.clear();
        this._comparisonList.addAll(copy);
        this.fireChangeEvent(EVENT_COMPARISON_LIST_CHANGED);
    }

    public List<ExpressionInterface> getComparisonList() {
        return new ArrayList<ExpressionInterface>(this._comparisonList);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._whatToCompare = this.singleReplaceResources(this._whatToCompare, oldResource, newResource, model, recursive);
        for (int i = 0; i < this._comparisonList.size(); ++i) {
            ExpressionInterface expression = this._comparisonList.get(i);
            ExpressionInterface newRes = this.singleReplaceResources(expression, oldResource, newResource, model, recursive);
            this._comparisonList.set(i, newRes);
        }
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        SimpleConditionalExpression_In clone = (SimpleConditionalExpression_In)super.clone();
        if (!(this._whatToCompare instanceof BusinessModelResource) && this._whatToCompare != null) {
            ExpressionInterface expr = (ExpressionInterface)this._whatToCompare.clone();
            clone.setWhatToCompare(expr);
        }
        ArrayList<ExpressionInterface> deepCopy = new ArrayList<ExpressionInterface>(this._comparisonList.size());
        for (ExpressionInterface expr : this._comparisonList) {
            if (!(expr instanceof BusinessModelResource)) {
                deepCopy.add((ExpressionInterface)expr.clone());
                continue;
            }
            deepCopy.add(expr);
        }
        clone.setComparisonList(deepCopy);
        return clone;
    }

    @SASScope
    public String toString() {
        try {
            String what = StringExpressionUtil.getInstance().getText(this._whatToCompare);
            String negate = this.isNegated() ? " NOT" : "";
            String list = this.valuesToString(this.getComparisonList());
            return "(" + what + negate + " IN " + list + ")";
        }
        catch (MetadataException e) {
            return "";
        }
    }

    private String valuesToString(List<? extends ExpressionInterface> list) throws MetadataException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("( ");
        for (int index = 0; index < list.size(); ++index) {
            if (index > 0) {
                buffer.append(", ");
            }
            ExpressionInterface expr = list.get(index);
            String text = StringExpressionUtil.getInstance().getText(expr);
            buffer.append(text);
        }
        buffer.append(" )");
        return buffer.toString();
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        this.nullSubexpressionNotAllowed(reasons, this._whatToCompare, "SimpleConditionalExpression_In.HasEmptyWhatToCompareValue.txt");
        if (this._comparisonList == null || this._comparisonList.contains(null)) {
            reasons.add(new Reason((Object)this, 2, 32, "SimpleConditionalExpression_In.HasEmptyWhatToCompareValue.txt", new Object[0]));
        } else if (this._comparisonList.size() == 0) {
            reasons.add(new Reason((Object)this, 2, 55, "SimpleConditionalExpression_In.EmptyComparisonList.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        if (this._whatToCompare instanceof Prompt && !ExpressionUtil.isSingleSelectionPrompt((Prompt)this._whatToCompare)) {
            Reason notSingleSelectionPrompt = new Reason((Object)this, 8, 225, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, this._whatToCompare);
            reasons.add(notSingleSelectionPrompt);
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "In";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        SimpleConditionalExpression_In.writeRelatedObject(this._whatToCompare, thisElement, writingContext, "WhatToCompare");
        SimpleConditionalExpression_In.writeRelatedObjects(this._comparisonList, thisElement, writingContext, "ComparisonList");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._whatToCompare = (ExpressionInterface)((Object)riHolder.consumeObject("WhatToCompare"));
        this._comparisonList = riHolder.consumeObjects("ComparisonList", ExpressionInterface.class);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._whatToCompare = (ExpressionInterface)((Object)SimpleConditionalExpression_In.v1_readItemUnderSubelement(thisElement, readingContext, "WhatToCompare", VALID_TYPES_ANY_EXPRESSION));
        this._comparisonList = SimpleConditionalExpression_In.v1_readItemListUnderSubelement(thisElement, readingContext, "ComparisonList", VALID_TYPES_ANY_EXPRESSION);
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._whatToCompare);
        if (this._comparisonList != null) {
            intoList.addAll(this._comparisonList);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._whatToCompare = (ExpressionInterface)SimpleConditionalExpression_In.replace(this._whatToCompare, oldObject, newObject);
        SimpleConditionalExpression_In.replaceInList(this._comparisonList, oldObject, newObject);
    }
}

