/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.RelationalConditionalExpression;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class SimpleConditionalExpression_Contains
extends RelationalConditionalExpression
implements BusinessModelResourceReferencer {
    public static final String EVENT_WHAT_TO_COMPARE_CHANGED = "What to compare changed";
    public static final String EVENT_WHAT_TO_CONTAIN_CHANGED = "What to contain changed";
    private ExpressionInterface _whatToCompare;
    private ExpressionInterface _whatToContain;

    public SimpleConditionalExpression_Contains() {
    }

    public SimpleConditionalExpression_Contains(BusinessModel businessModel) throws MetadataException {
        ServerProperties srvProps = businessModel.getServerProperties();
        Function function = srvProps.getFunctionByNameID(FunctionNameID.CONTAINS);
        if (function == null) {
            throw new UnsupportedOperationException(IQMetadataResourceBundle.getStringResource("SimpleConditionalExpression_Contains.ContainsNotImplemented.txt"));
        }
    }

    public void setWhatToCompare(ExpressionInterface expr) {
        if (expr instanceof ConditionalExpression) {
            // empty if block
        }
        this.moveListeningTo(this._whatToCompare, expr);
        this._whatToCompare = expr;
        this.fireChangeEvent(EVENT_WHAT_TO_COMPARE_CHANGED);
    }

    public ExpressionInterface getWhatToCompare() {
        return this._whatToCompare;
    }

    public void setWhatToContain(ExpressionInterface expr) {
        if (expr instanceof ConditionalExpression) {
            // empty if block
        }
        this.moveListeningTo(this._whatToContain, expr);
        this._whatToContain = expr;
        this.fireChangeEvent(EVENT_WHAT_TO_CONTAIN_CHANGED);
    }

    public ExpressionInterface getWhatToContain() {
        return this._whatToContain;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._whatToCompare = this.singleReplaceResources(this._whatToCompare, oldResource, newResource, model, recursive);
        this._whatToContain = this.singleReplaceResources(this._whatToContain, oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        ExpressionInterface expr;
        SimpleConditionalExpression_Contains clone = (SimpleConditionalExpression_Contains)super.clone();
        if (!(this._whatToCompare instanceof BusinessModelResource) && this._whatToCompare != null) {
            expr = (ExpressionInterface)this._whatToCompare.clone();
            clone.setWhatToCompare(expr);
        }
        if (!(this._whatToContain instanceof BusinessModelResource) && this._whatToContain != null) {
            expr = (ExpressionInterface)this._whatToContain.clone();
            clone.setWhatToContain(expr);
        }
        return clone;
    }

    @SASScope
    public String toString() {
        try {
            return "(" + StringExpressionUtil.getInstance().getText(this._whatToCompare) + (this.isNegated() ? " NOT" : "") + " CONTAINS " + StringExpressionUtil.getInstance().getText(this._whatToContain) + ")";
        }
        catch (MetadataException e) {
            return "";
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        this.nullSubexpressionNotAllowed(reasons, this._whatToCompare, "SimpleConditionalExpression_Contains.HasNullWhatToCompare.txt");
        this.nullSubexpressionNotAllowed(reasons, this._whatToContain, "SimpleConditionalExpression_Contains.HasNullWhatToContain.txt");
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        this.validateForPrompt(this._whatToCompare, reasons);
        this.validateForPrompt(this._whatToContain, reasons);
    }

    private void validateForPrompt(ExpressionInterface expression, List<Reason> reasons) {
        if (expression instanceof Prompt) {
            if (!ExpressionUtil.isSingleSelectionPrompt((Prompt)expression)) {
                Reason notSingleSelectionPrompt = new Reason((Object)this, 8, 225, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, expression);
                reasons.add(notSingleSelectionPrompt);
            }
            if (expression.getExpressionType() != 3) {
                Reason notCharacter = new Reason((Object)this, 8, 225, "Expression.OnlyCharacterPromptsAreSupported.fmt.txt", this, expression);
                reasons.add(notCharacter);
            }
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "ContainsExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        SimpleConditionalExpression_Contains.writeRelatedObject(this._whatToCompare, thisElement, writingContext, "LeftExpr");
        SimpleConditionalExpression_Contains.writeRelatedObject(this._whatToContain, thisElement, writingContext, "RightExpr");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._whatToCompare = (ExpressionInterface)((Object)riHolder.consumeObject("LeftExpr"));
        this._whatToContain = (ExpressionInterface)((Object)riHolder.consumeObject("RightExpr"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._whatToCompare = (ExpressionInterface)((Object)SimpleConditionalExpression_Contains.v1_readItemUnderSubelement(thisElement, readingContext, "LeftExpr", VALID_TYPES_ANY_EXPRESSION));
        this._whatToContain = (ExpressionInterface)((Object)SimpleConditionalExpression_Contains.v1_readItemUnderSubelement(thisElement, readingContext, "RightExpr", VALID_TYPES_ANY_EXPRESSION));
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._whatToCompare);
        intoList.add(this._whatToContain);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._whatToCompare = (ExpressionInterface)SimpleConditionalExpression_Contains.replace(this._whatToCompare, oldObject, newObject);
        this._whatToContain = (ExpressionInterface)SimpleConditionalExpression_Contains.replace(this._whatToContain, oldObject, newObject);
    }
}

