/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.RelationalConditionalExpression;
import com.sas.iquery.metadata.impl.Utils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class SimpleConditionalExpression_Between
extends RelationalConditionalExpression {
    public static final String EVENT_WHAT_TO_COMPARE_CHANGED = "What to compare changed";
    public static final String EVENT_LEFT_EXPRESSION_CHANGED = "Left expression changed";
    public static final String EVENT_RIGHT_EXPRESSION_CHANGED = "Right expression changed";
    private ExpressionInterface _whatToCompare;
    private ExpressionInterface _leftExpr;
    private ExpressionInterface _rightExpr;
    private static final Class<?>[] VALID_EXPRESSIONS = new Class[]{ExpressionInterface.class};

    public void setWhatToCompare(ExpressionInterface expr) {
        this.moveListeningTo(this._whatToCompare, expr);
        this._whatToCompare = expr;
        this.fireChangeEvent(EVENT_WHAT_TO_COMPARE_CHANGED);
    }

    public ExpressionInterface getWhatToCompare() {
        return this._whatToCompare;
    }

    public void setLeftExpression(ExpressionInterface expr) {
        this.moveListeningTo(this._leftExpr, expr);
        this._leftExpr = expr;
        this.fireChangeEvent(EVENT_LEFT_EXPRESSION_CHANGED);
    }

    public ExpressionInterface getLeftExpression() {
        return this._leftExpr;
    }

    public void setRightExpression(ExpressionInterface expr) {
        this.moveListeningTo(this._rightExpr, expr);
        this._rightExpr = expr;
        this.fireChangeEvent(EVENT_RIGHT_EXPRESSION_CHANGED);
    }

    public ExpressionInterface getRightExpression() {
        return this._rightExpr;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._whatToCompare = this.singleReplaceResources(this._whatToCompare, oldResource, newResource, model, recursive);
        this._leftExpr = this.singleReplaceResources(this._leftExpr, oldResource, newResource, model, recursive);
        this._rightExpr = this.singleReplaceResources(this._rightExpr, oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        SimpleConditionalExpression_Between clone = (SimpleConditionalExpression_Between)super.clone();
        if (!(this._leftExpr instanceof BusinessModelResource) && this._leftExpr != null) {
            clone.setLeftExpression((ExpressionInterface)this._leftExpr.clone());
        }
        if (!(this._rightExpr instanceof BusinessModelResource) && this._rightExpr != null) {
            clone.setRightExpression((ExpressionInterface)this._rightExpr.clone());
        }
        if (!(this._whatToCompare instanceof BusinessModelResource) && this._whatToCompare != null) {
            clone.setWhatToCompare((ExpressionInterface)this._whatToCompare.clone());
        }
        return clone;
    }

    @SASScope
    public String toString() {
        try {
            if (this._leftExpr != null && this._rightExpr != null || this._leftExpr == null && this._rightExpr == null) {
                return "(" + StringExpressionUtil.getInstance().getText(this._whatToCompare) + (this.isNegated() ? " NOT" : "") + " BETWEEN " + StringExpressionUtil.getInstance().getText(this._leftExpr) + " AND " + StringExpressionUtil.getInstance().getText(this._rightExpr) + ")";
            }
            if (this._leftExpr == null) {
                return (this.isNegated() ? " NOT " : "") + "(" + StringExpressionUtil.getInstance().getText(this._whatToCompare) + " " + Utils.toString(ComparisonOperator.COMPARE_EQ) + " " + StringExpressionUtil.getInstance().getText(this._rightExpr) + ")";
            }
            return (this.isNegated() ? " NOT " : "") + "(" + StringExpressionUtil.getInstance().getText(this._whatToCompare) + " " + Utils.toString(ComparisonOperator.COMPARE_EQ) + " " + StringExpressionUtil.getInstance().getText(this._leftExpr) + ")";
        }
        catch (MetadataException e) {
            return " ";
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        this.nullSubexpressionNotAllowed(reasons, this._whatToCompare, "SimpleConditionalExpression_Between.HasEmptyWhatToCompareValue.txt");
        if (this._leftExpr == null && this._rightExpr == null) {
            reasons.add(new Reason((Object)this, 2, 32, "SimpleConditionalExpression_Between.RangeNotSpecified.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        this.validateForPrompt(this._whatToCompare, reasons);
        this.validateForPrompt(this._leftExpr, reasons);
        this.validateForPrompt(this._rightExpr, reasons);
    }

    private void validateForPrompt(ExpressionInterface expression, List<Reason> reasons) {
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "Between";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        SimpleConditionalExpression_Between.writeRelatedObject(this._whatToCompare, thisElement, writingContext, "WhatToCompare");
        SimpleConditionalExpression_Between.writeRelatedObject(this._leftExpr, thisElement, writingContext, "LeftExpr");
        SimpleConditionalExpression_Between.writeRelatedObject(this._rightExpr, thisElement, writingContext, "RightExpr");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._whatToCompare = (ExpressionInterface)((Object)riHolder.consumeObject("WhatToCompare"));
        this._leftExpr = (ExpressionInterface)((Object)riHolder.consumeObject("LeftExpr"));
        this._rightExpr = (ExpressionInterface)((Object)riHolder.consumeObject("RightExpr"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._whatToCompare = (ExpressionInterface)((Object)SimpleConditionalExpression_Between.v1_readItemUnderSubelement(thisElement, readingContext, "WhatToCompare", VALID_EXPRESSIONS));
        this._leftExpr = (ExpressionInterface)((Object)SimpleConditionalExpression_Between.v1_readItemUnderSubelement(thisElement, readingContext, "LeftExpr", VALID_EXPRESSIONS));
        this._rightExpr = (ExpressionInterface)((Object)SimpleConditionalExpression_Between.v1_readItemUnderSubelement(thisElement, readingContext, "RightExpr", VALID_EXPRESSIONS));
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._leftExpr);
        intoList.add(this._rightExpr);
        intoList.add(this._whatToCompare);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._leftExpr = (ExpressionInterface)SimpleConditionalExpression_Between.replace(this._leftExpr, oldObject, newObject);
        this._rightExpr = (ExpressionInterface)SimpleConditionalExpression_Between.replace(this._rightExpr, oldObject, newObject);
        this._whatToCompare = (ExpressionInterface)SimpleConditionalExpression_Between.replace(this._whatToCompare, oldObject, newObject);
    }
}

