/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.TimeShiftAlignment;
import com.sas.iquery.metadata.expr.relational.TimeShiftDirection;
import com.sas.iquery.metadata.expr.relational.TimeShiftUnit;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.impl.MessageFormatter;

@SASScope(value="ALL")
@SubjectToChange
public class RelativeTimestampValueExpression
extends AbstractRelativeTimeValueExpression {
    private static final String SAS_RELATIVE_DATE_DATETIME = "datetime()";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final FunctionCall DATETIME = new FunctionCall();

    @SASScope(value="ALL")
    @SubjectToChange
    public RelativeTimestampValueExpression() {
        super(DATETIME, TimeShiftUnit.SECOND, TimeShiftDirection.CURRENT, 0, TimeShiftAlignment.NONE, false);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public RelativeTimestampValueExpression(ExpressionInterface shiftFrom, TimeShiftUnit unitValue, TimeShiftDirection directionValue, int multiplierValue, TimeShiftAlignment alignmentValue) {
        this(shiftFrom, unitValue, directionValue, multiplierValue, alignmentValue, false);
    }

    private RelativeTimestampValueExpression(ExpressionInterface shiftFrom, TimeShiftUnit unitValue, TimeShiftDirection directionValue, int multiplierValue, TimeShiftAlignment alignmentValue, boolean isConstant) throws IllegalArgumentException {
        super(shiftFrom, unitValue, directionValue, multiplierValue, alignmentValue, isConstant);
        if (!this.isValidShiftFrom(shiftFrom)) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("RelativeDateValueExpression.invalidStartDateType.fmt.txt", Integer.toString(shiftFrom.getExpressionType())));
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "RelativeTimestampValueExpr";
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public void setShiftingFrom(ExpressionInterface exp) throws IllegalArgumentException, MetadataException {
        if (!this.isValidShiftFrom(exp)) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("RelativeDateValueExpression.invalidStartDateType.fmt.txt", Integer.toString(exp.getExpressionType()));
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        super.setShiftingFrom(exp);
    }

    @Override
    @SASScope
    protected String getBaseSASRelativeDateString() {
        return SAS_RELATIVE_DATE_DATETIME;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public int getExpressionType() {
        return 6;
    }

    @Override
    @SASScope
    protected boolean isValidShiftFrom(ExpressionInterface exp) {
        boolean returnValue = true;
        if (null != exp && exp.getExpressionType() != 6) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    @SASScope
    protected TimeShiftUnit getBaseTimeUnit() {
        return TimeShiftUnit.SECOND;
    }

    @Override
    @SASScope
    public String generateQueryText(DataSelection dataSelection, ConnectionType connectionType) throws MetadataException {
        String returnValue = super.generateQueryText(dataSelection, connectionType);
        return returnValue;
    }

    @Override
    @SASScope
    public String toString() {
        String output = super.toString();
        return output;
    }

    static {
        try {
            Function datetime = ServerProperties.getFunctionByFullID("saswks90.DateTime");
            if (datetime == null) {
                throw new IQueryServicesRuntimeException(IQModelImplUtilities.getMessage("RelativeTimestampValueExpression.invalidconfigdatetime.txt", new Object[0]));
            }
            DATETIME.setFunction(datetime);
        }
        catch (MetadataException e) {
            throw new IQueryServicesRuntimeException(IQModelImplUtilities.getMessage("RelativeTimestampValueExpression.invalidconfigdatetime.txt", new Object[0]));
        }
    }
}

