/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.TimeShiftAlignment;
import com.sas.iquery.metadata.expr.relational.TimeShiftDirection;
import com.sas.iquery.metadata.expr.relational.TimeShiftUnit;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.impl.MessageFormatter;

@SASScope(value="ALL")
@SubjectToChange
public class RelativeDateValueExpression
extends AbstractRelativeTimeValueExpression {
    private static final String SAS_RELATIVE_DATE_TODAY = "today()";
    private static final String SAS_RELATIVE_DATE_YESTERDAY = "today()-1";
    private static final String SAS_RELATIVE_DATE_TOMORROW = "today()+1";
    @SubjectToChange
    public static final FunctionCall TODAY = new FunctionCall();
    @SASScope(value="ALL")
    @SubjectToChange
    public static final RelativeDateValueExpression YESTERDAY;
    @SubjectToChange
    public static final RelativeDateValueExpression TOMORROW;

    @SubjectToChange
    public RelativeDateValueExpression() {
        super(TODAY, TimeShiftUnit.DAY, TimeShiftDirection.CURRENT, 0, TimeShiftAlignment.NONE, false);
    }

    @SubjectToChange
    public RelativeDateValueExpression(ExpressionInterface shiftFrom, TimeShiftUnit unitValue, TimeShiftDirection directionValue, int multiplierValue, TimeShiftAlignment alignmentValue) {
        this(shiftFrom, unitValue, directionValue, multiplierValue, alignmentValue, false);
    }

    private RelativeDateValueExpression(ExpressionInterface shiftFrom, TimeShiftUnit unitValue, TimeShiftDirection directionValue, int multiplierValue, TimeShiftAlignment alignmentValue, boolean isConstant) throws IllegalArgumentException {
        super(shiftFrom, unitValue, directionValue, multiplierValue, alignmentValue, isConstant);
        if (!this.isValidShiftFrom(shiftFrom)) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.invalidStartDateType.fmt.txt", Integer.toString(shiftFrom.getExpressionType()));
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "RelativeDateValueExpr";
    }

    @Override
    @SubjectToChange
    public void setShiftingFrom(ExpressionInterface exp) throws IllegalArgumentException, MetadataException {
        if (!this.isValidShiftFrom(exp)) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.invalidStartDateType.fmt.txt", Integer.toString(exp.getExpressionType()));
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        super.setShiftingFrom(exp);
    }

    @Override
    @SASScope
    protected String getBaseSASRelativeDateString() {
        return SAS_RELATIVE_DATE_TODAY;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public int getExpressionType() {
        return 4;
    }

    @Override
    @SASScope
    protected boolean isValidShiftFrom(ExpressionInterface exp) {
        if (null != exp) {
            return exp.getExpressionType() == 4 || exp.getExpressionType() == 6;
        }
        return true;
    }

    @Override
    @SASScope
    protected TimeShiftUnit getBaseTimeUnit() {
        return TimeShiftUnit.DAY;
    }

    @Override
    @SASScope
    protected AbstractModelItem getConstantEquivalent() {
        RelativeDateValueExpression returnValue = null;
        if (this.equals(TOMORROW)) {
            returnValue = TOMORROW;
        } else if (this.equals(YESTERDAY)) {
            returnValue = YESTERDAY;
        }
        return returnValue;
    }

    @Override
    @SASScope
    public String generateQueryText(DataSelection dataSelection, ConnectionType connectionType, String shiftFromValue) throws MetadataException {
        String returnValue = super.generateQueryText(dataSelection, connectionType, shiftFromValue);
        return returnValue;
    }

    @Override
    @SASScope
    public String toString() {
        String output = "";
        output = this.equals(TOMORROW) ? SAS_RELATIVE_DATE_TOMORROW : (this.equals(YESTERDAY) ? SAS_RELATIVE_DATE_YESTERDAY : super.toString());
        return output;
    }

    static {
        try {
            Function today = ServerProperties.getFunctionByFullID("saswks90.Today");
            if (today == null) {
                throw new IQueryServicesRuntimeException(IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.invalidconfigdate.txt", new Object[0]));
            }
            TODAY.setFunction(today);
        }
        catch (MetadataException e) {
            throw new IQueryServicesRuntimeException(IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.invalidconfigdate.txt", new Object[0]));
        }
        YESTERDAY = new RelativeDateValueExpression(TODAY, TimeShiftUnit.DAY, TimeShiftDirection.PREVIOUS, 1, TimeShiftAlignment.NONE, true);
        TOMORROW = new RelativeDateValueExpression(TODAY, TimeShiftUnit.DAY, TimeShiftDirection.NEXT, 1, TimeShiftAlignment.NONE, true);
    }
}

