/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class DataItemFormattingExpression
extends AbstractModelItem
implements ExpressionInterface {
    public static final String EVENT_IS_FORMATTED_CHANGED = "The is formatted attribute has changed";
    public static final String EVENT_IS_CHARACTER_FORMATTED_WHEN_NO_FORMAT_CHANGED = "The use of default format for character attribute has changed";
    public static final String EVENT_DATA_ITEM_CHANGED = "The referenced data item has changed";
    private DataItem _dataItem;
    private boolean _isFormatted = true;
    private boolean _isCharacterFormattedWhenNoFormat = false;

    public DataItem getDataItem() {
        return this._dataItem;
    }

    public void setDataItem(DataItem item) {
        if (item != this._dataItem) {
            DataItem previousItem = this._dataItem;
            this._dataItem = item;
            if (previousItem != null) {
                previousItem.removeListener(this);
            }
            if (item != null) {
                item.addListener(this);
            }
            this.fireChangeEvent(EVENT_DATA_ITEM_CHANGED, item, previousItem);
        }
    }

    public boolean isFormatted() {
        return this._isFormatted;
    }

    public void setIsFormatted(boolean isFormatted) {
        if (this._isFormatted != isFormatted) {
            this._isFormatted = isFormatted;
            this.fireChangeEvent(EVENT_IS_FORMATTED_CHANGED, null, null);
        }
    }

    public boolean isCharacterFormattedWhenNoFormat() {
        return this._isCharacterFormattedWhenNoFormat;
    }

    public void setIsCharacterFormattedWhenNoFormat(boolean isCharacterFormattedWhenNoFormat) {
        if (this._isCharacterFormattedWhenNoFormat != isCharacterFormattedWhenNoFormat) {
            this._isCharacterFormattedWhenNoFormat = isCharacterFormattedWhenNoFormat;
            this.fireChangeEvent(EVENT_IS_CHARACTER_FORMATTED_WHEN_NO_FORMAT_CHANGED, null, null);
        }
    }

    @Override
    public int getExpressionType() {
        int type = 0;
        if (this._isFormatted) {
            type = 3;
        } else if (this._dataItem != null) {
            type = this._dataItem.getExpressionTypeIgnoringFormattingForced();
        }
        return type;
    }

    @Override
    protected String getDefinitionElementName() {
        return "DataItemFormattingExpr";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "isFormatted", this._isFormatted, true);
        IQModelImplUtilities.setBooleanAttr(thisElement, "charFormattedWhenNoFormat", this._isCharacterFormattedWhenNoFormat, false);
        DataItemFormattingExpression.writeRelatedObject(this._dataItem, thisElement, writingContext, "Item");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._isFormatted = attrsProvider.consumeBooleanAttr("isFormatted", true);
        this._isCharacterFormattedWhenNoFormat = attrsProvider.consumeBooleanAttr("charFormattedWhenNoFormat", false);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._dataItem = (DataItem)((Object)riHolder.consumeObject("Item"));
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._isFormatted = IQModelImplUtilities.getBooleanAttr(thisElement, "formatted", true);
        this._isCharacterFormattedWhenNoFormat = IQModelImplUtilities.getBooleanAttr(thisElement, "charFormattedWhenNoFormat", false);
        this._dataItem = (DataItem)((Object)DataItemFormattingExpression.v1_readItemUnderSubelement(thisElement, readingContext, "DI", new Class[]{DataItem.class}));
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        DataItem newItem = (DataItem)Utils.replaceResource(this._dataItem, oldResource, newResource, model, recursive);
        if (this._dataItem != newItem) {
            this._dataItem.removeListener(this);
            newItem.addListener(this);
            this._dataItem = newItem;
        }
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._dataItem);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._dataItem = (DataItem)DataItemFormattingExpression.replace(this._dataItem, oldObject, newObject);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataItemFormattingExpression clone = (DataItemFormattingExpression)super.clone();
        return clone;
    }

    public String toString() {
        String diText = null;
        if (this._dataItem != null) {
            try {
                diText = StringExpressionUtil.getInstance().getText(this._dataItem, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, null);
            }
            catch (MetadataException e) {
                diText = Utils.toString(this._dataItem);
            }
        }
        return "DataItemFormattingExpression(" + diText + ", " + (this._isFormatted ? "'formatted'" : "'unformatted'") + ", " + (this._isCharacterFormattedWhenNoFormat ? "'charFormattedWhenNoFormat'" : "'charNotFormattedWhenNoFormat'") + ")";
    }
}

