/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.relational.RelativeDateValueExpression;
import com.sas.iquery.metadata.expr.relational.TimeShiftAlignment;
import com.sas.iquery.metadata.expr.relational.TimeShiftDirection;
import com.sas.iquery.metadata.expr.relational.TimeShiftUnit;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFactory;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public abstract class AbstractRelativeTimeValueExpression
extends AbstractExpression {
    @SubjectToChange
    public static final String EVENT_UNIT_CHANGED = "Unit changed";
    @SubjectToChange
    public static final String EVENT_MULTIPLIER_CHANGED = "Multiplier changed";
    @SubjectToChange
    public static final String EVENT_ALIGNMENT_CHANGED = "Alignment changed";
    @SubjectToChange
    public static final String EVENT_SHIFT_DIRECTION_CHANGED = "Shift Direction changed";
    @SubjectToChange
    public static final String EVENT_SHIFT_FROM_CHANGED = "Shift from changed";
    private ExpressionInterface _shiftingFrom = null;
    private TimeShiftAlignment _shiftAlignment = null;
    private TimeShiftUnit _shiftUnit = null;
    private TimeShiftDirection _shiftDirection = null;
    private int _shiftMultiplier;
    private boolean _constant = false;
    private static final Logger _logger = LogManager.getLogger(AbstractRelativeTimeValueExpression.class);

    @SASScope
    protected AbstractRelativeTimeValueExpression() {
    }

    @SASScope
    protected AbstractRelativeTimeValueExpression(ExpressionInterface exp, TimeShiftUnit unitValue, TimeShiftDirection directionValue, int multiplierValue, TimeShiftAlignment alignmentValue, boolean isConstant) {
        this._shiftUnit = unitValue;
        this._shiftDirection = directionValue;
        this._shiftMultiplier = multiplierValue;
        this._shiftAlignment = alignmentValue;
        if (this.isValidShiftFrom(exp)) {
            this._shiftingFrom = exp;
        }
        this._constant = isConstant;
    }

    @SubjectToChange
    public static AbstractRelativeTimeValueExpression getRelativeSASDateExpression() {
        return new RelativeDateValueExpression();
    }

    @Override
    @SubjectToChange
    public abstract int getExpressionType();

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        List<String> invalidReasons = this.buildReasonsUnusable();
        for (String s : invalidReasons) {
            reasons.add(new Reason((Object)this, 2, 70, "AbstractRelativeTimeValueExpression.IllDefined.fmt.txt", s));
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        AbstractRelativeTimeValueExpression result = null;
        if (this.isConstant()) {
            result = this;
        } else {
            AbstractRelativeTimeValueExpression clone = (AbstractRelativeTimeValueExpression)super.clone();
            clone._shiftAlignment = this._shiftAlignment;
            clone._shiftDirection = this._shiftDirection;
            clone._shiftMultiplier = this._shiftMultiplier;
            clone._shiftUnit = this._shiftUnit;
            clone._shiftingFrom = (ExpressionInterface)this._shiftingFrom.clone();
            result = clone;
        }
        return result;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public TimeShiftAlignment getAlignment() {
        return this._shiftAlignment;
    }

    @SubjectToChange
    public void setAlignment(TimeShiftAlignment alignment) throws MetadataException, IllegalArgumentException {
        if (this._constant) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.unableToSetValueOnConstant.txt", new Object[0]));
        }
        Preconditions.ensureNonNull(alignment);
        if (IQModelImplUtilities.different(alignment, this._shiftAlignment)) {
            this._shiftAlignment = alignment;
            this.fireChangeEvent(EVENT_ALIGNMENT_CHANGED);
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (null != this._shiftAlignment && !this._shiftAlignment.equals(TimeShiftAlignment.NONE)) {
            IQModelImplUtilities.setAttr(thisElement, "shiftAlignment", this._shiftAlignment.getPersistentForm());
        }
        if (this._shiftMultiplier != 0) {
            IQModelImplUtilities.setIntAttr(thisElement, "shiftMultiplier", this._shiftMultiplier);
        }
        if (null != this._shiftUnit && !this._shiftUnit.equals(this.getBaseTimeUnit())) {
            IQModelImplUtilities.setAttr(thisElement, "shiftUnit", this._shiftUnit.getPersistentForm());
        }
        if (null != this._shiftDirection && !this._shiftDirection.equals(TimeShiftDirection.CURRENT)) {
            IQModelImplUtilities.setAttr(thisElement, "shiftDirection", this._shiftDirection.getPersistentForm());
        }
        AbstractRelativeTimeValueExpression.writeRelatedObject(this._shiftingFrom, thisElement, writingContext, "ShiftingFrom");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String attr = attrsProvider.consumeAttr("shiftAlignment");
        this._shiftAlignment = attr != null ? TimeShiftAlignment.fromPersistentForm(attr) : TimeShiftAlignment.NONE;
        this._shiftMultiplier = attrsProvider.consumeIntAttr("shiftMultiplier", 0);
        attr = attrsProvider.consumeAttr("shiftDirection");
        this._shiftDirection = attr != null ? TimeShiftDirection.fromPersistentForm(attr) : TimeShiftDirection.CURRENT;
        attr = attrsProvider.consumeAttr("shiftUnit");
        this._shiftUnit = attr != null ? TimeShiftUnit.fromPersistentForm(attr) : this.getBaseTimeUnit();
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._shiftingFrom = (ExpressionInterface)((Object)riHolder.consumeObject("ShiftingFrom"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String attr = IQModelImplUtilities.getAttr(thisElement, "shiftAlignment");
        this._shiftAlignment = attr != null ? TimeShiftAlignment.fromPersistentForm(attr) : TimeShiftAlignment.NONE;
        this._shiftMultiplier = IQModelImplUtilities.getIntAttr(thisElement, "shiftMultiplier", 0);
        attr = IQModelImplUtilities.getAttr(thisElement, "shiftDirection");
        this._shiftDirection = attr != null ? TimeShiftDirection.fromPersistentForm(attr) : TimeShiftDirection.CURRENT;
        attr = IQModelImplUtilities.getAttr(thisElement, "shiftUnit");
        this._shiftUnit = attr != null ? TimeShiftUnit.fromPersistentForm(attr) : this.getBaseTimeUnit();
        this.setShiftingFrom((ExpressionInterface)((Object)AbstractRelativeTimeValueExpression.v1_readItemUnderSubelement(thisElement, readingContext, "ShiftingFrom", VALID_TYPES_ANY_EXPRESSION)));
    }

    @SASScope
    public String generateQueryText(DataSelection dataSelection, ConnectionType connectionType, String shiftFromValue) throws MetadataException {
        String returnValue = this.generateOutputForSimpleShiftFrom(dataSelection, connectionType, shiftFromValue);
        if (null != returnValue) {
            return returnValue;
        }
        StringBuffer output = new StringBuffer("intnx(\"");
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        this.generateOutputForShiftUnit(output, computationalLocale);
        output.append("\",");
        output.append(shiftFromValue);
        output.append(",");
        this.generateOutputForShiftMultiplier(output);
        output.append(",\"");
        this.generateOutputForAlignment(output);
        output.append("\")");
        return output.toString();
    }

    @SASScope
    public String generateQueryText(DataSelection dataSelection, ConnectionType connectionType) throws MetadataException {
        String shiftFromValue;
        ExpressionInterface shiftFromExpr = this.getShiftingFrom();
        SQLSASFactory factory = new SQLSASFactory();
        try {
            SQLExpressionAbstract sqlExpression = factory.createSQLExpression();
            sqlExpression.setDataSelection(dataSelection);
            DataSelectionProcessorAbstract dsp = factory.newDataSelectionProcessor(dataSelection);
            sqlExpression.setDataSelectionProcessor(dsp);
            sqlExpression.setExecuteMacroExpressions(false);
            sqlExpression.setUseAltSyntaxForRelDate(false);
            shiftFromValue = sqlExpression.generateExpressionSQL(shiftFromExpr, 3, new HashMap<ExpressionInterface, String>());
        }
        catch (GenerationException e) {
            throw new MetadataException(e);
        }
        return this.generateQueryText(dataSelection, connectionType, shiftFromValue);
    }

    @SASScope
    protected abstract TimeShiftUnit getBaseTimeUnit();

    @SASScope
    protected abstract String getBaseSASRelativeDateString();

    private void generateOutputForShiftMultiplier(StringBuffer output) {
        TimeShiftDirection direct = this.getShiftDirection();
        if (direct == null) {
            direct = TimeShiftDirection.CURRENT;
        }
        if (direct.equals(TimeShiftDirection.CURRENT)) {
            output.append("0");
        } else if (direct.equals(TimeShiftDirection.PREVIOUS)) {
            output.append(-1 * this._shiftMultiplier);
        } else {
            output.append(this._shiftMultiplier);
        }
    }

    private void generateOutputForShiftUnit(StringBuffer output, Locale locale) {
        TimeShiftUnit shiftUnit = this.getShiftUnit();
        if (shiftUnit != null) {
            Calendar cal;
            int firstDayOfWeek;
            String unit = shiftUnit.getQueryText();
            if (!(this.getExpressionType() != 6 || shiftUnit.equals(TimeShiftUnit.SECOND) || shiftUnit.equals(TimeShiftUnit.MINUTE) || shiftUnit.equals(TimeShiftUnit.HOUR))) {
                unit = "dt" + unit;
            }
            if (shiftUnit == TimeShiftUnit.WEEK && (firstDayOfWeek = (cal = Calendar.getInstance(locale)).getFirstDayOfWeek()) != 1) {
                unit = unit + "." + firstDayOfWeek;
            }
            output.append(unit);
        } else {
            output.append(this.getBaseTimeUnit().getQueryText());
        }
    }

    private void generateOutputForAlignment(StringBuffer output) {
        TimeShiftAlignment align = this.getAlignment();
        if (null == align) {
            align = TimeShiftAlignment.NONE;
        }
        output.append(align.getQueryText());
    }

    private String generateOutputForSimpleShiftFrom(DataSelection dataSelection, ConnectionType connectionType, String shiftFromValue) throws MetadataException, IllegalArgumentException {
        String returnValue = null;
        ExpressionInterface startingTime = this.getShiftingFrom();
        if (null == startingTime) {
            TimeShiftUnit shiftUnit = this.getShiftUnit();
            if (null == shiftUnit || shiftUnit.equals(this.getBaseTimeUnit())) {
                returnValue = this.generateSimpleShiftFromWithMultiplier();
            }
        } else {
            if (null == this.getShiftUnit() || this.getShiftUnit().equals(this.getBaseTimeUnit())) {
                returnValue = this.generateChildTimeQueryValue(dataSelection, connectionType, shiftFromValue);
                TimeShiftDirection startModifier = this.getShiftDirection();
                if (null != startModifier) {
                    returnValue = this.generateStringMultiplerWithDirection(returnValue);
                }
            }
            if (returnValue == null) {
                if (null == this.getAlignment() || this.getAlignment() == TimeShiftAlignment.NONE) {
                    if (this._shiftMultiplier == 0 || null != this.getShiftDirection() && this.getShiftDirection() == TimeShiftDirection.CURRENT) {
                        returnValue = this.generateChildTimeQueryValue(dataSelection, connectionType, shiftFromValue);
                    }
                } else if ((null == this.getShiftUnit() || this.getShiftUnit() == this.getBaseTimeUnit()) && this._shiftMultiplier == 0) {
                    returnValue = this.generateChildTimeQueryValue(dataSelection, connectionType, returnValue);
                }
            }
        }
        return returnValue;
    }

    private String generateStringMultiplerWithDirection(String returnValue) {
        int mod = this.getShiftMultiplier();
        TimeShiftDirection startModifier = this.getShiftDirection();
        if (startModifier != null) {
            if (startModifier.equals(TimeShiftDirection.NEXT)) {
                returnValue = returnValue + "+" + mod;
            } else if (startModifier.equals(TimeShiftDirection.PREVIOUS)) {
                returnValue = returnValue + "-" + mod;
            }
        }
        return returnValue;
    }

    private String generateChildTimeQueryValue(DataSelection dataSelection, ConnectionType connectionType, String returnValue) throws MetadataException, IllegalArgumentException {
        ExpressionInterface startingTime = this.getShiftingFrom();
        returnValue = this.generateShiftFromTypeChange(returnValue, startingTime);
        return returnValue;
    }

    private String generateShiftFromTypeChange(String returnValue, ExpressionInterface startingTime) {
        if (this.getExpressionType() == 4) {
            if (startingTime.getExpressionType() == 6) {
                returnValue = "datepart(" + returnValue + ")";
            }
        } else if (this.getExpressionType() == 5 && startingTime.getExpressionType() == 6) {
            returnValue = "timepart(" + returnValue + ")";
        }
        return returnValue;
    }

    private String generateSimpleShiftFromWithMultiplier() {
        String returnValue = null;
        TimeShiftDirection shiftDirection = null;
        shiftDirection = this.getShiftDirection();
        returnValue = null != shiftDirection ? this.generateStringMultiplerWithDirection(this.getBaseSASRelativeDateString()) : this.getBaseSASRelativeDateString();
        return returnValue;
    }

    @Nonnull
    @SASScope
    protected List<String> buildReasonsUnusable() {
        ArrayList<String> invalidReasons = new ArrayList<String>();
        if (this._shiftingFrom == null || !this.isValidShiftFrom(this._shiftingFrom)) {
            String msg = IQModelImplUtilities.getMessage("RelativeDateValueExpression.invalidStartDateType.fmt.txt", "");
            invalidReasons.add(msg);
        }
        return invalidReasons;
    }

    @SASScope
    protected abstract boolean isValidShiftFrom(ExpressionInterface var1);

    @SASScope
    public String toString() {
        String sdv;
        TimeShiftAlignment al = this.getAlignment();
        String alignment = "";
        if (null != al && !al.equals(TimeShiftAlignment.NONE) && !this.getBaseTimeUnit().equals(this.getShiftUnit())) {
            alignment = alignment + al.toString();
        }
        TimeShiftDirection tm = this.getShiftDirection();
        String modifierString = "";
        if (null != tm) {
            modifierString = modifierString + tm.toString();
        }
        String multiplierString = "";
        String multiplierValueString = "";
        if (this._shiftMultiplier != 0 && tm != null && !tm.equals(TimeShiftDirection.CURRENT)) {
            multiplierString = Integer.toString(this._shiftMultiplier);
        }
        if (!tm.equals(TimeShiftDirection.CURRENT)) {
            multiplierValueString = multiplierString.length() > 0 ? IQModelImplUtilities.getMessage("TimeShiftModifier.toString.name.fmt.txt", modifierString, multiplierString) : IQModelImplUtilities.getMessage("TimeShiftModifierNoMultiplier.toString.name.fmt.txt", modifierString);
        }
        TimeShiftUnit ss = this.getShiftUnit();
        String unitString = "";
        if (null != ss) {
            unitString = this._shiftMultiplier <= 1 ? unitString + ss.toString() : unitString + ss.pluralDisplayText();
        }
        ExpressionInterface startDate = this.getShiftingFrom();
        String startDateString = "";
        startDateString = null != startDate ? ((sdv = startDate.toString()).length() != 0 && !sdv.equals(this.getBaseSASRelativeDateString()) ? startDateString + "{" + sdv + "}" : sdv) : startDateString + this.getBaseSASRelativeDateString();
        String multiplierWithUnitString = "";
        if (multiplierValueString.length() == 0 || unitString.length() == 0) {
            if (multiplierValueString.length() != 0 || null == ss || !ss.equals(this.getBaseTimeUnit())) {
                multiplierWithUnitString = multiplierValueString + unitString;
            }
        } else {
            multiplierWithUnitString = IQModelImplUtilities.getMessage("RelativeTimeShift.toString.fmt.txt", multiplierValueString, unitString);
        }
        if (alignment.length() == 0) {
            if (multiplierWithUnitString.length() == 0) {
                return startDateString;
            }
            return IQModelImplUtilities.getMessage("AbstractRelativeTimeValueExpressionANULL.toString.name.fmt.txt", multiplierWithUnitString, startDateString);
        }
        return IQModelImplUtilities.getMessage("AbstractRelativeTimeValueExpressionFNULL.toString.name.fmt.txt", alignment, multiplierWithUnitString, startDateString);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public TimeShiftUnit getShiftUnit() {
        return this._shiftUnit;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setShiftUnit(TimeShiftUnit unit) throws MetadataException, IllegalArgumentException {
        if (this._constant) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.unableToSetValueOnConstant.txt", new Object[0]));
        }
        Preconditions.ensureNonNull(unit);
        if (IQModelImplUtilities.different(this._shiftUnit, unit)) {
            this._shiftUnit = unit;
            this.fireChangeEvent(EVENT_UNIT_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public int getShiftMultiplier() {
        return this._shiftMultiplier;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setShiftMultiplier(int multiplier) throws MetadataException {
        if (this._constant) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.unableToSetValueOnConstant.txt", new Object[0]));
        }
        if (multiplier < 0) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("AbstractRelativeTimeValueExpression.NegativeMultiplier.fmt.txt", multiplier));
        }
        if (this._shiftMultiplier != multiplier) {
            this._shiftMultiplier = multiplier;
            this.fireChangeEvent(EVENT_MULTIPLIER_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ExpressionInterface getShiftingFrom() {
        return this._shiftingFrom;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setShiftingFrom(ExpressionInterface exp) throws IllegalArgumentException, MetadataException {
        if (this._constant) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.unableToSetValueOnConstant.txt", new Object[0]));
        }
        if (exp == this) {
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn(IQModelImplUtilities.getMessage("RelativeDateValueExpression.unableToSetShiftFromToSelf.txt", new Object[0]));
            }
            return;
        }
        if (this._shiftingFrom != exp) {
            this._shiftingFrom = exp;
            this.fireChangeEvent(EVENT_SHIFT_FROM_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public TimeShiftDirection getShiftDirection() {
        return this._shiftDirection;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setShiftDirection(TimeShiftDirection direction) throws MetadataException, IllegalArgumentException {
        if (this._constant) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("RelativeDateValueExpression.unableToSetValueOnConstant.txt", new Object[0]));
        }
        Preconditions.ensureNonNull(direction);
        if (IQModelImplUtilities.different(this._shiftDirection, direction)) {
            this._shiftDirection = direction;
            this.fireChangeEvent(EVENT_SHIFT_DIRECTION_CHANGED);
        }
    }

    @SASScope
    public int hashCode() {
        int result = 167;
        result = 37 * result + (this._shiftDirection == null ? 0 : this._shiftDirection.hashCode());
        result = 37 * result + (this._shiftAlignment == null ? 0 : this._shiftAlignment.hashCode());
        result = 37 * result + (this._shiftUnit == null ? 0 : this._shiftUnit.hashCode());
        result = 37 * result + (this._shiftingFrom == null ? 0 : this._shiftingFrom.hashCode());
        result = 37 * result + this._shiftMultiplier;
        result = 37 * result + 7;
        return result;
    }

    @SASScope
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractRelativeTimeValueExpression) {
            AbstractRelativeTimeValueExpression o2 = (AbstractRelativeTimeValueExpression)obj;
            boolean equals = IQModelImplUtilities.same(this.getShiftingFrom(), o2.getShiftingFrom());
            if (!equals && null != this.getShiftingFrom() && this.getShiftingFrom() instanceof FunctionCall && null != o2.getShiftingFrom() && o2.getShiftingFrom() instanceof FunctionCall) {
                FunctionCall fc = (FunctionCall)this.getShiftingFrom();
                FunctionCall o2fc = (FunctionCall)o2.getShiftingFrom();
                if (fc.getFunction().getNameID().equals(o2fc.getFunction().getNameID())) {
                    equals = true;
                }
            }
            if (equals) {
                equals = IQModelImplUtilities.same(this.getAlignment(), o2.getAlignment());
            }
            if (equals) {
                equals = IQModelImplUtilities.same(this.getShiftDirection(), o2.getShiftDirection());
            }
            if (equals && this.getShiftMultiplier() != o2.getShiftMultiplier()) {
                equals = false;
            }
            if (equals) {
                equals = IQModelImplUtilities.same(this.getShiftUnit(), o2.getShiftUnit());
            }
            return equals;
        }
        return false;
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._shiftingFrom);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._shiftingFrom = (ExpressionInterface)AbstractRelativeTimeValueExpression.replace(this._shiftingFrom, oldObject, newObject);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isConstant() {
        return this._constant;
    }
}

