/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.parser;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceIdentificationException;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.TimeValueExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression_Between;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.PromptedTimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.parser.EscapeIdentifier;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.parser.OlapMemberIdentifier;
import com.sas.iquery.metadata.expr.parser.Resource;
import com.sas.iquery.metadata.expr.parser.ResourceIdentifier;
import com.sas.iquery.metadata.expr.parser.StringIdentifier;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.util.LocalizableToStringInterface;
import com.sas.util.transforms.ObjectToStringTransform;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringExpressionUtilImpl
extends StringExpressionUtil {
    private TimeZone _FORMAT_TimeZone = TimeZone.getTimeZone("GMT");
    private static final Logger _logger = LogManager.getLogger(StringExpressionUtilImpl.class);
    private Locale _FORMAT_Locale = null;
    private static final String FORMAT_NULL_OBJECT = "null";
    private static final String FORMAT_QUALIFIED_MEMBER = "[{0}]";
    private static final String FORMAT_QUALIFIED_MEMBER_SEPR = ";";
    private static final String FORMAT_QUALIFIED_MEMBER_JOIN = "{0}{1}{2}";
    private static final String FORMAT_LIST_OF_VALUES = "({0})";
    private static final String FORMAT_LIST_OF_VALUES_SEPR = ",";
    private static final String FORMAT_LIST_OF_VALUES_JOIN = "{0}{1}{2}";
    private static final String FORMAT_CCE_GROUP = "( {0} )";
    private static final String FORMAT_CCE_GROUP_NOT = "NOT ( {0} )";
    private static final String FORMAT_CCE = "( {0} {1} {2} )";
    private static final String FORMAT_CCE_NOT = "NOT ( {0} {1} {2} )";
    private static final String FORMAT_DBFE = "( {0} WHERE {1} {2} {3} )";
    private static final String FORMAT_DBFE_NOT = "( {0} NOT ({1} {2} {3}) )";
    private static final String FORMAT_DBFE_BETWEEN = "( {0} WHERE ({1} IS {2} BETWEEN {3} AND {4}) )";
    private static final String FORMAT_DBFE_BETWEEN_NOT = "( {0} ({1} IS {2} NOT BETWEEN {3} AND {4}) )";
    private static final String FORMAT_MFE = "( {0} IN ({1}) )";
    private static final String FORMAT_MFE_NOT = "( {0} NOT IN ({1}) )";
    private static final String FORMAT_SFE = "( {0} IN ({1}) )";
    private static final String FORMAT_SFE_NOT = "( {0} NOT IN ({1}) )";
    private static final String FORMAT_MCE = "( {0} )";
    private static final String FORMAT_MCE_NOT = "NOT ( {0} )";
    private static final String FORMAT_MCE_LIST_JOIN = "{0} {1} {2}";
    private static final String FORMAT_SCE_BETWEEN = "( {0} BETWEEN {1} AND {2} )";
    private static final String FORMAT_SCE_BETWEEN_NOT = "( {0} NOT BETWEEN {1} AND {2} )";
    private static final String FORMAT_SCE_COMPARE = "( {0} {1} {2} )";
    private static final String FORMAT_SCE_COMPARE_NOT = "NOT ( {0} {1} {2} )";
    private static final String FORMAT_SCE_CONTAINS = "( {0} CONTAINS {1} )";
    private static final String FORMAT_SCE_CONTAINS_NOT = "( {0} NOT CONTAINS {1} )";
    private static final String FORMAT_SCE_IN = "( {0} IN {1} )";
    private static final String FORMAT_SCE_IN_NOT = "( {0} NOT IN {1} )";
    private static final String FORMAT_SCE_LIKE = "( {0} LIKE {1} )";
    private static final String FORMAT_SCE_LIKE_NOT = "( {0} NOT LIKE {1} )";
    private static final String FORMAT_SCE_ISNULL = "( {0} IS NULL )";
    private static final String FORMAT_SCE_ISNULL_NOT = "( {0} IS NOT NULL )";
    private static final String FORMAT_RELATIONAL_TYPE_AND = "AND";
    private static final String FORMAT_RELATIONAL_TYPE_OR = "OR";
    private static final String FORMAT_COMPARISON_OPERATOR_LT = "<";
    private static final String FORMAT_COMPARISON_OPERATOR_LE = "<=";
    private static final String FORMAT_COMPARISON_OPERATOR_GT = ">";
    private static final String FORMAT_COMPARISON_OPERATOR_GE = ">=";
    private static final String FORMAT_COMPARISON_OPERATOR_EQ = "=";
    private static final String FORMAT_COMPARISON_OPERATOR_NEQ = "<>";
    private static final String FORMAT_TF_N_PERIODS_FORWARD = "{0} ''LASTPERIODS(-{1},{2})''";
    private static final String FORMAT_TF_N_PERIODS_BACKWARD = "{0} ''LASTPERIODS({1},{2})''";
    private static final String FORMAT_TF_FIRST_LAST_PERIODS_FORWARD = "{0} '''{'LASTPERIODS({1}, OPENINGPERIOD({2}, {2}.HIERARCHY.DEFAULTMEMBER))'}'''";
    private static final String FORMAT_TF_FIRST_LAST_PERIODS_BACKWARD = "{0} '''{'LASTPERIODS({1}, CLOSINGPERIOD({2}, {2}.HIERARCHY.DEFAULTMEMBER))'}'''";
    private static final String FORMAT_PROMPTED_TIME_RANGE_NULL_PROMPT = "{0} '''{'{1}.Members'}'''";
    private static final String FORMAT_PROMPTED_TIME_RANGE = "{0} '''{'({1})'}'''";
    private static final String FORMAT_TIME_RANGE_NULL_STATE_AND_END = "{0} '''{'{1}.Members'}'''";
    private static final String FORMAT_TIME_RANGE_NULL_START = "{0} '''{'(OPENINGPERIOD({1},{1}.HIERARCHY.DEFAULTMEMBER) : {3})'}'''";
    private static final String FORMAT_TIME_RANGE_NULL_END = "{0} '''{'({2} : CLOSINGPERIOD({1},{1}.HIERARCHY.DEFAULTMEMBER))'}'''";
    private static final String FORMAT_TIME_RANGE = "{0} '''{'({2} : {3})'}'''";
    private static final String FORMAT_TF_N_PARALLEL_PERIODS_SUB_PATTERN_FORWARD = "PARALLELPERIOD({0},-{1},{2})";
    private static final String FORMAT_TF_N_PARALLEL_PERIODS_SUB_PATTERN_BACKWARD = "PARALLELPERIOD({0},{1},{2})";
    private static final String FORMAT_TF_N_PARALLEL_PERIODS_ZERO = "{0} '''{'{1}'}'''";
    private static final String FORMAT_TF_N_PARALLEL_PERIODS = "{0} '''{'{1},{2}'}'''";
    private static final String FORMAT_TIME_FILTER_EXPRESSION = "({0} Number of Periods: {1} with direction of {2})";

    @Override
    public TimeZone getFormatTimeZone() {
        return this._FORMAT_TimeZone;
    }

    @Override
    public void setFormatTimeZone(TimeZone timezone) {
        this._FORMAT_TimeZone = timezone;
    }

    @Override
    public Locale getFormatLocale() {
        if (this._FORMAT_Locale == null) {
            return LocaleUtilities.getDefaultViewerLocale();
        }
        return this._FORMAT_Locale;
    }

    @Override
    public void setFormatLocale(Locale locale) {
        this._FORMAT_Locale = locale;
    }

    @Override
    public ExpressionInterface newExpression(BusinessModel businessModel, String expr, int expressionType, ResourceScope scope) throws MetadataException {
        if (businessModel != null) {
            if (businessModel.getStructure().isOLAP()) {
                return new OLAPResourceAwareStringExpression(businessModel, expr, expressionType, scope);
            }
            return new ResourceAwareStringExpression(businessModel, expr, expressionType, scope);
        }
        if (_logger.isEnabled(Level.ERROR)) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, expr, IQMetadataResourceBundle.getStringResource("StringExpressionUtilNullModel.txt"));
            _logger.error(msF.toString());
        }
        return new ResourceAwareStringExpression(businessModel, expr, expressionType, scope);
    }

    @Override
    public ExpressionInterface newExpression(BusinessModel businessModel, String expr, int expressionType) throws MetadataException {
        return this.newExpression(businessModel, expr, expressionType, ResourceScope.BUSINESS_SCOPE);
    }

    @Override
    public ExpressionInterface newExpression(BusinessModel businessModel, String expr) throws MetadataException {
        return this.newExpression(businessModel, expr, 2, ResourceScope.BUSINESS_SCOPE);
    }

    @Override
    public synchronized String getText(ExpressionInterface expr) throws MetadataException {
        return this.getText(expr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, null, null, false, null, this.getFormatTimeZone(), this.getFormatLocale());
    }

    @Override
    public synchronized String getText(ExpressionInterface expr, ResourceScope scope, BusinessModel businessModel) throws MetadataException {
        return this.getText(expr, scope, businessModel, null, false, null, this.getFormatTimeZone(), this.getFormatLocale());
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr) throws MetadataException {
        return this.getReadableText(expr, null, this.getFormatTimeZone(), this.getFormatLocale());
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr, String format) throws MetadataException {
        return this.getReadableText(expr, format, this.getFormatTimeZone(), this.getFormatLocale());
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr, TimeZone timezone) throws MetadataException {
        return this.getReadableText(expr, null, timezone, this.getFormatLocale());
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr, String format, TimeZone timezone) throws MetadataException {
        return this.getReadableText(expr, format, timezone, this.getFormatLocale());
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr, Locale locale) throws MetadataException {
        return this.getReadableText(expr, null, this.getFormatTimeZone(), locale);
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr, String format, Locale locale) throws MetadataException {
        return this.getReadableText(expr, format, this.getFormatTimeZone(), locale);
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr, TimeZone timezone, Locale locale) throws MetadataException {
        return this.getReadableText(expr, null, timezone, locale);
    }

    @Override
    public synchronized String getReadableText(ExpressionInterface expr, String format, TimeZone timezone, Locale locale) throws MetadataException {
        return this.getText(expr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, null, null, true, format, timezone, locale);
    }

    @Override
    public synchronized String getText(ResourceAwareStringExpression expr, Map<BusinessModelResource, String> resourceMap) throws MetadataException {
        return this.getText(expr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, null, resourceMap, false, null, this.getFormatTimeZone(), this.getFormatLocale());
    }

    private String getText(ExpressionInterface expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return null;
        }
        String text = null;
        text = expr instanceof ResourceAwareStringExpression ? this.getText((ResourceAwareStringExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof StringExpression ? ((StringExpression)expr).getText() : (expr instanceof BusinessModelObject ? this.getText((BusinessModelObject)((Object)expr), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof Member ? this.getText((Member)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof Column ? this.getText((Column)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof OlapItem ? this.getText((OlapItem)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof MemberFilterExpression ? this.getText((MemberFilterExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof TimeFilterNPeriodsExpression ? this.getText((TimeFilterNPeriodsExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof TimeFilterFirstLastPeriodsExpression ? this.getText((TimeFilterFirstLastPeriodsExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof PromptedTimeRangeFilterExpression ? this.getText((PromptedTimeRangeFilterExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof TimeRangeFilterExpression ? this.getText((TimeRangeFilterExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof TimeFilterNParallelPeriodsExpression ? this.getText((TimeFilterNParallelPeriodsExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof TimeFilterExpression ? this.getText((TimeFilterExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof SlicerFilterExpression ? this.getText((SlicerFilterExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof FunctionCall ? this.getText((FunctionCall)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof ConditionalExpression ? this.getText((ConditionalExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof ConstantExpressionInterface ? this.getText((ConstantExpressionInterface)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (expr instanceof AbstractTimeValueExpression ? this.getText((AbstractTimeValueExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : this._toStringWithLocalAndTimeZone(expr, timezone, locale))))))))))))))))));
        return text;
    }

    private String getText(ResourceAwareStringExpression expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<ExpressionIdentifier> exprIter = expr.getExpressionIdentifiers().iterator();
        while (exprIter.hasNext()) {
            String tmp = null;
            ExpressionIdentifier identifier = exprIter.next();
            if (identifier.isString()) {
                tmp = this.getText((StringIdentifier)identifier, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
            } else if (identifier.isResource()) {
                tmp = resourceMap != null ? this.getText((ResourceIdentifier)identifier, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : this.getText((ResourceIdentifier)identifier, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
            } else if (identifier.isOlapMember()) {
                tmp = this.getText((OlapMemberIdentifier)identifier, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
            } else if (identifier.isEscape()) {
                tmp = this.getText((EscapeIdentifier)identifier, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
            }
            buffer.append(tmp);
        }
        return buffer.toString();
    }

    private String getText(StringIdentifier stringIdentifier, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        return stringIdentifier.getString();
    }

    private String getText(OlapMemberIdentifier identifier, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        return identifier.getMemberString();
    }

    private String getText(EscapeIdentifier escapeIdentifier, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer buf = new StringBuffer();
        buf.append("<!--").append(escapeIdentifier.getEscapeString()).append("-->");
        return buf.toString();
    }

    private String getText(ResourceIdentifier resourceIdentifier, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String text = null;
        Resource resource = resourceIdentifier.getResource();
        if (resource != null) {
            BusinessModelResource bmr = resource.getBusinessModelResource();
            if (resourceMap != null) {
                ExpressionInterface expr;
                text = resourceMap.get(bmr);
                if (text == null && bmr instanceof DataItem && (expr = ((DataItem)bmr).getExpression()) instanceof ResourceAwareStringExpression) {
                    text = this.getText((ResourceAwareStringExpression)expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
                }
            } else {
                text = bmr instanceof ExpressionInterface ? this.getText((ExpressionInterface)((Object)bmr), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (bmr instanceof BusinessModelObject ? this.getText((BusinessModelObject)bmr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : resourceIdentifier.getResourceString());
            }
        } else {
            text = resourceIdentifier.getResourceString();
        }
        return text;
    }

    private String getText(BusinessModel model, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String returnValue = model.getID();
        if (returnValue == null) {
            returnValue = FORMAT_NULL_OBJECT;
        }
        return returnValue;
    }

    private String getText(BusinessModelObject bmo, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (ResourceScope.PHYSICAL_SCOPE == scope && !(bmo instanceof DataSourceTable)) {
            Object[] args = new Object[]{"Business Object", scope.toString()};
            throw new ResourceIdentificationException(IQMetadataResourceBundle.getMessageFormatter("StringExpressionUtil.ExprInvalidInScope.fmt.txt", args), scope, -1, -1);
        }
        String text = null;
        if (bmo instanceof Prompt) {
            text = this.getText((Prompt)bmo, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else {
            StringBuffer temp = new StringBuffer();
            temp.append("<<").append(this.getText(bmo.getBusinessModel(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale)).append('.').append(bmo.getIntraModelID()).append(">>");
            text = temp.toString();
        }
        return text;
    }

    private String getText(Prompt prompt, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer temp = new StringBuffer();
        if (!isDescription) {
            temp.append("prompt::").append("<<").append(prompt.getIntraModelID()).append(">>");
        } else {
            String label = prompt.getLabel();
            temp.append("&").append(label);
        }
        return temp.toString();
    }

    private String getText(Member member, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String returnValue = member.getMemberUniqueName();
        if (returnValue == null) {
            returnValue = FORMAT_NULL_OBJECT;
        }
        return returnValue;
    }

    private String getText(Hierarchy hierarchy, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer temp = new StringBuffer();
        temp.append(this.getText(hierarchy.getOwningDimension(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale)).append('.').append(hierarchy.getLabel());
        return temp.toString();
    }

    private String getText(Measure measure, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer temp = new StringBuffer();
        Dimension dimension = null;
        if (measure.isUnresolved()) {
            Cube cube = measure.getOwningCube();
            if (cube != null && !cube.isUnresolved()) {
                List<Dimension> dimensions = cube.getDimensions();
                Iterator<Dimension> iter = dimensions.iterator();
                while (iter.hasNext() && dimension == null) {
                    Dimension iterDimension = iter.next();
                    if (iterDimension.isUnresolved() || iterDimension.getDimensionType() != 1) continue;
                    dimension = iterDimension;
                }
            }
        } else {
            dimension = measure.getOwningDimension();
        }
        if (dimension == null) {
            temp.append("Measures");
        } else {
            List<Hierarchy> hierarchies = dimension.getHierarchies();
            if (hierarchies.size() > 0) {
                Hierarchy hierarchy = hierarchies.get(0);
                List<com.sas.iquery.metadata.physical.Level> levels = hierarchy.getLevels();
                if (levels.size() > 0) {
                    com.sas.iquery.metadata.physical.Level level = levels.get(0);
                    if (level instanceof AllLevel) {
                        level = levels.get(1);
                    }
                    temp.append(this.getText(level, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
                } else {
                    temp.append(this.getText(dimension, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
                }
            } else {
                temp.append(this.getText(dimension, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
            }
        }
        temp.append('.').append(measure.getLabel());
        return temp.toString();
    }

    private String getText(Dimension dimension, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String returnValue = dimension.getLabel();
        if (returnValue == null) {
            returnValue = FORMAT_NULL_OBJECT;
        }
        return returnValue;
    }

    private String getText(NamedSet namedSet, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer temp = new StringBuffer();
        temp.append(this.getText(namedSet.getOwningHierarchy(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
        temp.append('.').append(namedSet.getLabel());
        return temp.toString();
    }

    private String getText(CalculatedMember calMember, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer temp = new StringBuffer();
        temp.append(this.getText(calMember.getOwningHierarchy(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
        temp.append('.').append(calMember.getLabel());
        return temp.toString();
    }

    private String getText(com.sas.iquery.metadata.physical.Level level, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer temp = new StringBuffer();
        if (level instanceof QualifiedLevel) {
            temp.append(this.getText(((QualifiedLevel)level).getOwningHierarchy(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
        } else {
            Dimension dimension = level.getOwningDimension();
            Hierarchy hierarchy = dimension.getHierarchies().get(0);
            temp.append(this.getText(hierarchy, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
        }
        temp.append('.').append(level.getLabel());
        return temp.toString();
    }

    private String getText(Column column, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        StringBuffer text = new StringBuffer();
        StringBuffer relationalText = new StringBuffer();
        Table table = column.getOwningTable();
        if (table instanceof DataSourceTable) {
            relationalText.append(((DataSourceTable)table).getIntraModelID());
        } else {
            relationalText.append(table.getLabel());
        }
        relationalText.append('.');
        if (!isDescription) {
            relationalText.append(column.getSasName());
        } else {
            relationalText.append(column.getLabel());
        }
        if (!isDescription && this.shouldQualifyPhysicalItem(relationalText.toString(), businessModel, scope)) {
            text.append("physical::");
        }
        text.append("<<").append(relationalText).append(">>");
        return text.toString();
    }

    private String getText(OlapItem olapItem, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String olapText;
        StringBuffer text = new StringBuffer();
        if (olapItem instanceof Dimension) {
            olapText = this.getText((Dimension)olapItem, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else if (olapItem instanceof Measure) {
            olapText = this.getText((Measure)olapItem, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else if (olapItem instanceof Hierarchy) {
            olapText = this.getText((Hierarchy)olapItem, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else if (olapItem instanceof com.sas.iquery.metadata.physical.Level) {
            olapText = this.getText((com.sas.iquery.metadata.physical.Level)olapItem, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else if (olapItem instanceof Member) {
            olapText = this.getText((Member)olapItem, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else if (olapItem instanceof NamedSet) {
            olapText = this.getText((NamedSet)olapItem, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else if (olapItem instanceof CalculatedMember) {
            olapText = this.getText((CalculatedMember)olapItem, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else {
            Object[] args = new Object[]{olapItem.getClass()};
            throw new ResourceIdentificationException(IQMetadataResourceBundle.getMessageFormatter("StringExpressionUtil.UnsupportedExpressionType.fmt.txt", args), scope, -1, -1);
        }
        if (!isDescription && this.shouldQualifyPhysicalItem(olapText, businessModel, scope)) {
            text.append("physical::");
        }
        text.append("<<").append(olapText).append(">>");
        return text.toString();
    }

    private String getText(FunctionCall functionCall, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        FunctionSignature signature;
        String syntaxTemplate = FORMAT_NULL_OBJECT;
        List<ExpressionInterface> args = functionCall.getArguments();
        if (functionCall != null && (signature = functionCall.getFunctionSignature()) != null) {
            syntaxTemplate = signature.getSyntaxTemplateFor(args);
        }
        Object[] argText = new Object[args.size()];
        int i = 0;
        for (ExpressionInterface expr : args) {
            argText[i++] = this.getText(expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        }
        try {
            String text = MessageFormat.format(syntaxTemplate, argText);
            return text;
        }
        catch (IllegalArgumentException e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Failed to getText. " + e + "\nsyntaxTemplate=" + syntaxTemplate + "\ntemplate=[" + syntaxTemplate + "] args=" + new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, argText), (Throwable)e);
            }
            throw e;
        }
    }

    private boolean shouldQualifyPhysicalItem(String id, BusinessModel businessModel, ResourceScope scope) throws MetadataException {
        boolean rval = false;
        if (scope.isBusinessAndPhysical() && (businessModel == null || this.doesExistBusinessItemWithSameID(id, businessModel))) {
            rval = true;
        }
        return rval;
    }

    private boolean doesExistBusinessItemWithSameID(String id, BusinessModel businessModel) throws MetadataException {
        return businessModel.getBusinessItemByID(id) != null;
    }

    private String getText(ConditionalExpression cond, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (cond == null) {
            return FORMAT_NULL_OBJECT;
        }
        if (!isDescription) {
            return cond.toString();
        }
        String text = "";
        text = cond instanceof CompoundConditionalExpression ? this.getText((CompoundConditionalExpression)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof DataBasedFilterExpression ? this.getText((DataBasedFilterExpression)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof DataBasedFilterExpression_Between ? this.getText((DataBasedFilterExpression_Between)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof MemberFilterExpression ? this.getText((MemberFilterExpression)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof SlicerFilterExpression ? this.getText((SlicerFilterExpression)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof MultipleConditionalExpression ? this.getText((MultipleConditionalExpression)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof SimpleConditionalExpression_Between ? this.getText((SimpleConditionalExpression_Between)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof SimpleConditionalExpression_Comparison ? this.getText((SimpleConditionalExpression_Comparison)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof SimpleConditionalExpression_Contains ? this.getText((SimpleConditionalExpression_Contains)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof SimpleConditionalExpression_In ? this.getText((SimpleConditionalExpression_In)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof SimpleConditionalExpression_Like ? this.getText((SimpleConditionalExpression_Like)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof SimpleConditionalExpression_TestForNull ? this.getText((SimpleConditionalExpression_TestForNull)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : (cond instanceof ConditionalExpressionAdapter ? this.getText((ConditionalExpressionAdapter)cond, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : this._toStringWithLocalAndTimeZone(cond, timezone, locale)))))))))))));
        return text;
    }

    private String getText(CompoundConditionalExpression expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String msgFormat;
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        ExpressionInterface left = expr.getLeftExpression();
        ConditionalRelationType type = expr.getRelationType();
        ExpressionInterface right = expr.getRightExpression();
        ArrayList<String> values = new ArrayList<String>();
        String saveApplyFormat = applyFormat;
        if (type == null && (left == null && right != null || right == null && left != null)) {
            String string = msgFormat = isNegated ? "NOT ( {0} )" : "( {0} )";
            if (left != null) {
                values.add(this.getText(left, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
            } else {
                values.add(this.getText(right, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
            }
        } else {
            String checkFormat;
            msgFormat = isNegated ? "NOT ( {0} {1} {2} )" : "( {0} {1} {2} )";
            String itemFormat = applyFormat;
            if (left instanceof DataItem && (checkFormat = ((DataItem)left).getFormat()) != null && checkFormat.length() > 0) {
                itemFormat = checkFormat;
            }
            values.add(this.getText(left, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale));
            values.add(this.getText(type, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale));
            values.add(this.getText(right, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale));
        }
        applyFormat = saveApplyFormat;
        String text = MessageFormat.format(msgFormat, values.toArray());
        return text;
    }

    private String getText(DataBasedFilterExpression expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? FORMAT_DBFE_NOT : FORMAT_DBFE;
        String val1 = this.getText(expr.getWhatToFilter(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = this.getTextForMemberList(expr.getLeftExpression(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val3 = this.getText(expr.getComparisonOperator(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val4 = this.getTextForMemberList(expr.getRightExpression(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2, val3, val4);
        return text;
    }

    private String getText(DataBasedFilterExpression_Between expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? FORMAT_DBFE_BETWEEN_NOT : FORMAT_DBFE_BETWEEN;
        String val1 = this.getText(expr.getWhatToFilter(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = this.getTextForMemberList(expr.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val3 = this.getTextForMemberList(expr.getLowerBound(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val4 = this.getTextForMemberList(expr.getUpperBound(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2, val3, val4);
        return text;
    }

    private String getText(MemberFilterExpression expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? "( {0} NOT IN ({1}) )" : "( {0} IN ({1}) )";
        String val1 = this.getText(expr.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = this.getTextForMemberList(expr.getMemberNames(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2);
        return text;
    }

    private String getText(SlicerFilterExpression expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? "( {0} NOT IN ({1}) )" : "( {0} IN ({1}) )";
        String val1 = this.getText(expr.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = this.getTextForMemberList(expr.getMemberNames(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2);
        return text;
    }

    private String getText(MultipleConditionalExpression expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        List<ExpressionInterface> list = expr.getExpressionList();
        String outerFormat = isNegated ? "NOT ( {0} )" : "( {0} )";
        String joinFormat = FORMAT_MCE_LIST_JOIN;
        String seprFormat = this.getText(expr.getRelationType(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = this.getText(list, outerFormat, FORMAT_MCE_LIST_JOIN, seprFormat, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        return text;
    }

    private String getText(SimpleConditionalExpression_Between expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        ExpressionInterface what = expr.getWhatToCompare();
        ExpressionInterface left = expr.getLeftExpression();
        ExpressionInterface right = expr.getRightExpression();
        String text = null;
        text = left == null && right != null || right == null && left != null ? this.getText(isNegated, what, ComparisonOperator.COMPARE_EQ, left == null ? right : left, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale) : this.getText(isNegated, what, left, right, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        return text;
    }

    private String getText(boolean isNegated, ExpressionInterface what, ExpressionInterface left, ExpressionInterface right, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String checkFormat;
        String msgFormat = isNegated ? FORMAT_SCE_BETWEEN_NOT : FORMAT_SCE_BETWEEN;
        String itemFormat = applyFormat;
        if (what instanceof DataItem && (checkFormat = ((DataItem)what).getFormat()) != null && checkFormat.length() > 0) {
            itemFormat = checkFormat;
        }
        String val1 = this.getText(what, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale);
        String val2 = this.getText(left, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale);
        String val3 = this.getText(right, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2, val3);
        return text;
    }

    private String getText(SimpleConditionalExpression_Comparison expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        ExpressionInterface left = expr.getLeftExpression();
        ComparisonOperator operator = expr.getComparisonOperator();
        ExpressionInterface right = expr.getRightExpression();
        return this.getText(isNegated, left, operator, right, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
    }

    private String getText(boolean isNegated, ExpressionInterface left, ComparisonOperator operator, ExpressionInterface right, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String checkFormat;
        String msgFormat = isNegated ? "NOT ( {0} {1} {2} )" : "( {0} {1} {2} )";
        String itemFormat = applyFormat;
        if (left instanceof DataItem && (checkFormat = ((DataItem)left).getFormat()) != null && checkFormat.length() > 0) {
            itemFormat = checkFormat;
        }
        String val1 = this.getText(left, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale);
        String val2 = this.getText(operator, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val3 = this.getText(right, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2, val3);
        return text;
    }

    private String getText(SimpleConditionalExpression_Contains expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? FORMAT_SCE_CONTAINS_NOT : FORMAT_SCE_CONTAINS;
        String val1 = this.getText(expr.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = this.getText(expr.getWhatToContain(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2);
        return text;
    }

    private String getText(SimpleConditionalExpression_In expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String checkFormat;
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? FORMAT_SCE_IN_NOT : FORMAT_SCE_IN;
        ExpressionInterface what = expr.getWhatToCompare();
        String itemFormat = applyFormat;
        if (what instanceof DataItem && (checkFormat = ((DataItem)what).getFormat()) != null && checkFormat.length() > 0) {
            itemFormat = checkFormat;
        }
        String val1 = this.getText(what, scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale);
        String val2 = this.getTextForValueList(expr.getComparisonList(), scope, businessModel, resourceMap, isDescription, itemFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2);
        return text;
    }

    private String getText(SimpleConditionalExpression_Like expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? FORMAT_SCE_LIKE_NOT : FORMAT_SCE_LIKE;
        String val1 = this.getText(expr.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        Character escape = expr.getEscapeCharacter();
        String likePattern = this.getText(expr.getPatternExpression(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = escape != null ? likePattern.concat(" ESCAPE '" + escape.toString() + "'") : likePattern;
        String text = MessageFormat.format(msgFormat, val1, val2);
        return text;
    }

    private String getText(SimpleConditionalExpression_TestForNull expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        String msgFormat = isNegated ? FORMAT_SCE_ISNULL_NOT : FORMAT_SCE_ISNULL;
        String val1 = this.getText(expr.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1);
        return text;
    }

    private String getText(ConditionalExpressionAdapter expr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (expr == null) {
            return FORMAT_NULL_OBJECT;
        }
        boolean isNegated = expr.isNegated();
        ExpressionInterface innerExpr = expr.getExpression();
        String msgFormat = isNegated ? "NOT ( {0} )" : "( {0} )";
        String val1 = this.getText(innerExpr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1);
        return text;
    }

    private String getTextForMemberList(List<ExpressionInterface> list, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        return this.getText(list, FORMAT_QUALIFIED_MEMBER, "{0}{1}{2}", FORMAT_QUALIFIED_MEMBER_SEPR, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
    }

    private String getTextForValueList(List<ExpressionInterface> list, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        return this.getText(list, FORMAT_LIST_OF_VALUES, "{0}{1}{2}", FORMAT_LIST_OF_VALUES_SEPR, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
    }

    private String getText(List<ExpressionInterface> list, String outer, String join, String sepr, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String text = "";
        if (list == null) {
            text = FORMAT_NULL_OBJECT;
        } else {
            if (list.size() == 0) {
                text = FORMAT_NULL_OBJECT;
            } else {
                Iterator<ExpressionInterface> iter = list.iterator();
                ExpressionInterface obj = iter.next();
                ExpressionInterface expr = null;
                if (obj instanceof ExpressionInterface) {
                    expr = obj;
                    text = this.getText(expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
                } else {
                    text = this._toStringWithLocalAndTimeZone(obj, timezone, locale);
                }
                while (iter.hasNext()) {
                    obj = iter.next();
                    String temp = null;
                    if (obj instanceof ExpressionInterface) {
                        expr = obj;
                        temp = this.getText(expr, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
                    } else {
                        temp = this._toStringWithLocalAndTimeZone(obj, timezone, locale);
                    }
                    text = MessageFormat.format(join, text, sepr, temp);
                }
            }
            text = MessageFormat.format(outer, text);
        }
        return text;
    }

    private String getText(ConditionalRelationType relType, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (relType == null) {
            return FORMAT_NULL_OBJECT;
        }
        if (!isDescription) {
            return relType.toString();
        }
        String text = relType.equals(ConditionalRelationType.AND) ? FORMAT_RELATIONAL_TYPE_AND : (relType.equals(ConditionalRelationType.OR) ? FORMAT_RELATIONAL_TYPE_OR : this._toStringWithLocalAndTimeZone(relType, timezone, locale));
        return text;
    }

    private String getText(ComparisonOperator oper, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (oper == null) {
            return FORMAT_NULL_OBJECT;
        }
        if (!isDescription) {
            return oper.toString();
        }
        String text = oper.equals(ComparisonOperator.COMPARE_LT) ? FORMAT_COMPARISON_OPERATOR_LT : (oper.equals(ComparisonOperator.COMPARE_LE) ? FORMAT_COMPARISON_OPERATOR_LE : (oper.equals(ComparisonOperator.COMPARE_GT) ? FORMAT_COMPARISON_OPERATOR_GT : (oper.equals(ComparisonOperator.COMPARE_GE) ? FORMAT_COMPARISON_OPERATOR_GE : (oper.equals(ComparisonOperator.COMPARE_EQ) ? FORMAT_COMPARISON_OPERATOR_EQ : (oper.equals(ComparisonOperator.COMPARE_NEQ) ? FORMAT_COMPARISON_OPERATOR_NEQ : this._toStringWithLocalAndTimeZone(oper, timezone, locale))))));
        return text;
    }

    public String generateQuotedLiteral(String s) {
        if (s == null) {
            return FORMAT_NULL_OBJECT;
        }
        StringBuffer result = new StringBuffer();
        result.append("'");
        s = s.replaceAll("'", "''");
        result.append(s).append("'");
        return result.toString();
    }

    private String getText(ConstantExpressionInterface constantExpression, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (!isDescription) {
            String text = null;
            text = constantExpression.getExpressionType() == 3 ? this.generateQuotedLiteral(constantExpression.getValue()) : constantExpression.toString();
            return text;
        }
        int type = constantExpression.getExpressionType();
        String defaultSASFormatText = StringExpressionUtilImpl.getDefaultSASFormatText(type);
        Object value = constantExpression.getValue();
        if (value instanceof String && !((String)value).equals(".") && type != 3 && type != 11) {
            try {
                value = Double.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.getText(value, defaultSASFormatText, isDescription, applyFormat, timezone, locale);
    }

    private String getText(AbstractTimeValueExpression abstractTimeValue, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        if (!isDescription) {
            return abstractTimeValue.toString();
        }
        int type = abstractTimeValue.getExpressionType();
        String defaultSASFormatText = StringExpressionUtilImpl.getDefaultSASFormatText(type);
        Comparable<Date> value = null;
        Double explicit = abstractTimeValue.getExplicitDoubleValue();
        if (explicit != null) {
            double sasValue = explicit;
            if (type == 5) {
                value = StringExpressionUtilImpl.convertSASTimeToJavaTime(sasValue, timezone);
            } else if (type == 4) {
                value = StringExpressionUtilImpl.convertSASDateToJavaDate(sasValue, timezone);
            } else if (type == 6) {
                value = StringExpressionUtilImpl.convertSASDateTimeToJavaTimestamp(sasValue, timezone);
            }
            if (value == null) {
                value = explicit;
            }
        } else {
            value = abstractTimeValue.getValue();
            if (abstractTimeValue instanceof TimeValueExpression) {
                value = TimeValueExpression.newTimeOnlyValue(value);
            }
        }
        return this.getText(value, defaultSASFormatText, isDescription, applyFormat, timezone, locale);
    }

    private String getText(TimeFilterNPeriodsExpression nPeriodsExpression, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String searchDirection = nPeriodsExpression.getSearchDirection();
        ExpressionInterface periods = nPeriodsExpression.getPeriods();
        String strPeriods = this.getText(periods, scope, businessModel, resourceMap, isDescription, null, timezone, locale).trim();
        boolean nPeriodsNonZero = true;
        if (!(periods instanceof Prompt)) {
            nPeriodsNonZero = strPeriods == null ? false : Integer.parseInt(strPeriods) != 0;
        }
        String msgFormat = null;
        msgFormat = searchDirection.equalsIgnoreCase("FORWARD") && nPeriodsNonZero ? FORMAT_TF_N_PERIODS_FORWARD : FORMAT_TF_N_PERIODS_BACKWARD;
        String val1 = this.getText(nPeriodsExpression.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = strPeriods;
        String val3 = this.getText(nPeriodsExpression.getDate(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String text = MessageFormat.format(msgFormat, val1, val2, val3);
        return text;
    }

    private String getText(TimeFilterNParallelPeriodsExpression nParallelPeriods, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String searchDirection = nParallelPeriods.getSearchDirection();
        String whatToCompare = this.getText(nParallelPeriods.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        ExpressionInterface periods = nParallelPeriods.getPeriods();
        String strPeriods = this.getText(periods, scope, businessModel, resourceMap, isDescription, null, timezone, locale).trim();
        String dateMember = this.getText(nParallelPeriods.getDate(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        int nPeriods = 0;
        boolean nPeriodsPrompted = false;
        if (periods instanceof Prompt) {
            nPeriodsPrompted = true;
        } else if (strPeriods != null) {
            nPeriods = Integer.parseInt(strPeriods);
        }
        String result = null;
        if (nPeriods != 0 || nPeriodsPrompted) {
            String levelName = this.getText(nParallelPeriods.getLevel(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
            String msgFormat = searchDirection.equalsIgnoreCase("FORWARD") ? FORMAT_TF_N_PARALLEL_PERIODS_SUB_PATTERN_FORWARD : FORMAT_TF_N_PARALLEL_PERIODS_SUB_PATTERN_BACKWARD;
            ArrayList<String> subMessages = new ArrayList<String>();
            if (!nPeriodsPrompted) {
                int absNPeriods = Math.abs(nPeriods);
                for (int pctr = 1; pctr <= absNPeriods; ++pctr) {
                    String subMessage = MessageFormat.format(msgFormat, levelName, pctr, dateMember);
                    subMessages.add(subMessage);
                }
            } else {
                String subMessage = MessageFormat.format(msgFormat, levelName, strPeriods, dateMember);
                subMessages.add(subMessage);
            }
            ArrayMessageFormatter embeddedPPs = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, subMessages.toArray());
            result = MessageFormat.format(FORMAT_TF_N_PARALLEL_PERIODS, whatToCompare, dateMember, embeddedPPs);
        } else {
            result = MessageFormat.format(FORMAT_TF_N_PARALLEL_PERIODS_ZERO, dateMember);
        }
        return result;
    }

    private String getText(TimeFilterFirstLastPeriodsExpression lastPeriodsExpression, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String searchDirection = lastPeriodsExpression.getSearchDirection();
        ExpressionInterface periods = lastPeriodsExpression.getPeriods();
        String strPeriods = this.getText(periods, scope, businessModel, resourceMap, isDescription, null, timezone, locale).trim();
        if (strPeriods == null) {
            strPeriods = "0";
        }
        String msgFormat = null;
        if (searchDirection.equalsIgnoreCase("FORWARD")) {
            if (!(periods instanceof Prompt)) {
                strPeriods = Integer.parseInt(strPeriods) <= 0 ? strPeriods : "-" + strPeriods;
            }
            msgFormat = FORMAT_TF_FIRST_LAST_PERIODS_FORWARD;
        } else {
            msgFormat = FORMAT_TF_FIRST_LAST_PERIODS_BACKWARD;
        }
        String val1 = this.getText(lastPeriodsExpression.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = strPeriods;
        String val3 = this.getText(lastPeriodsExpression.getLevel(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        return MessageFormat.format(msgFormat, val1, val2, val3);
    }

    private String getText(PromptedTimeRangeFilterExpression promptRangeExpression, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String val2;
        String msgFormat;
        String val1 = this.getText(promptRangeExpression.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        Prompt rPrompt = promptRangeExpression.getRangePrompt();
        if (rPrompt != null && rPrompt.getPromptDefinition() != null) {
            msgFormat = FORMAT_PROMPTED_TIME_RANGE;
            val2 = this.getText(rPrompt, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        } else {
            msgFormat = "{0} '''{'{1}.Members'}'''";
            val2 = this.getText(promptRangeExpression.getLevelName(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        }
        String text = MessageFormat.format(msgFormat, val1, val2);
        return text;
    }

    private String getText(TimeRangeFilterExpression rangeFilterExpression, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        ExpressionInterface sMember = rangeFilterExpression.getStartMember();
        ExpressionInterface eMember = rangeFilterExpression.getEndMember();
        String msgFormat = null;
        msgFormat = sMember == null && eMember == null ? "{0} '''{'{1}.Members'}'''" : (sMember != null && eMember == null ? FORMAT_TIME_RANGE_NULL_END : (sMember == null && eMember != null ? FORMAT_TIME_RANGE_NULL_START : FORMAT_TIME_RANGE));
        String val1 = this.getText(rangeFilterExpression.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = this.getText(rangeFilterExpression.getLevelName(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val3 = this.getText(sMember, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val4 = this.getText(eMember, scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String formatted = MessageFormat.format(msgFormat, val1, val2, val3, val4);
        return formatted;
    }

    private String getText(TimeFilterExpression timeFilterExpression, ResourceScope scope, BusinessModel businessModel, Map<BusinessModelResource, String> resourceMap, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String val1 = this.getText(timeFilterExpression.getWhatToCompare(), scope, businessModel, resourceMap, isDescription, applyFormat, timezone, locale);
        String val2 = this.getText(timeFilterExpression.getPeriods(), scope, businessModel, resourceMap, isDescription, null, timezone, locale).trim();
        String val3 = timeFilterExpression.getSearchDirection();
        String text = MessageFormat.format(FORMAT_TIME_FILTER_EXPRESSION, val1, val2, val3);
        return text;
    }

    private synchronized String getText(Object value, String defaultSasFormatText, boolean isDescription, String applyFormat, TimeZone timezone, Locale locale) throws MetadataException {
        String result = null;
        if (value == null) {
            result = FORMAT_NULL_OBJECT;
        } else if (!isDescription) {
            result = this._toStringWithLocalAndTimeZone(value, timezone, locale);
        } else {
            String result2;
            SASFormat format;
            String result1;
            if (applyFormat != null && (result1 = this.getText(value, (Format)(format = StringExpressionUtilImpl.getSASFormat(applyFormat = this.fixupFormatIfNeeded(value, applyFormat), locale)), timezone, locale)) != null && !this.isOverflowString(result1)) {
                result = result1;
            }
            if (!(result != null || defaultSasFormatText == null || applyFormat != null && defaultSasFormatText.equals(applyFormat) || (result2 = this.getText(value, (Format)(format = StringExpressionUtilImpl.getSASFormat(defaultSasFormatText = this.fixupFormatIfNeeded(value, defaultSasFormatText), locale)), timezone, locale)) == null || this.isOverflowString(result2))) {
                result = result2;
            }
            if (result == null) {
                result = this._toStringWithLocalAndTimeZone(value, timezone, locale);
            }
        }
        return result;
    }

    private boolean isOverflowString(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    private String fixupFormatIfNeeded(Object value, String sasFormatText) {
        int len;
        if (sasFormatText.equals("$.") && (len = Math.min((value + "").trim().length(), 80)) > 0) {
            sasFormatText = "$" + len + ".";
        }
        return sasFormatText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getText(Object value, Format format, TimeZone timezone, Locale locale) throws MetadataException {
        double seconds;
        String result = null;
        if (format == null) {
            return null;
        }
        if (value instanceof Time) {
            seconds = StringExpressionUtilImpl.convertJavaTimeToSASTime((Time)value, timezone);
            value = seconds;
        } else if (value instanceof Timestamp) {
            seconds = StringExpressionUtilImpl.convertJavaTimestampToSASDateTime((Timestamp)value, timezone);
            value = seconds;
        } else if (value instanceof Date) {
            seconds = StringExpressionUtilImpl.convertJavaDateToSASDate((Date)value, timezone);
            value = seconds;
        }
        if (format instanceof SASDateTimeFormat) {
            Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
            synchronized (SASDateTimeFormat.class) {
                TimeZone save = ((SASDateTimeFormat)format).getTimeZone();
                try {
                    result = format.format(value);
                }
                catch (Exception exception) {
                }
                finally {
                    ((SASDateTimeFormat)format).setTimeZone(save);
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
            }
        }
        try {
            result = format.format(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String _toStringWithLocalAndTimeZone(Object obj, TimeZone timezone, Locale locale) {
        String text = null;
        if (obj == null) {
            return FORMAT_NULL_OBJECT;
        }
        Class<TimeZone> clazz = TimeZone.class;
        synchronized (TimeZone.class) {
            TimeZone saveTZ = TimeZone.getDefault();
            try {
                TimeZone.setDefault(timezone);
                if (obj instanceof LocalizableToStringInterface) {
                    text = ((LocalizableToStringInterface)obj).toString(locale);
                } else {
                    ObjectToStringTransform transform = new ObjectToStringTransform(locale);
                    text = transform.transform(obj).toString();
                }
            }
            catch (Exception exception) {
            }
            finally {
                TimeZone.setDefault(saveTZ);
            }
            if (text != null) return text;
            return obj.toString();
        }
    }
}

