/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.parser;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.expr.ParseExpressionException;
import com.sas.iquery.metadata.expr.parser.EscapeIdentifier;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifierList;
import com.sas.iquery.metadata.expr.parser.OlapMemberIdentifier;
import com.sas.iquery.metadata.expr.parser.PhysicalResourceIdentifier;
import com.sas.iquery.metadata.expr.parser.PromptResourceIdentifier;
import com.sas.iquery.metadata.expr.parser.ResourceIdentifier;
import com.sas.iquery.metadata.expr.parser.StringIdentifier;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;

class StringExpressionTokenizer {
    private static final int INITIAL_STATE = 0;
    private static final int QUOTE_STATE = 1;
    private static final int RESOURCE_STATE = 2;
    private static final int ESCAPE_STATE = 3;
    private static final int PROMPT_RESOURCE_STATE = 4;
    private static final int OLAP_MEMBER_STATE = 5;
    private static final int PHYSICAL_RESOURCE_STATE = 6;
    private static final String[] STATES = new String[]{" Expression ", " Quote ", " Resource ", " Escape ", " PromptResource", " OlapMember"};
    private String _expression;
    private boolean _inSingleQuotedString;
    private boolean _inDoubleQuotedString;
    private int _state;
    private int _prevState;
    private ResourceIdentifier _resource;
    private OlapMemberIdentifier _olapMember;
    private EscapeIdentifier _escapeIdentifier;
    private StringBuffer _buffer;
    private int _index;
    private int _stateIndex;
    private ExpressionIdentifierList _exprList;

    static ExpressionIdentifierList tokenizeExpression(String expression) throws ParseExpressionException {
        Preconditions.ensureNonNull(expression);
        return new StringExpressionTokenizer(expression).tokenizeExpression();
    }

    private StringExpressionTokenizer(String str) {
        this._expression = str;
    }

    private ExpressionIdentifierList tokenizeExpression() throws ParseExpressionException {
        this.resetBuffer();
        this._exprList = new ExpressionIdentifierList();
        this.goToInitialState();
        this._index = 0;
        while (this._index < this._expression.length()) {
            char cur = this.getChar(this._index);
            char lookAhead = this._index < this._expression.length() - 1 ? this.getChar(this._index + 1) : (char)'\u0000';
            switch (this._state) {
                case 0: {
                    this.processInInitialState(cur);
                    break;
                }
                case 1: {
                    this.processInQuoteState(cur);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.processInResourceState(cur, lookAhead);
                    break;
                }
                case 5: {
                    this.processInOlapMemberState(cur);
                    break;
                }
                case 3: {
                    this.processInEscapeState(cur);
                }
            }
            ++this._index;
        }
        if (this._state != 0) {
            throw this.generateBadlyFormedException();
        }
        this.addIdentifierToList();
        return this._exprList;
    }

    private void processInInitialState(char cur) {
        if (this.isStartEscapeSequence(cur)) {
            this.addIdentifierToList();
            this.goToEscapeState();
        } else if (this.isStartOfQuote(cur)) {
            this.addIdentifierToList();
            this.goToQuoteState(cur);
            this.getBuffer().append(cur);
        } else if (this.isStartOfResource(cur)) {
            this.addIdentifierToList();
            this.goToResourceState(2);
        } else if (this.isStartOfPromptResource()) {
            this.addIdentifierToList();
            this.goToPromptResourceState();
        } else if (this.isStartOfPhysicalResource()) {
            this.addIdentifierToList();
            this.goToPhysicalResourceState();
        } else if (this.isStartOfOlapMember(cur)) {
            this.addIdentifierToList();
            this.goToOlapMemberState();
            this.getBuffer().append(cur);
        } else {
            this.getBuffer().append(cur);
        }
    }

    private void processInQuoteState(char cur) {
        if (this.isEndOfQuote(cur)) {
            this.getBuffer().append(cur);
            this.addIdentifierToList();
            this.goToInitialState();
        } else {
            this.getBuffer().append(cur);
        }
    }

    private void processInResourceState(char cur, char lookAhead) throws ParseExpressionException {
        if (this.isEndOfResource(cur)) {
            this._resource = this.createResource();
            this.addIdentifierToList();
            this._resource = null;
            this.goToInitialState();
        } else if (!this.isInPromptResourceState() && this.isNestedResource(cur)) {
            this._resource = this.createResource();
            this.resetBuffer();
        } else {
            if (this.isInvalidInResource(cur, lookAhead)) {
                throw this.generateInvalidResourceError();
            }
            this.getBuffer().append(cur);
        }
    }

    private ResourceIdentifier createResource() throws ParseExpressionException {
        String resourceString = this.getBuffer().toString();
        if (resourceString == null || resourceString.trim().length() == 0) {
            throw this.generateInvalidResourceError();
        }
        if (this.isInPromptResourceState()) {
            return new PromptResourceIdentifier(null, resourceString, this._stateIndex, this._index);
        }
        if (this.isInPhysicalResourceState()) {
            return new PhysicalResourceIdentifier(this._resource, resourceString, this._stateIndex, this._index);
        }
        return new ResourceIdentifier(this._resource, resourceString, this._stateIndex, this._index);
    }

    private void processInOlapMemberState(char cur) throws ParseExpressionException {
        if (this.isEndOfOlapMember(cur)) {
            if (this.isNestedOlapMember()) {
                this.getBuffer().append(cur);
            } else {
                this.getBuffer().append(cur);
                this._olapMember = new OlapMemberIdentifier(this.getBuffer().toString());
                this.addIdentifierToList();
                this.goToInitialState();
            }
        } else {
            this.getBuffer().append(cur);
        }
    }

    private void processInEscapeState(char cur) {
        if (this.isEndEscapeSequence(cur)) {
            this._escapeIdentifier = EscapeIdentifier.getInstance(this.getBuffer().toString());
            this.addIdentifierToList();
            this.goToPreviousState();
        } else {
            this.getBuffer().append(cur);
        }
    }

    private void addIdentifierToList() {
        if (this.isInResourceState()) {
            this._exprList.add(this._resource);
        } else if (this._state == 5) {
            this._exprList.add(this._olapMember);
        } else if (this._state == 3) {
            this._exprList.add(this._escapeIdentifier);
        } else {
            ExpressionIdentifier prev = null;
            if (this._exprList.size() > 0) {
                prev = this._exprList.get(this._exprList.size() - 1);
            }
            if (prev != null && prev.isString()) {
                ((StringIdentifier)prev).append(this.getBuffer().toString());
            } else if (this.getBuffer().length() != 0) {
                this._exprList.add(new StringIdentifier(this.getBuffer().toString()));
            }
        }
    }

    private boolean isStartEscapeSequence(char cur) {
        boolean rval = false;
        int lookAheadIndex = this._index + 3;
        if (!this.isIndexOutOfBounds(lookAheadIndex)) {
            char lookAhead1 = this.getChar(this._index + 1);
            char lookAhead2 = this.getChar(this._index + 2);
            char lookAhead3 = this.getChar(this._index + 3);
            if ('<' == cur && '!' == lookAhead1 && '-' == lookAhead2 && '-' == lookAhead3) {
                this._index += 3;
                rval = true;
            }
        }
        return rval;
    }

    private boolean isEndEscapeSequence(char cur) {
        boolean rval = false;
        int lookAheadIndex = this._index + 2;
        if (!this.isIndexOutOfBounds(lookAheadIndex)) {
            char lookAhead1 = this.getChar(this._index + 1);
            char lookAhead2 = this.getChar(this._index + 2);
            if ('-' == cur && '-' == lookAhead1 && '>' == lookAhead2) {
                this._index += 2;
                rval = true;
            }
        }
        return rval;
    }

    private boolean isNestedResource(char cur) throws ParseExpressionException {
        char lookAhead1;
        int increment = 0;
        int lookAheadIndex = this._index;
        if (cur == ']') {
            ++lookAheadIndex;
        }
        boolean rval = false;
        if (!this.isIndexOutOfBounds(lookAheadIndex) && '.' == (lookAhead1 = this.getChar(lookAheadIndex))) {
            char lookAhead2;
            rval = true;
            if (lookAheadIndex == this._index + 1) {
                ++increment;
            }
            if (!this.isIndexOutOfBounds(++lookAheadIndex) && '[' == (lookAhead2 = this.getChar(lookAheadIndex))) {
                ++increment;
            }
            this._index += increment;
        }
        return rval;
    }

    private boolean isNestedOlapMember() throws ParseExpressionException {
        char lookAhead2;
        int lookAheadIndex2;
        char lookAhead1;
        boolean rval = false;
        int lookAheadIndex1 = this._index + 1;
        if (!this.isIndexOutOfBounds(lookAheadIndex1) && this.isDottedOlapMember(lookAhead1 = this.getChar(lookAheadIndex1)) && !this.isIndexOutOfBounds(lookAheadIndex2 = lookAheadIndex1 + 1) && this.isStartOfOlapMember(lookAhead2 = this.getChar(lookAheadIndex2))) {
            rval = true;
        }
        return rval;
    }

    private boolean isStartOfPromptResource() {
        String prompt = "prompt::";
        return this.isStartOfQualifiedResource(prompt);
    }

    private boolean isStartOfPhysicalResource() {
        String physical = "physical::";
        return this.isStartOfQualifiedResource(physical);
    }

    private boolean isStartOfQualifiedResource(String qualifier) {
        int length = qualifier.length();
        boolean rval = true;
        rval = this._expression.regionMatches(true, this._index, qualifier, 0, length);
        if (rval) {
            int oldIndex = this._index;
            this._index += length;
            char cur = this.getChar(this._index);
            if (!this.isStartOfResource(cur)) {
                this._index = oldIndex;
                rval = false;
            }
        }
        return rval;
    }

    private boolean isStartOfOlapMember(char ch) {
        return ch == '[';
    }

    private boolean isDottedResource(char cur) {
        return '.' == cur;
    }

    private boolean isDottedOlapMember(char cur) {
        return '.' == cur;
    }

    private boolean isEndOfResource(char cur) {
        char lookAhead1;
        int increment = 0;
        int lookAheadIndex = this._index;
        if (cur == ']') {
            ++lookAheadIndex;
        }
        boolean rval = false;
        if (!this.isIndexOutOfBounds(lookAheadIndex) && '>' == (lookAhead1 = this.getChar(lookAheadIndex))) {
            char lookAhead2;
            if (lookAheadIndex == this._index + 1) {
                ++increment;
            }
            if (!this.isIndexOutOfBounds(++lookAheadIndex) && '>' == (lookAhead2 = this.getChar(lookAheadIndex))) {
                this._index += ++increment;
                rval = true;
            }
        }
        return rval;
    }

    private boolean isEndOfOlapMember(char cur) {
        return ']' == cur;
    }

    private boolean isStartOfQuote(char cur) {
        return '\'' == cur || '\"' == cur;
    }

    private boolean isStartOfResource(char cur) {
        char lookAhead1;
        if (cur != '<') {
            return false;
        }
        boolean rval = false;
        int lookAheadIndex1 = this._index + 1;
        if (!this.isIndexOutOfBounds(lookAheadIndex1) && '<' == (lookAhead1 = this.getChar(lookAheadIndex1))) {
            char lookAhead2;
            rval = true;
            ++this._index;
            int lookAheadIndex2 = lookAheadIndex1 + 1;
            if (!this.isIndexOutOfBounds(lookAheadIndex2) && '[' == (lookAhead2 = this.getChar(lookAheadIndex2))) {
                ++this._index;
            }
        }
        return rval;
    }

    private boolean isInvalidInResource(char cur, char lookAhead) {
        return '<' == cur && '<' == lookAhead;
    }

    private boolean isInPromptResourceState() {
        return this._state == 4;
    }

    private boolean isInPhysicalResourceState() {
        return this._state == 6;
    }

    private boolean isInResourceState() {
        return this._state == 2 || this.isInPromptResourceState() || this.isInPhysicalResourceState();
    }

    private boolean isEndOfQuote(char cur) {
        boolean rval = false;
        if (this._inSingleQuotedString && cur == '\'') {
            rval = true;
        } else if (this._inDoubleQuotedString && cur == '\"') {
            rval = true;
        }
        return rval;
    }

    private void goToInitialState() {
        this._prevState = this._state;
        this._state = 0;
        this._stateIndex = this._index;
        this.resetBuffer();
    }

    private void goToPreviousState() {
        int tmp = this._state;
        this._state = this._prevState;
        this._prevState = tmp;
        this._stateIndex = this._index;
        this.resetBuffer();
    }

    private void goToQuoteState(char cur) {
        this._prevState = this._state;
        this._state = 1;
        this._stateIndex = this._index;
        if (cur == '\'') {
            this._inSingleQuotedString = true;
            this._inDoubleQuotedString = false;
        } else if (cur == '\"') {
            this._inDoubleQuotedString = true;
            this._inSingleQuotedString = false;
        }
        this.resetBuffer();
    }

    private void goToEscapeState() {
        this._prevState = this._state;
        this._state = 3;
        this._stateIndex = this._index;
        this.resetBuffer();
    }

    private void goToResourceState(int state) {
        this._prevState = this._state;
        this._state = state;
        this._stateIndex = this._index;
        this._resource = null;
        this.resetBuffer();
    }

    private void goToPromptResourceState() {
        this.goToResourceState(4);
    }

    private void goToPhysicalResourceState() {
        this.goToResourceState(6);
    }

    private void goToOlapMemberState() {
        this._prevState = this._state;
        this._state = 5;
        this._stateIndex = this._index;
        this.resetBuffer();
    }

    private void resetBuffer() {
        this._buffer = new StringBuffer();
    }

    private StringBuffer getBuffer() {
        return this._buffer;
    }

    private boolean isIndexOutOfBounds(int someIndex) {
        return someIndex >= this._expression.length();
    }

    private char getChar(int someIndex) {
        return this._expression.charAt(someIndex);
    }

    private ParseExpressionException generateBadlyFormedException() {
        MessageFormatter errorMsg = null;
        if (this._state == 1) {
            Object[] params = new Object[]{this._inSingleQuotedString ? Character.valueOf('\'') : Character.valueOf('\"'), this._stateIndex};
            errorMsg = IQMetadataResourceBundle.getMessageFormatter("StringExpressionTokenizer.BadlyFormedQuote.fmt.txt", params);
        } else if (this._state == 2) {
            Object[] params = new Object[]{"<<", this._stateIndex, ">>"};
            errorMsg = IQMetadataResourceBundle.getMessageFormatter("StringExpressionTokenizer.BadlyFormedResource.fmt.txt", params);
        } else if (this._state == 5) {
            Object[] params = new Object[]{Character.valueOf('['), this._stateIndex, Character.valueOf(']')};
            errorMsg = IQMetadataResourceBundle.getMessageFormatter("StringExpressionTokenizer.BadlyFormedSquareBrace.fmt.txt", params);
        } else {
            errorMsg = IQMetadataResourceBundle.getMessageFormatter("StringExpressionTokenizer.UnexpectedParsingError.fmt.txt", this._stateIndex);
        }
        return new ParseExpressionException(errorMsg, this._index, this._stateIndex);
    }

    private ParseExpressionException generateInvalidResourceError() {
        return new ParseExpressionException(IQMetadataResourceBundle.getMessageFormatter("StringExpressionTokenizer.InvalidResource.fmt.txt", this._index, this._stateIndex), this._index, this._stateIndex);
    }

    public static void main(String[] args) throws ParseExpressionException {
        String test = "This is just an Expression";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "Prompt::<<[somePrompt]>>";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "phySical::<<physicalItem>>";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "<<[id1].[id2].[id3]>>";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "[D1].[H1].[M1].someOperator + 3";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "[D1].[H1].[MemberWith'].someOperator + 3";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "This is an Expression with a Escape <!-- Prompt::[somePrompt] --> String";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "This is an Expression with a <<table>>.something Resource";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = "This is an Expression with a  \"test String \" and a [table].[col] Resource";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = " select * from [table] where [table].[col] = \"abc\";";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = " select * from [table] where [table].[col1] = \"abc\" and [table].[col2] = [table2].[col1] '+' 5;";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
        test = " select * from [table] where [table].[col] = \"abc\" and b = ';";
        System.out.println(StringExpressionTokenizer.tokenizeExpression(test));
    }
}

