/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.parser;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.expr.ResourceIdentificationException;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifierList;
import com.sas.iquery.metadata.expr.parser.Resource;
import com.sas.iquery.metadata.expr.parser.ResourceIdentifier;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ResourceLocator {
    BusinessModel _businessModel;
    BusinessModel _businessModelToUseForThisResource;
    ResourceScope _scope;
    ExpressionIdentifierList _exprList;
    List _errors;
    private static final String RESOURCE_RESOLUTION_ERROR = "ResourceLocator.ResourceResolutionError.fmt.txt";
    private static final String INVALID_RESOURCE_ERROR = "ResourceLocator.InvalidResourceError.fmt.txt";
    private static final String METADATA_ERROR = "ResourceLocator.MetadataException.fmt.txt";
    private static final String GENERIC_ERROR = "ResourceLocator.GenericError.txt";

    ResourceLocator(BusinessModel businessModel, ExpressionIdentifierList exprList, ResourceScope scope) {
        this._businessModel = businessModel;
        this._exprList = exprList;
        this._scope = scope;
        this._errors = new ArrayList();
    }

    static void resolveResources(BusinessModel businessModel, ExpressionIdentifierList exprList, ResourceScope scope) throws MetadataException {
        new ResourceLocator(businessModel, exprList, scope).resolveResources();
    }

    private void resolveResources() throws MetadataException {
        List resourceIdentifierList = this._exprList.getResourceIdentifiers();
        Iterator resourceIdentifierIter = resourceIdentifierList.iterator();
        while (resourceIdentifierIter.hasNext()) {
            ResourceIdentifier cur = null;
            try {
                cur = (ResourceIdentifier)resourceIdentifierIter.next();
                this.resolveResource(cur);
            }
            catch (ResourceIdentificationException e) {
                this._errors.addAll(e.getErrors());
            }
            catch (MetadataException e) {
                this._errors.add(this.generateMetadataError(e.getMessage(), cur));
            }
        }
        if (this._errors.size() > 0) {
            throw new ResourceIdentificationException(IQMetadataResourceBundle.getMessageFormatter(GENERIC_ERROR, new Object[0]), this._errors);
        }
    }

    private ResourceIdentifier determineBusinessModelToUse(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        ResourceIdentifier bmIdentifier = resourceIdentifier;
        while (bmIdentifier.hasParent()) {
            bmIdentifier = bmIdentifier.getParent();
        }
        this._businessModelToUseForThisResource = this._businessModel;
        this._businessModelToUseForThisResource = this.getMatchingBusinessModel(bmIdentifier.getResourceString());
        if (this._businessModelToUseForThisResource != null) {
            resourceIdentifier = bmIdentifier.getChild();
            resourceIdentifier.setParent(null);
        } else {
            this._businessModelToUseForThisResource = this._businessModel;
        }
        return resourceIdentifier;
    }

    private void resolveResource(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        if ((resourceIdentifier = this.determineBusinessModelToUse(resourceIdentifier)).isPromptResource() && this._scope.isBusiness()) {
            this.resolveBusinessResource(resourceIdentifier);
        } else if (resourceIdentifier.isPhysicalResource() && this._scope.isPhysical()) {
            this.resolvePhysicalResource(resourceIdentifier);
        } else if (this._scope.isBusiness()) {
            try {
                this.resolveBusinessResource(resourceIdentifier);
            }
            catch (ResourceIdentificationException e) {
                if (this._scope.isPhysical()) {
                    this.resolvePhysicalResource(resourceIdentifier);
                }
                throw e;
            }
        } else if (this._scope.isPhysical()) {
            this.resolvePhysicalResource(resourceIdentifier);
        }
    }

    private void resolveBusinessResource(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        BusinessItem businessItem = null;
        String resourceString = resourceIdentifier.getResourceString();
        if (resourceIdentifier.hasParent()) {
            BusinessModel businessModel = this.getMatchingBusinessModel(resourceIdentifier.getParent().getResourceString());
            if (businessModel != null) {
                businessItem = businessModel.getBusinessItemByID(resourceString);
            }
        } else {
            BusinessModel curBusinessModel;
            BusinessModelChain chain = new BusinessModelChain(this._businessModelToUseForThisResource);
            while (chain.hasBusinessModel() && (businessItem = (curBusinessModel = chain.getBusinessModel()).getBusinessItemByID(resourceString)) == null) {
            }
        }
        if (businessItem == null) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        resourceIdentifier.setResource(new Resource(businessItem));
    }

    private void resolvePhysicalResource(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        try {
            this.resolveRelationalResource(resourceIdentifier);
        }
        catch (ResourceIdentificationException e) {
            this.resolveOLAPResource(resourceIdentifier);
        }
    }

    private void resolveRelationalResource(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        try {
            this.resolveColumn(resourceIdentifier);
        }
        catch (ResourceIdentificationException e) {
            this.resolveTable(resourceIdentifier);
        }
    }

    private void resolveColumn(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        if (!resourceIdentifier.hasParent()) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        ResourceIdentifier tableIdentifier = resourceIdentifier;
        while (tableIdentifier.hasParent()) {
            tableIdentifier = tableIdentifier.getParent();
        }
        this.resolveTable(tableIdentifier);
        Resource parentResource = tableIdentifier.getResource();
        if (parentResource == null || !(parentResource.getBusinessModelResource() instanceof DataSourceTable)) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        DataSourceTable table = (DataSourceTable)parentResource.getBusinessModelResource();
        QualifiedColumn column = this.getMatchingColumn(table, tableIdentifier);
        resourceIdentifier.setResource(new Resource(column));
    }

    private void resolveTable(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        DataSource table = null;
        String resourceString = resourceIdentifier.getResourceString();
        if (resourceIdentifier.hasParent()) {
            BusinessModel businessModel = this.getMatchingBusinessModel(resourceIdentifier.getParent().getResourceString());
            if (businessModel != null) {
                table = businessModel.getDataSourceByID(resourceString);
            }
        } else {
            BusinessModel curBusinessModel;
            BusinessModelChain chain = new BusinessModelChain(this._businessModelToUseForThisResource);
            while (chain.hasBusinessModel() && (table = (curBusinessModel = chain.getBusinessModel()).getDataSourceByID(resourceString)) == null) {
            }
        }
        if (table == null) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        resourceIdentifier.setResource(new Resource(table));
    }

    private BusinessModel getMatchingBusinessModel(String businessModelID) throws MetadataException {
        BusinessModelChain chain = new BusinessModelChain(this._businessModelToUseForThisResource);
        BusinessModel match = null;
        while (chain.hasBusinessModel()) {
            BusinessModel curBusinessModel = chain.getBusinessModel();
            if (!curBusinessModel.getID().equals(businessModelID)) continue;
            match = curBusinessModel;
            break;
        }
        return match;
    }

    private QualifiedColumn getMatchingColumn(DataSourceTable table, ResourceIdentifier tableIdentifier) throws ResourceIdentificationException, MetadataException {
        QualifiedColumn column = null;
        ResourceIdentifier resourceIdentifier = tableIdentifier.getChild();
        StringBuffer columnLabel = new StringBuffer();
        while (resourceIdentifier != null) {
            columnLabel.append(resourceIdentifier.getResourceString());
            if ((resourceIdentifier = resourceIdentifier.getChild()) == null) continue;
            columnLabel.append('.');
        }
        for (QualifiedColumn qualifiedColumn : table.getColumns()) {
            if (!columnLabel.toString().equalsIgnoreCase(qualifiedColumn.getLabel())) continue;
            column = qualifiedColumn;
            break;
        }
        if (null == column) {
            for (QualifiedColumn qualifiedColumn : table.getColumns()) {
                if (!columnLabel.toString().equalsIgnoreCase(qualifiedColumn.getSasName())) continue;
                column = qualifiedColumn;
                break;
            }
        }
        if (column == null) {
            throw this.generateResourceResolutionError(tableIdentifier);
        }
        return column;
    }

    private void resolveOLAPResource(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        if (this.isDimension(resourceIdentifier)) {
            this.resolveDimension(resourceIdentifier);
        } else if (this.isHierarchy(resourceIdentifier)) {
            try {
                this.resolveHierarchy(resourceIdentifier);
            }
            catch (ResourceIdentificationException e) {
                if (this.isMeasure(resourceIdentifier)) {
                    this.resolveMeasure(resourceIdentifier);
                }
                throw e;
            }
        } else if (this.isMeasure(resourceIdentifier)) {
            this.resolveMeasure(resourceIdentifier);
        } else if (this.isLevel(resourceIdentifier)) {
            this.resolveLevel(resourceIdentifier);
        }
    }

    private boolean isDimension(ResourceIdentifier resourceIdentifier) {
        return resourceIdentifier != null && !resourceIdentifier.hasParent();
    }

    private boolean isHierarchy(ResourceIdentifier resourceIdentifier) {
        return resourceIdentifier != null && this.isDimension(resourceIdentifier.getParent());
    }

    private boolean isLevel(ResourceIdentifier resourceIdentifier) {
        return resourceIdentifier != null && this.isHierarchy(resourceIdentifier.getParent());
    }

    private boolean isMeasure(ResourceIdentifier resourceIdentifier) {
        return resourceIdentifier != null && (this.isDimension(resourceIdentifier.getParent()) || this.isLevel(resourceIdentifier.getParent()));
    }

    private void resolveDimension(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        DataSourceCube cube = null;
        List<DataSourceCube> cubes = this._businessModelToUseForThisResource.getObjects(true, DataSourceCube.class);
        if (cubes == null || cubes.size() == 0) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        String resourceString = resourceIdentifier.getResourceString();
        cube = cubes.get(0);
        Iterator<Dimension> dimensionsIter = cube.getDimensions().iterator();
        Dimension dimension = null;
        while (dimensionsIter.hasNext()) {
            Dimension tmp = dimensionsIter.next();
            if (!resourceString.equalsIgnoreCase(tmp.getLabel())) continue;
            dimension = tmp;
            break;
        }
        if (dimension == null) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        resourceIdentifier.setResource(new Resource(dimension));
    }

    private void resolveHierarchy(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        String resourceString = resourceIdentifier.getResourceString();
        ResourceIdentifier parent = resourceIdentifier.getParent();
        this.resolveDimension(parent);
        Dimension dimension = (Dimension)parent.getResource().getBusinessModelResource();
        Iterator<Hierarchy> hierarchyIter = dimension.getHierarchies().iterator();
        Hierarchy hierarchy = null;
        while (hierarchyIter.hasNext()) {
            Hierarchy tmp = hierarchyIter.next();
            if (!resourceString.equalsIgnoreCase(tmp.getLabel())) continue;
            hierarchy = tmp;
            break;
        }
        if (hierarchy == null) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        resourceIdentifier.setResource(new Resource(hierarchy));
    }

    private void resolveMeasure(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        List<DataSourceCube> cubes = this._businessModelToUseForThisResource.getObjects(true, DataSourceCube.class);
        if (cubes == null || cubes.size() == 0) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        String resourceString = resourceIdentifier.getResourceString();
        Measure measure = null;
        List<Measure> measures = cubes.get(0).getMeasures();
        for (Measure m : measures) {
            if (!resourceString.equalsIgnoreCase(m.getLabel())) continue;
            measure = m;
            break;
        }
        if (measure == null) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        resourceIdentifier.setResource(new Resource(measure));
    }

    private void resolveLevel(ResourceIdentifier resourceIdentifier) throws ResourceIdentificationException, MetadataException {
        String resourceString = resourceIdentifier.getResourceString();
        ResourceIdentifier parent = resourceIdentifier.getParent();
        this.resolveHierarchy(parent);
        Hierarchy hierarchy = (Hierarchy)parent.getResource().getBusinessModelResource();
        Iterator<Level> hierarchyIter = hierarchy.getLevels().iterator();
        Level level = null;
        while (hierarchyIter.hasNext()) {
            Level tmp = hierarchyIter.next();
            if (!resourceString.equalsIgnoreCase(tmp.getLabel())) continue;
            level = tmp;
            break;
        }
        if (level == null) {
            throw this.generateResourceResolutionError(resourceIdentifier);
        }
        resourceIdentifier.setResource(new Resource(level));
    }

    private ResourceIdentificationException generateMetadataError(String msg, ResourceIdentifier resourceIdentifier) throws MetadataException {
        Object[] params = new Object[4];
        params[0] = msg;
        params[1] = this.getMostNestedIdentifier(resourceIdentifier).toString();
        int start = resourceIdentifier.getStartIndex();
        params[2] = start;
        int end = resourceIdentifier.getEndIndex();
        params[3] = end;
        return new ResourceIdentificationException(IQMetadataResourceBundle.getMessageFormatter(METADATA_ERROR, params), this._scope, start, end);
    }

    private ResourceIdentificationException generateResourceResolutionError(ResourceIdentifier resourceIdentifier) throws MetadataException {
        Object[] params = new Object[3];
        params[0] = this.getMostNestedIdentifier(resourceIdentifier).toString();
        int start = resourceIdentifier.getStartIndex();
        params[1] = start;
        int end = resourceIdentifier.getEndIndex();
        params[2] = end;
        return new ResourceIdentificationException(IQMetadataResourceBundle.getMessageFormatter(RESOURCE_RESOLUTION_ERROR, params), this._scope, start, end);
    }

    private ResourceIdentificationException generateInvalidResourceError(ResourceIdentifier resourceIdentifier) {
        Object[] params = new Object[3];
        params[0] = this.getMostNestedIdentifier(resourceIdentifier).toString();
        int start = resourceIdentifier.getStartIndex();
        params[1] = start;
        int end = resourceIdentifier.getEndIndex();
        params[2] = end;
        return new ResourceIdentificationException(IQMetadataResourceBundle.getMessageFormatter(INVALID_RESOURCE_ERROR, params), this._scope, start, end);
    }

    private ResourceIdentifier getMostNestedIdentifier(ResourceIdentifier resourceIdentifier) {
        ResourceIdentifier last = resourceIdentifier;
        while (last.hasChild()) {
            last = last.getChild();
        }
        return last;
    }

    static class BusinessModelChain {
        BusinessModel next;
        int cursor;

        BusinessModelChain(BusinessModel model) {
            this.next = model;
            this.cursor = 0;
        }

        boolean hasBusinessModel() {
            if (this.cursor != 0) {
                this.next = this.next.getBaseModel();
            }
            return this.next != null;
        }

        BusinessModel getBusinessModel() {
            ++this.cursor;
            return this.next;
        }
    }
}

