/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.parser;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.parser.Resource;

class ResourceIdentifier
extends ExpressionIdentifier {
    static final char START_RESOURCE_CHAR1 = '<';
    static final char START_RESOURCE_CHAR2 = '<';
    static final char START_RESOURCE_OPTIONAL_CHAR = '[';
    static final char END_RESOURCE_OPTIONAL_CHAR = ']';
    static final char END_RESOURCE_CHAR1 = '>';
    static final char END_RESOURCE_CHAR2 = '>';
    static final char DOTTED_RESOURCE = '.';
    static final String START_RESOURCE = "<<";
    static final String END_RESOURCE = ">>";
    private ResourceIdentifier _parent;
    private ResourceIdentifier _child;
    private Resource _resource;
    private String _resourceString;
    private int _startIndex;
    private int _endIndex;

    ResourceIdentifier(ResourceIdentifier parent, String resourceString, int startIndex, int endIndex) {
        super(1);
        this._parent = parent;
        if (this._parent != null) {
            this._parent.setChild(this);
        }
        this._resourceString = resourceString;
        this._startIndex = startIndex;
        this._endIndex = endIndex;
    }

    ResourceIdentifier(Resource resource) throws MetadataException {
        super(1);
        this.setResource(resource);
    }

    final void setParent(ResourceIdentifier parent) {
        this._parent = parent;
    }

    private void setChild(ResourceIdentifier child) {
        this._child = child;
    }

    final void setResource(Resource resource) {
        this._resource = resource;
    }

    final Resource getResource() {
        return this._resource;
    }

    final boolean hasChild() {
        return this._child != null;
    }

    final ResourceIdentifier getChild() {
        return this._child;
    }

    final boolean hasParent() {
        return this.getParent() != null;
    }

    final ResourceIdentifier getParent() {
        return this._parent;
    }

    public final int getStartIndex() {
        return this.hasParent() ? this._parent.getStartIndex() : this._startIndex;
    }

    public final int getEndIndex() {
        return this.hasChild() ? this._child.getEndIndex() : this._endIndex;
    }

    final String getResourceString() throws MetadataException {
        return this._resource != null ? this._resource.getID() : this._resourceString;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        try {
            if (this.hasParent()) {
                tmp.append(this.getParent());
                tmp.append('.');
            }
            tmp.append(this.getResourceString());
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return tmp.toString();
    }
}

