/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.parser;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.util.Preconditions;

class Resource {
    private static final int BUSINESS_MODEL_OBJECT = 1;
    private static final int QUALIFIED_COLUMN = 2;
    private static final int OLAP_ITEM = 3;
    private static final String NULL_RESOURCE = "Resource.NullResource.txt";
    private static final String INVALID_RESOURCE = "Resource.InvalidResourceType.fmt.txt";
    private BusinessModelResource _resource;
    private int _type;

    Resource(BusinessModelResource businessModelResource) {
        Preconditions.ensureNonNull(businessModelResource, "businessModelResource");
        this._resource = businessModelResource;
        this.setResourceType();
    }

    boolean isBusinessModelObject() {
        return 1 == this._type;
    }

    boolean isQualifiedColumn() {
        return 2 == this._type;
    }

    boolean isOlapItem() {
        return 3 == this._type;
    }

    boolean isBusinessItem() {
        return this._resource instanceof BusinessItem;
    }

    boolean isPhysicalResource() {
        return this._resource instanceof PhysicalResource;
    }

    String getID() throws MetadataException {
        String rval = null;
        if (this.isBusinessModelObject()) {
            rval = ((BusinessModelObject)this._resource).getIntraModelID();
        } else if (this.isQualifiedColumn()) {
            rval = ((QualifiedColumn)this._resource).getSasName();
        } else if (this.isOlapItem()) {
            if (this._resource instanceof Dimension) {
                rval = ((Dimension)this._resource).getDimensionName();
            } else if (this._resource instanceof Level) {
                rval = ((Level)this._resource).getLevelName();
            } else if (this._resource instanceof Measure) {
                rval = ((Measure)this._resource).getMeasureName();
            }
        } else {
            rval = "";
        }
        return rval;
    }

    BusinessModelResource getBusinessModelResource() {
        return this._resource;
    }

    private void setResourceType() {
        if (this._resource instanceof BusinessModelObject) {
            this._type = 1;
        } else if (this._resource instanceof QualifiedColumn) {
            this._type = 2;
        } else if (this._resource instanceof OlapItem) {
            this._type = 3;
        } else if (this._resource instanceof Hierarchy) {
            this._type = 3;
        } else {
            Object[] params = new Object[]{this._resource.getClass()};
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageString(INVALID_RESOURCE, params));
        }
    }
}

