/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.parser;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.parser.EscapeIdentifier;
import com.sas.iquery.metadata.expr.parser.OlapMemberIdentifier;
import com.sas.iquery.metadata.expr.parser.PromptResourceIdentifier;
import com.sas.iquery.metadata.expr.parser.Resource;
import com.sas.iquery.metadata.expr.parser.ResourceIdentifier;
import com.sas.iquery.metadata.expr.parser.StringIdentifier;

public abstract class ExpressionIdentifier
implements Cloneable {
    static final int STRING_IDENTIFIER = 0;
    static final int RESOURCE_IDENTIFIER = 1;
    static final int ESCAPE_IDENTIFIER = 2;
    static final int MEMBER_IDENTIFIER = 3;
    static final int PROMPT_RESOURCE_IDENTIFIER = 4;
    static final int PHYSICAL_RESOURCE_IDENTIFIER = 5;
    private int _type;

    public static ExpressionIdentifier getResourceIdentifier(BusinessModelResource resource) throws MetadataException {
        return new ResourceIdentifier(new Resource(resource));
    }

    public static ExpressionIdentifier getPromptResourceIdentifier(Prompt resource) throws MetadataException {
        return new PromptResourceIdentifier(new Resource(resource));
    }

    public static ExpressionIdentifier getStringIdentifier(String str) {
        return new StringIdentifier(str);
    }

    public static ExpressionIdentifier getEscapeIdentifier(String str) {
        return new EscapeIdentifier(str);
    }

    public static ExpressionIdentifier getOlapMemberIdentifier(String str) {
        return new OlapMemberIdentifier(str);
    }

    protected ExpressionIdentifier(int type) {
        this.setType(type);
    }

    protected void setType(int type) {
        this._type = type;
    }

    public boolean isString() {
        return 0 == this._type;
    }

    public boolean isResource() {
        return 1 == this._type || 4 == this._type || 5 == this._type;
    }

    public boolean isPromptResource() {
        return 4 == this._type;
    }

    public boolean isPhysicalResource() {
        return 5 == this._type;
    }

    public boolean isEscape() {
        return 2 == this._type;
    }

    public boolean isOlapMember() {
        return 3 == this._type;
    }

    public String getStringValue() throws MetadataException {
        String rval = "";
        if (this.isString()) {
            rval = ((StringIdentifier)this).getString();
        } else if (this.isEscape()) {
            rval = ((EscapeIdentifier)this).getEscapeString();
        } else if (this.isResource()) {
            rval = ((ResourceIdentifier)this).getResourceString();
        } else if (this.isOlapMember()) {
            rval = ((OlapMemberIdentifier)this).getMemberString();
        }
        return rval;
    }

    public BusinessModelResource getBusinessModelResource() {
        Resource resource;
        BusinessModelResource rval = null;
        if (this.isResource() && (resource = ((ResourceIdentifier)this).getResource()) != null) {
            rval = resource.getBusinessModelResource();
        }
        return rval;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

