/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.AbstractTimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberTuple;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeRangeFilter;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class TimeRangeFilterExpression
extends AbstractTimeRangeFilterExpression {
    public static final String EVENT_START_DATE_MEMBER_CHANGED = "The Start Date attribute has changed";
    public static final String EVENT_END_DATE_MEMBER_CHANGED = "The End Date attribute has changed";
    private ExpressionInterface _startMember = null;
    private ExpressionInterface _endMember = null;
    private List<MemberTuple> _memberTuples = new ArrayList<MemberTuple>();
    private String _memberLevelRoot = null;
    private Locale _memberLocale = null;
    private static final Logger _logger = LogManager.getLogger(TimeRangeFilterExpression.class);
    private static final Logger _MDXLogger = LogManager.getLogger(MDXGenerationUtil.class);

    @SASScope(value="ALL")
    @SubjectToChange
    public TimeRangeFilterExpression() {
    }

    @SASScope
    protected void fixDateTuple(ExpressionInterface expression) {
        block2: {
            DataItem da = (DataItem)expression;
            try {
                this.buildMemberTuples(da.getBusinessModel());
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("TimeFilterExpressionTupleNotThere.txt"));
            }
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getStartDateMember() {
        String startDateMember = null;
        if (this._startMember instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._startMember;
            startDateMember = constant.getValue();
        }
        return startDateMember;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getEndDateMember() {
        String endDateMember = null;
        if (this._endMember instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._endMember;
            endDateMember = constant.getValue();
        }
        return endDateMember;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ExpressionInterface getStartMember() {
        return this._startMember;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ExpressionInterface getEndMember() {
        return this._endMember;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isNegated() {
        return false;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public void setIsNegated(boolean flag) {
        String msg = IQMetadataResourceBundle.getMessageString("TimeFilterExpression.MethodNotSupported.fmt.txt", "setIsNegated(boolean)");
        throw new UnsupportedOperationException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected void buildMemberTuples(BusinessModel model) throws MetadataException {
        block10: {
            if (this.isNegated() || this.getResources(Prompt.class, 65535).size() > 0) {
                _logger.debug("No member tuples are built, this is only built if there is EQ expression, it does not contain prompts");
                return;
            }
            try {
                OLAPServerUtilities olapServerUtil = OLAPServerUtilities.getInstance();
                try (OLAPDataSet olapDataSet = null;){
                    olapDataSet = TimeRangeFilterExpression.buildResultSet(this, model);
                    if (olapDataSet == null) {
                        MDXGenerationUtil.applyDebugStatement("No olapdataSet was constructed for building a filter tuple list.", this.getClass());
                        return;
                    }
                    ArrayList<String> memberTrimStrings = new ArrayList<String>();
                    List<MemberTuple> returnList = olapServerUtil.getFilterTupleList((OLAPDataSetInterface)olapDataSet, memberTrimStrings, false);
                    this._memberLevelRoot = olapServerUtil.getFilterTupleAncestor();
                    this.setFilterTupleList(returnList);
                }
            }
            catch (GenerationException ge) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, ge.getLocalizedMessage(), IQMetadataResourceBundle.getStringResource("MemberFitlerExpressionGenerationExcp.txt"));
                MetadataException e = new MetadataException(msF);
                e.initCause(ge);
                throw e;
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(Level.ERROR)) break block10;
                _logger.debug("Error while closing the OlapDataSet, just continue: " + e.getLocalizedMessage());
            }
        }
    }

    private static String getMDXString(TimeRangeFilterExpression expression, String cubeName) throws GenerationException {
        StringBuilder memberNamesString = new StringBuilder();
        memberNamesString.append("{").append(TimeRangeFilter.getMDXExpression(expression, null)).append("}");
        String mdxSet = MDXGenerationUtil.buildSetQuery(memberNamesString.toString(), cubeName);
        if (null == mdxSet || mdxSet.length() == 0) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MemberFitlerExpressionNoMDXSet.txt")};
            if (_MDXLogger.isEnabled(Level.ERROR)) {
                _MDXLogger.error(memberNamesString.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException e = new GenerationException(msF);
            throw e;
        }
        return mdxSet;
    }

    private static OLAPDataSet buildResultSet(TimeRangeFilterExpression tme, BusinessModel model) throws GenerationException {
        OLAPDataSet olapDataSet = null;
        String mdxSet = "";
        try {
            mdxSet = TimeRangeFilterExpression.getMDXString(tme, OLAPConnectionInfoUtil.getCube(model).getCubeName());
            olapDataSet = OLAPConnectionInfoUtil.executeQuery(model, mdxSet);
        }
        catch (MetadataException me) {
            Object[] msgArgs2 = new Object[]{mdxSet, IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilQueryFail.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException ge = new GenerationException(msF);
            throw ge;
        }
        catch (IQueryServicesException me) {
            Object[] msgArgs2 = new Object[]{mdxSet, IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilNoCube.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            _MDXLogger.error(mdxSet);
            GenerationException ge = new GenerationException(msF);
            throw ge;
        }
        if (olapDataSet == null) {
            Object[] msgArgs2 = new Object[]{mdxSet, IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilNoOLAPDataSet.txt")};
            _MDXLogger.error(mdxSet);
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException e = new GenerationException(msF);
            throw e;
        }
        return olapDataSet;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getMemberLevelRoot() {
        ExpressionInterface expression = this.getWhatToCompare();
        if (expression instanceof DataItem && this._memberLevelRoot == null) {
            this.fixDateTuple(expression);
        }
        return this._memberLevelRoot;
    }

    private void setFilterTupleList(List<MemberTuple> memberTuples) {
        this._memberTuples = memberTuples;
    }

    public void setStartDateMember(String startDateMember) throws IllegalArgumentException {
        if (startDateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(startDateMember);
            this._startMember = constant;
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            if (expression instanceof DataItem && this._memberLevelRoot != null) {
                this.fixDateTuple(expression);
            }
        } else {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullDateMember.txt", new Object[0]));
        }
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    private void determineMemberLocale(ExpressionInterface expression) {
        if (expression instanceof DataItem) {
            DataItem da = (DataItem)expression;
            BusinessModel model = da.getBusinessModel();
            this._memberLocale = LocaleUtilities.getDefaultViewerLocale(model);
        } else {
            this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
        }
    }

    public void setEndDateMember(String endDateMember) throws IllegalArgumentException {
        if (endDateMember != null) {
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(endDateMember);
            this._endMember = constant;
            if (expression instanceof DataItem && this._memberLevelRoot != null) {
                this.fixDateTuple(expression);
            }
        } else {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullDateMember.txt", new Object[0]));
        }
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    public void setStartMember(ExpressionInterface startDateMember) throws IllegalArgumentException {
        if (startDateMember != null) {
            this._startMember = startDateMember;
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            if (expression instanceof DataItem && this._memberLevelRoot != null) {
                this.fixDateTuple(expression);
            }
        } else {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullDateMember.txt", new Object[0]));
        }
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    public void setEndMember(ExpressionInterface endDateMember) throws IllegalArgumentException {
        if (endDateMember != null) {
            this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
            this._endMember = endDateMember;
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            if (expression instanceof DataItem && this._memberLevelRoot != null) {
                this.fixDateTuple(expression);
            }
        } else {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullDateMember.txt", new Object[0]));
        }
        this.fireChangeEvent(EVENT_START_DATE_MEMBER_CHANGED);
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._startMember instanceof AbstractModelItem) {
            intoList.add(this._startMember);
        }
        if (this._endMember instanceof AbstractModelItem) {
            intoList.add(this._endMember);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._startMember = (ExpressionInterface)TimeRangeFilterExpression.replace(this._startMember, oldObject, newObject);
        this._endMember = (ExpressionInterface)TimeRangeFilterExpression.replace(this._endMember, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        block11: {
            super.replaceDirectReferencesDuringResourceReplacement(oldObject, newObject);
            if (newObject instanceof PhysicalResource && ((PhysicalResource)newObject).isUnresolved()) {
                return;
            }
            ExpressionInterface whatToCompare = this.getWhatToCompare();
            if (BusinessQueryOLAPUtil.shouldReplaceStringInFilter(whatToCompare, newObject)) {
                Hierarchy hierarchy;
                ExpressionInterface hierarchyOfDataItem;
                if (whatToCompare instanceof DataItem && (hierarchyOfDataItem = ((DataItem)whatToCompare).getExpression()) instanceof Hierarchy && (hierarchy = (Hierarchy)hierarchyOfDataItem).isUnresolved()) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(IQMetadataResourceBundle.getStringResource("TimeFilterExpressionHierarchNotResolved.txt"));
                    }
                    return;
                }
                if (this._memberLevelRoot != null && this._startMember == null && this._endMember == null) {
                    ConstantExpression conExp = BusinessQueryOLAPUtil.convertStringIntoExpression(this._memberLevelRoot);
                    BusinessQueryOLAPUtil.replaceHierarchyInFilter(conExp, whatToCompare, newObject);
                    MDXGenerationUtil.applyDebugStatement("Lowest common level replaced from " + this._memberLevelRoot + " to " + conExp.getValue(), TimeRangeFilterExpression.class);
                    this._memberLevelRoot = conExp.getValue();
                }
                if (this._startMember != null && this._startMember instanceof ConstantExpression) {
                    ExpressionInterface prevStartMember = this._startMember;
                    BusinessQueryOLAPUtil.replaceHierarchyInFilter(this._startMember, whatToCompare, newObject);
                    MDXGenerationUtil.applyDebugStatement("Start Date replaced from " + prevStartMember.toString() + " to " + this._startMember.toString(), TimeRangeFilterExpression.class);
                }
                if (this._endMember != null && this._endMember instanceof ConstantExpression) {
                    ExpressionInterface prevEndMember = this._endMember;
                    BusinessQueryOLAPUtil.replaceHierarchyInFilter(this._endMember, this.getWhatToCompare(), newObject);
                    MDXGenerationUtil.applyDebugStatement("End Date replaced from " + prevEndMember.toString() + " to " + this._endMember.toString(), TimeRangeFilterExpression.class);
                }
                if (this._memberLevelRoot == null || this._startMember != null || this._endMember != null) {
                    MDXGenerationUtil.applyDebugStatement("No member level was found for this time filter expression.  We should have one at this point.  We will fix that condition now.", this.getClass());
                    ExpressionInterface objectWhat = this.getWhatToCompare();
                    if (objectWhat instanceof DataItem) {
                        try {
                            this.buildMemberTuples(((DataItem)objectWhat).getBusinessModel());
                        }
                        catch (MetadataException me) {
                            if (!_logger.isEnabled(Level.ERROR)) break block11;
                            _logger.error("Member definition: " + ((DataItem)objectWhat).getLabel() + " is not valid based on " + me.getLocalizedMessage());
                        }
                    }
                }
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved()) {
            Reason reason;
            Object[] reasonArgs;
            Vector<Integer> expTypes;
            int expType;
            if (this._endMember != null && (expType = this._endMember.getExpressionType()) != 3) {
                expTypes = ExpressionUtil.getJdbcTypes(expType);
                reasonArgs = new Object[]{this._endMember, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                reasons.add(reason);
            }
            if (this._startMember != null && (expType = this._startMember.getExpressionType()) != 3) {
                expTypes = ExpressionUtil.getJdbcTypes(expType);
                reasonArgs = new Object[]{this._startMember, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                reasons.add(reason);
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        this.validateForPrompt(this._startMember, reasons);
        this.validateForPrompt(this._endMember, reasons);
    }

    private void validateForPrompt(ExpressionInterface expression, List<Reason> reasons) {
        if (expression instanceof Prompt && !BaseFilterExpression.isValidOlapMemberPrompt((Prompt)expression)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidSingleSelectOlapMemberPrompt.fmt.txt", this, expression);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        TimeRangeFilterExpression clone = (TimeRangeFilterExpression)super.clone();
        clone._startMember = TimeRangeFilterExpression.cloneReferencedExpression(this._startMember);
        clone._endMember = TimeRangeFilterExpression.cloneReferencedExpression(this._endMember);
        return clone;
    }

    @SASScope
    public String toString() {
        String result;
        block2: {
            result = null;
            try {
                result = StringExpressionUtil.getInstance().getReadableText(this);
            }
            catch (MetadataException me) {
                result = "TimeRangeFilterExpression(Range=(" + Utils.toString(this.getWhatToCompare()) + "from=" + this._startMember + ", to=" + this._endMember + "), LevelName=" + this.getLevelName() + ")";
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug("Exception getting readable text for TimeRangeFilterExpression", (Throwable)me);
            }
        }
        return result;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "TimeRangeFilterExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        TimeRangeFilterExpression.writeRelatedObject(this._startMember, thisElement, writingContext, "StartDateMember");
        TimeRangeFilterExpression.writeRelatedObject(this._endMember, thisElement, writingContext, "EndDateMember");
        IQModelImplUtilities.setAttr(thisElement, "memberLevelRoot", this._memberLevelRoot);
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        String endDateMember;
        super.consumeAttributes(attrsProvider);
        String startDateMember = attrsProvider.consumeAttr("timeStartDate");
        if (startDateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(startDateMember);
            this._startMember = constant;
        }
        if ((endDateMember = attrsProvider.consumeAttr("timeEndDate")) != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(endDateMember);
            this._endMember = constant;
        }
        this._memberLevelRoot = attrsProvider.consumeAttr("memberLevelRoot");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        AbstractBase endMember;
        super.consumeRelatedObjects(riHolder);
        AbstractBase startMember = riHolder.consumeObject("StartDateMember");
        if (startMember != null) {
            this._startMember = (ExpressionInterface)((Object)startMember);
        }
        if ((endMember = riHolder.consumeObject("EndDateMember")) != null) {
            this._endMember = (ExpressionInterface)((Object)endMember);
        }
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String endDateMember;
        super.readDefinitionV1(thisElement, readingContext);
        String startDateMember = IQModelImplUtilities.getAttr(thisElement, "timeStartDate");
        if (startDateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(startDateMember);
            this._startMember = constant;
        }
        if ((endDateMember = IQModelImplUtilities.getAttr(thisElement, "timeEndDate")) != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(endDateMember);
            this._endMember = constant;
        }
    }
}

