/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class TimeFilterNPeriodsExpression
extends TimeFilterExpression {
    public static final String EVENT_DATE_CHANGED = "The date attribute has changed";
    private ExpressionInterface _dateMember = null;
    private Locale _memberLocale = null;
    private static final Logger _logger = LogManager.getLogger(TimeFilterNPeriodsExpression.class);

    @SASScope(value="ALL")
    @SubjectToChange
    public void setDateMember(String date) throws IllegalArgumentException {
        if (date != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(date);
            this._dateMember = constant;
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            if (expression instanceof DataItem && this.getMemberLevelRoot() == null) {
                this.fixDateTuple(expression);
            }
        } else {
            MessageFormatter errmsg = IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullDateMember.txt", new Object[0]);
            _logger.error((Object)errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this.fireChangeEvent(EVENT_DATE_CHANGED);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setDate(ExpressionInterface date) throws IllegalArgumentException {
        if (date != null) {
            this._dateMember = date;
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            if (expression instanceof DataItem && this.getMemberLevelRoot() == null) {
                this.fixDateTuple(expression);
            }
        } else {
            MessageFormatter errmsg = IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullDateMember.txt", new Object[0]);
            _logger.error((Object)errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this.fireChangeEvent(EVENT_DATE_CHANGED);
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getDateMember() {
        String dataMember;
        if (this._dateMember instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._dateMember;
            dataMember = constant.getValue();
        } else {
            dataMember = "";
        }
        return dataMember;
    }

    private void determineMemberLocale(ExpressionInterface expression) {
        if (expression instanceof DataItem) {
            DataItem da = (DataItem)expression;
            BusinessModel model = da.getBusinessModel();
            this._memberLocale = LocaleUtilities.getDefaultViewerLocale(model);
        } else {
            this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ExpressionInterface getDate() {
        return this._dateMember;
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved()) {
            if (this._dateMember == null) {
                reasons.add(new Reason((Object)this, 2, 104, "DataItemTimeFilterNullDateMember.txt", new Object[0]));
            } else {
                int expType = this._dateMember.getExpressionType();
                if (expType != 3) {
                    Vector<Integer> expTypes = ExpressionUtil.getJdbcTypes(expType);
                    Object[] reasonArgs = new Object[]{this._dateMember, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                    Reason reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                    reasons.add(reason);
                }
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (this._dateMember instanceof Prompt && !TimeFilterNPeriodsExpression.isValidOlapMemberPrompt((Prompt)this._dateMember)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidSingleSelectOlapMemberPrompt.fmt.txt", this, this._dateMember);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        TimeFilterNPeriodsExpression clone = (TimeFilterNPeriodsExpression)super.clone();
        clone._dateMember = TimeFilterNPeriodsExpression.cloneReferencedExpression(this._dateMember);
        return clone;
    }

    @Override
    @SASScope
    public String toString() {
        String result;
        block2: {
            result = null;
            try {
                result = StringExpressionUtil.getInstance().getReadableText(this);
            }
            catch (MetadataException me) {
                result = "(Date Member: " + this._dateMember + ")";
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug("Exception getting readable text for TimeFilterNPeriodsExpression", (Throwable)me);
            }
        }
        return result;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "TimeNPeriodsFilterExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        TimeFilterNPeriodsExpression.writeRelatedObject(this._dateMember, thisElement, writingContext, "DateMember");
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String dateMember = attrsProvider.consumeAttr("timeDateMember");
        if (dateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(dateMember);
            this._dateMember = constant;
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        AbstractBase dateMember = riHolder.consumeObject("DateMember");
        if (dateMember != null) {
            this._dateMember = (ExpressionInterface)((Object)dateMember);
            this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
        }
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        String dateMember = IQModelImplUtilities.getAttr(thisElement, "timeDateMember");
        if (dateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(dateMember);
            this._dateMember = constant;
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._dateMember instanceof AbstractModelItem) {
            intoList.add(this._dateMember);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._dateMember = (ExpressionInterface)TimeFilterNPeriodsExpression.replace(this._dateMember, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        Hierarchy hierarchy;
        ExpressionInterface hierarchyOfDataItem;
        if (newObject instanceof PhysicalResource && ((PhysicalResource)newObject).isUnresolved()) {
            return;
        }
        ExpressionInterface whatToCompare = this.getWhatToCompare();
        if (whatToCompare instanceof DataItem && (hierarchyOfDataItem = ((DataItem)whatToCompare).getExpression()) instanceof Hierarchy && (hierarchy = (Hierarchy)hierarchyOfDataItem).isUnresolved()) {
            _logger.error("Hierarchy is not resolved, string in filter can not be replaced");
            return;
        }
        if (BusinessQueryOLAPUtil.shouldReplaceStringInFilter(whatToCompare, newObject) && !BusinessQueryOLAPUtil.isPersistencePath(oldObject, newObject) && this._dateMember instanceof ConstantExpression && this._dateMember != null) {
            ExpressionInterface prevdate = this._dateMember;
            BusinessQueryOLAPUtil.replaceHierarchyInFilter(this._dateMember, whatToCompare, newObject);
            MDXGenerationUtil.applyDebugStatement("Date member replaced from " + prevdate.toString() + " to " + this._dateMember.toString(), this.getClass());
        }
        super.replaceDirectReferencesDuringResourceReplacement(oldObject, newObject);
    }
}

