/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberTuple;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeFirstLastPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNParallelPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNPeriodsFilter;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public abstract class TimeFilterExpression
extends BaseFilterExpression {
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_SEARCH_DIRECTION_CHANGED = "Search direction changed";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_PERIODS_CHANGED = "Number of periods changed";
    private String _memberLevelRoot = null;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_NPERIODS_CHANGED = "Number of periods changed";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String FORWARD = "FORWARD";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String BACKWARD = "BACKWARD";
    private String _searchDirection = null;
    private ExpressionInterface _periods;
    private List<MemberTuple> _memberTuples = new ArrayList<MemberTuple>();
    private static final Logger _logger = LogManager.getLogger(TimeFilterExpression.class);

    public void setnPeriods(int nPeriods) {
        if (nPeriods < 0) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilter.BadPeriods.txt", new Object[0]));
        }
        ConstantExpression constant = new ConstantExpression();
        constant.setExpressionType(2);
        constant.setValue(Integer.toString(nPeriods));
        this._periods = constant;
        this.fireChangeEvent("Number of periods changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected void buildMemberTuples(BusinessModel model) throws MetadataException {
        block20: {
            if (this.isNegated() || this.getResources(Prompt.class, 65535).size() > 0) {
                _logger.debug("No member tuples are built, this is only built if there is EQ expression, it does not contain prompts");
                return;
            }
            String expSet = "";
            try {
                OLAPServerUtilities olapServerUtil = OLAPServerUtilities.getInstance();
                try (OLAPDataSet olapDataSet = null;){
                    TimeFilterExpression tfne;
                    if (this instanceof TimeFilterFirstLastPeriodsExpression) {
                        expSet = TimeFirstLastPeriodsFilter.getMDXExpression((TimeFilterFirstLastPeriodsExpression)this, null);
                    } else if (this instanceof TimeFilterNParallelPeriodsExpression) {
                        tfne = (TimeFilterNParallelPeriodsExpression)this;
                        if (((TimeFilterNParallelPeriodsExpression)tfne).getDate() == null) {
                            _logger.debug("No Date for timeFilterNPeriodsExpression. Continue processing");
                            return;
                        }
                        expSet = TimeNParallelPeriodsFilter.getMDXExpression((TimeFilterNParallelPeriodsExpression)this, null);
                    } else if (this instanceof TimeFilterNPeriodsExpression) {
                        tfne = (TimeFilterNPeriodsExpression)this;
                        if (((TimeFilterNPeriodsExpression)tfne).getDate() == null) {
                            _logger.debug("No Date for timeFilterNPeriodsExpression. Continue processing");
                            return;
                        }
                        expSet = TimeNPeriodsFilter.getMDXExpression((TimeFilterNPeriodsExpression)this, null);
                    }
                    String mdxSet = MDXGenerationUtil.buildSetQuery(expSet, OLAPConnectionInfoUtil.getCubeName(model));
                    olapDataSet = OLAPConnectionInfoUtil.executeQuery(model, mdxSet);
                    if (olapDataSet == null) {
                        MDXGenerationUtil.applyDebugStatement("No olapdataSet was constructed for building a filter tuple list. ", this.getClass());
                        return;
                    }
                    ArrayList<String> memberTrimStrings = new ArrayList<String>();
                    List<MemberTuple> returnList = olapServerUtil.getFilterTupleList((OLAPDataSetInterface)olapDataSet, memberTrimStrings, false);
                    this._memberLevelRoot = olapServerUtil.getFilterTupleAncestor();
                    this.setFilterTupleList(returnList);
                }
            }
            catch (GenerationException ge) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, ge.getLocalizedMessage(), IQMetadataResourceBundle.getStringResource("MemberFitlerExpressionGenerationExcp.txt"));
                MetadataException e = new MetadataException(msF);
                e.initCause(ge);
                throw e;
            }
            catch (IQueryServicesException ge) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, ge.getLocalizedMessage(), IQMetadataResourceBundle.getStringResource("MemberFitlerExpressionGenerationExcp.txt"));
                MetadataException e = new MetadataException(msF);
                e.initCause(ge);
                throw e;
            }
            catch (OLAPException e) {
                if (!_logger.isDebugEnabled()) break block20;
                _logger.debug("Error while closing the OlapDataSet, just continue: " + e.getLocalizedMessage());
            }
        }
    }

    public String getMemberLevelRoot() {
        ExpressionInterface expression = this.getWhatToCompare();
        if (expression instanceof DataItem && this._memberLevelRoot == null) {
            this.fixDateTuple(expression);
        }
        return this._memberLevelRoot;
    }

    @SASScope
    protected void setMemberLevelRootUnresolved(String memberLevel) {
        this._memberLevelRoot = memberLevel;
    }

    private void setFilterTupleList(List<MemberTuple> memberTuples) {
        this._memberTuples = memberTuples;
    }

    @SASScope
    protected void fixDateTuple(ExpressionInterface expression) {
        block2: {
            DataItem da = (DataItem)expression;
            try {
                this.buildMemberTuples(da.getBusinessModel());
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("TimeFilterExpressionTupleNotThere.txt"));
            }
        }
    }

    public void setPeriods(ExpressionInterface periods) {
        if (periods instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)periods;
            if (constant.getExpressionType() != 2) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilter.InvalidPeriodExpressionType.txt", new Object[0]));
            }
            int nPeriods = Integer.parseInt(constant.getValue());
            if (nPeriods < 0) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilter.BadPeriods.txt", new Object[0]));
            }
        }
        this._periods = periods;
        ExpressionInterface expression = this.getWhatToCompare();
        if (expression instanceof DataItem && this._memberLevelRoot == null) {
            this.fixDateTuple(expression);
        }
        this.fireChangeEvent("Number of periods changed");
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public void setIsNegated(boolean flag) {
        throw new UnsupportedOperationException(IQMetadataResourceBundle.getMessageString("TimeFilterExpression.MethodNotSupported.fmt.txt", "setIsNegated(boolean)"));
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        super.replaceResource(oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    public void setSearchDirection(String searchDirection) throws IllegalArgumentException {
        if (searchDirection != null && (searchDirection.equals(FORWARD) || searchDirection.equals(BACKWARD))) {
            this._searchDirection = searchDirection;
            ExpressionInterface expression = this.getWhatToCompare();
            if (expression instanceof DataItem && this._memberLevelRoot == null) {
                this.fixDateTuple(expression);
            }
        } else {
            MessageFormatter errmsg = IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterBadSearchDirection.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)errmsg);
            }
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this.fireChangeEvent(EVENT_SEARCH_DIRECTION_CHANGED);
    }

    public int getnPeriods() {
        int nPeriods = 0;
        if (this._periods instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._periods;
            try {
                nPeriods = Integer.parseInt(constant.getValue(), 10);
            }
            catch (NumberFormatException nfe) {
                _logger.debug("The _periods value was not a valid numeric", (Throwable)nfe);
            }
        }
        return nPeriods;
    }

    public ExpressionInterface getPeriods() {
        return this._periods;
    }

    public String getSearchDirection() {
        return this._searchDirection;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        TimeFilterExpression.writeRelatedObject(this._periods, thisElement, writingContext, "Periods");
        IQModelImplUtilities.setAttr(thisElement, "timeSearchDir", this._searchDirection);
        IQModelImplUtilities.setAttr(thisElement, "memberLevelRoot", this._memberLevelRoot);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._searchDirection = attrsProvider.consumeAttrAndInternResult("timeSearchDir");
        String periods = attrsProvider.consumeAttr("timeNPeriods");
        if (periods != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(2);
            constant.setValue(periods);
            this._periods = constant;
        }
        this._memberLevelRoot = attrsProvider.consumeAttr("memberLevelRoot");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        AbstractBase periods = riHolder.consumeObject("Periods");
        if (periods != null) {
            this._periods = (ExpressionInterface)((Object)periods);
        }
    }

    @SASScope
    protected void fixMemberTuples() throws MetadataException {
        this.buildMemberTuples(((DataItem)this.getWhatToCompare()).getBusinessModel());
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._searchDirection = IQModelImplUtilities.getAttrAndInternResult(thisElement, "timeSearchDir");
        String periods = IQModelImplUtilities.getAttr(thisElement, "timeNPeriods");
        if (periods != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(2);
            constant.setValue(periods);
            this._periods = constant;
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        TimeFilterExpression clone = (TimeFilterExpression)super.clone();
        clone._periods = TimeFilterExpression.cloneReferencedExpression(this._periods);
        clone._searchDirection = this._searchDirection;
        return clone;
    }

    @SASScope
    public String toString() {
        String result = null;
        try {
            result = StringExpressionUtil.getInstance().getReadableText(this);
        }
        catch (MetadataException me) {
            result = "(" + Utils.toString(this.getWhatToCompare()) + " Number of Periods: " + this._periods + " with direction of " + Utils.toString(this._searchDirection) + ")";
            _logger.debug("Exception getting readable text for TimeFilterExpression", (Throwable)me);
        }
        return result;
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        int expType;
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._searchDirection == null) {
            reasons.add(new Reason((Object)this, 2, 102, "DataItemTimeFilterBadSearchDirection.txt", new Object[0]));
        }
        if (!this._searchDirection.equals(FORWARD) && !this._searchDirection.equals(BACKWARD)) {
            reasons.add(new Reason((Object)this, 2, 102, "DataItemTimeFilterBadSearchDirection.txt", new Object[0]));
        }
        if (this._periods != null && (expType = this._periods.getExpressionType()) != 2) {
            Reason reason = new Reason((Object)this, 2, 226, "DataItemTimeFilter.InvalidPeriodExpressionType.txt", new Object[0]);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (this._periods instanceof Prompt) {
            if (!ExpressionUtil.isSingleSelectionPrompt((Prompt)this._periods)) {
                Reason notSingleSelectionPrompt = new Reason((Object)this, 8, 225, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, this._periods);
                reasons.add(notSingleSelectionPrompt);
            }
            if (this._periods.getExpressionType() != 2) {
                Reason notCharacter = new Reason((Object)this, 8, 225, "Expression.OnlyNumericPromptsAreSupported.fmt.txt", this, this._periods);
                reasons.add(notCharacter);
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._periods instanceof AbstractModelItem) {
            intoList.add(this._periods);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._periods = (ExpressionInterface)TimeFilterExpression.replace(this._periods, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        super.replaceDirectReferencesDuringResourceReplacement(oldObject, newObject);
        if (newObject instanceof PhysicalResource && ((PhysicalResource)newObject).isUnresolved()) {
            return;
        }
        if (BusinessQueryOLAPUtil.shouldReplaceStringInFilter(this.getWhatToCompare(), newObject) && !BusinessQueryOLAPUtil.isPersistencePath(oldObject, newObject)) {
            Hierarchy hierarchy;
            ExpressionInterface hierarchyOfDataItem;
            ExpressionInterface whatToCompare = this.getWhatToCompare();
            if (whatToCompare instanceof DataItem && (hierarchyOfDataItem = ((DataItem)whatToCompare).getExpression()) instanceof Hierarchy && (hierarchy = (Hierarchy)hierarchyOfDataItem) != null && hierarchy.isUnresolved()) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQMetadataResourceBundle.getStringResource("TimeFilterExpressionHierarchNotResolved.txt"));
                }
                return;
            }
            boolean queryForLevelRoot = false;
            if (this instanceof TimeFilterNPeriodsExpression) {
                if (((TimeFilterNPeriodsExpression)this).getDate() != null) {
                    queryForLevelRoot = true;
                }
            } else if (this instanceof TimeFilterNParallelPeriodsExpression && ((TimeFilterNParallelPeriodsExpression)this).getDate() != null) {
                queryForLevelRoot = true;
            }
            if (queryForLevelRoot) {
                ExpressionInterface objectWhat = this.getWhatToCompare();
                if (objectWhat instanceof DataItem) {
                    try {
                        this.buildMemberTuples(((DataItem)objectWhat).getBusinessModel());
                    }
                    catch (MetadataException me) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error("Member definition: " + ((DataItem)objectWhat).getLabel() + " is not valid based on " + me.getLocalizedMessage());
                        }
                    }
                }
            } else {
                ConstantExpression conExp = BusinessQueryOLAPUtil.convertStringIntoExpression(this._memberLevelRoot);
                BusinessQueryOLAPUtil.replaceHierarchyInFilter(conExp, this.getWhatToCompare(), newObject);
                MDXGenerationUtil.applyDebugStatement("Lowest common level replaced from " + this._memberLevelRoot + " to " + conExp.getValue(), this.getClass());
                this._memberLevelRoot = conExp.getValue();
            }
        }
        if (this._memberLevelRoot == null && _logger.isEnabled(Level.ERROR)) {
            _logger.error(IQMetadataResourceBundle.getStringResource("TimeFilterExpressionNoFilter.txt"));
        }
    }
}

