/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberTuple;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class MemberFilterExpression
extends BaseFilterExpression {
    private Locale _memberLocale = null;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_MEMBER_NAMES_CHANGED = "Member names changed";
    private List _memberNames = ListUtils.newList(5);
    private boolean _areThereOrphans = false;
    private boolean _orphansToBeFixed = true;
    private String _memberLevelRoot = null;
    private List _memberTuples = new ArrayList();
    private boolean _isByGroup = false;
    private static final Logger _logger = LogManager.getLogger(MemberFilterExpression.class);

    @SASScope(value="ALL")
    @SubjectToChange
    public void setMemberNames(List<? extends ExpressionInterface> values) {
        try {
            this.setMemberNames(values, null);
        }
        catch (MetadataException me) {
            _logger.debug("Metadata Exception was encountered during a call to setMemberName passing null for dataItem");
        }
    }

    @SASScope
    public void setMemberNames(List<? extends ExpressionInterface> values, DataItem dataItem) throws MetadataException {
        this.setMemberNames(values, dataItem, null);
    }

    private Locale determineMemberLocale(ExpressionInterface expression) {
        Locale returnLocale = LocaleUtilities.getDefaultComputationalLocale();
        if (expression instanceof DataItem) {
            DataItem da = (DataItem)expression;
            BusinessModel model = da.getBusinessModel();
            returnLocale = LocaleUtilities.getDefaultViewerLocale(model);
        }
        return returnLocale;
    }

    @SASScope
    public void setMemberNames(List<? extends ExpressionInterface> values, DataItem dataItem, Locale locale) throws MetadataException {
        values = ListUtils.newList(values);
        IQModelImplUtilities.ensureProperArgumentTypes(values, VALID_TYPES_ANY_EXPRESSION);
        if (locale == null) {
            ExpressionInterface expression = this.getWhatToCompare();
            locale = this.determineMemberLocale(expression);
        }
        this._memberLocale = locale;
        this.moveListeningTo(this._memberNames, values);
        this._memberNames.clear();
        this._memberNames.addAll(values);
        if (dataItem != null) {
            this.buildMemberTuples((List<? extends ExpressionInterface>)this._memberNames, dataItem);
        }
        this.fireChangeEvent(EVENT_MEMBER_NAMES_CHANGED);
    }

    private void setFilterTupleList(List memberTuples) {
        this._memberTuples = memberTuples;
    }

    @SASScope
    public List getFilterTupleList() {
        return this._memberTuples;
    }

    @SASScope
    protected void buildMemberTuples(List<? extends ExpressionInterface> memberNames, DataItem dataItem) throws MetadataException {
        if (!this._isByGroup) {
            this.buildMemberTuples(memberNames, dataItem.getBusinessModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected void buildMemberTuples(List<? extends ExpressionInterface> memberNames, BusinessModel model) throws MetadataException {
        if (this.isNegated() || this.getResources(Prompt.class, 65535).size() > 0) {
            _logger.debug("No member tuples are built, this is only built if there is EQ expression, it does not contain prompts");
            return;
        }
        ArrayList<String> memberTrimStrings = new ArrayList<String>();
        try {
            OLAPServerUtilities olapServerUtil = OLAPServerUtilities.getInstance();
            try (OLAPDataSet olapDataSet = null;){
                olapDataSet = MDXGenerationUtil.buildResultSet(memberNames, model, memberTrimStrings, this.getMemberLocale());
                if (olapDataSet == null) {
                    MDXGenerationUtil.applyDebugStatement("No olapdataSet was constructed for building a filter tuple list. This is reasonable because the memberFilter could be all prompts." + memberNames, this.getClass());
                    return;
                }
                List<MemberTuple> returnList = olapServerUtil.getFilterTupleList((OLAPDataSetInterface)olapDataSet, memberTrimStrings, false);
                this._memberLevelRoot = olapServerUtil.getFilterTupleAncestor();
                this._areThereOrphans = olapServerUtil.isFilterMemberNamesOrphaned();
                this.setFilterTupleList(returnList);
            }
        }
        catch (GenerationException ge) {
            Object[] msgArgs2 = new Object[]{ge.getLocalizedMessage(), IQMetadataResourceBundle.getStringResource("MemberFitlerExpressionGenerationExcp.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            MetadataException e = new MetadataException((MessageFormatter)msF, (Throwable)ge);
            throw e;
        }
        catch (OLAPException e) {
            _logger.debug("Error while closing the OlapDataSet, just continue: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getMemberLevelRoot() {
        return this._memberLevelRoot;
    }

    @SASScope
    public boolean isOrphanMembersInFilterFixed() {
        return this._orphansToBeFixed;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean containsOrphans() {
        return this._areThereOrphans;
    }

    @SASScope
    public void fixOrphanMembers(boolean orphansToBeFixed) {
        this._orphansToBeFixed = orphansToBeFixed;
    }

    @SASScope
    public List getMemberNames(boolean isByGroup) {
        this._isByGroup = isByGroup;
        if (isByGroup) {
            return ListUtils.newList(this._memberNames);
        }
        return this.getMemberNames();
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<ExpressionInterface> getMemberNames() {
        if (!this.isNegated() && this.getResources(Prompt.class, 65535).size() == 0 && this._memberNames.size() > 0 && this._memberTuples.size() == 0) {
            try {
                this.fixMemberTuples();
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        } else {
            _logger.debug("No MemberTuple created because expression is either defined as NOT EQ or memberName are prompts");
        }
        return ListUtils.newList(this._memberNames);
    }

    @SASScope
    protected void fixMemberTuples() throws MetadataException {
        this.buildMemberTuples((List<? extends ExpressionInterface>)this._memberNames, (DataItem)this.getWhatToCompare());
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        super.replaceResource(oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        MemberFilterExpression clone = (MemberFilterExpression)super.clone();
        List<ExpressionInterface> newMemberNamesList = Utils.cloneExpressionList(this._memberNames, false);
        clone.setMemberNames(newMemberNamesList);
        clone._memberNames = new ArrayList(this._memberNames);
        return clone;
    }

    @SASScope
    public String toString() {
        return "(" + IQModelImplUtilities.toString(this.getWhatToCompare()) + (this.isNegated() ? " NOT IN (" : " IN (") + IQModelImplUtilities.toString(this._memberNames) + "))";
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._memberNames == null || this._memberNames.contains(null)) {
            reasons.add(new Reason((Object)this, 2, 32, "Expression.ReferencesNullSubexpression.txt", new Object[0]));
        } else if (this._memberNames.size() == 0) {
            reasons.add(new Reason((Object)this, 2, 56, "MemberFilterExpression.HasEmptyMemberNameList.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (this._memberNames != null && !this._memberNames.isEmpty()) {
            for (Object comparisonObj : this._memberNames) {
                Prompt iqPrompt;
                if (!(comparisonObj instanceof Prompt) || !ExpressionUtil.isRangePrompt(iqPrompt = (Prompt)comparisonObj) && iqPrompt.getExpressionType() == 3) continue;
                Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidMultiSelectOlapMemberPrompt.fmt.txt", this, iqPrompt);
                reasons.add(reason);
            }
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "MemberFilterExpr";
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        MemberFilterExpression.writeRelatedObjects(this._memberNames, thisElement, writingContext, "MemberNames");
        if (this._isByGroup) {
            return;
        }
        if (this._memberLevelRoot != null) {
            MemberFilterExpression.writeRelatedObjects(this._memberTuples, thisElement, writingContext, "MemberInfoSnapshot");
            IQModelImplUtilities.setBooleanAttr(thisElement, "isOrphansFixed", this._orphansToBeFixed, true);
            IQModelImplUtilities.setBooleanAttr(thisElement, "isOrphan", this._areThereOrphans, false);
        }
        IQModelImplUtilities.setAttr(thisElement, "memberLevelRoot", this._memberLevelRoot);
        if (this._memberLocale != null) {
            DataItem ditem;
            Locale modelLocale;
            ExpressionInterface expression = this.getWhatToCompare();
            if (expression instanceof DataItem && (modelLocale = (ditem = (DataItem)expression).getBusinessModel().getComputationalLocale()) != null && this._memberLocale.equals(modelLocale)) {
                return;
            }
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._memberNames = riHolder.consumeObjects("MemberNames", ExpressionInterface.class);
        if (this._isByGroup) {
            return;
        }
        this._memberTuples = riHolder.consumeObjects("MemberInfoSnapshot", MemberTuple.class);
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
        if (this._memberLocale == null) {
            this._memberLocale = this.determineMemberLocale(this.getWhatToCompare());
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        if (this._isByGroup) {
            return;
        }
        this._orphansToBeFixed = attrsProvider.consumeBooleanAttr("isOrphansFixed", true);
        this._memberLevelRoot = attrsProvider.consumeAttr("memberLevelRoot");
        this._areThereOrphans = attrsProvider.consumeBooleanAttr("isOrphan", false);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._memberNames = MemberFilterExpression.v1_readItemListUnderSubelement(thisElement, readingContext, "MemberNamesList", VALID_TYPES_ANY_EXPRESSION);
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._memberNames != null) {
            intoList.addAll(this._memberNames);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
    }

    @Override
    @SASScope
    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        super.replaceDirectReferencesDuringResourceReplacement(oldObject, newObject);
        if (newObject instanceof PhysicalResource && ((PhysicalResource)newObject).isUnresolved()) {
            return;
        }
        if (newObject instanceof Hierarchy || newObject instanceof Dimension) {
            if (BusinessQueryOLAPUtil.isPersistencePath(oldObject, newObject)) {
                return;
            }
            boolean continueWithReplace = this.getToLookBackReplace();
            if (continueWithReplace) {
                continueWithReplace = BusinessQueryOLAPUtil.shouldReplaceStringInFilter(this.getWhatToCompare(), newObject);
            }
            if (!continueWithReplace) {
                return;
            }
        }
        int ct = 0;
        boolean memberNamesContainsPrompts = false;
        for (Object member : this._memberNames) {
            if (member instanceof StringExpression) {
                StringExpression memExp = (StringExpression)member;
                try {
                    String prevmem = memExp.getText();
                    if (newObject instanceof Hierarchy) {
                        if (((Hierarchy)newObject).isUnresolved()) {
                            return;
                        }
                        BusinessQueryOLAPUtil.replaceHierarchyInString(memExp, newObject);
                    } else if (newObject instanceof Dimension) {
                        if (((Dimension)newObject).isUnresolved()) {
                            return;
                        }
                        BusinessQueryOLAPUtil.replaceDimensionInString(memExp, newObject);
                    }
                    this._memberNames.set(ct, memExp);
                    MDXGenerationUtil.applyDebugStatement("Element in the member list of this filter has been replaced from " + prevmem + " to " + memExp, this.getClass());
                    ++ct;
                }
                catch (MetadataException me) {
                    if (!_logger.isEnabled(Level.ERROR)) continue;
                    Object[] msgArgs2 = new Object[]{me.getLocalizedMessage(), memExp.toString(), IQMetadataResourceBundle.getStringResource("MemberFilterExpressionMetadataExceptionFilter.txt")};
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    _logger.error(msF.toString());
                }
                continue;
            }
            if (!(member instanceof Prompt)) continue;
            memberNamesContainsPrompts = true;
        }
        ExpressionInterface expr = this.getWhatToCompare();
        if (expr instanceof DataItem) {
            block18: {
                try {
                    this.buildMemberTuples((List<? extends ExpressionInterface>)this._memberNames, (DataItem)expr);
                    MDXGenerationUtil.applyDebugStatement("Replaced member list has been validated.", this.getClass());
                }
                catch (MetadataException me) {
                    if (!_logger.isEnabled(Level.ERROR)) break block18;
                    _logger.error(me.getLocalizedMessage());
                    _logger.error(IQMetadataResourceBundle.getStringResource("MemberFilterExpressionMetadataExcReplacement.txt"));
                }
            }
            if (this._memberLevelRoot == null && !memberNamesContainsPrompts && _logger.isEnabled(Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("TimeFilterExpressionNoFilter.txt"));
            }
        }
    }
}

