/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.util.impl.AppliedFilter;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.storage.olap.MetadataInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public abstract class BaseFilterExpression
extends ConditionalExpression
implements BusinessModelResourceReferencer {
    @SubjectToChange
    public static final String EVENT_WHAT_TO_COMPARE_CHANGED = "What to compare changed";
    private ExpressionInterface _whatToCompare = null;
    private boolean _lookBackReplace = false;

    public void setWhatToCompare(ExpressionInterface expr) {
        this.changeableCheck();
        this.moveListeningTo(this._whatToCompare, expr);
        this._whatToCompare = expr;
        this.fireChangeEvent(EVENT_WHAT_TO_COMPARE_CHANGED);
    }

    public ExpressionInterface getWhatToCompare() {
        return this._whatToCompare;
    }

    public List<QualifiedLevel> getLevels(MetadataInterface metadata) {
        return new ArrayList<QualifiedLevel>();
    }

    public String getDisplayedText(MetadataInterface metadata, boolean applyPromptValues, Locale locale) {
        IQMetadataInterface iqMetadataInterface;
        BusinessModel businessModel;
        String returnValue = this.toString();
        if (metadata instanceof IQMetadataInterface && (businessModel = (iqMetadataInterface = (IQMetadataInterface)metadata).getRelatedBusinessModel()) instanceof DataSelection) {
            DataSelection ds = (DataSelection)businessModel;
            returnValue = AppliedFilter.getOLAPParentFilterDescription(ds, this, iqMetadataInterface, applyPromptValues, locale);
        }
        return returnValue;
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._whatToCompare = (ExpressionInterface)BaseFilterExpression.replace(this._whatToCompare, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._whatToCompare);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        ExpressionInterface expr;
        if (this._whatToCompare != null && (expr = this.singleReplaceResources(this._whatToCompare, oldResource, newResource, model, recursive)) != this._whatToCompare) {
            this.setWhatToCompare(expr);
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        BaseFilterExpression.writeRelatedObject(this._whatToCompare, thisElement, writingContext, "WhatToCompare");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._whatToCompare = (ExpressionInterface)((Object)riHolder.consumeObject("WhatToCompare"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._whatToCompare = (ExpressionInterface)((Object)BaseFilterExpression.v1_readItemUnderSubelement(thisElement, readingContext, "WhatToCompare", VALID_TYPES_ANY_EXPRESSION));
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        this.nullSubexpressionNotAllowed(reasons, this._whatToCompare, "MemberFilterExpressionInvalidExpressionNoLeftValue.txt");
        this.accumulateReasonsPromptsAreUnusable(reasons);
    }

    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        if (this._whatToCompare instanceof Prompt && !BaseFilterExpression.isValidOlapMemberPrompt((Prompt)this._whatToCompare)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidSingleSelectOlapMemberPrompt.fmt.txt", this, this._whatToCompare);
            reasons.add(reason);
        }
    }

    @SASScope
    public static boolean isValidOlapMemberPrompt(Prompt iqPrompt) {
        boolean result = true;
        if (!ExpressionUtil.isSingleSelectionPrompt(iqPrompt) || !BaseFilterExpression.isOLAPMemberNameDefinition(iqPrompt)) {
            result = false;
        }
        return result;
    }

    @SASScope
    public void setToLookBackReplace(boolean setting) {
        this._lookBackReplace = setting;
    }

    @SASScope
    public boolean getToLookBackReplace() {
        return this._lookBackReplace;
    }

    @SASScope
    protected static boolean isOLAPMemberNameDefinition(Prompt iqPrompt) {
        boolean result = false;
        PromptDefinitionInterface pDefinition = iqPrompt.getPromptDefinition();
        if (pDefinition instanceof OLAPMemberNameDefinitionInterface) {
            result = true;
        }
        return result;
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        BaseFilterExpression clone = (BaseFilterExpression)super.clone();
        if (!(this._whatToCompare instanceof BusinessModelResource) && this._whatToCompare != null) {
            clone.setWhatToCompare((ExpressionInterface)this._whatToCompare.clone());
        }
        return clone;
    }
}

