/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.Formatter;
import com.sas.iquery.metadata.expr.iqtextparser.FormatterExpressionizer;
import com.sas.iquery.metadata.expr.iqtextparser.FormatterFactory;
import com.sas.iquery.metadata.expr.iqtextparser.NodeFactory;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParser;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Table;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ParsedNodeUtil {
    public static Map<ParsedNode, ParsedNode> getReferences(ParsedNode node) {
        return ParsedNodeUtil.getReferences(node, null, new LinkedHashMap<ParsedNode, ParsedNode>());
    }

    private static LinkedHashMap<ParsedNode, ParsedNode> getReferences(ParsedNode node, ParsedNode parent, LinkedHashMap<ParsedNode, ParsedNode> refNodesToParents) {
        if (node != null) {
            ParsedNode[] children = node.getChildren();
            int type = node.getType();
            switch (type) {
                case 18: 
                case 19: 
                case 20: 
                case 32: 
                case 52: 
                case 327683: 
                case 327684: 
                case 327685: 
                case 327686: 
                case 327695: 
                case 327696: 
                case 327697: 
                case 327698: 
                case 327699: 
                case 327712: 
                case 327744: 
                case 327745: 
                case 327760: 
                case 0x500051: 
                case 0xFF0001: {
                    refNodesToParents.put(node, parent);
                    break;
                }
                default: {
                    if (children == null) break;
                    for (int i = 0; i < children.length; ++i) {
                        ParsedNode child = children[i];
                        if (child == null) continue;
                        ParsedNodeUtil.getReferences(child, node, refNodesToParents);
                    }
                }
            }
        }
        return refNodesToParents;
    }

    public static Map<ParsedNode, ParsedNode> getResourceReferences(ParsedNode node) {
        return ParsedNodeUtil.getResourceReferences(node, null, new LinkedHashMap<ParsedNode, ParsedNode>());
    }

    private static LinkedHashMap<ParsedNode, ParsedNode> getResourceReferences(ParsedNode node, ParsedNode parent, LinkedHashMap<ParsedNode, ParsedNode> resNodesToParents) {
        if (node != null) {
            ParsedNode[] children = node.getChildren();
            int type = node.getType();
            switch (type) {
                case 32: 
                case 327712: {
                    resNodesToParents.put(node, parent);
                    break;
                }
                default: {
                    if (children == null) break;
                    for (int i = 0; i < children.length; ++i) {
                        ParsedNode child = children[i];
                        if (child == null) continue;
                        ParsedNodeUtil.getResourceReferences(child, node, resNodesToParents);
                    }
                }
            }
        }
        return resNodesToParents;
    }

    static ParsedNode refactorResourceParents(NodeFactory nodeFactory, ParsedNode node, String leafNameTemplate, int startNameNum, Map<ParsedNode, ParsedNode> leaves) throws CloneNotSupportedException {
        ParsedNode clone = (ParsedNode)node.clone();
        Map<ParsedNode, ParsedNode> resourceRefs = ParsedNodeUtil.getResourceReferences(clone);
        int counter = 0;
        block0: for (Map.Entry<ParsedNode, ParsedNode> entry : resourceRefs.entrySet()) {
            ParsedNode resNode = entry.getKey();
            ParsedNode resParent = entry.getValue();
            if (resParent == null) {
                ParsedNode replaceChild = ParsedNodeUtil.createPlaceHolderAndMarker(nodeFactory, resNode, leafNameTemplate, startNameNum + counter, leaves);
                ++counter;
                clone = replaceChild;
                continue;
            }
            ParsedNode[] siblings = resParent.getChildren();
            if (siblings == null) continue;
            for (int i = 0; i < siblings.length; ++i) {
                ParsedNode sibling = siblings[i];
                if (sibling != resNode) continue;
                ParsedNode replaceChild = ParsedNodeUtil.createPlaceHolderAndMarker(nodeFactory, resNode, leafNameTemplate, startNameNum + counter, leaves);
                ++counter;
                siblings[i] = replaceChild;
                continue block0;
            }
        }
        return clone;
    }

    public static Map<ParsedNode, ParsedNode> getAggregateReferences(ParsedNode node) {
        return ParsedNodeUtil.getAggregateReferences(node, null, new LinkedHashMap<ParsedNode, ParsedNode>());
    }

    private static LinkedHashMap<ParsedNode, ParsedNode> getAggregateReferences(ParsedNode node, ParsedNode parent, LinkedHashMap<ParsedNode, ParsedNode> aggNodesToParents) {
        if (node != null) {
            ParsedNode[] children;
            if (ParsedNodeUtil.isAggFunction(node)) {
                aggNodesToParents.put(node, parent);
            }
            if ((children = node.getChildren()) != null) {
                for (int i = 0; i < children.length; ++i) {
                    ParsedNode child = children[i];
                    if (child == null) continue;
                    ParsedNodeUtil.getAggregateReferences(child, node, aggNodesToParents);
                }
            }
        }
        return aggNodesToParents;
    }

    public static boolean hasNestedAggFunctions(ParsedNode node) {
        ParsedNode[] children;
        boolean hasNestedAggFunctions = false;
        if (node != null && (children = node.getChildren()) != null) {
            for (int i = 0; i < children.length && !hasNestedAggFunctions; ++i) {
                ParsedNode child = children[i];
                if (ParsedNodeUtil.hasNestedAggFunctions(child)) {
                    hasNestedAggFunctions = true;
                    continue;
                }
                boolean isAgg = ParsedNodeUtil.isAggFunction(node);
                boolean containsAgg = ParsedNodeUtil.containsAggFunction(child);
                if (!isAgg || !containsAgg) continue;
                hasNestedAggFunctions = true;
            }
        }
        return hasNestedAggFunctions;
    }

    public static boolean containsAggFunction(ParsedNode node) {
        ParsedNode[] children;
        boolean containsAggFunction = false;
        if (node != null && (children = node.getChildren()) != null) {
            for (int i = 0; i < children.length && !containsAggFunction; ++i) {
                ParsedNode child = children[i];
                if (ParsedNodeUtil.isAggFunction(child)) {
                    containsAggFunction = true;
                    continue;
                }
                if (!ParsedNodeUtil.containsAggFunction(child)) continue;
                containsAggFunction = true;
            }
        }
        return containsAggFunction;
    }

    public static boolean isAggFunction(ParsedNode node) {
        boolean isAggFunction = false;
        if (node != null) {
            int type = node.getType();
            switch (type) {
                case 327690: 
                case 327691: 
                case 327692: {
                    isAggFunction = true;
                    break;
                }
            }
        }
        return isAggFunction;
    }

    public static ParsedNode refactorAggChildren(NodeFactory nodeFactory, ParsedNode node, String leafNameTemplate, int startNameNum, Map<ParsedNode, ParsedNode> leaves) throws CloneNotSupportedException {
        ParsedNode clone = (ParsedNode)node.clone();
        Map<ParsedNode, ParsedNode> aggregateRefs = ParsedNodeUtil.getAggregateReferences(clone);
        int counter = 0;
        for (Map.Entry<ParsedNode, ParsedNode> entry : aggregateRefs.entrySet()) {
            ParsedNode aggNode = entry.getKey();
            ParsedNode[] aggChildren = aggNode.getChildren();
            if (aggChildren == null) continue;
            for (int i = 0; i < aggChildren.length; ++i) {
                ParsedNode[] aggParms;
                ParsedNode aggChild = aggChildren[i];
                if (aggChild.getType() != 327682 || (aggParms = aggChild.getChildren()) == null) continue;
                for (int j = 0; j < aggParms.length; ++j) {
                    ParsedNode parm = aggParms[j];
                    ParsedNode replaceChild = ParsedNodeUtil.createPlaceHolderAndMarker(nodeFactory, parm, leafNameTemplate, startNameNum + counter, leaves);
                    ++counter;
                    aggParms[i] = replaceChild;
                }
            }
        }
        return clone;
    }

    public static ExpressionInterface newExpressionInterface(NodeFactory nodeFactory, ParsedNode node, BusinessModel model, ResourceScope allowedScope) throws MetadataException {
        FormatterExpressionizer iqFormatter = FormatterFactory.newExpressionInterfaceFormatter();
        ExpressionInterface expr = iqFormatter.newExpressionInterface(model, node, true, true, allowedScope);
        return expr;
    }

    public static List<Object> getFormattedParms(List<Object> parms, ParsedNode node, Formatter formatter, String childPrefixText, String childIndentText, boolean includeComments, int nested) {
        if (node != null) {
            Object[] keywords = node.getKeywords();
            if (keywords != null) {
                for (int i = 0; i < keywords.length; ++i) {
                    Object keyword = keywords[i];
                    String keywordAsString = String.valueOf(keyword);
                    parms.add(keywordAsString);
                }
            }
            ParsedNode[] children = node.getChildren();
            if (node.getChildren() != null) {
                for (int i = 0; i < children.length; ++i) {
                    ParsedNode childNode = children[i];
                    Object parm = childNode;
                    if (formatter != null) {
                        parm = formatter.format(childNode, childPrefixText, childIndentText, includeComments, nested + 1);
                    }
                    parms.add(parm);
                }
            }
        }
        return parms;
    }

    public static ParsedNode refactorAggParents(NodeFactory nodeFactory, ParsedNode node, String leafNameTemplate, int startNameNum, Map<ParsedNode, ParsedNode> leaves) throws CloneNotSupportedException {
        ParsedNode clone = (ParsedNode)node.clone();
        Map<ParsedNode, ParsedNode> aggregateRefs = ParsedNodeUtil.getAggregateReferences(clone);
        int counter = 0;
        for (Map.Entry<ParsedNode, ParsedNode> entry : aggregateRefs.entrySet()) {
            ParsedNode aggNode = entry.getKey();
            ParsedNode aggParent = entry.getValue();
            if (aggParent == null) {
                ParsedNode replaceAgg = ParsedNodeUtil.createPlaceHolderAndMarker(nodeFactory, aggNode, leafNameTemplate, startNameNum + counter, leaves);
                ++counter;
                clone = replaceAgg;
                continue;
            }
            ParsedNode[] aggSiblings = aggParent.getChildren();
            if (aggSiblings == null) continue;
            for (int i = 0; i < aggSiblings.length; ++i) {
                ParsedNode aggSibling = aggSiblings[i];
                if (aggSibling != aggNode) continue;
                ParsedNode replaceAgg = ParsedNodeUtil.createPlaceHolderAndMarker(nodeFactory, aggNode, leafNameTemplate, startNameNum + counter, leaves);
                ++counter;
                aggSiblings[i] = replaceAgg;
            }
        }
        return clone;
    }

    static ParsedNode createPlaceHolderAndMarker(NodeFactory nodeFactory, ParsedNode node, String leafNameTemplate, int nameNum, Map<ParsedNode, ParsedNode> markers) {
        String text = MessageFormat.format(leafNameTemplate, nameNum);
        ParsedNode placeholder = nodeFactory.newPlaceholderNode(text, node);
        ParsedNode marker = nodeFactory.newMarkerNode(text, node);
        if (markers != null) {
            markers.put(marker, placeholder);
        }
        return placeholder;
    }

    public static boolean replaceResources(ParsedNode[] nodes, BusinessModel model, DataSourceTable dsTable, NodeParser parser) throws MetadataException {
        StringExpressionUtil util = StringExpressionUtil.getInstance();
        HashMap<String, ParsedNode> dictionary = new HashMap<String, ParsedNode>();
        List<Column> columns = dsTable.getColumns();
        for (Column column : columns) {
            QualifiedColumn qColumn = (QualifiedColumn)column;
            String txtQColumn = util.getText(qColumn, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, model);
            ParsedNode pnQColumn = parser.parseCalculation(txtQColumn, false, false, false, false);
            Column pColumn = qColumn.getColumn();
            ParsedNodeUtil.addDefinition(dictionary, dsTable, pColumn, pnQColumn);
        }
        boolean replaced = false;
        for (int k = 0; k < nodes.length; ++k) {
            ParsedNode exprnode = nodes[k];
            Formatter textualizer = FormatterFactory.newRetextualizer();
            Map<ParsedNode, ParsedNode> childToParentMap = ParsedNodeUtil.getReferences(exprnode);
            for (Map.Entry<ParsedNode, ParsedNode> entry : childToParentMap.entrySet()) {
                ParsedNode replacement;
                ParsedNode resource = entry.getKey();
                ParsedNode parent = entry.getValue();
                String reTextKey = String.valueOf(textualizer.format(resource, null, null, true));
                if (reTextKey == null || (replacement = (ParsedNode)dictionary.get(reTextKey.toUpperCase())) == null) continue;
                if (parent == null) {
                    nodes[k] = replacement;
                    replaced = true;
                    continue;
                }
                ParsedNode[] children = parent.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] != resource) continue;
                    children[i] = replacement;
                    replaced = true;
                }
            }
        }
        return replaced;
    }

    private static void addDefinition(Map<String, ParsedNode> dictionary, Table physicalTable, Column physicalColumn, ParsedNode qualifiedColumn) {
        String tblDbmsName;
        String tblSasName;
        String colDbmsName;
        String colSasName;
        try {
            colSasName = physicalColumn.getSasName();
        }
        catch (MetadataException e) {
            colSasName = null;
        }
        try {
            colDbmsName = physicalColumn.getDbmsName();
        }
        catch (MetadataException e) {
            colDbmsName = null;
        }
        try {
            tblSasName = physicalTable.getSasName();
        }
        catch (MetadataException e) {
            tblSasName = null;
        }
        try {
            tblDbmsName = physicalTable.getDbmsName();
        }
        catch (MetadataException e) {
            tblDbmsName = null;
        }
        LinkedHashSet<String> colNames = new LinkedHashSet<String>();
        colNames.add(physicalColumn.getLabel().toUpperCase());
        if (colSasName != null && colSasName.length() > 0) {
            colNames.add(colSasName.toUpperCase());
        }
        if (colDbmsName != null && colDbmsName.length() > 0) {
            colNames.add(colDbmsName.toUpperCase());
        }
        LinkedHashSet<String> tblNames = new LinkedHashSet<String>();
        tblNames.add("");
        tblNames.add(physicalTable.getLabel().toUpperCase());
        if (tblSasName != null && tblSasName.length() > 0) {
            tblNames.add(tblSasName.toUpperCase());
        }
        if (tblDbmsName != null && tblDbmsName.length() > 0) {
            tblNames.add(tblDbmsName.toUpperCase());
        }
        for (String tableName : tblNames) {
            for (String columnName : colNames) {
                if (tableName.length() == 0) {
                    dictionary.put(columnName, qualifiedColumn);
                    continue;
                }
                dictionary.put(tableName + '.' + columnName, qualifiedColumn);
            }
        }
    }
}

