/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.metadata.expr.iqtextparser.AggregateDefinition;
import com.sas.iquery.metadata.expr.iqtextparser.Messages;
import com.sas.iquery.metadata.expr.iqtextparser.NodeFactory;
import com.sas.iquery.metadata.expr.iqtextparser.NodeLexer;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParser;
import com.sas.iquery.metadata.expr.iqtextparser.ParseError;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.Token;
import com.sas.iquery.metadata.expr.iqtextparser.TokenError;
import com.sas.iquery.metadata.expr.iqtextparser.Tokenizer;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class NodeParserImpl
implements NodeParser {
    private NodeFactory _nodeFactory;
    private static List<AggregateDefinition> _aggregateDefinitions = Collections.unmodifiableList(Arrays.asList(new AggregateDefinition("COUNT", 1, true, false), new AggregateDefinition("NMISS", 1, true, false), new AggregateDefinition("AVG", 1, true, true), new AggregateDefinition("SUM", 1, true, false), new AggregateDefinition("MAX", 1, true, false), new AggregateDefinition("MIN", 1, true, false), new AggregateDefinition("MEAN", 1, true, false), new AggregateDefinition("FREQ", 1, true, true), new AggregateDefinition("N", 1, true, false), new AggregateDefinition("CSS", 1, true, false), new AggregateDefinition("CV", 1, true, false), new AggregateDefinition("PRT", 1, true, true), new AggregateDefinition("RANGE", 1, true, false), new AggregateDefinition("STD", 1, true, false), new AggregateDefinition("STDERR", 1, true, false), new AggregateDefinition("SUMWGT", 1, true, true), new AggregateDefinition("T", 1, true, true), new AggregateDefinition("USS", 1, true, false), new AggregateDefinition("VAR", 1, true, false), new AggregateDefinition("FractionOfTotalExpression", 2, true, false), new AggregateDefinition("FractionOfTotalExpression", 3, false, true)));

    NodeParserImpl(NodeFactory nodeFactory) {
        this._nodeFactory = nodeFactory;
    }

    @Override
    public List<AggregateDefinition> getAggregateDefinitions() {
        return _aggregateDefinitions;
    }

    @Override
    public void setAggregateDefinitions(List<AggregateDefinition> aggregateDefinitions) {
        _aggregateDefinitions = aggregateDefinitions;
    }

    public ParseError parseerror(Tokenizer ts, String bundleName, String resourceKey) {
        Token token = ts.getToken();
        return this.parseerror(bundleName, resourceKey, new Object[]{ts.tokenizerStatus(token)});
    }

    @Override
    public ParseError parseerror(String bundleName, String messageKey, Object[] messageObjects) {
        return new ParseError(bundleName, messageKey, messageObjects);
    }

    @Override
    public ParsedNode parsePredicate(String text, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        Tokenizer tokenReader = this.newTokenizer(text, enableComments, enableTuples, enableSets, enableObjRefs);
        return this.parse_Condition(tokenReader);
    }

    @Override
    public ParsedNode parseCalculation(String text, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        Tokenizer tokenReader = this.newTokenizer(text, enableComments, enableTuples, enableSets, enableObjRefs);
        return this.parse_Expression(tokenReader);
    }

    @Override
    public ParsedNode parseFormat(String text, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        Tokenizer tokenReader = this.newTokenizer(text, enableComments, enableTuples, enableSets, enableObjRefs);
        return this.parse_FormatLiteral(tokenReader);
    }

    @Override
    public Tokenizer newTokenizer(String text, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        StringReader reader = new StringReader(text);
        return this.newTokenizer(reader, enableComments, enableTuples, enableSets, enableObjRefs);
    }

    @Override
    public ParsedNode parsePredicate(Reader reader, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        Tokenizer tokenReader = this.newTokenizer(reader, enableComments, enableTuples, enableSets, enableObjRefs);
        return this.parse_Condition(tokenReader);
    }

    @Override
    public ParsedNode parseCalculation(Reader reader, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        Tokenizer tokenReader = this.newTokenizer(reader, enableComments, enableTuples, enableSets, enableObjRefs);
        return this.parse_Expression(tokenReader);
    }

    @Override
    public ParsedNode parseFormat(Reader reader, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        Tokenizer tokenReader = this.newTokenizer(reader, enableComments, enableTuples, enableSets, enableObjRefs);
        return this.parse_FormatLiteral(tokenReader);
    }

    @Override
    public Tokenizer newTokenizer(Reader reader, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        return new NodeLexer(reader, enableComments, enableTuples, enableSets, enableObjRefs);
    }

    ParsedNode parse_Expression(Tokenizer ts) {
        ParsedNode ret = this.parse_ExpressionPhrase(ts);
        if (!ts.isEOF()) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Expression.HasUnparsedRemainder.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
        }
        return ret;
    }

    ParsedNode parse_Condition(Tokenizer ts) {
        ParsedNode ret = this.parse_PredicatePhrase(ts);
        if (!ts.isEOF()) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Condition.HasUnparsedRemainder.fmt.txt", new Object[]{ret, ts.tokenizerStatus(ts.getToken())});
        }
        return ret;
    }

    ParsedNode parse_PredicatePhrase(Tokenizer ts) {
        return this.parse_OrPredicate(ts);
    }

    ParsedNode parse_ExpressionPhrase(Tokenizer ts) {
        return this.parse_AddSub(ts);
    }

    ParsedNode parse_OrPredicate(Tokenizer ts) {
        ParsedNode jValue = this.parse_AndPredicate(ts);
        ParsedNode ret = this.parse_OrPredicateOpt(ts, jValue);
        return ret;
    }

    ParsedNode parse_OrPredicateOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        if (ts.getToken().getValue() == -308 || ts.getToken().getValue() == -122 || ts.getToken().getValue() == -121) {
            String operatorKeyword = ts.getToken().getString();
            ts.next();
            ParsedNode next = this.parse_AndPredicate(ts);
            ParsedNode current = this._nodeFactory.newOrPredicateNode(previous, operatorKeyword, next);
            ret = this.parse_OrPredicateOpt(ts, current);
        } else {
            ret = previous;
        }
        return ret;
    }

    ParsedNode parse_AndPredicate(Tokenizer ts) {
        ParsedNode commentedIValue = this.parse_NotWithComments(ts);
        ParsedNode ret = this.parse_AndPredicateOpt(ts, commentedIValue);
        return ret;
    }

    ParsedNode parse_AndPredicateOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        if (ts.getToken().getValue() == -307 || ts.getToken().getValue() == -130) {
            String operatorKeyword = ts.getToken().getString();
            ts.next();
            ParsedNode next = this.parse_NotWithComments(ts);
            ParsedNode current = this._nodeFactory.newAndPredicateNode(previous, operatorKeyword, next);
            ret = this.parse_AndPredicateOpt(ts, current);
        } else {
            ret = previous;
        }
        return ret;
    }

    ParsedNode parse_NotWithComments(Tokenizer ts) {
        ParsedNode preCommentedTermValue = this.parse_NotWithPrecomments(ts);
        return preCommentedTermValue;
    }

    ParsedNode parse_NotWithPrecomments(Tokenizer ts) {
        ParsedNode ret;
        switch (ts.getToken().getValue()) {
            case -403: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_NotWithPrecomments(ts);
                ret = this._nodeFactory.newPrefixCommentNode(2, "/*", textOfComment, "*/", valueFollowingComment);
                break;
            }
            case -407: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_NotWithPrecomments(ts);
                ret = this._nodeFactory.newPrefixCommentNode(5, "<!--", textOfComment, "-->", valueFollowingComment);
                break;
            }
            default: {
                ret = this.parse_Not(ts);
            }
        }
        return ret;
    }

    ParsedNode parse_NotWithPostcomments(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        switch (ts.getToken().getValue()) {
            case -403: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode commentedPrevious = this._nodeFactory.newSuffixCommentNode(3, previous, "/*", textOfComment, "*/");
                ret = this.parse_NotWithPostcomments(ts, commentedPrevious);
                break;
            }
            case -407: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode commentedPrevious = this._nodeFactory.newSuffixCommentNode(6, previous, "/*", textOfComment, "*/");
                ret = this.parse_NotWithPostcomments(ts, commentedPrevious);
                break;
            }
            default: {
                ret = previous;
            }
        }
        return ret;
    }

    ParsedNode parse_Not(Tokenizer ts) {
        ParsedNode ret;
        if (ts.getToken().getValue() == -306 || ts.getToken().getValue() == -150 || ts.getToken().getValue() == -151) {
            String notKeywordText = ts.getToken().getString();
            ts.next();
            ParsedNode negatedValue = this.parse_NotWithComments(ts);
            ret = this._nodeFactory.newSimpleLogicalNegationNode(notKeywordText, negatedValue);
        } else {
            ret = this.parse_SimpleCompare(ts);
        }
        return ret;
    }

    ParsedNode parse_SimpleCompare(Tokenizer ts) {
        ParsedNode eValue = this.parse_ComplexCompare(ts);
        ParsedNode ret = this.parse_SimpleCompareOpt(ts, eValue);
        return ret;
    }

    ParsedNode parse_SimpleCompareOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        int type;
        String compareKeyword = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -200: {
                type = 393217;
                break;
            }
            case -201: {
                type = 393218;
                break;
            }
            case -202: {
                type = 393219;
                break;
            }
            case -203: {
                type = 393220;
                break;
            }
            case -204: {
                type = 393221;
                break;
            }
            case -205: {
                type = 393222;
                break;
            }
            case -405: {
                type = this.getSasCompareWordsType(compareKeyword);
                if (type == -1) break;
                compareKeyword = ' ' + compareKeyword + ' ';
                break;
            }
            default: {
                type = -1;
            }
        }
        if (type == -1) {
            ret = previous;
        } else {
            ts.next();
            ParsedNode next = this.parse_ComplexCompare(ts);
            ParsedNode current = this._nodeFactory.newSimpleTwoOperandNode(type, previous, compareKeyword, next);
            ret = this.parse_SimpleCompareOpt(ts, current);
        }
        return ret;
    }

    private int getSasCompareWordsType(String compareKeyword) {
        String cmp = compareKeyword.trim().toLowerCase();
        int type = cmp.equals("eq") ? 393217 : (cmp.equals("ne") ? 393218 : (cmp.equals("lt") ? 393219 : (cmp.equals("le") ? 393220 : (cmp.equals("gt") ? 393221 : (cmp.equals("ge") ? 393222 : (cmp.equals("eqt") ? 393233 : (cmp.equals("net") ? 393234 : (cmp.equals("ltt") ? 393235 : (cmp.equals("let") ? 393236 : (cmp.equals("gtt") ? 393237 : (cmp.equals("get") ? 393238 : -1)))))))))));
        return type;
    }

    ParsedNode parse_ComplexCompare(Tokenizer ts) {
        ParsedNode eValue = this.parse_ExpressionPhrase(ts);
        ParsedNode ret = this.parse_ComplexCompareOpt(ts, eValue);
        return ret;
    }

    ParsedNode parse_ComplexCompareOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        String optNotText = null;
        boolean isNot = false;
        if (ts.getToken().getValue() == -300) {
            ret = this.parse_IsPredicate(ts, previous);
        } else {
            if (ts.getToken().getValue() == -306) {
                isNot = true;
                optNotText = ts.getToken().getString();
                ts.next();
            }
            switch (ts.getToken().getValue()) {
                case -303: {
                    ret = this.parse_InPredicate(ts, previous, isNot, optNotText);
                    break;
                }
                case -302: {
                    ret = this.parse_BetweenPredicate(ts, previous, isNot, optNotText);
                    break;
                }
                case -301: {
                    ret = this.parse_LikePredicate(ts, previous, isNot, optNotText);
                    break;
                }
                case -315: 
                case -140: {
                    ret = this.parse_ContainsPredicate(ts, previous, isNot, optNotText);
                    break;
                }
                default: {
                    if (isNot) {
                        if (isNot) {
                            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.NotComparison.KeywordNotValid.fmt.txt", new Object[]{previous, optNotText, ts.tokenizerStatus(ts.getToken())});
                        }
                        throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Comparison.KeywordNotValid.fmt.txt", new Object[]{previous, ts.tokenizerStatus(ts.getToken())});
                    }
                    ret = previous;
                }
            }
        }
        return ret;
    }

    ParsedNode parse_LikePredicate(Tokenizer ts, ParsedNode previous, boolean negated, String notKeyword) {
        String likeKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode patternValue = this.parse_ExpressionPhrase(ts);
        ParsedNode escapeValue = null;
        String escapeKeyword = null;
        if (ts.getToken().getValue() == -310) {
            escapeKeyword = ts.getToken().getString();
            ts.next();
            escapeValue = this.parse_ExpressionPhrase(ts);
        }
        ParsedNode ret = escapeValue == null ? (negated ? this._nodeFactory.newNotLikePredicate(previous, notKeyword, likeKeywordText, patternValue) : this._nodeFactory.newLikePredicate(previous, likeKeywordText, patternValue)) : (negated ? this._nodeFactory.newNotLikePredicate(previous, notKeyword, likeKeywordText, patternValue, escapeKeyword, escapeValue) : this._nodeFactory.newLikePredicate(previous, likeKeywordText, patternValue, escapeKeyword, escapeValue));
        return ret;
    }

    ParsedNode parse_ContainsPredicate(Tokenizer ts, ParsedNode previous, boolean negated, String notKeyword) {
        String containsKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode value = this.parse_ExpressionPhrase(ts);
        ParsedNode ret = negated ? this._nodeFactory.newNotContainsPredicate(previous, notKeyword, containsKeywordText, value) : this._nodeFactory.newContainsPredicate(previous, containsKeywordText, value);
        return ret;
    }

    ParsedNode parse_BetweenPredicate(Tokenizer ts, ParsedNode previous, boolean negated, String notKeyword) {
        String betweenKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode valueLeft = this.parse_ExpressionPhrase(ts);
        Token token = ts.getToken();
        if (token.getValue() != -307) {
            if (negated) {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.NotBetween.MissingAND.fmt.txt", new Object[]{previous, notKeyword, betweenKeywordText, valueLeft, ts.tokenizerStatus(token)});
            }
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Between.MissingAND.fmt.txt", new Object[]{previous, betweenKeywordText, valueLeft, ts.tokenizerStatus(token)});
        }
        String andKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode valueRight = this.parse_ExpressionPhrase(ts);
        ParsedNode ret = negated ? this._nodeFactory.newNotBetweenPredicate(previous, notKeyword, betweenKeywordText, valueLeft, andKeywordText, valueRight) : this._nodeFactory.newBetweenPredicate(previous, betweenKeywordText, valueLeft, andKeywordText, valueRight);
        return ret;
    }

    ParsedNode parse_InPredicate(Tokenizer ts, ParsedNode previous, boolean negated, String notKeyword) {
        ParsedNode ret;
        String inKeywordText = ts.getToken().getString();
        ts.next();
        switch (ts.getToken().getValue()) {
            case -101: {
                String startParenText = ts.getToken().getString();
                ts.next();
                ParsedNode valuesList = this.parse_CommaListWithComments(ts, -102, true, true, false);
                if (ts.getToken().getValue() != -102) {
                    if (negated) {
                        throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.NotInList.NoCloseParen.fmt.txt", new Object[]{previous, notKeyword, inKeywordText, valuesList, ts.tokenizerStatus(ts.getToken())});
                    }
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.InList.NoCloseParen.fmt.txt", new Object[]{previous, inKeywordText, valuesList, ts.tokenizerStatus(ts.getToken())});
                }
                String endParenText = ts.getToken().getString();
                ret = negated ? this._nodeFactory.newNotInValuesPredicate(previous, notKeyword, inKeywordText, startParenText, valuesList, endParenText) : this._nodeFactory.newInValuesPredicate(previous, inKeywordText, startParenText, valuesList, endParenText);
                int parmCount = this.countParms(valuesList);
                if (parmCount == 0) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.InList.EmptyList.fmt.txt", new Object[]{ret, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                break;
            }
            default: {
                if (negated) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.NotInList.NoOpenParen.fmt.txt", new Object[]{previous, notKeyword, inKeywordText, ts.tokenizerStatus(ts.getToken())});
                }
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.InList.NoOpenParen.fmt.txt", new Object[]{previous, inKeywordText, ts.tokenizerStatus(ts.getToken())});
            }
        }
        return ret;
    }

    ParsedNode parse_IsPredicate(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        String notKeywordText = null;
        boolean negated = false;
        String isKeywordText = ts.getToken().getString();
        ts.next();
        if (ts.getToken().getValue() == -306) {
            negated = true;
            notKeywordText = ts.getToken().getString();
            ts.next();
        }
        if (ts.getToken().getValue() != -309 || ts.getToken().getString().equalsIgnoreCase("MISSING")) {
            if (negated) {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.IsNot.MissingNULL.fmt.txt", new Object[]{previous, isKeywordText, notKeywordText, ts.tokenizerStatus(ts.getToken())});
            }
            if (!ts.isObjRefsSupportEnabled()) {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Is.MissingNULL.fmt.txt", new Object[]{previous, isKeywordText, ts.tokenizerStatus(ts.getToken())});
            }
            ParsedNode rightValue = this.parse_ExpressionPhrase(ts);
            ret = this._nodeFactory.newIsPredicate(previous, isKeywordText, rightValue);
        } else {
            ParsedNode wordValue = this._nodeFactory.newWord(ts.getToken().getString());
            ts.next();
            ret = negated ? this._nodeFactory.newIsPredicate(previous, isKeywordText, notKeywordText, wordValue) : this._nodeFactory.newIsPredicate(previous, isKeywordText, wordValue);
        }
        return ret;
    }

    ParsedNode parse_AddSub(Tokenizer ts) {
        ParsedNode dValue = this.parse_MultDivCat(ts);
        ParsedNode ret = this.parse_AddSubOpt(ts, dValue);
        return ret;
    }

    ParsedNode parse_AddSubOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        int type;
        String operatorKeyword = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -110: {
                type = 262145;
                break;
            }
            case -111: {
                type = 262146;
                break;
            }
            case -120: {
                type = 262147;
                break;
            }
            default: {
                type = -1;
            }
        }
        if (type == -1) {
            ret = previous;
        } else {
            ts.next();
            ParsedNode next = this.parse_MultDivCat(ts);
            ParsedNode current = this._nodeFactory.newSimpleTwoOperandNode(type, previous, operatorKeyword, next);
            ret = this.parse_AddSubOpt(ts, current);
        }
        return ret;
    }

    ParsedNode parse_MultDivCat(Tokenizer ts) {
        ParsedNode cValue = this.parse_UnaryWithComments(ts);
        ParsedNode ret = this.parse_MultDivCatOpt(ts, cValue);
        return ret;
    }

    ParsedNode parse_MultDivCatOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        int type;
        String operatorKeyword = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -113: {
                type = 196609;
                break;
            }
            case -112: {
                type = 196610;
                break;
            }
            case -114: {
                type = 196611;
                break;
            }
            default: {
                type = -1;
            }
        }
        if (type == -1) {
            ret = previous;
        } else {
            ts.next();
            ParsedNode next = this.parse_UnaryWithComments(ts);
            ParsedNode current = this._nodeFactory.newSimpleTwoOperandNode(type, previous, operatorKeyword, next);
            ret = this.parse_MultDivCatOpt(ts, current);
        }
        return ret;
    }

    ParsedNode parse_UnaryWithComments(Tokenizer ts) {
        ParsedNode preCommentedTermValue = this.parse_UnaryWithPrecomments(ts);
        ParsedNode postCommentedTermValue = this.parse_UnaryWithPostcomments(ts, preCommentedTermValue);
        return postCommentedTermValue;
    }

    ParsedNode parse_UnaryWithPrecomments(Tokenizer ts) {
        ParsedNode ret;
        switch (ts.getToken().getValue()) {
            case -403: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_UnaryWithPrecomments(ts);
                ret = this._nodeFactory.newPrefixCommentNode(2, "/*", textOfComment, "*/", valueFollowingComment);
                break;
            }
            case -407: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_UnaryWithPrecomments(ts);
                ret = this._nodeFactory.newPrefixCommentNode(5, "<!--", textOfComment, "-->", valueFollowingComment);
                break;
            }
            default: {
                ret = this.parse_Unary(ts);
            }
        }
        return ret;
    }

    ParsedNode parse_UnaryWithPostcomments(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        switch (ts.getToken().getValue()) {
            case -403: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode commentedPrevious = this._nodeFactory.newSuffixCommentNode(3, previous, "/*", textOfComment, "*/");
                ret = this.parse_UnaryWithPostcomments(ts, commentedPrevious);
                break;
            }
            case -407: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode commentedPrevious = this._nodeFactory.newSuffixCommentNode(6, previous, "<!--", textOfComment, "-->");
                ret = this.parse_UnaryWithPostcomments(ts, commentedPrevious);
                break;
            }
            default: {
                ret = previous;
            }
        }
        return ret;
    }

    ParsedNode parse_Unary(Tokenizer ts) {
        ParsedNode ret;
        int type;
        String operatorText = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -110: {
                type = 65537;
                break;
            }
            case -111: {
                type = 65538;
                break;
            }
            default: {
                type = -1;
            }
        }
        if (type == -1) {
            ret = this.parse_Exponent(ts);
        } else {
            ts.next();
            ParsedNode operandValue = this.parse_Exponent(ts);
            ret = this._nodeFactory.newSimplePrefixOperandNode(type, operatorText, operandValue);
        }
        return ret;
    }

    ParsedNode parse_Exponent(Tokenizer ts) {
        ParsedNode bValue = this.parse_TypeCast(ts);
        ParsedNode ret = this.parse_ExponentOpt(ts, bValue);
        return ret;
    }

    ParsedNode parse_ExponentOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        int type;
        String operatorKeyword = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -116: {
                type = 131074;
                break;
            }
            default: {
                type = -1;
            }
        }
        if (type == -1) {
            ret = previous;
        } else {
            ts.next();
            ParsedNode next = this.parse_UnaryWithComments(ts);
            ParsedNode current = this._nodeFactory.newSimpleTwoOperandNode(type, previous, operatorKeyword, next);
            ret = this.parse_ExponentOpt(ts, current);
        }
        return ret;
    }

    ParsedNode parse_TypeCast(Tokenizer ts) {
        ParsedNode leftValue;
        String resourceTypeCastOperator = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -340: {
                ts.next();
                leftValue = this._nodeFactory.newResourceQualifier(327714, resourceTypeCastOperator);
                break;
            }
            case -341: {
                ts.next();
                leftValue = this._nodeFactory.newResourceQualifier(327713, resourceTypeCastOperator);
                break;
            }
            default: {
                leftValue = this.parse_CommentBeforeTerm(ts);
            }
        }
        ParsedNode ret = this.parse_TypeCastOpt(ts, leftValue);
        return ret;
    }

    ParsedNode parse_TypeCastOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        String operatorText = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -104: {
                ts.next();
                if (ts.getToken().getValue() == -500) {
                    ParsedNode resourceName = this.parse_ResourceName(ts);
                    int typeModifier = previous.getType();
                    if (typeModifier == 327714 || typeModifier == 327713) {
                        ParsedNode resource = this._nodeFactory.newQualifiedResource(previous, operatorText, resourceName);
                        ParsedNode withMemberOperations = this.parse_MemberOpt(ts, resource);
                        ret = this.parse_TypeCastOpt(ts, withMemberOperations);
                        break;
                    }
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.TypeCast.ResourceQualifierMissing.fmt.txt", new Object[]{previous, resourceName, ts.tokenizerStatus(ts.getToken())});
                }
                ParsedNode dataType = this.parse_DataTypeLiteral(ts);
                ParsedNode current = this._nodeFactory.newTypeCastOperator(previous, operatorText, dataType);
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.TypeCast.UnsupportedResourceQualifier.fmt.txt", new Object[]{current, ts.tokenizerStatus(ts.getToken())});
            }
            default: {
                ret = previous;
            }
        }
        return ret;
    }

    private ParsedNode parse_MemberOpt(Tokenizer ts, ParsedNode previous) {
        ParsedNode ret;
        if (ts.isObjRefsSupportEnabled() && ts.getToken().getValue() == -105) {
            String operationText = ts.getToken().getString();
            ts.next();
            Token token = ts.getToken();
            switch (token.getValue()) {
                case -405: {
                    ParsedNode resourceProp = this._nodeFactory.newWord(ts.getToken().getString());
                    ts.next();
                    ret = this._nodeFactory.newMemberOperation(previous, operationText, resourceProp);
                    break;
                }
                case -404: {
                    ParsedNode resourceProp = this.parse_FunctionName(ts);
                    ret = this._nodeFactory.newMemberOperation(previous, operationText, resourceProp);
                    break;
                }
                default: {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Resource.InvalidMemberReference.fmt.txt", new Object[]{token, ts.tokenizerStatus(token)});
                }
            }
            if (ts.getToken().getValue() == -105) {
                ret = this.parse_MemberOpt(ts, ret);
            }
        } else {
            ret = previous;
        }
        return ret;
    }

    ParsedNode parse_CommentBeforeTerm(Tokenizer ts) {
        ParsedNode ret;
        switch (ts.getToken().getValue()) {
            case -403: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_CommentBeforeTerm(ts);
                ret = this._nodeFactory.newPrefixCommentNode(2, "/*", textOfComment, "*/", valueFollowingComment);
                break;
            }
            case -407: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_CommentBeforeTerm(ts);
                ret = this._nodeFactory.newPrefixCommentNode(5, "<!--", textOfComment, "-->", valueFollowingComment);
                break;
            }
            default: {
                ret = this.parse_Term(ts);
            }
        }
        return ret;
    }

    ParsedNode parse_Term(Tokenizer ts) {
        ParsedNode ret;
        switch (ts.getToken().getValue()) {
            case -101: {
                ret = this.parse_MemberOpt(ts, this.parse_NestedExpression(ts));
                break;
            }
            case -316: {
                ret = this.parse_InputFunction(ts);
                break;
            }
            case -314: {
                ret = this.parse_PutFunction(ts);
                break;
            }
            case -320: {
                ret = this.parse_CaseExpression(ts);
                break;
            }
            case -330: {
                ret = this.parse_MemberOpt(ts, this.parse_CastFunction(ts));
                break;
            }
            case -406: {
                ret = this._nodeFactory.newNumber(ts.getToken().getNumber());
                ts.next();
                break;
            }
            case -405: {
                ret = this.parse_NumericWord(ts, false);
                if (ret != null) break;
                ParsedNode startReferenceName = this._nodeFactory.newReferenceName(ts.getToken().getString());
                ts.next();
                ret = this.parse_ReferenceNameList(ts, startReferenceName);
                break;
            }
            case -404: {
                ret = this.parse_MemberOpt(ts, this.parse_FunctionName(ts));
                break;
            }
            case -500: {
                ret = this.parse_MemberOpt(ts, this.parse_ResourceName(ts));
                break;
            }
            case -600: {
                ret = this.parse_TupleNameList(ts);
                break;
            }
            case -401: {
                StringBuffer dqText = new StringBuffer(ts.getToken().getString());
                ts.next();
                while (ts.getToken().getValue() == -401) {
                    dqText.append("\"\"").append(ts.getToken().getString());
                    ts.next();
                }
                ParsedNode doubleQuoteNode = this._nodeFactory.newQuotedText(327684, "\"", dqText.toString());
                ret = this.parse_Literal(ts, doubleQuoteNode);
                break;
            }
            case -402: {
                StringBuffer sqText = new StringBuffer(ts.getToken().getString());
                ts.next();
                while (ts.getToken().getValue() == -402) {
                    sqText.append("''").append(ts.getToken().getString());
                    ts.next();
                }
                ParsedNode singleQuoteNode = this._nodeFactory.newQuotedText(327685, "'", sqText.toString());
                ret = this.parse_Literal(ts, singleQuoteNode);
                break;
            }
            case -113: {
                ret = this._nodeFactory.newAllColumn(ts.getToken().getString());
                ts.next();
                break;
            }
            case -309: {
                ret = this._nodeFactory.newWord(ts.getToken().getString());
                ts.next();
                break;
            }
            case -105: {
                StringBuffer missingValueText = new StringBuffer(ts.getToken().getString());
                ts.next();
                if (ts.getToken() != null) {
                    char ch;
                    int nextValue = ts.getToken().getValue();
                    String nextText = ts.getToken().getString();
                    if (nextValue == -405 && nextText != null && nextText.length() == 1 && (Character.isLetter(ch = nextText.charAt(0)) || ch == '_')) {
                        missingValueText.append(ch);
                        ts.next();
                    }
                }
                ret = this._nodeFactory.newWord(missingValueText.toString());
                break;
            }
            case -304: {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Exists.NotSupported.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
            }
            case -106: {
                if (ts.isSetsSupportEnabled()) {
                    ret = this.parse_MemberOpt(ts, this.parse_SetOfExpressions(ts));
                    break;
                }
            }
            default: {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.MissingExpressionTerm.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
            }
        }
        return ret;
    }

    ParsedNode parse_ResourceName(Tokenizer ts) {
        String resourceText = ts.getToken().getString();
        ts.next();
        ParsedNode ret = this._nodeFactory.newResource("<<", resourceText, ">>");
        return ret;
    }

    ParsedNode parse_Literal(Tokenizer ts, ParsedNode quoteNode) {
        ParsedNode ret;
        String literalTypeKeywordText = ts.getToken().getString();
        if (ts.getToken().getValue() == -405 && literalTypeKeywordText.equalsIgnoreCase("n")) {
            ParsedNode nameLiteral = this.parse_NameLiteral(ts, quoteNode);
            ret = this.parse_ReferenceNameList(ts, nameLiteral);
        } else {
            ret = this.parse_QuotedLiteral(ts, quoteNode);
        }
        return ret;
    }

    ParsedNode parse_NameLiteral(Tokenizer ts, ParsedNode quoteNode) {
        String literalTypeKeywordText = ts.getToken().getString();
        if (ts.getToken().getValue() != -405 || !literalTypeKeywordText.equalsIgnoreCase("n")) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.NamedLiteral.MissingLiteral.fmt.txt", new Object[]{quoteNode, literalTypeKeywordText, ts.tokenizerStatus(ts.getToken())});
        }
        ts.next();
        ParsedNode ret = this._nodeFactory.newQuotedLiteral(327696, literalTypeKeywordText, quoteNode);
        return ret;
    }

    ParsedNode parse_ReferenceNameList(Tokenizer ts, ParsedNode previous) {
        ArrayList<ParsedNode> referenceNameList = new ArrayList<ParsedNode>();
        referenceNameList.add(previous);
        Token token = ts.getToken();
        boolean starTerminated = false;
        while (token.getValue() == -105 && !starTerminated) {
            ParsedNode nextTerm;
            ts.next();
            token = ts.getToken();
            switch (token.getValue()) {
                case -405: {
                    nextTerm = this._nodeFactory.newReferenceName(ts.getToken().getString());
                    ts.next();
                    break;
                }
                case -401: {
                    StringBuffer dqText = new StringBuffer(ts.getToken().getString());
                    ts.next();
                    while (ts.getToken().getValue() == -401) {
                        dqText.append("\"\"").append(token.getString());
                        ts.next();
                    }
                    ParsedNode doubleQuoteNode = this._nodeFactory.newQuotedText(327684, "\"", dqText.toString());
                    nextTerm = this.parse_NameLiteral(ts, doubleQuoteNode);
                    break;
                }
                case -402: {
                    StringBuffer sqText = new StringBuffer(ts.getToken().getString());
                    ts.next();
                    while (ts.getToken().getValue() == -402) {
                        sqText.append("''").append(ts.getToken().getString());
                        ts.next();
                    }
                    ParsedNode singleQuoteNode = this._nodeFactory.newQuotedText(327685, "'", sqText.toString());
                    nextTerm = this.parse_NameLiteral(ts, singleQuoteNode);
                    break;
                }
                case -113: {
                    nextTerm = this._nodeFactory.newAllColumn(ts.getToken().getString());
                    ts.next();
                    starTerminated = true;
                    break;
                }
                case -100: {
                    this.unexpectedListEOF(ts, referenceNameList, token, ".");
                }
                default: {
                    ParsedNode bad = this._nodeFactory.newListNode(".", referenceNameList);
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Reference.InvalidSyntax.fmt.txt", new Object[]{bad, token, ts.tokenizerStatus(token)});
                }
            }
            referenceNameList.add(nextTerm);
            token = ts.getToken();
        }
        ParsedNode referenceNameListNode = this._nodeFactory.newListNode(".", referenceNameList);
        ParsedNode ret = this._nodeFactory.newQualifiedReference(referenceNameListNode);
        return ret;
    }

    private void unexpectedListEOF(Tokenizer ts, List<ParsedNode> referenceNameList, Token token, String delim) {
        ParsedNode unexpectedEofAfter = this._nodeFactory.newListNode(delim, referenceNameList);
        throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.UnexpectedEndOfInput.fmt.txt", new Object[]{unexpectedEofAfter, delim, token, ts.tokenizerStatus(token)});
    }

    private ParsedNode parse_Word(Tokenizer ts) {
        String string = ts.getToken().getString();
        ParsedNode ret = this._nodeFactory.newWord(string);
        return ret;
    }

    ParsedNode parse_NumericWord(Tokenizer ts, boolean failIfNotNumber) {
        ParsedNode ret;
        block3: {
            ret = null;
            String string = ts.getToken().getString();
            try {
                BigDecimal number = new BigDecimal(string);
                ret = this._nodeFactory.newNumber(number);
            }
            catch (NumberFormatException nfe) {
                if (!failIfNotNumber) break block3;
                ParseError e = this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Number.CouldNotParse.fmt.txt", new Object[]{string, ts.tokenizerStatus(ts.getToken())});
                e.initCause(nfe);
                throw e;
            }
        }
        if (ret != null) {
            ts.next();
        }
        return ret;
    }

    private void printShortStackTrace(Exception marker) {
        StackTraceElement[] source = marker.getStackTrace();
        ArrayList<StackTraceElement> dest = new ArrayList<StackTraceElement>();
        boolean copy = true;
        for (int i = 0; i < source.length; ++i) {
            StackTraceElement element = source[i];
            String where = element.getClassName();
            if (!where.startsWith("com.sas.iquery")) {
                copy = false;
            }
            if (!copy) continue;
            dest.add(element);
        }
        marker.setStackTrace(dest.toArray(new StackTraceElement[dest.size()]));
        marker.printStackTrace();
    }

    ParsedNode parse_QuotedLiteral(Tokenizer ts, ParsedNode quoteNode) {
        ParsedNode ret;
        String literalTypeKeywordText = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -405: {
                if (literalTypeKeywordText.equalsIgnoreCase("t")) {
                    ts.next();
                    ret = this._nodeFactory.newQuotedLiteral(327697, literalTypeKeywordText, quoteNode);
                    break;
                }
                if (literalTypeKeywordText.equalsIgnoreCase("d")) {
                    ts.next();
                    ret = this._nodeFactory.newQuotedLiteral(327698, literalTypeKeywordText, quoteNode);
                    break;
                }
                if (literalTypeKeywordText.equalsIgnoreCase("dt")) {
                    ts.next();
                    ret = this._nodeFactory.newQuotedLiteral(327699, literalTypeKeywordText, quoteNode);
                    break;
                }
                int type = this.getSasCompareWordsType(literalTypeKeywordText);
                if (type == -1) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.QuotedLiteral.MissingLiteral.fmt.txt", new Object[]{quoteNode, literalTypeKeywordText, ts.tokenizerStatus(ts.getToken())});
                }
                ret = quoteNode;
                break;
            }
            default: {
                ret = quoteNode;
            }
        }
        return ret;
    }

    ParsedNode parse_NestedExpression(Tokenizer ts) {
        String nestingBeginText = ts.getToken().getString();
        ts.next();
        ParsedNode value = this.parse_PredicatePhrase(ts);
        String nestingEndText = ts.getToken().getString();
        if (ts.getToken().getValue() != -102) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Nesting.MissingCloseParen.fmt.txt", new Object[]{nestingBeginText, value, ts.tokenizerStatus(ts.getToken())});
        }
        ts.next();
        ParsedNode ret = this._nodeFactory.newNestedTerm(nestingBeginText, value, nestingEndText);
        return ret;
    }

    ParsedNode parse_SetOfExpressions(Tokenizer ts) {
        String setBeginText = ts.getToken().getString();
        ts.next();
        ParsedNode values = this.parse_CommaListWithComments(ts, -107, true, true, true);
        String setEndText = ts.getToken().getString();
        if (ts.getToken().getValue() != -107) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.ExpressionSet.MissingCloseCurlyBrace.fmt.txt", new Object[]{setBeginText, values, ts.tokenizerStatus(ts.getToken())});
        }
        ts.next();
        ParsedNode ret = this._nodeFactory.newSetOfExpressions(setBeginText, values, setEndText);
        return ret;
    }

    ParsedNode parse_CastFunction(Tokenizer ts) {
        ParsedNode ret;
        String castFunc = ts.getToken().getString();
        ts.next();
        switch (ts.getToken().getValue()) {
            case -101: {
                ts.next();
                ParsedNode eValue = this.parse_ExpressionPhrase(ts);
                if (ts.getToken().getValue() != -331) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.TypeCast.MissingAS.fmt.txt", new Object[]{castFunc, eValue, ts.tokenizerStatus(ts.getToken())});
                }
                String asText = ts.getToken().getString();
                ts.next();
                ParsedNode dataType = this.parse_DataTypeLiteral(ts);
                ret = this._nodeFactory.newTypeCastFunction(castFunc, eValue, asText, dataType);
                if (ts.getToken().getValue() != -102) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.TypeCast.MissingCloseParen.fmt.txt", new Object[]{castFunc, eValue, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                break;
            }
            default: {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.TypeCast.MissingOpenParen.fmt.txt", new Object[]{castFunc, ts.tokenizerStatus(ts.getToken())});
            }
        }
        throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.TypeCast.UnsupportedFunctionTypeCast.fmt.txt", new Object[]{ret, ts.tokenizerStatus(ts.getToken())});
    }

    ParsedNode parse_DataTypeLiteral(Tokenizer ts) {
        ParsedNode ret;
        String dataType = ts.getToken().getString();
        switch (ts.getToken().getValue()) {
            case -405: {
                ts.next();
                ret = this._nodeFactory.newDataType(dataType);
                break;
            }
            case -404: {
                ts.next();
                if (ts.getToken().getValue() != -101) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.DataType.MissingOpenParen.fmt.txt", new Object[]{dataType, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                String value1 = ts.getToken().getString();
                if (ts.getToken().getValue() != -406) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.DataType.MissingParameter1.fmt.txt", new Object[]{dataType, value1, ts.tokenizerStatus(ts.getToken())});
                }
                Number number1 = ts.getToken().getNumber();
                ParsedNode lengthOrPercisionValue = this._nodeFactory.newNumber(number1);
                ts.next();
                if (ts.getToken().getValue() == -103) {
                    ts.next();
                    String value2 = ts.getToken().getString();
                    if (ts.getToken().getValue() != -406) {
                        throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.DataType.MissingParameter2.fmt.txt", new Object[]{dataType, lengthOrPercisionValue, value2, ts.tokenizerStatus(ts.getToken())});
                    }
                    Number number2 = ts.getToken().getNumber();
                    ParsedNode scaleValue = this._nodeFactory.newNumber(number2);
                    ts.next();
                    if (ts.getToken().getValue() != -102) {
                        throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.DataType.MissingCloseParenAfterComma.fmt.txt", new Object[]{dataType, lengthOrPercisionValue, scaleValue, ts.tokenizerStatus(ts.getToken())});
                    }
                    ret = this._nodeFactory.newDataType(dataType, lengthOrPercisionValue, scaleValue);
                } else if (ts.getToken().getValue() == -102) {
                    ret = this._nodeFactory.newDataType(dataType, lengthOrPercisionValue);
                } else {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.MissingCloseParenBeforeComma.fmt.txt", new Object[]{dataType, lengthOrPercisionValue, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                break;
            }
            default: {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.DataType.MissingLiteral.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
            }
        }
        return ret;
    }

    ParsedNode parse_PutFunction(Tokenizer ts) {
        ParsedNode ret;
        String putFunc = ts.getToken().getString();
        ts.next();
        switch (ts.getToken().getValue()) {
            case -101: {
                ts.next();
                ParsedNode eValue = this.parse_ExpressionPhrase(ts);
                if (ts.getToken().getValue() != -103) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Put.MissingComma.fmt.txt", new Object[]{putFunc, eValue, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                if (ts.getToken().getValue() == -140) {
                    String qmarkText = ts.getToken().getString();
                    ts.next();
                    ParsedNode format = this.parse_FormatLiteral(ts);
                    ret = this._nodeFactory.newPutQFunction(putFunc, eValue, qmarkText, format);
                } else {
                    ParsedNode format = this.parse_FormatLiteral(ts);
                    ret = this._nodeFactory.newPutFunction(putFunc, eValue, format);
                }
                if (ts.getToken().getValue() != -102) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Put.MissingCloseParen.fmt.txt", new Object[]{ret, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                break;
            }
            default: {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Put.MissingOpenParen.fmt.txt", new Object[]{putFunc, ts.tokenizerStatus(ts.getToken())});
            }
        }
        return ret;
    }

    ParsedNode parse_InputFunction(Tokenizer ts) {
        ParsedNode ret;
        String inputFunc = ts.getToken().getString();
        ts.next();
        switch (ts.getToken().getValue()) {
            case -101: {
                ts.next();
                ParsedNode eValue = this.parse_ExpressionPhrase(ts);
                if (ts.getToken().getValue() != -103) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Input.MissingComma.fmt.txt", new Object[]{inputFunc, eValue, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                if (ts.getToken().getValue() == -140) {
                    String qmarkText = ts.getToken().getString();
                    ts.next();
                    if (ts.getToken().getValue() == -140) {
                        String qmarkText2 = ts.getToken().getString();
                        ts.next();
                        qmarkText = qmarkText + qmarkText2;
                    }
                    ParsedNode format = this.parse_FormatLiteral(ts);
                    ret = this._nodeFactory.newInputQFunction(inputFunc, eValue, qmarkText, format);
                } else {
                    ParsedNode format = this.parse_FormatLiteral(ts);
                    ret = this._nodeFactory.newInputFunction(inputFunc, eValue, format);
                }
                if (ts.getToken().getValue() != -102) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Input.MissingCloseParen.fmt.txt", new Object[]{ret, ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                break;
            }
            default: {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Input.MissingOpenParen.fmt.txt", new Object[]{inputFunc, ts.tokenizerStatus(ts.getToken())});
            }
        }
        return ret;
    }

    ParsedNode parse_FormatLiteral(Tokenizer ts) {
        StringBuffer format = new StringBuffer(ts.getToken().getString());
        int value = ts.getToken().getValue();
        if (value == -405) {
            ts.next();
            String formatDW = ts.getToken().getString();
            if (ts.getToken().getValue() == -105) {
                format.append(ts.getToken().getString());
            } else if (ts.getToken().getValue() == -406 && formatDW.length() > 0 && formatDW.charAt(0) == '.') {
                for (int i = 1; i < formatDW.length(); ++i) {
                    if (Character.isDigit(formatDW.charAt(i))) continue;
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Format.InvalidDecimalWidth.fmt.txt", new Object[]{format, ts.tokenizerStatus(ts.getToken())});
                }
                format.append(formatDW);
            } else {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Format.MissingDot.fmt.txt", new Object[]{format, ts.tokenizerStatus(ts.getToken())});
            }
            ts.next();
        } else if (value == -406) {
            ts.next();
        } else {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Format.MissingLiteral.fmt.txt", new Object[]{format, ts.tokenizerStatus(ts.getToken())});
        }
        ParsedNode ret = this._nodeFactory.newFormat(format.toString());
        return ret;
    }

    ParsedNode parse_CaseExpression(Tokenizer ts) {
        String caseKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode ret = ts.getToken().getValue() != -321 ? this.parse_CaseSimple(ts, caseKeywordText) : this.parse_CaseSearch(ts, caseKeywordText);
        return ret;
    }

    ParsedNode parse_CaseSimple(Tokenizer ts, String caseKeywordText) {
        ParsedNode compareToValue = this.parse_ExpressionPhrase(ts);
        if (ts.getToken().getValue() != -321) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CaseSimple.MissingWHEN.fmt.txt", new Object[]{caseKeywordText, compareToValue, ts.tokenizerStatus(ts.getToken())});
        }
        ParsedNode whenElseNodes = this.parse_CaseList(ts, true);
        if (ts.getToken().getValue() != -324) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CaseSimple.MissingEND.fmt.txt", new Object[]{caseKeywordText, compareToValue, whenElseNodes, ts.tokenizerStatus(ts.getToken())});
        }
        String endKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode ret = this._nodeFactory.newSimpleCaseExpression(caseKeywordText, compareToValue, whenElseNodes, endKeywordText);
        return ret;
    }

    ParsedNode parse_CaseSearch(Tokenizer ts, String caseKeywordText) {
        ParsedNode whenElseNodes = this.parse_CaseList(ts, false);
        if (ts.getToken().getValue() != -324) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CaseSearch.MissingEND.fmt.txt", new Object[]{caseKeywordText, whenElseNodes, ts.tokenizerStatus(ts.getToken())});
        }
        String endKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode ret = this._nodeFactory.newSearchCaseExpression(caseKeywordText, whenElseNodes, endKeywordText);
        return ret;
    }

    ParsedNode parse_CaseList(Tokenizer ts, boolean isSimple) {
        ArrayList<ParsedNode> nodes = new ArrayList<ParsedNode>();
        ParsedNode caseWhenValue = isSimple ? this.parse_CaseWhenSimple(ts) : this.parse_CaseWhenSearch(ts);
        nodes.add(caseWhenValue);
        while (ts.getToken().getValue() == -321) {
            caseWhenValue = isSimple ? this.parse_CaseWhenSimple(ts) : this.parse_CaseWhenSearch(ts);
            nodes.add(caseWhenValue);
        }
        if (ts.getToken().getValue() == -323) {
            ParsedNode caseElseValue = this.parse_CaseElse(ts);
            nodes.add(caseElseValue);
        }
        ParsedNode ret = this._nodeFactory.newListNode(" ", nodes);
        return ret;
    }

    ParsedNode parse_CaseWhenSimple(Tokenizer ts) {
        String whenKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode whenEqualsValue = this.parse_ExpressionPhrase(ts);
        if (ts.getToken().getValue() != -322) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CaseSimple.MissingTHEN.fmt.txt", new Object[]{whenKeywordText, whenEqualsValue, ts.tokenizerStatus(ts.getToken())});
        }
        ParsedNode thenReturnValue = this.parse_CaseThen(ts);
        ParsedNode ret = this._nodeFactory.newSimpleCaseWhenClause(whenKeywordText, whenEqualsValue, thenReturnValue);
        return ret;
    }

    ParsedNode parse_CaseWhenSearch(Tokenizer ts) {
        String whenKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode whenPredicateValue = this.parse_PredicatePhrase(ts);
        if (ts.getToken().getValue() != -322) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CaseSearch.MissingTHEN.fmt.txt", new Object[]{whenKeywordText, whenPredicateValue, ts.tokenizerStatus(ts.getToken())});
        }
        ParsedNode thenReturnValue = this.parse_CaseThen(ts);
        ParsedNode ret = this._nodeFactory.newSearchCaseWhenClause(whenKeywordText, whenPredicateValue, thenReturnValue);
        return ret;
    }

    ParsedNode parse_CaseThen(Tokenizer ts) {
        String thenKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode thenReturnValue = this.parse_ExpressionPhrase(ts);
        ParsedNode ret = this._nodeFactory.newCaseThenClause(thenKeywordText, thenReturnValue);
        return ret;
    }

    ParsedNode parse_CaseElse(Tokenizer ts) {
        String elseKeywordText = ts.getToken().getString();
        ts.next();
        ParsedNode elseReturnValue = this.parse_ExpressionPhrase(ts);
        ParsedNode ret = this._nodeFactory.newElseReturnClause(elseKeywordText, elseReturnValue);
        return ret;
    }

    ParsedNode parse_TupleNameList(Tokenizer ts) {
        ArrayList<ParsedNode> tupleNamesInList = new ArrayList<ParsedNode>();
        Token token = ts.getToken();
        String tupleNameText = token.getString();
        ParsedNode tupleNode = this._nodeFactory.newTupleName("[", tupleNameText, "]");
        tupleNamesInList.add(tupleNode);
        ts.next();
        token = ts.getToken();
        while (token.getValue() == -105) {
            ParsedNode nextTerm;
            ts.next();
            token = ts.getToken();
            switch (token.getValue()) {
                case -600: {
                    tupleNameText = token.getString();
                    nextTerm = this._nodeFactory.newTupleName("[", tupleNameText, "]");
                    ts.next();
                    break;
                }
                case -405: {
                    if (ts.isObjRefsSupportEnabled()) {
                        nextTerm = this._nodeFactory.newWord(ts.getToken().getString());
                        ts.next();
                        break;
                    }
                    ParsedNode bad = this._nodeFactory.newListNode(".", tupleNamesInList);
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Tuple.InvalidSyntax.fmt.txt", new Object[]{bad, token, ts.tokenizerStatus(token)});
                }
                case -404: {
                    if (ts.isObjRefsSupportEnabled()) {
                        nextTerm = this.parse_FunctionName(ts);
                        break;
                    }
                    ParsedNode bad = this._nodeFactory.newListNode(".", tupleNamesInList);
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Tuple.InvalidSyntax.fmt.txt", new Object[]{bad, token, ts.tokenizerStatus(token)});
                }
                default: {
                    ParsedNode bad = this._nodeFactory.newListNode(".", tupleNamesInList);
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Tuple.MissingElement.fmt.txt", new Object[]{bad, token, ts.tokenizerStatus(token)});
                }
            }
            tupleNamesInList.add(nextTerm);
            token = ts.getToken();
        }
        ParsedNode tupleListNode = this._nodeFactory.newListNode(".", tupleNamesInList);
        ParsedNode ret = this._nodeFactory.newQualifiedTuple(tupleListNode);
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    ParsedNode parse_FunctionName(Tokenizer ts) {
        funcName = ts.getToken().getString();
        ts.next();
        switch (ts.getToken().getValue()) {
            case -101: {
                ts.next();
                prefixComments = this.parse_CommaListPrecomments(ts);
                allValue = null;
                distinctValue = null;
                isAgg = false;
                if (ts.getToken().getValue() == -311) {
                    isAgg = true;
                    value = this._nodeFactory.newAllAggregationModifier(ts.getToken().getString());
                    allValue = this.addPrefixComments(prefixComments, value);
                    ts.next();
                    prefixComments = this.parse_CommaListPrecomments(ts);
                } else if (ts.getToken().getValue() == -312 || ts.getToken().getValue() == -313) {
                    isAgg = true;
                    value = this._nodeFactory.newDistinctAggregationModifier(ts.getToken().getString());
                    distinctValue = this.addPrefixComments(prefixComments, value);
                    ts.next();
                    prefixComments = this.parse_CommaListPrecomments(ts);
                }
                zValue = this.parse_CommaListWithComments(ts, -102, true, true, false);
                if (ts.getToken().getValue() != -102) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Function.MissingCloseParen.fmt.txt", new Object[]{funcName, zValue, ts.tokenizerStatus(ts.getToken())});
                }
                foundAggDef = null;
                aggDefs = this.getAggregateDefinitions();
                parmCount = this.countParms(zValue);
                if (distinctValue != null || allValue != null) ** GOTO lbl36
                for (AggregateDefinition aggDef : aggDefs) {
                    if (!aggDef.matches(funcName, null, parmCount, zValue, this, ts)) continue;
                    isAgg = true;
                    foundAggDef = aggDef;
                    ** GOTO lbl45
                }
                ** GOTO lbl45
lbl36:
                // 1 sources

                if (parmCount != 1) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Function.AggWithKeywordHasOnlyOneParm.fmt.txt", new Object[]{funcName, distinctValue != null ? distinctValue : allValue, zValue, ts.tokenizerStatus(ts.getToken())});
                }
                firstChild = zValue.getChildren()[0];
                if (firstChild.getType() == 327695) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Function.AggWithKeywordExcludesAllColumn.fmt.txt", new Object[]{funcName, distinctValue != null ? distinctValue : allValue, zValue, ts.tokenizerStatus(ts.getToken())});
                }
                for (AggregateDefinition aggDef : aggDefs) {
                    if (!aggDef.matches(funcName, null, parmCount, zValue, this, ts)) continue;
                    foundAggDef = aggDef;
                    break;
                }
lbl45:
                // 4 sources

                if (prefixComments != null) {
                    if (zValue == null || zValue.getChildren() == null || zValue.getChildren().length == 0) {
                        zValue = this._nodeFactory.newListNode(",", Arrays.asList(new ParsedNode[]{this._nodeFactory.newNothingNode()}));
                    }
                    zChildren = zValue.getChildren();
                    firstChild = zChildren[0];
                    zChildren[0] = firstChild = this.addPrefixComments(prefixComments, firstChild);
                }
                ret = allValue != null ? this._nodeFactory.newAllFunction(funcName, allValue, zValue, foundAggDef) : (distinctValue != null ? this._nodeFactory.newDistinctFunction(funcName, distinctValue, zValue, foundAggDef) : (isAgg != false ? this._nodeFactory.newAggFunction(funcName, zValue, foundAggDef) : this._nodeFactory.newFunction(funcName, zValue)));
                ts.next();
                break;
            }
            default: {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.Function.MissingOpenParen.fmt.txt", new Object[]{funcName, ts.tokenizerStatus(ts.getToken())});
            }
        }
        return ret;
    }

    private int countParms(ParsedNode value) {
        ParsedNode[] children;
        int count = 0;
        if (value != null && (children = value.getChildren()) != null && (count = children.length) == 1) {
            ParsedNode walk = children[0];
            while (walk != null) {
                int type = walk.getType();
                if (type == 2 || type == 5) {
                    walk = walk.getChildren()[1];
                    continue;
                }
                if (type == 3 || type == 5) {
                    walk = walk.getChildren()[0];
                    continue;
                }
                if (type != 0) break;
                count = 0;
                break;
            }
        }
        return count;
    }

    ParsedNode parse_CommaListWithComments(Tokenizer ts, int listEndToken, boolean emptyListAllowed, boolean emptyItemsAllowed, boolean rangeOperationAllowed) {
        ParsedNode ret;
        boolean done;
        ArrayList<ParsedNode> nodes = new ArrayList<ParsedNode>();
        boolean bl = done = ts.getToken().getValue() == listEndToken;
        if (done && !emptyListAllowed) {
            throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CommaList.EmptyList1.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
        }
        while (!done) {
            ParsedNode prefixComments = this.parse_CommaListPrecomments(ts);
            ParsedNode current = null;
            if (ts.getToken().getValue() == listEndToken) {
                if (nodes.size() == 0 && !emptyListAllowed) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CommaList.EmptyItemInList1.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
                }
                if (!emptyItemsAllowed) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CommaList.EmptyItemAtEndOfList.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
                }
                current = null;
                done = true;
            } else if (ts.getToken().getValue() == -103) {
                if (!emptyItemsAllowed) {
                    throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CommaList.EmptyItemInList2.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
                }
                ts.next();
                current = null;
                done = false;
            } else {
                current = this.parse_PredicatePhrase(ts);
                if (rangeOperationAllowed && ts.getToken().getValue() == -108) {
                    String opText = ts.getToken().getString();
                    ts.next();
                    ParsedNode next = this.parse_PredicatePhrase(ts);
                    current = this._nodeFactory.newSetRangeOperation(current, opText, next);
                }
                boolean bl2 = done = ts.getToken().getValue() == listEndToken;
                if (!done) {
                    if (ts.getToken().getValue() == -103) {
                        ts.next();
                    } else {
                        throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CommaList.ExpectedCommaOrEndOfList.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
                    }
                }
            }
            if (current == null) {
                current = this._nodeFactory.newNothingNode();
            }
            current = this.addPrefixComments(prefixComments, current);
            nodes.add(current);
        }
        if (nodes.size() > 0) {
            ret = this._nodeFactory.newListNode(",", nodes);
        } else {
            if (!emptyListAllowed) {
                throw this.parseerror(Messages.getBundleName(), "NodeParserImpl.Error.CommaList.EmptyList2.fmt.txt", new Object[]{ts.tokenizerStatus(ts.getToken())});
            }
            ret = null;
        }
        return ret;
    }

    private ParsedNode addPrefixComments(ParsedNode comments, ParsedNode current) {
        ParsedNode tmp = comments;
        while (tmp != null) {
            ParsedNode[] children = tmp.getChildren();
            if (children != null && children.length > 0) {
                ParsedNode test = children[1];
                if (test == null) {
                    children[1] = current;
                    current = tmp;
                    tmp = null;
                    continue;
                }
                tmp = test;
                continue;
            }
            tmp = null;
        }
        return current;
    }

    ParsedNode parse_CommaListPrecomments(Tokenizer ts) {
        ParsedNode ret;
        switch (ts.getToken().getValue()) {
            case -403: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_CommaListPrecomments(ts);
                ret = this._nodeFactory.newPrefixCommentNode(2, "/*", textOfComment, "*/", valueFollowingComment);
                break;
            }
            case -407: {
                String textOfComment = ts.getToken().getString();
                ts.next();
                ParsedNode valueFollowingComment = this.parse_CommaListPrecomments(ts);
                ret = this._nodeFactory.newPrefixCommentNode(5, "<!--", textOfComment, "-->", valueFollowingComment);
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }
}

