/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.metadata.expr.iqtextparser.Messages;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParser;
import com.sas.iquery.metadata.expr.iqtextparser.ParseError;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.Token;
import com.sas.iquery.metadata.expr.iqtextparser.Tokenizer;

public class AggregateDefinition {
    private String _functionKeyword;
    private int _numberOfParameters;
    private boolean _invalidWithFewerParameters;
    private boolean _invalidWithExtraParameters;

    public String toString() {
        return "AggregateDefinition=" + this._functionKeyword + "(args=" + this._numberOfParameters + ",less=" + this._invalidWithFewerParameters + ",more=" + this._invalidWithExtraParameters + ')';
    }

    public AggregateDefinition(String functionKeyword, int numberOfParameters, boolean invalidWithFewerParameters, boolean invalidWithExtraParameters) {
        this._functionKeyword = functionKeyword.trim();
        this._numberOfParameters = numberOfParameters;
        this._invalidWithFewerParameters = invalidWithFewerParameters;
        this._invalidWithExtraParameters = invalidWithExtraParameters;
    }

    public String getFunctionKeyword() {
        return this._functionKeyword;
    }

    public boolean isInvalidWithExtraParameters() {
        return this._invalidWithExtraParameters;
    }

    public boolean isInvalidWithFewerParameters() {
        return this._invalidWithFewerParameters;
    }

    public int getNumberOfParameters() {
        return this._numberOfParameters;
    }

    public boolean matches(String funcName, ParsedNode modifier, int parmCount, ParsedNode parmListNode, NodeParser parser, Tokenizer ts) throws ParseError {
        boolean match = false;
        if (funcName != null && funcName.trim().compareToIgnoreCase(this._functionKeyword) == 0) {
            if (parmCount == this._numberOfParameters) {
                match = true;
            } else {
                Object list = parmListNode == null ? "" : parmListNode;
                Token token = ts.getToken();
                if (this._invalidWithFewerParameters && parmCount < this._numberOfParameters) {
                    if (modifier != null) {
                        throw parser.parseerror(Messages.getBundleName(), "AggregateDefinition.TooFewParmsWithModifier.fmt.txt", new Object[]{funcName, modifier, list, this._numberOfParameters, ts.tokenizerStatus(token)});
                    }
                    throw parser.parseerror(Messages.getBundleName(), "AggregateDefinition.TooFewParms.fmt.txt", new Object[]{funcName, list, this._numberOfParameters, ts.tokenizerStatus(token)});
                }
                if (this._invalidWithExtraParameters && parmCount > this._numberOfParameters) {
                    if (modifier != null) {
                        throw parser.parseerror(Messages.getBundleName(), "AggregateDefinition.TooManyParmsWithModifier.fmt.txt", new Object[]{funcName, modifier, list, this._numberOfParameters, ts.tokenizerStatus(token)});
                    }
                    throw parser.parseerror(Messages.getBundleName(), "AggregateDefinition.TooManyParms.fmt.txt", new Object[]{funcName, list, this._numberOfParameters, ts.tokenizerStatus(token)});
                }
            }
        }
        return match;
    }
}

