/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public final class TimestampValueExpression
extends AbstractTimeValueExpression {
    private static final String SAS_DATETIME19_PATTERN = "''ddMMMyyyy:HH:mm:ss'''DT'";
    private static final String SQL99_TIMESTAMP_PATTERN = "'TIMESTAMP '''yyyy-MM-dd HH:mm:ss''";
    private static final int NOXML_NANOS = 0;

    public TimestampValueExpression() {
    }

    public TimestampValueExpression(Timestamp timestampValue) {
        this.setFromTimestamp(timestampValue);
    }

    public TimestampValueExpression(Date timestampValue) {
        if (timestampValue instanceof Timestamp) {
            this.setFromTimestamp((Timestamp)timestampValue);
        } else {
            this.setValue(timestampValue);
        }
    }

    public Timestamp getTimestampValue() {
        return (Timestamp)this.getValue();
    }

    public void setTimestampValue(Timestamp timestamp) {
        this.setFromTimestamp(timestamp);
        this.fireChangeEvent("Value changed");
    }

    private void setFromTimestamp(Timestamp timestamp) {
        Date useTimestamp = null;
        if (timestamp != null) {
            useTimestamp = (Date)timestamp.clone();
        }
        this._trustedSetValue(useTimestamp);
    }

    @Override
    public void setValue(Date value) {
        if (value instanceof Timestamp) {
            this._trustedSetValue((Timestamp)value.clone());
            this.fireChangeEvent("Value changed");
        } else {
            super.setValue(value);
        }
    }

    @Override
    @SASScope
    protected SimpleDateFormat getFormatter() {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH);
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        formatter.setTimeZone(gmtTimeZone);
        return formatter;
    }

    @Override
    @SASScope
    protected String getPattern(DataSelection dataSelection, ConnectionType connectionType) throws MetadataException {
        String pattern = connectionType == ConnectionType.IOM_TSSQL ? SQL99_TIMESTAMP_PATTERN : SAS_DATETIME19_PATTERN;
        return pattern;
    }

    @Override
    Date newCoreObject(long value) {
        return new Timestamp(value);
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        Timestamp value = this.getTimestampValue();
        if (value != null) {
            int additionalNanos = value.getNanos() % 1000000;
            IQModelImplUtilities.setIntAttr(thisElement, "nanoseconds", additionalNanos, 0);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        Timestamp value = this.getTimestampValue();
        if (value != null) {
            int additionalNanos = attrsProvider.consumeIntAttr("nanoseconds", 0);
            long millis = value.getTime();
            long nanos = millis % 1000L * 1000000L + (long)additionalNanos;
            value.setNanos((int)nanos);
            this.setValue(value);
        }
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String nanosAttr;
        super.readDefinitionV1(thisElement, readingContext);
        Timestamp value = this.getTimestampValue();
        if (value != null && (nanosAttr = IQModelImplUtilities.getAttr(thisElement, "nanos")) != null) {
            int nanos = IQModelImplUtilities.getIntAttr(thisElement, "nanos", 0);
            value.setNanos(nanos);
            this.setValue(value);
        }
    }

    @Override
    public int getExpressionType() {
        return 6;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "TimestampValue";
    }
}

