/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.parser.StringExpressionUtilImpl;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope(value="ALL")
@SubjectToChange
public abstract class StringExpressionUtil {
    private static final String DEFAULT_CHARACTER_FORMAT = "$.";
    private static final String DEFAULT_NUMERIC_FORMAT = "BEST.";
    private static final String DEFAULT_DATETIME_FORMAT = IQMetadataResourceBundle.getMessageString("StringExpressionUtil.DefaultSasFormatForDateTime.lcl", new Object[0]);
    private static final String DEFAULT_DATE_FORMAT = IQMetadataResourceBundle.getMessageString("StringExpressionUtil.DefaultSasFormatForDate.lcl", new Object[0]);
    private static final String DEFAULT_TIME_FORMAT = IQMetadataResourceBundle.getMessageString("StringExpressionUtil.DefaultSasFormatForTime.lcl", new Object[0]);
    private static final StringExpressionUtil _instance = new StringExpressionUtilImpl();

    public static StringExpressionUtil getInstance() {
        return _instance;
    }

    public abstract ExpressionInterface newExpression(BusinessModel var1, String var2, int var3, ResourceScope var4) throws MetadataException;

    @SASScope
    public abstract ExpressionInterface newExpression(BusinessModel var1, String var2, int var3) throws MetadataException;

    @SASScope
    public abstract ExpressionInterface newExpression(BusinessModel var1, String var2) throws MetadataException;

    @SASScope
    public abstract String getText(ExpressionInterface var1) throws MetadataException;

    public abstract String getText(ExpressionInterface var1, ResourceScope var2, BusinessModel var3) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1, TimeZone var2) throws MetadataException;

    @SASScope
    public abstract String getText(ResourceAwareStringExpression var1, Map<BusinessModelResource, String> var2) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1, String var2) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1, String var2, TimeZone var3) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1, Locale var2) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1, TimeZone var2, Locale var3) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1, String var2, Locale var3) throws MetadataException;

    @SASScope
    public abstract String getReadableText(ExpressionInterface var1, String var2, TimeZone var3, Locale var4) throws MetadataException;

    @SASScope
    public abstract TimeZone getFormatTimeZone();

    @SASScope
    public abstract void setFormatTimeZone(TimeZone var1);

    @SASScope
    public abstract Locale getFormatLocale();

    @SASScope
    public abstract void setFormatLocale(Locale var1);

    @SASScope
    public static SASFormat getSASFormat(String sasFormatText, Locale locale) {
        SASFormat formatter = null;
        if (sasFormatText == null || sasFormatText.trim().length() == 0) {
            return null;
        }
        formatter = SASFormat.getInstance((String)sasFormatText, (Locale)locale);
        return formatter;
    }

    @SASScope
    public static String getDefaultSASFormatText(int expType) {
        String sasFormatText;
        switch (expType) {
            case 3: {
                sasFormatText = DEFAULT_CHARACTER_FORMAT;
                break;
            }
            case 2: {
                sasFormatText = DEFAULT_NUMERIC_FORMAT;
                break;
            }
            case 5: {
                sasFormatText = DEFAULT_TIME_FORMAT;
                break;
            }
            case 4: {
                sasFormatText = DEFAULT_DATE_FORMAT;
                break;
            }
            case 6: {
                sasFormatText = DEFAULT_DATETIME_FORMAT;
                break;
            }
            default: {
                sasFormatText = null;
            }
        }
        return sasFormatText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static synchronized double convertJavaTimeToSASTime(Time time, TimeZone timezone) {
        double result = 0.0;
        SASDateTimeFormat foo = (SASDateTimeFormat)SASDateTimeFormat.getInstance((String)"DATETIME.");
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            TimeZone save = foo.getTimeZone();
            try {
                foo.setTimeZone(timezone);
                result = SASDateTimeFormat.javaDateToSASTime((long)time.getTime());
            }
            catch (Exception exception) {
            }
            finally {
                foo.setTimeZone(save);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static synchronized double convertJavaTimestampToSASDateTime(Timestamp timestamp, TimeZone timezone) {
        double result = 0.0;
        SASDateTimeFormat foo = (SASDateTimeFormat)SASDateTimeFormat.getInstance((String)"DATETIME.");
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            TimeZone save = foo.getTimeZone();
            try {
                foo.setTimeZone(timezone);
                result = SASDateTimeFormat.javaDateToSASDateTime((long)timestamp.getTime());
            }
            catch (Exception exception) {
            }
            finally {
                foo.setTimeZone(save);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static synchronized double convertJavaDateToSASDate(Date date, TimeZone timezone) {
        double result = 0.0;
        SASDateTimeFormat foo = (SASDateTimeFormat)SASDateTimeFormat.getInstance((String)"DATETIME.");
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            TimeZone save = foo.getTimeZone();
            try {
                foo.setTimeZone(timezone);
                result = SASDateTimeFormat.javaDateToSASDate((long)date.getTime());
            }
            catch (Exception exception) {
            }
            finally {
                foo.setTimeZone(save);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static synchronized Time convertSASTimeToJavaTime(double sasTime, TimeZone timezone) {
        Time result = null;
        SASDateTimeFormat foo = (SASDateTimeFormat)SASDateTimeFormat.getInstance((String)"DATETIME.");
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            TimeZone save = foo.getTimeZone();
            try {
                foo.setTimeZone(timezone);
                long javaValue = SASDateTimeFormat.SASTimeToJavaDate((double)sasTime);
                result = new Time(javaValue);
            }
            finally {
                foo.setTimeZone(save);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static synchronized Timestamp convertSASDateTimeToJavaTimestamp(double sasTimeDate, TimeZone timezone) {
        Timestamp result = null;
        SASDateTimeFormat foo = (SASDateTimeFormat)SASDateTimeFormat.getInstance((String)"DATETIME.");
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            TimeZone save = foo.getTimeZone();
            try {
                foo.setTimeZone(timezone);
                long javaValue = SASDateTimeFormat.SASDateTimeToJavaDate((double)sasTimeDate);
                result = new Timestamp(javaValue);
            }
            finally {
                foo.setTimeZone(save);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static synchronized Date convertSASDateToJavaDate(double sasDate, TimeZone timezone) {
        Date result = null;
        SASDateTimeFormat foo = (SASDateTimeFormat)SASDateTimeFormat.getInstance((String)"DATETIME.");
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            TimeZone save = foo.getTimeZone();
            try {
                foo.setTimeZone(timezone);
                long javaValue = SASDateTimeFormat.SASDateToJavaDate((double)sasDate);
                result = new Date(javaValue);
            }
            finally {
                foo.setTimeZone(save);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SASScope
    public static synchronized Date parseDateFromString(String text, String sasFormatText, Locale locale, TimeZone timezone) throws ParseException {
        Date date = null;
        SASFormat format = StringExpressionUtil.getSASFormat(sasFormatText, locale);
        if (format instanceof DateFormat) {
            return StringExpressionUtil.parseDateFromString(text, (DateFormat)format, timezone);
        }
        if (!(format instanceof SASDateTimeFormat)) return date;
        SASDateTimeFormat formatter = (SASDateTimeFormat)format;
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            TimeZone save = formatter.getTimeZone();
            try {
                Object obj = formatter.parseObject(text);
                if (!(obj instanceof Date)) return date;
                date = (Date)obj;
            }
            finally {
                formatter.setTimeZone(save);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return date;
        }
    }

    @SASScope
    public static synchronized Date parseDateFromString(String text, DateFormat dateFormatter, TimeZone timeZone) throws ParseException {
        dateFormatter.setTimeZone(timeZone);
        Date date = dateFormatter.parse(text);
        return date;
    }
}

