/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.business.impl.AbstractEnumerationObject;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import java.util.Enumeration;
import java.util.concurrent.CopyOnWriteArrayList;

@SASScope(value="ALL")
@SubjectToChange
public class ResourceScope
extends AbstractEnumerationObject {
    private static final CopyOnWriteArrayList<ResourceScope> allDefined = new CopyOnWriteArrayList();
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int BUSINESS = 0;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int PHYSICAL = 1;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int BUSINESS_AND_PHYSICAL = 2;
    private static final String[] SCOPES = new String[]{"ResourceScope.BusinessScope.txt", "ResourceScope.PhysicalScope.txt", "ResourceScope.BusinessAndPhysicalScope.txt"};
    private static final String[] SCOPES_V1_PERSISTENT_FORM = new String[]{"0", "1", "2"};
    private static final String[] SCOPES_V2_PERSISTENT_FORM = new String[]{"bus", "phys", "busNphys"};
    @SASScope(value="ALL")
    @SubjectToChange
    public static final ResourceScope BUSINESS_SCOPE = new ResourceScope(0);
    @SASScope(value="ALL")
    @SubjectToChange
    public static final ResourceScope PHYSICAL_SCOPE = new ResourceScope(1);
    @SASScope(value="ALL")
    @SubjectToChange
    public static final ResourceScope BUSINESS_AND_PHYSICAL_SCOPE = new ResourceScope(2);
    private int _type;

    private ResourceScope(int type) {
        super(SCOPES[type], SCOPES_V1_PERSISTENT_FORM[type], SCOPES_V2_PERSISTENT_FORM[type]);
        this._type = type;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static ResourceScope getScope(int type) {
        ResourceScope rval = null;
        if (type == 0) {
            rval = BUSINESS_SCOPE;
        } else if (type == 1) {
            rval = PHYSICAL_SCOPE;
        } else if (type == 2) {
            rval = BUSINESS_AND_PHYSICAL_SCOPE;
        }
        return rval;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public int getType() {
        return this._type;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isBusiness() {
        return this._type == 0 || this._type == 2;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isPhysical() {
        return this._type == 1 || this._type == 2;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isBusinessAndPhysical() {
        return this._type == 2;
    }

    @SASScope
    public static ResourceScope consumeValue(AttributesProvider attrsHolder, String attrName, ResourceScope defaultValue) {
        return ResourceScope.consumeValue(attrsHolder, attrName, allDefined, defaultValue);
    }

    @SASScope
    public static ResourceScope fromPersistentFormV2(String attrName, String persistentForm) {
        return ResourceScope.fromPersistentFormV2(attrName, persistentForm, allDefined);
    }

    @Override
    @SASScope
    protected void registerInstance() {
        allDefined.add(this);
    }

    @SASScope
    public static Enumeration<ResourceScope> enumeration() {
        return new AbstractEnumerationObject.AEOEnumerator<ResourceScope>(allDefined);
    }

    @SASScope
    public Enumeration<ResourceScope> enumerateSiblings() {
        return ResourceScope.enumeration();
    }
}

