/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.DataItemContainerExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifierList;
import com.sas.iquery.metadata.expr.parser.StringExpressionParser;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class ResourceAwareStringExpression
extends StringExpression
implements DataItemContainerExpression {
    private ExpressionIdentifierList _exprList;
    private ResourceScope _scope;
    @SASScope
    public BusinessModel _businessModel;
    private static final String runningAttrPrefix = "cmp";
    private SortedMap _cIndexToAttrName = null;
    private LinkedHashMap _cAttrNameToAttrValue = null;
    private static final String PERSISTED_PREFIX_STRING_IDENTIFIER = "Text:";
    private static final String PERSISTED_PREFIX_ESCAPE_IDENTIFIER = "Esc:";
    private static final String PERSISTED_PREFIX_MEMBER_IDENTIFIER = "Member:";

    @SASScope
    public ResourceAwareStringExpression() {
    }

    @SASScope
    public ResourceAwareStringExpression(BusinessModel businessModel, String expression, int expressionType, ResourceScope scope) throws MetadataException {
        this._exprList = StringExpressionParser.parseExpression(businessModel, expression, scope);
        this._scope = scope;
        this.setExpressionType(expressionType);
        this._businessModel = businessModel;
    }

    @SASScope
    public ResourceAwareStringExpression(BusinessModel businessModel, String expression, int expressionType) throws MetadataException {
        this(businessModel, expression, expressionType, ResourceScope.BUSINESS_SCOPE);
    }

    @SASScope
    public ResourceAwareStringExpression(BusinessModel businessModel, String expression) throws MetadataException {
        this(businessModel, expression, 0, ResourceScope.BUSINESS_SCOPE);
    }

    @SASScope
    public ResourceAwareStringExpression(ExpressionIdentifierList exprList, int expressionType) {
        this(exprList, expressionType, ResourceScope.BUSINESS_SCOPE);
    }

    @SASScope
    public ResourceAwareStringExpression(ExpressionIdentifierList exprList, int expressionType, ResourceScope scope) {
        this(null, exprList, expressionType, scope);
    }

    @SASScope
    public ResourceAwareStringExpression(BusinessModel businessModel, ExpressionIdentifierList exprList, int expressionType, ResourceScope scope) {
        this._businessModel = businessModel;
        this._exprList = exprList;
        this._scope = scope;
        this.setExpressionType(expressionType);
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getText() throws MetadataException {
        return StringExpressionUtil.getInstance().getText(this, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, null);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getText(ResourceScope scope, BusinessModel businessModel) throws MetadataException {
        return StringExpressionUtil.getInstance().getText(this, scope, businessModel);
    }

    @SASScope
    public BusinessModel getBusinessModel() {
        return this._businessModel;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getText(Map<BusinessModelResource, String> resourceMap) throws MetadataException {
        return StringExpressionUtil.getInstance().getText(this, resourceMap);
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public void setText(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this._exprList.replaceResource(oldResource, newResource, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._exprList.replaceResource(oldResource, newResource, recursive);
    }

    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource) throws MetadataException {
        this._exprList.replaceResource(oldResource, newResource);
    }

    @SASScope
    public List<ExpressionIdentifier> getExpressionIdentifiers() {
        return this._exprList.getIdentifiers();
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ResourceScope getResourceScope() {
        return this._scope;
    }

    @Override
    @SASScope
    public boolean equals(Object arg0) {
        boolean rval = false;
        rval = arg0 == this ? true : arg0 instanceof ResourceAwareStringExpression && super.equals(arg0) && this.getResourceScope() == ((ResourceAwareStringExpression)arg0).getResourceScope() && this._businessModel == ((ResourceAwareStringExpression)arg0)._businessModel;
        return rval;
    }

    @Override
    @SASScope
    public int hashCode() {
        return super.hashCode() + this._scope.getType();
    }

    @Override
    @SASScope
    public String toString() {
        StringExpressionUtil util = StringExpressionUtil.getInstance();
        String visualText = null;
        try {
            visualText = util.getReadableText(this);
        }
        catch (MetadataException e) {
            visualText = e.getMessage();
        }
        return visualText;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public boolean containsAggregateFunction(ServerProperties serverProperties) throws MetadataException {
        if (serverProperties == null) {
            return false;
        }
        return serverProperties.containsAggregateFunction(this.getText());
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isCalculatedItem() {
        return this._exprList.isCalculatedItem();
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public boolean containsUserTypedAggregation() throws MetadataException {
        ServerProperties sp = this._businessModel.getServerProperties();
        boolean rval = false;
        if (sp.containsAggregateFunction(this.getText())) {
            rval = true;
        } else {
            DataItem di;
            Iterator<DataItem> iterator = this.getResources(DataItem.class, 0).iterator();
            while (iterator.hasNext() && !(rval = (di = iterator.next()).containsUserTypedAggregation())) {
            }
        }
        return rval;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public List<DataItem> getLeafDataItems() {
        LinkedHashSet<DataItem> leafItems = new LinkedHashSet<DataItem>();
        for (DataItem di : this.getResources(DataItem.class, 0)) {
            leafItems.addAll(di.getLeafDataItems());
        }
        return new ArrayList<DataItem>(leafItems);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        ResourceAwareStringExpression clone = (ResourceAwareStringExpression)super.clone();
        clone._exprList = (ExpressionIdentifierList)this._exprList.clone();
        return clone;
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._exprList != null) {
            List<ModelItem> list = this._exprList.getDirectlyReferencedItems();
            intoList.addAll(list);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._exprList == null || this._exprList.size() == 0) {
            Reason reason = new Reason((Object)this, 2, 16, "ResourceAwareStringExpression.InvalidExpr.txt", new Object[0]);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        if (this._exprList != null) {
            this._exprList.replaceResource((BusinessModelResource)oldObject, (BusinessModelResource)newObject, false);
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "ResourceAwareStringExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        ArrayList<BusinessModelResource> resourcesToWrite = new ArrayList<BusinessModelResource>();
        int attrIndex = 1;
        IQModelImplUtilities.setEnumAttr(thisElement, "scope", this._scope);
        Iterator<ExpressionIdentifier> identifierIter = this.getExpressionIdentifiers().iterator();
        while (identifierIter.hasNext()) {
            String attrName = runningAttrPrefix + attrIndex;
            ++attrIndex;
            ExpressionIdentifier identifier = identifierIter.next();
            if (identifier.isResource()) {
                BusinessModelResource resource = identifier.getBusinessModelResource();
                if (resource == null) continue;
                resourcesToWrite.add(resource);
                continue;
            }
            if (identifier.isString()) {
                IQModelImplUtilities.setAttr(thisElement, attrName, PERSISTED_PREFIX_STRING_IDENTIFIER + identifier.getStringValue());
                continue;
            }
            if (identifier.isEscape()) {
                IQModelImplUtilities.setAttr(thisElement, attrName, PERSISTED_PREFIX_ESCAPE_IDENTIFIER + identifier.getStringValue());
                continue;
            }
            if (!identifier.isOlapMember()) continue;
            IQModelImplUtilities.setAttr(thisElement, attrName, PERSISTED_PREFIX_MEMBER_IDENTIFIER + identifier.getStringValue());
        }
        ResourceAwareStringExpression.writeRelatedObjects(resourcesToWrite, thisElement, writingContext, "Resources");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._scope = ResourceScope.consumeValue(attrsProvider, "scope", ResourceScope.BUSINESS_SCOPE);
        this._cIndexToAttrName = attrsProvider.getOrderedPrefixNAttrNames(runningAttrPrefix);
        this._cAttrNameToAttrValue = new LinkedHashMap();
        this._exprList = new ExpressionIdentifierList();
        for (String cAttrName : this._cIndexToAttrName.values()) {
            String cAttrValue = attrsProvider.consumeAttr(cAttrName);
            this._cAttrNameToAttrValue.put(cAttrName, cAttrValue);
            ExpressionIdentifier identifier = this.newExpressionIdentifier(cAttrValue);
            this._exprList.add(identifier);
        }
        this._businessModel = (BusinessModel)((Object)attrsProvider.getModelBeingRead());
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        List<Object> resources = riHolder.consumeObjects("Resources", Object.class);
        ArrayList<Object> combinedOrder = new ArrayList<Object>();
        Integer[] orderedSuffixValues = this._cIndexToAttrName.keySet().toArray(new Integer[this._cIndexToAttrName.size()]);
        for (int i = 0; i < orderedSuffixValues.length; ++i) {
            Integer suffixIndexObj = orderedSuffixValues[i];
            int suffixIndex = suffixIndexObj;
            int span = --suffixIndex - combinedOrder.size();
            int resourceCountToUse = Math.min(span, resources.size());
            for (int j = 0; j < resourceCountToUse; ++j) {
                Object resource = resources.remove(0);
                combinedOrder.add(resource);
            }
            String cAttrName = (String)this._cIndexToAttrName.get(suffixIndexObj);
            String cAttrValue = (String)this._cAttrNameToAttrValue.get(cAttrName);
            combinedOrder.add(cAttrValue);
        }
        if (resources.size() > 0) {
            combinedOrder.addAll(resources);
        }
        ExpressionIdentifierList exprIdentifierList = new ExpressionIdentifierList();
        int combinedSize = combinedOrder.size();
        for (int i = 0; i < combinedSize; ++i) {
            Object obj = combinedOrder.get(i);
            ExpressionIdentifier identifier = null;
            if (obj instanceof String) {
                String attrValue = (String)obj;
                identifier = this.newExpressionIdentifier(attrValue);
            } else {
                try {
                    identifier = obj instanceof Prompt ? ExpressionIdentifier.getPromptResourceIdentifier((Prompt)obj) : ExpressionIdentifier.getResourceIdentifier((BusinessModelResource)obj);
                }
                catch (MetadataException e) {
                    SAXException se = new SAXException(e.getMessage());
                    se.initCause(e);
                    throw se;
                }
            }
            if (identifier == null) continue;
            exprIdentifierList.add(identifier);
        }
        this._exprList = exprIdentifierList;
        this._businessModel = (BusinessModel)((Object)riHolder.getReadingContext().getModelBeingRead());
        this._cIndexToAttrName = null;
        this._cAttrNameToAttrValue = null;
    }

    private ExpressionIdentifier newExpressionIdentifier(String attrValue) throws SAXException {
        ExpressionIdentifier identifier = null;
        if (attrValue.startsWith(PERSISTED_PREFIX_STRING_IDENTIFIER)) {
            identifier = ExpressionIdentifier.getStringIdentifier(attrValue.substring(PERSISTED_PREFIX_STRING_IDENTIFIER.length()));
        } else if (attrValue.startsWith(PERSISTED_PREFIX_ESCAPE_IDENTIFIER)) {
            identifier = ExpressionIdentifier.getEscapeIdentifier(attrValue.substring(PERSISTED_PREFIX_ESCAPE_IDENTIFIER.length()));
        } else if (attrValue.startsWith(PERSISTED_PREFIX_MEMBER_IDENTIFIER)) {
            identifier = ExpressionIdentifier.getOlapMemberIdentifier(attrValue.substring(PERSISTED_PREFIX_MEMBER_IDENTIFIER.length()));
        } else {
            String msg = IQMetadataResourceBundle.getMessageString("InvalidAttributeValueFail.fmt.txt", attrValue);
            throw new SAXException(msg);
        }
        return identifier;
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        ExpressionIdentifierList exprIdentifierList = new ExpressionIdentifierList();
        int scopeInt = IQModelImplUtilities.getIntAttr(thisElement, "scope", 0);
        ResourceScope scope = ResourceScope.getScope(scopeInt);
        NodeList childElements = thisElement.getChildNodes();
        if (childElements != null) {
            for (int i = 0; i < childElements.getLength(); ++i) {
                String value;
                Node cur = childElements.item(i);
                if (cur.getNodeType() != 1) continue;
                Element child = (Element)cur;
                String tagName = child.getTagName();
                ExpressionIdentifier identifier = null;
                if ("String".equals(tagName)) {
                    value = IQModelImplUtilities.getAttr(child, "strValue");
                    identifier = ExpressionIdentifier.getStringIdentifier(value);
                } else if ("Escape".equals(tagName)) {
                    value = IQModelImplUtilities.getAttr(child, "escValue");
                    identifier = ExpressionIdentifier.getEscapeIdentifier(value);
                } else if ("OlapMember".equals(tagName)) {
                    value = IQModelImplUtilities.getAttr(child, "OlapMemValue");
                    identifier = ExpressionIdentifier.getOlapMemberIdentifier(value);
                } else {
                    AbstractModelItem object = readingContext.readModelElement(child);
                    if (object instanceof BusinessModelResource) {
                        BusinessModelResource tmp = (BusinessModelResource)((Object)object);
                        identifier = tmp instanceof Prompt ? ExpressionIdentifier.getPromptResourceIdentifier((Prompt)tmp) : ExpressionIdentifier.getResourceIdentifier(tmp);
                    } else {
                        throw new IQueryServicesRuntimeException(IQMetadataResourceBundle.getMessageFormatter("ResourceAwareStringExpression.InvalidResource.txt", new Object[0]));
                    }
                }
                if (identifier == null) continue;
                exprIdentifierList.add(identifier);
            }
        }
        this._businessModel = (BusinessModel)((Object)readingContext.getModelBeingRead());
        this._exprList = exprIdentifierList;
        this._scope = scope;
    }
}

