/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class OLAPStringExpressionUtil {
    private static final Logger _logger = LogManager.getLogger(OLAPStringExpressionUtil.class);
    private static final char DOTTED_RESOURCE = '.';
    private static final String START_RESOURCE = "<<";
    private static final String END_RESOURCE = ">>";

    public static String getReadableText(ExpressionInterface expr) throws MetadataException {
        String readableText = OLAPStringExpressionUtil.getExpressionText(expr);
        return readableText;
    }

    public static String getReadableText(ExpressionInterface expr, String startingLevelName) throws MetadataException {
        String readableText = OLAPStringExpressionUtil.getExpressionText(expr, startingLevelName);
        return readableText;
    }

    private static String getCoreExpression(ExpressionInterface expression) {
        return OLAPStringExpressionUtil.getCoreExpression(expression, null);
    }

    private static String getCoreExpression(ExpressionInterface expression, String startingLevelName) {
        StringBuffer coreExpression = new StringBuffer();
        try {
            if (expression instanceof DataItem) {
                expression = ((DataItem)expression).getExpression();
            }
            if (expression instanceof Dimension) {
                String dimension = OLAPStringExpressionUtil.getDimensionExpression((Dimension)expression);
                coreExpression.append(dimension);
            } else if (expression instanceof Hierarchy) {
                String hierarchy = OLAPStringExpressionUtil.getHierarchyExpression((Hierarchy)expression, startingLevelName);
                coreExpression.append(hierarchy);
            } else if (expression instanceof Level) {
                String level = OLAPStringExpressionUtil.getLevelExpression((Level)expression);
                coreExpression.append(level);
            } else if (expression instanceof Measure) {
                String measure = OLAPStringExpressionUtil.getMeasureExpression((Measure)expression);
                coreExpression.append(measure);
            } else if (expression instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)expression;
                try {
                    StringExpressionUtil stringExpressionUtil = StringExpressionUtil.getInstance();
                    HashMap<BusinessModelResource, String> resourceToMDXMap = new HashMap<BusinessModelResource, String>();
                    List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
                    for (BusinessModelResource bmaResource : resources) {
                        if (bmaResource instanceof DataItem) {
                            DataItem di = (DataItem)bmaResource;
                            resourceToMDXMap.put(di, OLAPStringExpressionUtil.getCoreExpression(di, di.getStartingLevelName()));
                            continue;
                        }
                        if (bmaResource instanceof Dimension) {
                            Dimension physDimension = (Dimension)bmaResource;
                            String dimName = stringExpressionUtil.getText(physDimension);
                            resourceToMDXMap.put(physDimension, dimName);
                            continue;
                        }
                        if (bmaResource instanceof Hierarchy) {
                            Hierarchy physHierarchy = (Hierarchy)bmaResource;
                            String hierName = stringExpressionUtil.getText(physHierarchy);
                            resourceToMDXMap.put(physHierarchy, hierName);
                            continue;
                        }
                        if (bmaResource instanceof Level) {
                            Level physLevel = (Level)bmaResource;
                            String levelName = stringExpressionUtil.getText(physLevel);
                            resourceToMDXMap.put(physLevel, levelName);
                            continue;
                        }
                        if (!(bmaResource instanceof Measure)) continue;
                        Measure physMeasure = (Measure)bmaResource;
                        String measureName = stringExpressionUtil.getText(physMeasure);
                        resourceToMDXMap.put(physMeasure, measureName);
                    }
                    String resourceMDX = resourceExp.getText(resourceToMDXMap);
                    coreExpression.append(resourceMDX);
                }
                catch (MetadataException me) {
                    return null;
                }
            }
            return coreExpression.toString();
        }
        catch (MetadataUnresolvedException mdue) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(mdue.getMessage(), (Throwable)mdue);
            }
            return null;
        }
    }

    private static String getExpressionText(ExpressionInterface expr) throws MetadataException {
        String expressionText = null;
        expressionText = OLAPStringExpressionUtil.getExpressionText(expr, null);
        return expressionText;
    }

    private static String getExpressionText(ExpressionInterface expr, String startingLevelName) throws MetadataException {
        OlapItem olapItem;
        String text = null;
        StringExpressionUtil stringExpressionUtil = StringExpressionUtil.getInstance();
        text = expr instanceof OlapItem ? ((olapItem = (OlapItem)expr) instanceof Hierarchy || olapItem instanceof Dimension || olapItem instanceof Level || olapItem instanceof Measure ? OLAPStringExpressionUtil.getCoreExpression(expr, startingLevelName) : stringExpressionUtil.getReadableText(expr)) : stringExpressionUtil.getReadableText(expr);
        return text;
    }

    private static String getDimensionExpression(Dimension dimension) {
        StringBuffer buildExpression = new StringBuffer();
        String defaultHierarchyName = null;
        try {
            defaultHierarchyName = dimension.getDefaultHierarchy();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXDefaultHierException.txt"), (Throwable)e);
            }
            return null;
        }
        List<Hierarchy> hierarchies = null;
        try {
            hierarchies = dimension.getHierarchies();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXHierException.txt"), (Throwable)e);
            }
            return null;
        }
        Iterator<Hierarchy> iterator = hierarchies.iterator();
        Hierarchy hierarchy = null;
        while (iterator.hasNext()) {
            hierarchy = iterator.next();
            String uniqueName = null;
            try {
                uniqueName = hierarchy.getHierarchyUniqueName();
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(IQMetadataResourceBundle.getStringResource("MDXUniqueHierException.txt"), (Throwable)e);
                }
                return null;
            }
            if (defaultHierarchyName != null && !defaultHierarchyName.equalsIgnoreCase(uniqueName)) continue;
            break;
        }
        if (hierarchy == null) {
            try {
                if (dimension.isInMeasureDimension()) {
                    StringExpressionUtil stringExpressionUtil = StringExpressionUtil.getInstance();
                    buildExpression.append(stringExpressionUtil.getReadableText(dimension));
                    return buildExpression.toString();
                }
            }
            catch (MetadataException e1) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(IQMetadataResourceBundle.getStringResource("MDXUniqueHierException.txt"), (Throwable)e1);
                }
                return null;
            }
        }
        List<Level> levels = null;
        try {
            levels = hierarchy.getLevels();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXHierLevelException.txt"), (Throwable)e);
            }
            return null;
        }
        if (levels == null || levels.size() == 0) {
            return null;
        }
        Level topLevel = levels.get(0);
        String levelName = null;
        try {
            levelName = topLevel.getLevelName();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXHierLevelNameException.txt"), (Throwable)e);
            }
            return null;
        }
        if (topLevel instanceof AllLevel || levelName.startsWith("All") && levels.size() > 1) {
            topLevel = levels.get(1);
        }
        StringExpressionUtil stringExpressionUtil = StringExpressionUtil.getInstance();
        String uniqueName = null;
        try {
            uniqueName = stringExpressionUtil.getReadableText(topLevel);
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXHierLevelNameException.txt"), (Throwable)e);
            }
            return null;
        }
        buildExpression.append(uniqueName);
        buildExpression.append(".");
        buildExpression.append("MEMBERS");
        return buildExpression.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String getHierarchyExpression(Hierarchy hierarchy, String startingLevelName) {
        buildExpression = new StringBuffer();
        topLevel = null;
        if (startingLevelName != null) {
            try {
                if (startingLevelName.equals("SAS_BIQ_DefaultMemberLevelName")) {
                    buildExpression.append("<<").append(hierarchy.getOwningDimension().getLabel()).append('.').append(hierarchy.getLabel()).append(">>").append(".DefaultMember.Level.Members");
                }
                if (startingLevelName == null) ** GOTO lbl18
                buildExpression.append("<<").append(hierarchy.getOwningDimension().getLabel()).append('.').append(hierarchy.getLabel()).append('.').append(startingLevelName).append(">>").append(".Members");
            }
            catch (MetadataException e) {
                if (OLAPStringExpressionUtil._logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    OLAPStringExpressionUtil._logger.error(IQMetadataResourceBundle.getStringResource("MDXHierDimensionNameException.txt"), (Throwable)e);
                }
                return null;
            }
        } else {
            topLevel = OLAPStringExpressionUtil.getTopLevel(hierarchy);
        }
lbl18:
        // 4 sources

        if (topLevel != null) {
            stringExpressionUtil = StringExpressionUtil.getInstance();
            uniqueName = null;
            try {
                uniqueName = stringExpressionUtil.getReadableText(topLevel);
            }
            catch (MetadataException e) {
                if (OLAPStringExpressionUtil._logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    OLAPStringExpressionUtil._logger.error(IQMetadataResourceBundle.getStringResource("MDXHierUniqueNameException.txt"), (Throwable)e);
                }
                return null;
            }
            buildExpression.append(uniqueName).append(".MEMBERS");
        }
        return buildExpression.toString();
    }

    private static Level getTopLevel(Hierarchy hierarchy) {
        List<Level> levels = null;
        try {
            levels = hierarchy.getLevels();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXHierLevelsException.txt"), (Throwable)e);
            }
            return null;
        }
        if (levels == null || levels.size() == 0) {
            return null;
        }
        Level topLevel = levels.get(0);
        String levelName = null;
        try {
            levelName = topLevel.getLevelName();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXLevelNameException.txt"), (Throwable)e);
            }
            return null;
        }
        if (topLevel instanceof AllLevel || levelName.startsWith("All") && levels.size() > 1) {
            topLevel = levels.get(1);
        }
        return topLevel;
    }

    private static String getLevelExpression(Level level) {
        String levelText;
        block2: {
            levelText = null;
            StringExpressionUtil stringExpressionUtil = StringExpressionUtil.getInstance();
            try {
                String levelTxt = stringExpressionUtil.getReadableText(level);
                StringBuffer buildExpression = new StringBuffer(levelTxt);
                buildExpression.append(".");
                buildExpression.append("MEMBERS");
                levelText = buildExpression.toString();
            }
            catch (MetadataException e) {
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXLevelNameException.txt.txt"), (Throwable)e);
            }
        }
        return levelText;
    }

    private static String getMeasureExpression(Measure measure) {
        String measureText;
        block2: {
            measureText = null;
            StringExpressionUtil stringExpressionUtil = StringExpressionUtil.getInstance();
            try {
                measureText = stringExpressionUtil.getReadableText(measure);
            }
            catch (MetadataException e) {
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("MDXLevelNameException.txt.txt"), (Throwable)e);
            }
        }
        return measureText;
    }
}

