/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalStateException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.DataItemContainerExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.metadata.serverprop.ParameterType;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.FunctionCallOptimizer;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
@NotThreadSafe
public class FunctionCall
extends AbstractExpression
implements DataItemContainerExpression,
BusinessModelResourceReferencer {
    public static final String EVENT_FUNCTION_CHANGED = "The FunctionCall function has changed";
    public static final String EVENT_ARGUMENTS_CHANGED = "The FunctionCall arguments have changed";
    private Function _function;
    private List<ExpressionInterface> _args;
    private int _hashCode = -1;

    public FunctionCall() {
        this._args = new ArrayList<ExpressionInterface>(4);
    }

    public FunctionCall(Function function, ExpressionInterface ... args) {
        this._function = Preconditions.ensureNonNull(function);
        this._args = new ArrayList<ExpressionInterface>(args.length);
        for (ExpressionInterface arg : args) {
            Preconditions.ensureNonNull(arg);
            arg.addListener(this);
            this._args.add(arg);
        }
    }

    public FunctionCall(Function function, List<? extends ExpressionInterface> arguments) {
        this._function = Preconditions.ensureNonNull(function);
        this._args = new ArrayList<ExpressionInterface>((Collection)Preconditions.ensureNonNull(arguments));
        for (ExpressionInterface expr : this._args) {
            expr.addListener(this);
        }
    }

    public Function getFunction() {
        return this._function;
    }

    public void setFunction(Function function) {
        this.changeableCheck();
        if (!IQModelImplUtilities.same(this._function, function)) {
            this._function = function;
            this._hashCode = -1;
            this.fireChangeEvent(EVENT_FUNCTION_CHANGED);
        }
    }

    public List<ExpressionInterface> getArguments() {
        assert (this._args != null);
        return new ArrayList<ExpressionInterface>(this._args);
    }

    public void setArguments(List<? extends ExpressionInterface> arguments) {
        List<ExpressionInterface> previous = this._args;
        this._args = new ArrayList<ExpressionInterface>((Collection)Preconditions.ensureNonNull(arguments));
        ArrayList<ExpressionInterface> removedArgs = new ArrayList<ExpressionInterface>(previous);
        removedArgs.removeAll(this._args);
        ArrayList<ExpressionInterface> addedArgs = new ArrayList<ExpressionInterface>(this._args);
        addedArgs.removeAll(previous);
        this.removeListeningTo(removedArgs);
        this.listenTo(addedArgs);
        this._hashCode = -1;
        this.fireChangeEvent(EVENT_ARGUMENTS_CHANGED);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        for (int i = 0; i < this._args.size(); ++i) {
            ExpressionInterface newExpr;
            ExpressionInterface arg = this._args.get(i);
            if (arg == (newExpr = (ExpressionInterface)Utils.replaceResource(arg, oldResource, newResource, model))) continue;
            arg.removeListener(this);
            newExpr.addListener(this);
            this._args.set(i, newExpr);
            this._hashCode = -1;
        }
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    public FunctionSignature getFunctionSignature() {
        if (this._function == null || this._args == null) {
            throw new IQueryServicesIllegalStateException(IQMetadataResourceBundle.getMessageFormatter("FunctionCall.NotFullyDefined.fmt.txt", this.toString()));
        }
        FunctionSignature fs = this._function.getCompatibleSignature(this._args);
        return fs;
    }

    @Override
    public int getExpressionType() {
        int expType = 0;
        FunctionSignature fs = this.getFunctionSignature();
        if (fs != null) {
            expType = fs.getReturnType().toExpressionType();
        }
        return expType;
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        FunctionCall clone = (FunctionCall)super.clone();
        assert (this._args != null);
        clone._args = new ArrayList<ExpressionInterface>(this._args);
        return clone;
    }

    @SASScope
    public String toString() {
        FunctionSignature signature;
        String syntaxTemplate = "null";
        if (this._function != null && (signature = this._function.getCompatibleSignature(this._args)) != null) {
            syntaxTemplate = signature.getSyntaxTemplateFor(this._args);
        }
        return MessageFormat.format(syntaxTemplate, this._args.toArray());
    }

    @Override
    public boolean containsUserTypedAggregation() throws MetadataException {
        ExpressionInterface cur;
        boolean rval = false;
        Iterator<ExpressionInterface> iterator = this._args.iterator();
        while (!(!iterator.hasNext() || (cur = iterator.next()) instanceof DataItemContainerExpression && (rval = ((DataItemContainerExpression)cur).containsUserTypedAggregation()))) {
        }
        return rval;
    }

    @Override
    public List<DataItem> getLeafDataItems() {
        LinkedHashSet<DataItem> leafItems = new LinkedHashSet<DataItem>();
        for (ExpressionInterface expr : this._args) {
            if (!(expr instanceof DataItemContainerExpression)) continue;
            DataItemContainerExpression containerExpr = (DataItemContainerExpression)expr;
            leafItems.addAll(containerExpr.getLeafDataItems());
        }
        return new ArrayList<DataItem>(leafItems);
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._function == null) {
            reasons.add(new Reason((Object)this, 2, 42, "FunctionCall.HasNullFunction.txt", new Object[0]));
        } else {
            FunctionSignature fs = this.getFunctionSignature();
            if (fs == null) {
                ArrayList<Object> parmTypes = new ArrayList<Object>();
                if (this._args == null) {
                    parmTypes.add(null);
                } else {
                    for (ExpressionInterface arg : this._args) {
                        if (arg == null) {
                            parmTypes.add(null);
                            continue;
                        }
                        boolean found = false;
                        int argType = arg.getExpressionType();
                        for (ParameterType parmType : ParameterType.ALL_PARAMETER_TYPES) {
                            int parmExprType = parmType.toExpressionType();
                            if (parmExprType == 0 || parmExprType != argType) continue;
                            parmTypes.add(parmType);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        parmTypes.add(argType + "(" + arg + ")");
                    }
                }
                if (parmTypes.size() > 0) {
                    reasons.add(new Reason((Object)this, 2, 43, "FunctionCall.HasNoFunctionSignatureForArgumentsGiven.fmt.txt", this.getFunction().getNameID(), new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, parmTypes.toArray()), this._args == null ? null : new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._args.toArray())));
                } else {
                    reasons.add(new Reason((Object)this, 2, 43, "FunctionCall.HasNoFunctionSignature.fmt.txt", this.getFunction().getNameID()));
                }
            } else if (!FunctionCallOptimizer.isReplaceable(this._function)) {
                for (ExpressionInterface arg : this._args) {
                    Prompt prompt;
                    boolean isSingle;
                    if (!(arg instanceof Prompt) || (isSingle = ExpressionUtil.isSingleSelectionPrompt(prompt = (Prompt)arg))) continue;
                    Reason multiValuePromptsNotSupported = new Reason((Object)this, 8, 88, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, prompt);
                    reasons.add(multiValuePromptsNotSupported);
                }
            } else {
                List<Prompt> prompts = this.getResources(Prompt.class, 0);
                for (Prompt prompt : prompts) {
                    if (!ExpressionUtil.isRangePrompt(prompt)) continue;
                    Reason multiValuePromptsNotSupported = new Reason((Object)this, 8, 88, "Expression.RangePromptsNotSupported.fmt.txt", this, prompt);
                    reasons.add(multiValuePromptsNotSupported);
                }
            }
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "FunctionCall";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        if (this._function != null) {
            String functionID = this._function.getID();
            IQModelImplUtilities.setAttr(thisElement, "ftn", functionID);
        }
        FunctionCall.writeRelatedObjects(this._args, thisElement, writingContext, "Args");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String functionID = attrsProvider.consumeAttr("ftn");
        if (functionID != null) {
            try {
                this._function = ServerProperties.getFunctionByFullID(functionID);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
            if (this._function == null) {
                this._function = new Function(functionID);
            }
        } else {
            this._function = null;
        }
        this._hashCode = -1;
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._args = riHolder.consumeObjects("Args", ExpressionInterface.class);
        this._hashCode = -1;
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String functionID = IQModelImplUtilities.getAttr(thisElement, "op");
        if (functionID != null) {
            this._function = ServerProperties.getFunctionByFullID(functionID);
            if (this._function == null) {
                this._function = new Function(functionID);
            }
        } else {
            this._function = null;
        }
        this._args = FunctionCall.v1_readItemListUnderSubelement(thisElement, readingContext, "FunctionArgs", new Class[]{ExpressionInterface.class});
        this._hashCode = -1;
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.addAll(this._args);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        FunctionCall.replaceInList(this._args, oldObject, newObject);
    }

    @SASScope
    public int hashCode() {
        if (this._hashCode < 0) {
            int result = 179;
            result = 37 * result + (this._function == null ? 0 : this._function.hashCode());
            result = 37 * result + (this._args == null ? 0 : this._args.hashCode());
            this._hashCode = result = 37 * result + 7;
        }
        return this._hashCode;
    }

    @SASScope
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        boolean results = super.equals(obj);
        if (!results && obj instanceof FunctionCall) {
            FunctionCall objValue = (FunctionCall)obj;
            results = this.hashCode() == objValue.hashCode();
        }
        return results;
    }
}

