/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public abstract class ConditionalExpression
extends AbstractExpression {
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_NEGATION_CHANGED = "The negation attribute has changed";
    private boolean _negateThisExpression = false;
    private static final int[] VALID_EXPRESSION_TYPES = new int[]{1, 9, 3, 4, 8, 7, 2, 5, 6};
    private static final boolean NOXML_NEGATE = false;

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isNegated() {
        return this._negateThisExpression;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setIsNegated(boolean flag) {
        if (this._negateThisExpression != flag) {
            this._negateThisExpression = flag;
            this.fireChangeEvent(EVENT_NEGATION_CHANGED);
        }
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public int getExpressionType() {
        return 9;
    }

    @SASScope
    protected ExpressionInterface singleReplaceResources(ExpressionInterface prevExpr, BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        ExpressionInterface newExpr = (ExpressionInterface)Utils.replaceResource(prevExpr, oldResource, newResource, model, recursive);
        this.moveListeningTo(prevExpr, newExpr);
        return newExpr;
    }

    @SASScope
    protected void singleReplaceResourcesInList(List<ExpressionInterface> resourceList, BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        for (int i = 0; i < resourceList.size(); ++i) {
            ExpressionInterface _obj = resourceList.get(i);
            if (_obj instanceof ExpressionInterface) {
                ExpressionInterface expression = _obj;
                ExpressionInterface newExp = this.singleReplaceResources(expression, oldResource, newResource, model, recursive);
                resourceList.set(i, newExp);
                continue;
            }
            if (!(_obj instanceof DataItem)) continue;
            DataItem da = (DataItem)_obj;
            ExpressionInterface daExpression = da.getExpression();
            ExpressionInterface newExp = this.singleReplaceResources(daExpression, oldResource, newResource, model, recursive);
            resourceList.set(i, newExp);
        }
    }

    @SASScope
    protected int[] getValidExpressionTypes() {
        return VALID_EXPRESSION_TYPES;
    }

    @SASScope
    protected boolean hasValidExpressionType(int exprType) {
        boolean valid = false;
        int[] validTypes = this.getValidExpressionTypes();
        for (int i = 0; i < validTypes.length && !valid; ++i) {
            if (exprType != validTypes[i]) continue;
            valid = true;
        }
        return valid;
    }

    @SASScope
    protected List<Reason> getReasonsUseOfExpressionWithTypeUnusable(int exprType) {
        if (!this.hasValidExpressionType(exprType)) {
            Reason reason = new Reason((Object)this, 2, 31, "Expression.ReferencesInvalidExpressionType.txt", new Object[0]);
            return Collections.singletonList(reason);
        }
        return Collections.emptyList();
    }

    @SASScope
    protected List<Reason> getReasonsExprIsUnusableAsExpressionArg(ExpressionInterface expr, String msgidIfNull) {
        if (expr == null) {
            Reason reason = new Reason((Object)this, 2, 32, msgidIfNull, new Object[0]);
            return Collections.singletonList(reason);
        }
        return Collections.emptyList();
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        IQModelImplUtilities.setBooleanAttr(thisElement, "negate", this._negateThisExpression, false);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._negateThisExpression = attrsProvider.consumeBooleanAttr("negate", false);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._negateThisExpression = IQModelImplUtilities.getBooleanAttr(thisElement, "neg", false);
    }
}

