/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.CascadableFilter;
import com.sas.iquery.metadata.business.FilterCascadeContainer;
import com.sas.iquery.metadata.business.FilterCascadeContainerUpdater;
import com.sas.iquery.metadata.business.FilterCascadeInterface;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class CompoundConditionalExpression
extends ConditionalExpression
implements FilterCascadeContainerUpdater,
CascadableFilter {
    public static final String EVENT_RELATION_TYPE_CHANGED = "Relation type changed";
    public static final String EVENT_LEFT_EXPRESSION_CHANGED = "Left expression changed";
    public static final String EVENT_RIGHT_EXPRESSION_CHANGED = "Right expression changed";
    private ExpressionInterface _leftExpr;
    private ConditionalRelationType _relationType;
    private ExpressionInterface _rightExpr;
    private List<FilterCascadeInterface> _filterCascades = new ArrayList<FilterCascadeInterface>();
    private static final Logger _logger = LogManager.getLogger(CompoundConditionalExpression.class);

    public ConditionalRelationType getRelationType() {
        return this._relationType;
    }

    public void setRelationType(ConditionalRelationType relationType) {
        this.changeableCheck();
        if (this._relationType != relationType) {
            this._relationType = relationType;
            this.fireChangeEvent(EVENT_RELATION_TYPE_CHANGED);
        }
    }

    public void setLeftExpression(ExpressionInterface condExpr) {
        this.changeableCheck();
        this.moveListeningTo(this._leftExpr, condExpr);
        this._leftExpr = condExpr;
        this.fireChangeEvent(EVENT_LEFT_EXPRESSION_CHANGED);
    }

    public ExpressionInterface getLeftExpression() {
        return this._leftExpr;
    }

    public void setRightExpression(ExpressionInterface condExpr) {
        this.changeableCheck();
        this.moveListeningTo(this._rightExpr, condExpr);
        this._rightExpr = condExpr;
        this.fireChangeEvent(EVENT_RIGHT_EXPRESSION_CHANGED);
    }

    public ExpressionInterface getRightExpression() {
        return this._rightExpr;
    }

    @Override
    public void setCascades(@Nonnull List<? extends FilterCascadeInterface> filterCascades) {
        if (filterCascades == null) {
            filterCascades = Collections.emptyList();
        }
        this._filterCascades.clear();
        this._filterCascades.addAll(filterCascades);
        Preconditions.ensureNonNullTypedElements(this._filterCascades, FilterCascadeInterface.class, _logger);
    }

    @Override
    public List<FilterCascadeInterface> getCascades(boolean recursive) {
        LinkedHashSet<FilterCascadeInterface> cascades = new LinkedHashSet<FilterCascadeInterface>(this._filterCascades);
        if (recursive) {
            if (this._leftExpr != null && this._leftExpr instanceof FilterCascadeContainer) {
                cascades.addAll(((FilterCascadeContainer)((Object)this._leftExpr)).getCascades(recursive));
            }
            if (this._rightExpr != null && this._rightExpr instanceof FilterCascadeContainer) {
                cascades.addAll(((FilterCascadeContainer)((Object)this._rightExpr)).getCascades(recursive));
            }
        }
        return new ArrayList<FilterCascadeInterface>(cascades);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._leftExpr = this.singleReplaceResources(this._leftExpr, oldResource, newResource, model, recursive);
        this._rightExpr = this.singleReplaceResources(this._rightExpr, oldResource, newResource, model, recursive);
        ListIterator<FilterCascadeInterface> cascadeIter = this._filterCascades.listIterator();
        while (cascadeIter.hasNext()) {
            ExpressionInterface newExp = this.singleReplaceResources((ExpressionInterface)((Object)cascadeIter.next()), oldResource, newResource, model, recursive);
            cascadeIter.set((FilterCascadeInterface)((Object)newExp));
        }
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        ExpressionInterface expr;
        CompoundConditionalExpression clone = (CompoundConditionalExpression)super.clone();
        if (!(this._leftExpr instanceof BusinessModelResource)) {
            expr = null;
            if (this._leftExpr != null) {
                expr = (ExpressionInterface)this._leftExpr.clone();
            }
            clone.setLeftExpression(expr);
        }
        if (!(this._rightExpr instanceof BusinessModelResource)) {
            expr = null;
            if (this._rightExpr != null) {
                expr = (ExpressionInterface)this._rightExpr.clone();
            }
            clone.setRightExpression(expr);
        }
        ArrayList<FilterCascadeInterface> deepCopy = new ArrayList<FilterCascadeInterface>(this._filterCascades);
        clone._filterCascades = deepCopy;
        return clone;
    }

    @SASScope
    public String toString() {
        if (this._rightExpr != null && this._leftExpr == null && this._relationType == null) {
            return (this.isNegated() ? "NOT (" : "(") + Utils.toString(this._rightExpr) + ")";
        }
        if (this._leftExpr != null && this._rightExpr == null && this._relationType == null) {
            return (this.isNegated() ? "NOT (" : "(") + Utils.toString(this._leftExpr) + ")";
        }
        return (this.isNegated() ? "NOT (" : "(") + Utils.toString(this._leftExpr) + " " + Utils.toString(this._relationType) + " " + Utils.toString(this._rightExpr) + ")";
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._leftExpr != null && this._rightExpr != null && this._relationType == null) {
            reasons.add(new Reason((Object)this, 2, 29, "CompoundConditionalExpression.HasNullRelationType.txt", new Object[0]));
        } else if (this._leftExpr == null && this._rightExpr == null) {
            reasons.add(new Reason((Object)this, 2, 30, "CompoundConditionalExpression.HasNullLeftAndRightExpressions.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "CompoundConditionalExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._relationType);
        CompoundConditionalExpression.writeRelatedObject(this._leftExpr, thisElement, writingContext, "LeftExpr");
        CompoundConditionalExpression.writeRelatedObject(this._rightExpr, thisElement, writingContext, "RightExpr");
        CompoundConditionalExpression.writeRelatedObjects(this._filterCascades, thisElement, writingContext, "FilterCascades");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._relationType = ConditionalRelationType.consumeValue(attrsProvider, "operator", null);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._leftExpr = (ExpressionInterface)((Object)riHolder.consumeObject("LeftExpr"));
        this._rightExpr = (ExpressionInterface)((Object)riHolder.consumeObject("RightExpr"));
        this._filterCascades.clear();
        this._filterCascades.addAll(riHolder.consumeObjects("FilterCascades", FilterCascadeInterface.class));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._relationType = ConditionalRelationType.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "op"));
        this._leftExpr = (ExpressionInterface)((Object)CompoundConditionalExpression.v1_readItemUnderSubelement(thisElement, readingContext, "LeftExpr", VALID_TYPES_ANY_EXPRESSION));
        this._rightExpr = (ExpressionInterface)((Object)CompoundConditionalExpression.v1_readItemUnderSubelement(thisElement, readingContext, "RightExpr", VALID_TYPES_ANY_EXPRESSION));
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._leftExpr != null) {
            intoList.add(this._leftExpr);
        }
        if (this._rightExpr != null) {
            intoList.add(this._rightExpr);
        }
        if (this._filterCascades != null) {
            intoList.addAll(this._filterCascades);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._leftExpr = (ExpressionInterface)CompoundConditionalExpression.replace(this._leftExpr, oldObject, newObject);
        this._rightExpr = (ExpressionInterface)CompoundConditionalExpression.replace(this._rightExpr, oldObject, newObject);
        ListIterator<FilterCascadeInterface> filterCascadesIter = this._filterCascades.listIterator();
        while (filterCascadesIter.hasNext()) {
            FilterCascadeInterface filterCascade = filterCascadesIter.next();
            if (filterCascade != oldObject) continue;
            filterCascadesIter.set((FilterCascadeInterface)newObject);
        }
    }

    @Override
    public ExpressionInterface getExpression() {
        return this;
    }
}

