/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MonotonicIntegerToStringMapping;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class DataItemRankFilter
extends BaseFilter {
    public static final String EVENT_BY_RANK_ORDER_CHANGED = "By rank order changed";
    public static final String EVENT_BY_RANK_TYPE_CHANGED = "By rank type changed";
    public static final String EVENT_VALUE_CHANGED = "Value changed";
    private int _rankOrder;
    private int _rankType;
    private int _value;
    private boolean _includeTies = false;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int COUNT = 0;
    public static final int PERCENT = 1;
    public static final int SUM = 2;
    private static final String[] RANK_ORDER_PERSISTENCE_VALUES = new String[]{"TOP", "BOTTOM"};
    private static final int[] RANK_ORDER_MODEL_INT_VALUES = new int[]{0, 1};
    private static final String[] RANK_TYPE_PERSISTENCE_VALUES = new String[]{"COUNT"};
    private static final int[] RANK_TYPE_MODEL_INT_VALUES = new int[]{0};
    private static final MonotonicIntegerToStringMapping rankOrderPersistor = new MonotonicIntegerToStringMapping(RANK_ORDER_PERSISTENCE_VALUES, RANK_ORDER_MODEL_INT_VALUES);
    private static final MonotonicIntegerToStringMapping rankTypePersistor = new MonotonicIntegerToStringMapping(RANK_TYPE_PERSISTENCE_VALUES, RANK_TYPE_MODEL_INT_VALUES);
    private static final Logger _logger = LogManager.getLogger(DataItemRankFilter.class);

    public DataItemRankFilter(int rankOrder, int value) {
        this.setRankType(0);
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    public DataItemRankFilter(int rankOrder, int value, boolean includeTies) {
        this.setRankType(0);
        this._includeTies = includeTies;
        this.setRankOrder(rankOrder);
        this.setValue(value);
    }

    @SASScope
    public DataItemRankFilter() {
    }

    public boolean isIncludeTies() {
        return this._includeTies;
    }

    public void setRankOrder(int rankOrder) {
        this.changeableCheck();
        if (rankOrder < 0 || rankOrder >= RANK_ORDER_PERSISTENCE_VALUES.length) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataItemRankBadRankOrder.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this._rankOrder = rankOrder;
        this.fireChangeEvent(EVENT_BY_RANK_ORDER_CHANGED);
    }

    public int getRankOrder() {
        return this._rankOrder;
    }

    public void setRankType(int rankType) {
        this.changeableCheck();
        if (rankType != 0 && _logger.isEnabled(Level.ERROR)) {
            _logger.error(IQModelImplUtilities.getMessage("DataItemRankFilterNoSetRankType.txt", new Object[0]));
        }
        this._rankType = 0;
        this.fireChangeEvent(EVENT_BY_RANK_TYPE_CHANGED);
    }

    public int getRankType() {
        return 0;
    }

    public void setValue(int value) {
        this.changeableCheck();
        if (this._value != value) {
            this._value = value;
            this.fireChangeEvent(EVENT_VALUE_CHANGED);
        }
    }

    public int getValue() {
        return this._value;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataItemRelationalRankFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "rankOrder", rankOrderPersistor.stringValue(this._rankOrder));
        IQModelImplUtilities.setAttr(thisElement, "rankType", rankTypePersistor.stringValue(this._rankType));
        IQModelImplUtilities.setIntAttr(thisElement, "rankValue", this._value);
        IQModelImplUtilities.setBooleanAttr(thisElement, "rankIncludeTies", this._includeTies, false);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._rankOrder = attrsProvider.consumeIntWrittenAsString("rankOrder", rankOrderPersistor, 0);
        this._value = attrsProvider.consumeIntAttr("rankValue", 0);
        this._rankType = attrsProvider.consumeIntWrittenAsString("rankType", rankTypePersistor, 0);
        this._includeTies = attrsProvider.consumeBooleanAttr("rankIncludeTies", false);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        String rankOrderStr = IQModelImplUtilities.getAttr(thisElement, "rankOrder");
        this._rankOrder = rankOrderPersistor.intValue(rankOrderStr, 0);
        String rankTypeStr = IQModelImplUtilities.getAttr(thisElement, "rankType");
        this._rankType = rankTypePersistor.intValue(rankTypeStr, 0);
        this._value = IQModelImplUtilities.getIntAttr(thisElement, "rankValue", 0);
        this._includeTies = IQModelImplUtilities.getBooleanAttr(thisElement, "rankIncludeTies", false);
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @SASScope
    public String toString(Locale locale) {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("DataItemRankFilterRelational.toString.fmt.txt", this.actionTypeMessageFormatter(), this._rankOrder, this._value, this._rankType, this._includeTies ? 1 : 0);
        return message.getMessage(locale);
    }
}

