/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class StepManager {
    private static final Logger _logger = LogManager.getLogger((String)"com.sas.iquery.metadata.business.step");

    public static void addStep(@Nonnull StepInterface step, @Nonnull List<? super StepInterface> steps) {
        Preconditions.ensureNonNull(step, _logger);
        Preconditions.ensureNonNull(steps, _logger);
        steps.add(step);
    }

    public static StepInterface getStep(int stepNumber, List<? extends StepInterface> steps) {
        int stepNum = steps.size();
        if (stepNum > 0) {
            --stepNum;
        }
        if (stepNumber > stepNum) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("StepsInvalidStep.txt"));
            }
            return null;
        }
        StepInterface step = null;
        step = stepNumber == -1 ? steps.get(0) : (stepNumber == -999 ? steps.get(stepNum) : steps.get(stepNumber));
        return step;
    }

    public static List<StepInterface> getSteps(List<StepInterface> steps) {
        return new ArrayList<StepInterface>(steps);
    }

    public static void setSteps(@Nullable List<? extends StepInterface> setOfSteps, @Nonnull List<? super StepInterface> steps) {
        Preconditions.ensureNonNull(steps, _logger);
        steps.clear();
        if (setOfSteps != null) {
            steps.addAll(setOfSteps);
        }
    }

    public static void removeStep(int stepNumber, List steps) {
        int stepNum = steps.size();
        if (stepNum > 0) {
            --stepNum;
        }
        if (stepNumber > stepNum) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("StepsInvalidStep.txt"));
            }
            return;
        }
        if (stepNumber == -1) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("StepsInvalidStep.txt"));
            }
            return;
        }
        if (stepNumber == -1) {
            steps.remove(0);
        } else if (stepNumber == -999) {
            steps.remove(stepNum);
        } else {
            steps.remove(stepNumber);
        }
    }
}

