/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MemberLevelComparator;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.embedded.OLAPDataSet;
import java.util.Arrays;
import java.util.List;

@SASScope
public class DrillUtil {
    public static void drillUp(DataItem dataItem) {
        int lastStepIndex;
        StepInterface lastStep;
        List<StepInterface> steps;
        if (dataItem != null && dataItem.hasSteps() && (steps = dataItem.getSteps()).size() > 0 && (lastStep = steps.get(lastStepIndex = steps.size() - 1)) instanceof StepFilterInterface && ((StepFilterInterface)lastStep).getActionType() == 0) {
            dataItem.removeStep(lastStepIndex);
        }
    }

    public static void drillToLevel(DataItem dataItem) {
        if (dataItem != null) {
            int breakpoint = -1;
            if (dataItem.hasSteps()) {
                int i;
                List<StepInterface> steps = dataItem.getSteps();
                for (i = 0; i < steps.size(); ++i) {
                    StepInterface obj = steps.get(i);
                    if (obj instanceof DataItemDataBasedFilter || obj instanceof DataItemMemberFilter || obj instanceof DataItemMemberPropertiesFilter || obj instanceof DataItemRankFilter || obj instanceof DataItemTimeFilter || obj instanceof DataItemTimeRangeFilter) continue;
                    breakpoint = i;
                    break;
                }
                if (breakpoint > -1) {
                    for (i = steps.size() - 1; i >= breakpoint; --i) {
                        dataItem.removeStep(i);
                    }
                }
            }
        }
    }

    public static void drillToMember(DataItem dataItem, String uniqueMemberName, OLAPDataSetInterface model) throws OLAPException, MetadataException {
        if (dataItem != null) {
            int breakpoint = -1;
            if (dataItem.hasSteps()) {
                int i;
                List<StepInterface> steps = dataItem.getSteps();
                for (i = 0; i < steps.size(); ++i) {
                    StepInterface obj = steps.get(i);
                    if (obj instanceof DataItemDataBasedFilter || obj instanceof DataItemMemberFilter || obj instanceof DataItemMemberPropertiesFilter || obj instanceof DataItemRankFilter || obj instanceof DataItemTimeFilter || obj instanceof DataItemTimeRangeFilter) continue;
                    breakpoint = i;
                    break;
                }
                if (breakpoint > -1) {
                    for (i = steps.size() - 1; i >= breakpoint; --i) {
                        dataItem.removeStep(i);
                    }
                }
            }
        }
        MemberInterface[] members = null;
        if (model != null && uniqueMemberName != null && !(model instanceof OLAPDataSet)) {
            MetadataInterface metadata = model.getDatabaseMetadata();
            String cubeName = model.getCubeName();
            if (cubeName != null && metadata != null) {
                Filter filter = new Filter();
                filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                filter.setUniqueMemberName(uniqueMemberName);
                filter.setCubeName(cubeName);
                members = metadata.getMembers(filter, 0, -1);
                Arrays.sort(members, MemberLevelComparator.defaultInstance);
            }
        }
        if (members != null) {
            for (int i = 0; i < members.length; ++i) {
                if (OLAPUtil.isAllLevel((LevelInterface)members[i].getLevel())) continue;
                DataItemNavigationFilter step = new DataItemNavigationFilter(4, members[i].getUniqueName());
                step.setActionType(0);
                dataItem.addStep(step);
            }
        }
    }
}

