/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class DataItemMemberPropertiesFilter
extends BaseFilter
implements BusinessModelResourceReferencer {
    public static final String EVENT_MEMBER_PROPERTY_NAME_CHANGED = "Member property name changed";
    public static final String EVENT_RIGHT_EXPRESSION_CHANGED = "Right expression changed";
    public static final String EVENT_COMPARISON_OPERATOR_CHANGED = "Comparison operator changed";
    private String _memberPropertyName;
    private ComparisonOperator _operator;
    @Nonnull
    private List<NonCalculatedValue> _rightExpressionList = new ArrayList<NonCalculatedValue>();
    private static final Logger _logger = LogManager.getLogger(DataItemMemberPropertiesFilter.class);

    public DataItemMemberPropertiesFilter() {
    }

    public DataItemMemberPropertiesFilter(@Nonnull String memberPropertyName, @Nonnull ComparisonOperator operator, @Nonnull Object value) {
        this.setMemberPropertyName(memberPropertyName);
        this.setOperator(operator);
        if (value != null) {
            StringExpression valueExpression = new StringExpression();
            valueExpression.setText(value.toString());
            valueExpression.setExpressionType(3);
            this.setRightExpression(Collections.singletonList(valueExpression));
        }
    }

    public void setMemberPropertyName(String nameOfProperty) {
        this._memberPropertyName = nameOfProperty;
        this.fireChangeEvent(EVENT_MEMBER_PROPERTY_NAME_CHANGED);
    }

    public void setMemberPropertyNameExpression(String nameOfProperty) {
        this.setMemberPropertyName(nameOfProperty);
    }

    public String getMemberPropertyName() {
        return this._memberPropertyName;
    }

    public String getmemberPropertyNameExpression() {
        return this.getMemberPropertyName();
    }

    public void setOperator(ComparisonOperator operator) {
        if (operator == null) {
            MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("DataItemMemberPropertiesFilterBadOperator.txt", new Object[0]);
            _logger.error((Object)errorMsg);
            throw new IQueryServicesIllegalArgumentException(errorMsg);
        }
        this._operator = operator;
        this.fireChangeEvent(EVENT_COMPARISON_OPERATOR_CHANGED);
    }

    public ComparisonOperator getOperator() {
        return this._operator;
    }

    public void setRightExpression(List<? extends NonCalculatedValue> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        this._rightExpressionList.clear();
        this._rightExpressionList.addAll(values);
        for (NonCalculatedValue o : this._rightExpressionList) {
            if (o instanceof NonCalculatedValue) continue;
            Object[] msgArgs = new Object[]{o == null ? "null" : o.getClass().getName(), NonCalculatedValue.class.getName()};
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.ImproperObjTypeSpecified.fmt.txt", msgArgs));
        }
        this.fireChangeEvent(EVENT_RIGHT_EXPRESSION_CHANGED);
    }

    public List<NonCalculatedValue> getRightExpression() {
        return new ArrayList<NonCalculatedValue>(this._rightExpressionList);
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(@Nonnull List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._rightExpressionList == null || this._rightExpressionList.size() == 0) {
            reasons.add(new Reason((Object)this, 2, 95, "DataItemMemberPropertiesFilterEmptyRight.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        ListIterator<NonCalculatedValue> rightIterator = this._rightExpressionList.listIterator();
        while (rightIterator.hasNext()) {
            ExpressionInterface newExp = this.singleReplaceResources((ExpressionInterface)((Object)rightIterator.next()), oldResource, newResource, model, recursive);
            rightIterator.set((NonCalculatedValue)((Object)newExp));
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataItemMemberPropertiesFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._operator);
        IQModelImplUtilities.setAttr(thisElement, "memberPropertyName", this._memberPropertyName);
        DataItemMemberPropertiesFilter.writeRelatedObjects(this._rightExpressionList, thisElement, writingContext, "RightExprs");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._operator = ComparisonOperator.consumeValue(attrsProvider, "operator", null);
        this._memberPropertyName = attrsProvider.consumeAttr("memberPropertyName");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._rightExpressionList.clear();
        this._rightExpressionList.addAll(riHolder.consumeObjects("RightExprs", NonCalculatedValue.class));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._operator = ComparisonOperator.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "operator"));
        this._memberPropertyName = IQModelImplUtilities.getAttr(thisElement, "memberPropertyName");
        this._rightExpressionList.clear();
        this._rightExpressionList.addAll(DataItemMemberPropertiesFilter.v1_readItemListUnderSubelement(thisElement, readingContext, "RightFilterExprList", VALID_TYPES_NONCALCULATED_VALUE));
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        intoList.addAll(this._rightExpressionList);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        ListIterator<NonCalculatedValue> rightExpressionIterator = this._rightExpressionList.listIterator();
        while (rightExpressionIterator.hasNext()) {
            NonCalculatedValue ncv = rightExpressionIterator.next();
            if (ncv != oldObject) continue;
            rightExpressionIterator.set((NonCalculatedValue)newObject);
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        DataItemMemberPropertiesFilter clone = (DataItemMemberPropertiesFilter)super.clone();
        clone._rightExpressionList = new ArrayList<NonCalculatedValue>(this._rightExpressionList.size());
        clone.setRightExpression(DataItemMemberPropertiesFilter.cloneReferencedExpressionList(this._rightExpressionList));
        return clone;
    }

    @SASScope
    public String toString(Locale locale) {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("DataItemMemberPropertiesFilter.toString.fmt.txt", this.actionTypeMessageFormatter(), this._memberPropertyName, this._operator, new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._rightExpressionList == null ? null : this._rightExpressionList.toArray()));
        return message.getMessage(locale);
    }
}

