/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MonotonicIntegerToStringMapping;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class DataItemMemberFilter
extends BaseFilter
implements BusinessModelResourceReferencer {
    public static final String EVENT_MEMBER_FILTER_TYPE_CHANGED = "Member filter type changed";
    public static final String EVENT_MEMBER_NAMES_CHANGED = "Member names changed";
    public static final String EVENT_NEGATION_CHANGED = "The negation attribute has changed";
    @NonNull
    private List<NonCalculatedValue> _memberNames = new ArrayList<NonCalculatedValue>();
    private int _memberFilterType;
    private boolean _negateThisExpression = false;
    private Locale _memberLocale = null;
    public static final int LIST_MEMBER_FILTER_TYPE = 0;
    public static final int RANGE_MEMBER_FILTER_TYPE = 1;
    private static final Logger _logger = LogManager.getLogger(DataItemMemberFilter.class);
    private static final String[] TYPE_PERSISTENCE_VALUES = new String[]{"LIST_MEMBER_FILTER", "RANGE_MEMBER_FILTER"};
    private static final int[] TYPE_MODEL_INT_VALUES = new int[]{0, 1};
    private static final MonotonicIntegerToStringMapping valuePersistor = new MonotonicIntegerToStringMapping(TYPE_PERSISTENCE_VALUES, TYPE_MODEL_INT_VALUES);

    public DataItemMemberFilter() {
        this(new String[0], 0);
    }

    public DataItemMemberFilter(@NonNull String[] memberNames, int memberFilterType) {
        this.setMemberFilterType(memberFilterType);
        ArrayList<StringExpression> memberNameList = new ArrayList<StringExpression>();
        if (memberNames != null) {
            for (String s : memberNames) {
                StringExpression member = new StringExpression();
                member.setText(s);
                member.setExpressionType(3);
                memberNameList.add(member);
            }
        }
        this.setMemberNames(memberNameList);
    }

    public void setMemberFilterType(int memberFilterType) {
        if (memberFilterType < 0 || memberFilterType >= TYPE_PERSISTENCE_VALUES.length) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataItemMemberFilterBadFilter.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this._memberFilterType = memberFilterType;
        this.fireChangeEvent(EVENT_MEMBER_FILTER_TYPE_CHANGED);
    }

    public int getMemberFilterType() {
        return this._memberFilterType;
    }

    public boolean isNegated() {
        return this._negateThisExpression;
    }

    public void setIsNegated(boolean flag) {
        if (flag != this._negateThisExpression) {
            this._negateThisExpression = flag;
            this.fireChangeEvent(EVENT_NEGATION_CHANGED);
        }
    }

    public void setMemberNames(List<? extends NonCalculatedValue> memberNames, Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        this._memberLocale = locale;
        if (memberNames == null) {
            memberNames = Collections.emptyList();
        }
        this._memberNames.clear();
        this._memberNames.addAll(memberNames);
        for (NonCalculatedValue o : this._memberNames) {
            if (o instanceof NonCalculatedValue) continue;
            Object[] msgArgs = new Object[]{o == null ? "null" : o.getClass().getName(), NonCalculatedValue.class.getName()};
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.ImproperObjTypeSpecified.fmt.txt", msgArgs));
        }
        this.fireChangeEvent(EVENT_MEMBER_NAMES_CHANGED);
    }

    public void setMemberNames(List<? extends NonCalculatedValue> memberNames) {
        this.setMemberNames(memberNames, null);
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    public List<NonCalculatedValue> getMemberNames() {
        return new ArrayList<NonCalculatedValue>(this._memberNames);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        ListIterator<NonCalculatedValue> memberIterator = this._memberNames.listIterator();
        while (memberIterator.hasNext()) {
            ExpressionInterface expression = (ExpressionInterface)((Object)memberIterator.next());
            ExpressionInterface newExp = (ExpressionInterface)Utils.replaceResource(expression, oldResource, newResource, model, recursive);
            memberIterator.set((NonCalculatedValue)((Object)newExp));
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataItemMemberFilter";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "negate", this._negateThisExpression, false);
        if (this._memberFilterType != 0) {
            IQModelImplUtilities.setAttr(thisElement, "filterMemberType", valuePersistor.stringValue(this._memberFilterType));
        }
        DataItemMemberFilter.writeRelatedObjects(this._memberNames, thisElement, writingContext, "MemberFilters");
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._negateThisExpression = attrsProvider.consumeBooleanAttr("negate", false);
        this._memberFilterType = attrsProvider.consumeIntWrittenAsString("filterMemberType", valuePersistor, 0);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._memberNames.clear();
        this._memberNames.addAll(riHolder.consumeObjects("MemberFilters", NonCalculatedValue.class));
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._negateThisExpression = IQModelImplUtilities.getBooleanAttr(thisElement, "NegativeCompoundStep", false);
        String filterTypeStr = IQModelImplUtilities.getAttr(thisElement, "filterMemberType");
        this._memberFilterType = valuePersistor.intValue(filterTypeStr, 0);
        this._memberNames.clear();
        this._memberNames.addAll(DataItemMemberFilter.v1_readItemListUnderSubelement(thisElement, readingContext, "memberFilterList", VALID_TYPES_NONCALCULATED_VALUE));
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._memberNames == null || this._memberNames.size() == 0) {
            reasons.add(new Reason((Object)this, 2, 63, "DataItemMemberFilterEmptyMemberNames.txt", new Object[0]));
        }
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        intoList.addAll(this._memberNames);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        ListIterator<NonCalculatedValue> memberIterator = this._memberNames.listIterator();
        while (memberIterator.hasNext()) {
            NonCalculatedValue ncv = memberIterator.next();
            if (ncv != oldObject) continue;
            memberIterator.set((NonCalculatedValue)newObject);
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        DataItemMemberFilter clone = (DataItemMemberFilter)super.clone();
        clone._memberNames = new ArrayList<NonCalculatedValue>(this._memberNames.size());
        clone.setMemberNames(DataItemMemberFilter.cloneReferencedExpressionList(this._memberNames));
        return clone;
    }

    @SASScope
    public String toString(Locale locale) {
        MessageFormatter message = IQModelImplUtilities.getMessageFormatter("DataItemMemberFilter.toString.fmt.txt", this.actionTypeMessageFormatter(), this._memberFilterType, this._negateThisExpression ? 1 : 0, new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, this._memberNames == null ? null : this._memberNames.toArray()));
        return message.getMessage(locale);
    }
}

