/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.step.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MonotonicIntegerToStringMapping;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.AppliedFilter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.util.LocalizableString;
import com.sas.util.LocalizableToStringInterface;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public abstract class BaseFilter
extends AbstractModelItem
implements StepFilterInterface,
Cloneable,
LocalizableToStringInterface {
    private static final int[] ACTION_TYPE_MODEL_INT_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final String[] ACTION_TYPE_PERSISTENCE_VALUES = new String[]{"INITIAL", "APPEND", "PREPEND", "INSERT", "DIFFERENCE", "INTERSECT", "SPECIAL", "UNION"};
    public static final String EVENT_ACTION_TYPE_CHANGED = "Action type changed";
    public static final String EVENT_LOCALIZABLE_LABELS_CHANGED = "localizable label changed";
    private static final MonotonicIntegerToStringMapping valuePersistor = new MonotonicIntegerToStringMapping(ACTION_TYPE_PERSISTENCE_VALUES, ACTION_TYPE_MODEL_INT_VALUES);
    @SASScope
    protected int _actionType = 0;
    @SASScope
    protected CompoundStep _compoundStep;
    private LocalizableString _labels = null;
    private static final Logger _logger = LogManager.getLogger(BaseFilter.class);

    @SASScope
    protected LocalizableString _getLabels() {
        if (this._labels == null) {
            this._labels = new LocalizablePersistableString();
        }
        return this._labels;
    }

    public List<QualifiedLevel> getLevels(MetadataInterface metadata, DataItem dataItem) {
        return Collections.emptyList();
    }

    public String getDisplayedText(MetadataInterface metadata, DataItem dataItem, boolean showPromptValues, Locale locale) {
        IQMetadataInterface iqMetadataInterface;
        BusinessModel businessModel;
        String returnValue = this.toString();
        if (metadata instanceof IQMetadataInterface && (businessModel = (iqMetadataInterface = (IQMetadataInterface)metadata).getRelatedBusinessModel()) instanceof DataSelection) {
            DataSelection ds = (DataSelection)businessModel;
            returnValue = AppliedFilter.getOLAPDataItemStepFilterDescription(ds, dataItem, this, iqMetadataInterface, showPromptValues, locale);
        }
        return returnValue;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._actionType != 0) {
            IQModelImplUtilities.setAttr(thisElement, "actionType", valuePersistor.stringValue(this._actionType));
        }
        if (this._labels != null && (this._labels.getLocales().size() > 0 || this._labels.getDefaultLocale() != null)) {
            BaseFilter.writeForeignObjectUnderNewSubelement(this._labels, thisElement, writingContext, "Labels");
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._labels = (LocalizableString)riHolder.consumeForeignObject("Labels");
        if (this._labels == null) {
            this._labels = new LocalizablePersistableString();
        }
    }

    private void _updateLocalizableString(LocalizableString localizableString, Locale locale, String text, String propertyChangeEventId) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        if (localizableString != null) {
            List knownLocales = localizableString.getLocales();
            if (text == null) {
                if (knownLocales.contains(locale)) {
                    this.changeableCheck();
                    localizableString.clearText(locale);
                    this.fireChangeEvent(propertyChangeEventId, locale, null);
                }
            } else if (!knownLocales.contains(locale)) {
                this.changeableCheck();
                localizableString.setText(text, locale);
                this.fireChangeEvent(propertyChangeEventId, null, locale);
            } else {
                String oldText = localizableString.getText(locale);
                if (!IQModelImplUtilities.same(oldText, text)) {
                    this.changeableCheck();
                    localizableString.setText(text, locale);
                    this.fireChangeEvent(propertyChangeEventId, locale, locale);
                }
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        this.accumulateReasonsPromptsAreUnusable(reasons);
    }

    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
    }

    @SASScope
    protected MessageFormatter actionTypeMessageFormatter() {
        return IQModelImplUtilities.getMessageFormatter("BaseFilter.ActionType.toString.fmt.txt", this._actionType);
    }

    @Override
    public int getActionType() {
        return this._actionType;
    }

    @Deprecated
    @SASScope
    public CompoundStep getCompoundStep() {
        return this._compoundStep;
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._actionType = attrsProvider.consumeIntWrittenAsString("actionType", valuePersistor, 0);
    }

    @SASScope
    public String getLabel(Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        LocalizableString labels = this._labels;
        String result = null;
        if (labels != null) {
            result = labels.getText(locale);
        }
        if (result == null) {
            result = this._labels.toString();
        }
        return result;
    }

    @Override
    @SASScope
    public String getLabel() {
        Locale locale = LocaleUtilities.getDefaultViewerLocale();
        return this.getLabel(locale);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String actionTypeStr = IQModelImplUtilities.getAttr(thisElement, "actionType");
        this._actionType = valuePersistor.intValue(actionTypeStr, 0);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    public void setActionType(int inActionType) {
        if (inActionType >= 0 && inActionType < ACTION_TYPE_PERSISTENCE_VALUES.length) {
            this._actionType = inActionType;
        } else {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQModelImplUtilities.getMessage("BaseFilterBadDataAction.txt", new Object[0]));
            }
            this._actionType = 0;
        }
        this.fireChangeEvent(EVENT_ACTION_TYPE_CHANGED);
    }

    @SASScope
    public void setCompoundStep(CompoundStep compoundStep) {
        this._compoundStep = compoundStep;
    }

    @SASScope
    public void setLabel(String label, Locale locale) {
        LocalizableString labels = this._getLabels();
        this._updateLocalizableString(labels, locale, label, EVENT_LOCALIZABLE_LABELS_CHANGED);
    }

    @Override
    @SASScope
    public void setLabel(String label) {
        Locale locale = LocaleUtilities.getDefaultViewerLocale();
        this.setLabel(label, locale);
    }

    @SASScope
    protected ExpressionInterface singleReplaceResources(ExpressionInterface prevExpr, BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        ExpressionInterface newExpr = (ExpressionInterface)Utils.replaceResource(prevExpr, oldResource, newResource, model, recursive);
        if (prevExpr != newExpr) {
            if (prevExpr != null) {
                prevExpr.removeListener(this);
            }
            if (newExpr != null) {
                newExpr.addListener(this);
            }
        }
        return newExpr;
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return null;
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @SASScope
    public String toString() {
        return this.toString(null);
    }
}

