/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.thread;

import com.sas.iquery.metadata.business.impl.thread.ThreadPool;
import com.sas.iquery.metadata.business.impl.thread.WorkerThreadInterface;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

final class WorkerThread
extends Thread
implements WorkerThreadInterface {
    private Object _lock = new Object();
    private Runnable _currentWork;
    private boolean _dying;
    private ThreadPool _myPool;
    private SecurityContext _securityContext;
    private static final Logger _logger = LogManager.getLogger(WorkerThread.class);

    public WorkerThread(ThreadPool myPool, String name) {
        super(name);
        this.setDaemon(true);
        this._myPool = myPool;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAsynchronously(Runnable work) {
        Object object = this._lock;
        synchronized (object) {
            this._currentWork = work;
            this.captureSecurityContext();
            this._lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForWorkToComplete(Runnable previousWorkAssignment) {
        if (previousWorkAssignment == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                while (this._currentWork == previousWorkAssignment) {
                    this._lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForWorkToComplete(Runnable previousWorkAssignment, long timeoutMSec) {
        if (previousWorkAssignment == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                long now = WorkerThread.now();
                long expire = now + timeoutMSec;
                while (this._currentWork == previousWorkAssignment && now < expire) {
                    long waitTime = Math.max(1L, expire - now);
                    this._lock.wait(waitTime);
                    now = WorkerThread.now();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNewWork() {
        try {
            Object object = this._lock;
            synchronized (object) {
                while (this._currentWork == null && !this._dying) {
                    this._lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCurrentWorkNow() {
        if (this._currentWork != null) {
            try {
                this.reestablishSecurityContext();
                this._currentWork.run();
            }
            catch (Throwable t) {
                StringBuffer msg = new StringBuffer(200);
                msg.append("\n** client of THREAD POOL threw unexpected exception");
                msg.append("\n** " + t.getClass().getName());
                msg.append("\n** " + (t.getMessage() != null ? t.getMessage() : ""));
                msg.append("\n** work item class: " + this._currentWork.getClass());
                try {
                    msg.append("\n** work item toString(): " + this._currentWork.toString());
                }
                catch (RuntimeException e) {
                    msg.append("--worker toString() threw exception too [").append(e).append("]");
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(msg.toString());
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug(msg.toString(), t);
                }
            }
            finally {
                Object object = this._lock;
                synchronized (object) {
                    this.cleanseThread();
                    this._currentWork = null;
                    this._lock.notifyAll();
                }
            }
            this._myPool.readyForNewAssignment(this);
        }
    }

    private void cleanseThread() {
        SecurityContextHolder.clearContext();
        this._securityContext = null;
    }

    private void captureSecurityContext() {
        this._securityContext = SecurityContextHolder.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reestablishSecurityContext() {
        Object object = this._lock;
        synchronized (object) {
            if (this._securityContext != null) {
                SecurityContextHolder.setContext((SecurityContext)this._securityContext);
            }
        }
    }

    @Override
    public void run() {
        block1: {
            while (true) {
                this.waitForNewWork();
                if (this._currentWork == null) break;
                this.doCurrentWorkNow();
            }
            if (this._dying) break block1;
            this._myPool.workerPhonesInSick(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateWhenCurrentWorkCompletes() {
        Object object = this._lock;
        synchronized (object) {
            this._dying = true;
            this._lock.notifyAll();
        }
    }
}

