/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.security.BaseEventMessage;
import com.sas.iquery.metadata.business.impl.security.TableColumnInfo;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableInfoServiceResponse
extends BaseEventMessage {
    public static final String ELEMENT_INFO_RESPONSE = "TableInfoServiceResponse";
    public static final String ELEMENT_IS_AUTHORIZED = "IsAuthorized";
    public static final String ELEMENT_FILTER = "Filter";
    public static final String ELEMENT_AUTHORIZED_COLS = "AuthorizedColumns";
    public static final String ELEMENT_COLUMN = "Column";
    public static final String ELEMENT_IS_SESSION_UP = "IsSessionAvailable";
    public static final String ELEMENT_ERROR = "Error";
    public static final String ATTRIBUTE_TABLE = "table";
    public static final String ATTRIBUTE_LIBREF = "libref";
    public static final String ATTRIBUTE_PATH = "path";
    public static final String ATTRIBUTE_ACCESS_ID = "accessID";
    public static final String ATTRIBUTE_ACCESS_PWD = "accessPassword";
    public static final String ATTRIBUTE_REPOSITORYID = "reposID";
    public static final String ATTRIBUTE_REPOSITORYNAME = "reposName";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_LENGTH = "length";
    public static final String ATTRIBUTE_FORMAT = "format";
    public static final String ATTRIBUTE_INFORMAT = "informat";
    private static final Logger _logger = LogManager.getLogger(TableInfoServiceResponse.class);
    private String filter;
    private String tableName;
    private String tableLibref;
    private String tablePath;
    private String tableAccessID;
    private String tableAccessPassword;
    private String repositoryID;
    private String repositoryName;
    private List<TableColumnInfo> columns;
    private String error;
    private Node startNode;
    private boolean sessionAvailable;
    private boolean authorized;
    private boolean requestedIsAuthorized;
    private boolean inError;

    public TableInfoServiceResponse() {
    }

    public TableInfoServiceResponse(String message) throws MetadataException {
        super(message);
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public boolean hasRequestedIsAuthorized() {
        return this.requestedIsAuthorized;
    }

    private void setRequestedIsAuthorized(boolean flag) {
        this.requestedIsAuthorized = flag;
    }

    public List<TableColumnInfo> getColumns() {
        return this.columns;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isSessionAvailable() {
        return this.sessionAvailable;
    }

    public void setAuthorized(boolean flag) {
        this.setRequestedIsAuthorized(true);
        this.authorized = flag;
    }

    public void setRepositoryID(String id) {
        this.repositoryID = id;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public void setRepositoryName(String name) {
        this.repositoryName = name;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setColumns(List<TableColumnInfo> list) {
        this.columns = list;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSessionAvailable(boolean flag) {
        this.sessionAvailable = flag;
    }

    public String getError() {
        return this.error;
    }

    public boolean isInError() {
        return this.inError;
    }

    public void setError(String txt) {
        this.error = txt;
        this.setInError(true);
    }

    public void resetError() {
        this.error = null;
        this.setInError(false);
    }

    public void setInError(boolean b) {
        this.inError = b;
    }

    public void setTableName(String tbl) {
        this.tableName = tbl;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableLibref(String lib) {
        this.tableLibref = lib;
    }

    public String getTableLibref() {
        if (this.tableLibref == null) {
            return "";
        }
        return this.tableLibref;
    }

    public void setTablePath(String path) {
        this.tablePath = path;
    }

    public String getTablePath() {
        if (this.tablePath == null) {
            return "";
        }
        return this.tablePath;
    }

    public void setTableAccessID(String id) {
        this.tableAccessID = id;
    }

    public String getTableAccessID() {
        if (this.tableAccessID == null) {
            return "";
        }
        return this.tableAccessID;
    }

    public void setTableAccessPassword(String pwd) {
        this.tableAccessPassword = pwd;
    }

    public String getTableAccessPassword() {
        if (this.tableAccessPassword == null) {
            return "";
        }
        return this.tableAccessPassword;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String columnElements = null;
        if (this.columns != null && !this.columns.isEmpty()) {
            columnElements = this.buildColumnElements();
        }
        sb.append("<TableInfoServiceResponse table=\"" + this.getTableName() + "\"");
        sb.append(" libref=\"" + this.getTableLibref() + "\"");
        sb.append(" path=\"" + this.getTablePath() + "\"");
        sb.append(" accessID=\"" + this.getTableAccessID() + "\"");
        sb.append(" accessPassword=\"**************\"");
        sb.append(" reposID=\"" + this.getRepositoryID() + "\"");
        sb.append(" reposName=\"" + this.getRepositoryName() + "\"");
        sb.append(">\n");
        if (this.hasRequestedIsAuthorized()) {
            sb.append("<IsAuthorized>\n");
            sb.append(Boolean.toString(this.isAuthorized()));
            sb.append("</IsAuthorized>\n");
        }
        if (this.isInError()) {
            sb.append("<Error>\n" + this.getError() + "</" + ELEMENT_ERROR + ">\n");
        }
        if (this.filter != null && !this.isInError() && this.filter.length() > 0) {
            String tempFilter = this.getFilter();
            String filterBlock = "";
            int i = 0;
            int blockSize = 5000;
            do {
                try {
                    filterBlock = tempFilter.substring(i * blockSize, Math.min(tempFilter.length(), (i + 1) * blockSize));
                }
                catch (IndexOutOfBoundsException e) {
                    filterBlock = "";
                }
                if (!filterBlock.equals("")) {
                    sb.append("<Filter>\n" + this.wrapCDATA(filterBlock) + "</" + ELEMENT_FILTER + ">\n");
                }
                ++i;
            } while (!filterBlock.equals(""));
        }
        sb.append("<IsSessionAvailable>\n");
        sb.append(Boolean.toString(this.isSessionAvailable()));
        sb.append("</IsSessionAvailable>\n");
        if (columnElements != null && !this.isInError()) {
            sb.append(columnElements);
        }
        sb.append("</TableInfoServiceResponse>\n");
        return sb.toString();
    }

    private String buildColumnElements() {
        StringBuffer sb = new StringBuffer();
        sb.append("<AuthorizedColumns>");
        for (TableColumnInfo column : this.columns) {
            sb.append("<Column");
            sb.append(" label=\"" + column.getLabel() + "\"");
            sb.append(" type=\"" + column.getType() + "\"");
            sb.append(" length=\"" + Integer.toString(column.getLength()) + "\"");
            sb.append(" format=\"" + column.getFormat() + "\"");
            sb.append(" informat=\"" + column.getInformat() + "\">");
            sb.append(column.getName());
            sb.append("</Column>\n");
        }
        sb.append("</AuthorizedColumns>\n");
        return sb.toString();
    }

    private void findTableInfoServiceResponseNode(Node node) {
        if (ELEMENT_INFO_RESPONSE.equals(node.getNodeName())) {
            this.startNode = node;
        } else {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.findTableInfoServiceResponseNode(children.item(i));
            }
        }
    }

    @Override
    protected void create(DocumentFragment doc) throws MetadataException {
        _logger.debug("Creating TableInfoServiceResponse from XML Document.");
        NodeList items = doc.getChildNodes();
        _logger.debug("Fetching main TableInfoServiceResponse node.");
        for (int i = 0; i < items.getLength(); ++i) {
            this.startNode = null;
            this.findTableInfoServiceResponseNode(items.item(i));
            if (this.startNode != null) break;
        }
        if (ELEMENT_INFO_RESPONSE.equals(this.startNode.getNodeName())) {
            Node n;
            NamedNodeMap attrs = this.startNode.getAttributes();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Attributes from TableInfoServiceResponse: " + attrs);
            }
            if ((n = attrs.getNamedItem(ATTRIBUTE_TABLE)) != null) {
                this.setTableName(n.getNodeValue());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("set table: " + n.getNodeValue());
                }
            }
            if ((n = attrs.getNamedItem(ATTRIBUTE_LIBREF)) != null) {
                this.setTableLibref(n.getNodeValue());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("set libref: " + n.getNodeValue());
                }
            }
            if ((n = attrs.getNamedItem(ATTRIBUTE_PATH)) != null) {
                this.setTablePath(n.getNodeValue());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("set path: " + n.getNodeValue());
                }
            }
            if ((n = attrs.getNamedItem(ATTRIBUTE_ACCESS_ID)) != null) {
                this.setTableAccessID(n.getNodeValue());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("set access id: " + n.getNodeValue());
                }
            }
            if ((n = attrs.getNamedItem(ATTRIBUTE_ACCESS_PWD)) != null) {
                this.setTableAccessPassword(n.getNodeValue());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("set access pwd: " + n.getNodeValue());
                }
            }
            if ((n = attrs.getNamedItem(ATTRIBUTE_REPOSITORYID)) != null) {
                this.setRepositoryID(n.getNodeValue());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("set repository id: " + n.getNodeValue());
                }
            }
            if ((n = attrs.getNamedItem(ATTRIBUTE_REPOSITORYNAME)) != null) {
                this.setRepositoryName(n.getNodeValue());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("set repository name: " + n.getNodeValue());
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Done getting attributes from TableInfoServiceResponse.");
            }
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("TableInfoServiceResponse.ErrorDocumentFragmentInvalid.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        items = this.startNode.getChildNodes();
        _logger.debug("Retrieved main TableInfoServiceResponse node.");
        for (int i = 0; i < items.getLength(); ++i) {
            String text;
            NodeList nl;
            Node node = items.item(i);
            String tagName = node.getNodeName();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Reading in tagName: " + tagName);
            }
            if (tagName.equals(ELEMENT_FILTER)) {
                nl = node.getChildNodes();
                text = "";
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Number of child nodes: " + nl.getLength());
                }
                if (nl.getLength() > 0) {
                    text = nl.item(1).getNodeValue().trim();
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Child node text: " + text);
                }
                this.setFilter(text);
                continue;
            }
            if (tagName.equals(ELEMENT_IS_AUTHORIZED)) {
                nl = node.getChildNodes();
                text = "";
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Number of child nodes: " + nl.getLength());
                }
                if (nl.getLength() <= 0) continue;
                text = nl.item(0).getNodeValue().trim();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Child node text: " + text);
                }
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("yes")) {
                    this.setAuthorized(true);
                    continue;
                }
                this.setAuthorized(false);
                continue;
            }
            if (tagName.equals(ELEMENT_IS_SESSION_UP)) {
                nl = node.getChildNodes();
                text = "";
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Number of child nodes: " + nl.getLength());
                }
                if (nl.getLength() <= 0) continue;
                text = nl.item(0).getNodeValue().trim();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Child node text: " + text);
                }
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("yes")) {
                    this.setSessionAvailable(true);
                    continue;
                }
                this.setSessionAvailable(false);
                continue;
            }
            if (tagName.equals(ELEMENT_ERROR)) {
                nl = node.getChildNodes();
                text = "";
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Number of child nodes: " + nl.getLength());
                }
                if (nl.getLength() <= 0) continue;
                text = nl.item(0).getNodeValue().trim();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Child node text: " + text);
                }
                this.setError(text);
                this.setInError(true);
                continue;
            }
            if (!tagName.equals(ELEMENT_AUTHORIZED_COLS)) continue;
            _logger.debug("Going to get all the column info.");
            NodeList condInfo = node.getChildNodes();
            ArrayList<TableColumnInfo> list = new ArrayList<TableColumnInfo>();
            for (int ii = 0; ii < condInfo.getLength(); ++ii) {
                NamedNodeMap nodeMap;
                Node namedItem;
                Node n = condInfo.item(ii);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Node " + ii + " type: " + n.getNodeType());
                }
                if (n.getNodeType() != 1) continue;
                String subName = n.getNodeName();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("subName: " + subName);
                }
                if (!subName.equals(ELEMENT_COLUMN)) continue;
                NodeList nl2 = n.getChildNodes();
                String name = "";
                String label = "";
                String type = "";
                int length = 0;
                String format = "";
                String informat = "";
                if (nl2.getLength() > 0) {
                    name = nl2.item(0).getNodeValue().trim();
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("getting attributes for column: " + name);
                }
                if ((namedItem = (nodeMap = n.getAttributes()).getNamedItem(ATTRIBUTE_LABEL)) != null) {
                    label = namedItem.getNodeValue();
                }
                if ((namedItem = nodeMap.getNamedItem(ATTRIBUTE_TYPE)) != null) {
                    type = namedItem.getNodeValue();
                }
                if ((namedItem = nodeMap.getNamedItem(ATTRIBUTE_LENGTH)) != null) {
                    String len = namedItem.getNodeValue();
                    try {
                        length = Integer.parseInt(len);
                    }
                    catch (Exception e) {
                        length = 0;
                    }
                }
                if ((namedItem = nodeMap.getNamedItem(ATTRIBUTE_FORMAT)) != null) {
                    format = namedItem.getNodeValue();
                }
                if ((namedItem = nodeMap.getNamedItem(ATTRIBUTE_INFORMAT)) != null) {
                    informat = namedItem.getNodeValue();
                }
                TableColumnInfo colTO = new TableColumnInfo(name, label, type, length, format, informat);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Got all the column attributes." + colTO);
                }
                list.add(colTO);
            }
            if (list.isEmpty()) continue;
            this.setColumns(list);
        }
    }
}

