/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.security.BaseEventMessage;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableInfoServiceRequest
extends BaseEventMessage {
    public static final String ELEMENT_INFO_REQUEST = "TableInfoServiceRequest";
    public static final String ELEMENT_SESSION = "SessionContext";
    public static final String ELEMENT_SESSION_LOCK = "SessionLockID";
    public static final String ELEMENT_USERID = "Userid";
    public static final String ELEMENT_PASSWORD = "Password";
    public static final String ELEMENT_DOMAIN = "Domain";
    public static final String ELEMENT_TABLE_NAME = "TableName";
    public static final String ELEMENT_REPOSITORY = "Repository";
    public static final String ELEMENT_ACTIONS = "Actions";
    public static final String ELEMENT_IS_AUTHORIZED = "IsUserAuthorized";
    public static final String ELEMENT_GET_FILTER = "GetFilter";
    public static final String ELEMENT_GET_COLUMNS = "GetColumnNames";
    public static final String ELEMENT_UNLOCK = "UnlockSession";
    public static final int IS_AUTHORIZED = 0;
    public static final int GET_FILTER = 1;
    public static final int GET_COLUMNS = 2;
    public static final int UNLOCK = 99;
    private String tableName;
    private String repository;
    private String sessionContext;
    private String sessionLockID;
    private String userid;
    private String password;
    private String domain;
    private List<Integer> actions;
    private boolean unlock = false;

    public TableInfoServiceRequest() {
    }

    public TableInfoServiceRequest(String message) throws MetadataException {
        super(message);
    }

    public List<Integer> getActions() {
        return this.actions;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public void setActions(List<Integer> list) {
        this.actions = list;
    }

    public void setRepository(String repos) {
        this.repository = repos;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setUnlock(boolean flag) {
        this.unlock = flag;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSessionContext() {
        return this.sessionContext;
    }

    public String getSessionLockID() {
        return this.sessionLockID;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setDomain(String dom) {
        this.domain = dom;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public void setSessionContext(String key) {
        this.sessionContext = key;
    }

    public void setSessionLockID(String lock) {
        this.sessionLockID = lock;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public boolean hasSessionContext() {
        return this.sessionContext != null && this.sessionLockID != null;
    }

    public boolean hasUserCredentials() {
        return this.userid != null && this.password != null && this.domain != null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<TableInfoServiceRequest>");
        if (this.hasSessionContext()) {
            sb.append("<SessionContext>");
            sb.append(this.getSessionContext());
            sb.append("</SessionContext>");
            sb.append("<SessionLockID>");
            sb.append(this.getSessionLockID());
            sb.append("</SessionLockID>");
        }
        if (this.hasUserCredentials()) {
            sb.append("<Userid>");
            sb.append(this.getUserid());
            sb.append("</Userid>");
            sb.append("<Password>");
            sb.append(this.getPassword());
            sb.append("</Password>");
            sb.append("<Domain>");
            sb.append(this.getDomain());
            sb.append("</Domain>");
        }
        if (this.tableName != null) {
            sb.append("<TableName>");
            sb.append(this.getTableName());
            sb.append("</TableName>");
        }
        if (this.repository != null) {
            sb.append("<Repository>");
            sb.append(this.getRepository());
            sb.append("</Repository>");
        }
        if (this.actions != null && !this.actions.isEmpty()) {
            sb.append("<Actions>");
            for (Integer action : this.actions) {
                switch (action) {
                    case 0: {
                        sb.append("<IsUserAuthorized/>");
                        break;
                    }
                    case 1: {
                        sb.append("<GetFilter/>");
                        break;
                    }
                    case 2: {
                        sb.append("<GetColumnNames/>");
                        break;
                    }
                    case 99: {
                        sb.append("<UnlockSession/>");
                    }
                }
            }
            sb.append("</Actions>");
        }
        sb.append("</TableInfoServiceRequest>");
        return sb.toString();
    }

    @Override
    protected void create(DocumentFragment doc) throws MetadataException {
        int i;
        Node node = null;
        NodeList items = doc.getChildNodes();
        boolean found = false;
        for (i = 0; i < items.getLength(); ++i) {
            node = items.item(i);
            if (!ELEMENT_INFO_REQUEST.equals(node.getNodeName())) continue;
            items = node.getChildNodes();
            found = true;
            break;
        }
        if (!found) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("TableInfoServiceRequest.ErrorDocumentFragmentInvalid.txt", new Object[0]);
            throw new MetadataException(msg);
        }
        for (i = 0; i < items.getLength(); ++i) {
            String text;
            node = items.item(i);
            if (node.getNodeType() != 1) continue;
            String tagName = node.getNodeName();
            if (tagName.equals(ELEMENT_SESSION)) {
                text = node.getFirstChild().getNodeValue();
                this.setSessionContext(text);
            }
            if (tagName.equals(ELEMENT_SESSION_LOCK)) {
                text = node.getFirstChild().getNodeValue();
                this.setSessionLockID(text);
            }
            if (tagName.equals(ELEMENT_USERID)) {
                text = node.getFirstChild().getNodeValue();
                this.setUserid(text);
            }
            if (tagName.equals(ELEMENT_PASSWORD)) {
                text = node.getFirstChild().getNodeValue();
                this.setPassword(text);
            }
            if (tagName.equals(ELEMENT_DOMAIN)) {
                text = node.getFirstChild().getNodeValue();
                this.setDomain(text);
            }
            if (tagName.equals(ELEMENT_TABLE_NAME)) {
                text = node.getFirstChild().getNodeValue();
                this.setTableName(text);
            }
            if (tagName.equals(ELEMENT_REPOSITORY)) {
                text = node.getFirstChild().getNodeValue();
                this.setRepository(text);
            }
            if (!tagName.equals(ELEMENT_ACTIONS)) continue;
            NodeList condInfo = node.getChildNodes();
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int ii = 0; ii < condInfo.getLength(); ++ii) {
                Node n = condInfo.item(ii);
                if (n.getNodeType() != 1) continue;
                String subName = n.getNodeName();
                if (subName.equals(ELEMENT_IS_AUTHORIZED)) {
                    list.add(0);
                    continue;
                }
                if (subName.equals(ELEMENT_GET_FILTER)) {
                    list.add(1);
                    continue;
                }
                if (subName.equals(ELEMENT_GET_COLUMNS)) {
                    list.add(2);
                    continue;
                }
                if (!subName.equals(ELEMENT_UNLOCK)) continue;
                list.add(99);
            }
            if (list.isEmpty()) continue;
            this.setActions(list);
        }
        if (!this.hasSessionContext() && !this.hasUserCredentials()) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("TableInfoServiceRequest.missing.session.or.user.txt", new Object[0]);
            throw new MetadataException(msg);
        }
    }
}

