/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.impl.security.AbstractEventBrokerImpl;
import com.sas.iquery.metadata.business.impl.security.EventBrokerCredentials;
import com.sas.iquery.metadata.business.impl.security.TableInfoServiceRequest;
import com.sas.iquery.metadata.business.impl.security.TableInfoServiceResponse;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HCMSolutionEventBroker
extends AbstractEventBrokerImpl {
    private static final Logger _logger = LogManager.getLogger(HCMSolutionEventBroker.class);
    private static String SES_SERVICE_REQUESTED_EVENT_NAME = "SAS.Solutions.Service.Requested";
    private static String SES_SERVICE_REQUESTED_EVENT_TEMPLATE = "<XMLSelect search=\"Event[@Name='" + SES_SERVICE_REQUESTED_EVENT_NAME + "'][EventBrokers/ServiceComponent[@Name='Event Broker Service']/Trees/Tree[@Name='Event']/SoftwareComponents/SoftwareComponent[@Name='Remote Services']]\" />";

    HCMSolutionEventBroker(SessionContextInterface session, String sesServicesRepositoryName) throws MetadataException {
        super(session);
        if (sesServicesRepositoryName != null) {
            throw new MetadataException(HCMSolutionEventBroker.getErrorMessageNotSupportedWithRepositoryName(sesServicesRepositoryName));
        }
        throw new MetadataException(HCMSolutionEventBroker.getErrorMessageNotSupported());
    }

    @Override
    protected boolean useEntityKeyForEvent() throws MetadataException {
        return true;
    }

    @Override
    protected TableInfoServiceResponse getTableInfo(EventBrokerCredentials credentials, TableInfoServiceRequest request, DiscoveryServiceInterface discoveryService, DataSourceTable dataSourceTable) throws MetadataException {
        throw new MetadataException(HCMSolutionEventBroker.getErrorMessageNotSupported());
    }

    public static String getSolutionsRepositoryName(SessionContextInterface session) throws MetadataException {
        String sesRepositoryName;
        block9: {
            sesRepositoryName = null;
            try {
                UserContextInterface userContext = session.getUserContext();
                List userRepositories = userContext.getRepositories();
                for (Object item : userRepositories) {
                    OMIServerRepository omiRepository;
                    String repositoryAccess;
                    RepositoryInterface repository;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("user context Repository: " + item.toString());
                    }
                    if (!(item instanceof OMIRepositoryInterface) || (repository = (RepositoryInterface)item).isDestroyed() || repository instanceof OMIServerRepository && (repositoryAccess = (omiRepository = (OMIServerRepository)repository).getRepositoryAccess()) != null && repositoryAccess.trim().toUpperCase().contains("OFFLINE") || (sesRepositoryName = HCMSolutionEventBroker.getSolutionsRepository(session, repository)) == null) continue;
                    break;
                }
            }
            catch (RemoteException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQMetadataResourceBundle.getStringResource("SecurityBrokerFactory.WarnCouldDetermineSecurityBrokerType.txt"), (Throwable)e);
                }
            }
            catch (ServiceException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQMetadataResourceBundle.getStringResource("SecurityBrokerFactory.WarnCouldDetermineSecurityBrokerType.txt"), (Throwable)e);
                }
            }
            catch (MdException e) {
                if (!_logger.isEnabled(Level.ERROR)) break block9;
                _logger.error(IQMetadataResourceBundle.getStringResource("SecurityBrokerFactory.WarnCouldDetermineSecurityBrokerType.txt"), (Throwable)e);
            }
        }
        if (sesRepositoryName != null) {
            throw new MetadataException(HCMSolutionEventBroker.getErrorMessageNotSupportedWithRepositoryName(sesRepositoryName));
        }
        return sesRepositoryName;
    }

    public static String getSolutionsRepository(SessionContextInterface session, RepositoryInterface repository) throws RemoteException, MetadataException, MdException, ServiceException {
        int omrFlags = 8476;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Looking for Solutions Repository with session=" + session + ", start repository=" + repository);
        }
        List smartObjects = IQModelImplUtilities.searchRepositoryForObjectsOfTypeWithTemplate(repository, "Event", SES_SERVICE_REQUESTED_EVENT_TEMPLATE, omrFlags);
        if (_logger.isDebugEnabled() && smartObjects != null) {
            _logger.debug("Found " + smartObjects.size() + " objects to inspect");
        }
        String repositoryName = null;
        if (smartObjects != null && smartObjects.size() > 0) {
            Iterator it = smartObjects.iterator();
            while (it.hasNext() && repositoryName == null) {
                Object object = it.next();
                if (_logger.isDebugEnabled()) {
                    _logger.debug(" object=" + object + (object != null ? ", class=" + object.getClass().getName() : ""));
                }
                if (!(object instanceof MetadataInterface)) continue;
                MetadataInterface smartObject = (MetadataInterface)object;
                Object repositoryEntity = smartObject.getRepositoryEntity();
                if (_logger.isDebugEnabled()) {
                    _logger.debug(" repositoryEntity=" + repositoryEntity + (repositoryEntity != null ? ", class=" + repositoryEntity.getClass().getName() : ""));
                }
                if (!(repositoryEntity instanceof Event)) continue;
                _logger.debug(" Event object found");
                Event eventObject = (Event)repositoryEntity;
                String name = eventObject.getName();
                String id = eventObject.getId();
                if (_logger.isDebugEnabled()) {
                    _logger.debug(" Event object name=" + name + ", id=" + id);
                }
                if (name.compareToIgnoreCase(SES_SERVICE_REQUESTED_EVENT_NAME) != 0 || (repositoryName = HCMSolutionEventBroker.getRepositoryName(smartObject)) != null) continue;
                repositoryName = "Foundation";
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug(" Using default Event repository name=" + repositoryName);
            }
        }
        if (_logger.isDebugEnabled() && repositoryName == null) {
            _logger.debug("Returning null because we canot find a event broker's repository");
        }
        return repositoryName;
    }

    private static String getErrorMessageNotSupported() {
        return IQMetadataResourceBundle.getStringResource("HCMSolutionEventBroker.ErrorMessageNotSupported.txt");
    }

    private static MessageFormatter getErrorMessageNotSupportedWithRepositoryName(String sesServicesRepositoryName) {
        return IQMetadataResourceBundle.getMessageFormatter("HCMSolutionEventBroker.ErrorMessageNotSupportedWithRepositoryName.fmt.txt", sesServicesRepositoryName);
    }
}

