/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventBrokerCredentials {
    private static final Logger _logger = LogManager.getLogger(EventBrokerCredentials.class);
    private SessionContextInterface _sessionContext;
    private UserContextInterface _userContext;
    private String _userid;
    private String _password;
    private String _domain;
    private String _host;
    private String _port;

    public EventBrokerCredentials(SessionContextInterface session) throws MetadataException {
        this._sessionContext = session;
        try {
            this._userContext = session.getUserContext();
            if (_logger.isDebugEnabled()) {
                _logger.debug("found user context=" + this._userContext);
            }
        }
        catch (RemoteException e1) {
            MessageFormatter msg5 = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorGettingUserContext.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg5.toString(), (Throwable)e1);
            }
            throw new MetadataException(msg5, (Throwable)e1);
        }
        ServerInterface server = null;
        try {
            server = this._userContext.getAuthServer();
            if (_logger.isDebugEnabled()) {
                _logger.debug("using server [" + server + "]");
            }
            this._host = server.getHost();
            int portInt = server.getPort();
            this._port = Integer.toString(portInt);
            this._domain = server.getDomain();
            if (_logger.isDebugEnabled()) {
                _logger.debug("host [" + this._host + "]");
                _logger.debug("port [" + this._port + "]");
                _logger.debug("domain [" + this._domain + "]");
            }
        }
        catch (ServiceException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorGettingAuthServerInfo.fmt.txt", this._userContext);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorGettingAuthServerInfo.fmt.txt", this._userContext);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
        if (this._host == null || this._host.trim().length() == 0) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.MissingAuthServerHostValue.fmt.txt", server);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        if (this._port == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.MissingAuthServerPortValue.fmt.txt", server);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        if (this._domain == null || this._domain.trim().length() == 0) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.MissingAuthServerDomainValue.fmt.txt", server);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        UserIdentityInterface identityByDomain = null;
        try {
            identityByDomain = this._userContext.getIdentityByDomain(this.getDomain());
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorGettingIdentityByDomain.fmt.txt", this._domain, this._userContext);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new MetadataException(msg, (Throwable)e);
        }
        if (identityByDomain == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.IdentityByDomainNotFound.fmt.txt", this._domain, this._userContext);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Identity by Domain: [" + identityByDomain + "]");
        }
        this._userid = (String)identityByDomain.getPrincipal();
        this._password = (String)identityByDomain.getCredential();
        if (_logger.isDebugEnabled()) {
            _logger.debug("userid [" + this._userid + "]");
        }
        if (this._userid == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.MissingIdentityByDomainUseridValue.fmt.txt", identityByDomain, this._domain);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        if (this._password == null) {
            this._password = "";
        }
        String encPassword = "";
        if (this._password.length() > 0) {
            try {
                String encValue;
                String value = this._password;
                String valToEncrypt = null;
                try {
                    valToEncrypt = SasPasswordString.decode((String)value);
                }
                catch (Exception e) {
                    valToEncrypt = value;
                }
                encPassword = encValue = SasPasswordString.encode((String)"sas001", (String)valToEncrypt);
            }
            catch (SasPasswordEncodingException e) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorEncryptingPassword.fmt.txt", "sas001");
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)msg, (Throwable)e);
                }
                throw new MetadataException(msg, (Throwable)e);
            }
            this._password = encPassword;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("encrypted password [" + encPassword + "]");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("after scanning principles> host=" + this._host + ", port=" + this._port + ", user=" + this._userid + ", pwd=" + encPassword + ", domain" + this._domain);
        }
        if (this._host == null || this._port == null || this._userid == null || this._password == null || this._domain == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorGettingSessionContextLogin.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
    }

    public String getUserid() {
        return this._userid;
    }

    public String getPassword() {
        return this._password;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        return this._port;
    }

    public UserContextInterface getUserContext() {
        return this._userContext;
    }

    public SessionContextInterface getSessionContext() {
        return this._sessionContext;
    }
}

