/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.DataSecurityInterface;
import com.sas.iquery.metadata.business.impl.security.DataSecurityFactory;
import com.sas.iquery.metadata.business.impl.security.HCMSolutionEventBroker;
import com.sas.iquery.metadata.business.impl.security.OMATableExtensionBroker;
import com.sas.iquery.metadata.business.impl.security.RestrictedAccessBrokerImpl;
import com.sas.services.session.SessionContextInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum BrokerTypes {
    ERROR_LOADING_BROKER_INFO{

        @Override
        DataSecurityInterface newDataSecurityBroker(SessionContextInterface session) throws MetadataException {
            return new RestrictedAccessBrokerImpl(session);
        }
    }
    ,
    OMA_TABLE_EXTENSION_BROKER{

        @Override
        DataSecurityInterface newDataSecurityBroker(SessionContextInterface session) throws MetadataException {
            return new OMATableExtensionBroker(session);
        }
    }
    ,
    HCM_SOLUTION_EVENT_BROKER{

        @Override
        DataSecurityInterface newDataSecurityBroker(SessionContextInterface session) throws MetadataException {
            HCMSolutionEventBroker broker = null;
            String hcmRepository = HCMSolutionEventBroker.getSolutionsRepositoryName(session);
            if (hcmRepository != null) {
                _logger.debug("We are using Solutions for security, repository is not null");
                if (_logger.isDebugEnabled()) {
                    _logger.debug("About to get solutions security impl, session=" + session + ", repository=" + hcmRepository);
                }
                broker = new HCMSolutionEventBroker(session, hcmRepository);
            }
            return broker;
        }
    };

    private static final Logger _logger;

    abstract DataSecurityInterface newDataSecurityBroker(SessionContextInterface var1) throws MetadataException;

    static {
        _logger = LogManager.getLogger(DataSecurityFactory.class);
    }
}

