/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.DataSecurityInterface;
import com.sas.iquery.metadata.business.impl.SecuredObjectInterface;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.OMAResource;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectBase;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSecurityImpl
implements DataSecurityInterface {
    private Map<Object, Boolean> _readCache = new HashMap<Object, Boolean>();
    private static final Logger _logger = LogManager.getLogger(AbstractSecurityImpl.class);
    SessionContextInterface _session = null;

    protected abstract boolean isDataAccessible(QualifiedColumn var1) throws MetadataException;

    protected abstract boolean isDataAccessible(DataSourceTable var1) throws MetadataException;

    protected abstract String getDataFilter(DataSourceTable var1) throws MetadataException;

    public AbstractSecurityImpl(SessionContextInterface session) throws MetadataException {
        this._session = session;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    @Override
    public void destroy() throws MetadataException {
        this.cleanup(this._session);
        this._session = null;
    }

    protected synchronized void cleanup(SessionContextInterface session) throws MetadataException {
        if (this._readCache != null) {
            this._readCache.clear();
        }
    }

    public SessionContextInterface getSessionContext() {
        return this._session;
    }

    @Override
    public boolean isDataAccessible(SecuredObjectInterface securedObject) throws MetadataException {
        if (securedObject instanceof QualifiedColumn) {
            return this.isDataAccessible((QualifiedColumn)((Object)securedObject));
        }
        if (securedObject instanceof DataSourceTable) {
            return this.isDataAccessible((DataSourceTable)((Object)securedObject));
        }
        return true;
    }

    @Override
    public boolean isDataAccessible(BusinessModelObject resource) throws MetadataException {
        boolean authorized;
        BusinessModel model = resource.getBusinessModel();
        if (model == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorMustBeAddedToMap.fmt.txt", resource, resource.getIntraModelID()));
        }
        SessionContextInterface sessionContext = model.getSession();
        if (sessionContext == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorHasNoSessionContext.fmt.txt", resource, resource.getIntraModelID()));
        }
        if (resource instanceof SecuredObjectInterface && !(authorized = this.isDataAccessible((SecuredObjectInterface)((Object)resource)))) {
            return false;
        }
        List<SecuredObjectInterface> resources = resource.getResources(SecuredObjectInterface.class, 65535);
        for (int i = 0; i < resources.size(); ++i) {
            SecuredObjectInterface securedObject = resources.get(i);
            boolean authorized2 = this.isDataAccessible(securedObject);
            if (authorized2) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDataFilter(SecuredObjectInterface securedFilterableObject) throws MetadataException {
        if (securedFilterableObject instanceof DataSourceTable) {
            return this.getDataFilter((DataSourceTable)((Object)securedFilterableObject));
        }
        return "";
    }

    protected boolean hasOMRQueryReadPermission(Object startObject) throws MetadataException {
        boolean test = true;
        Boolean cachedTest = this._readCache.get(startObject);
        if (cachedTest != null) {
            test = cachedTest;
            return test;
        }
        List<Object> toCheck = this.findResourceToCheck(startObject);
        for (int i = 0; i < toCheck.size(); ++i) {
            Object obj = toCheck.get(i);
            cachedTest = this._readCache.get(obj);
            if (cachedTest != null) {
                test = cachedTest;
            } else {
                OMAResource omaResource;
                CMetadata cMetadata;
                MetadataInterface mi = null;
                if (obj instanceof JFSResource) {
                    JFSResource jfs = (JFSResource)obj;
                    mi = jfs.getMetadataInterface();
                } else if (obj instanceof OMAResource && (cMetadata = (omaResource = (OMAResource)obj).getOMAObject()) != null) {
                    mi = omaResource.getJFSObject();
                }
                if (mi != null) {
                    try {
                        boolean test2 = mi.isAuthorized("Read");
                        this._readCache.put(obj, test2);
                        if (!test2) {
                            test = test2;
                        }
                    }
                    catch (RemoteException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error("Error reading isAuthrorized on MetadataInterface of Object=" + mi, (Throwable)e);
                        }
                        throw new MetadataException(e);
                    }
                    catch (ServiceException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error("Error reading isAuthrorized on MetadataInterface of Object=" + mi, (Throwable)e);
                        }
                        throw new MetadataException(e);
                    }
                }
            }
            if (!test) break;
        }
        return test;
    }

    private List<Object> findResourceToCheck(Object startObject) throws MetadataException {
        QualifiedColumn qc;
        Column col;
        ArrayList<Object> toCheck = new ArrayList<Object>();
        toCheck.add(startObject);
        if (startObject instanceof DataSourceTable) {
            DataSourceTable dst = (DataSourceTable)startObject;
            Table table = dst.getTable();
            if (!toCheck.contains(table)) {
                toCheck.add(table);
            }
        } else if (startObject instanceof QualifiedColumn && !toCheck.contains(col = (qc = (QualifiedColumn)startObject).getColumn())) {
            toCheck.add(col);
        }
        return toCheck;
    }

    protected Table getUnderlyingTable(DataSourceTable dsTable) {
        List<Table> underlyingTables = dsTable.getResources(Table.class, 65535);
        if (underlyingTables.size() != 1) {
            return null;
        }
        Table table = underlyingTables.get(0);
        return table;
    }

    protected String getFullyQualifiedTableName(DataSourceTable dsTable) throws MetadataException {
        Table table = this.getUnderlyingTable(dsTable);
        if (table == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorGettingUnderlyingTable.fmt.txt", dsTable, dsTable.getIntraModelID()));
        }
        String dbmsName = table.getDbmsName();
        String sasName = table.getSasName();
        String label = table.getLabel();
        if (_logger.isDebugEnabled()) {
            _logger.debug("getFullyQualifiedTableName for " + dsTable.getIntraModelID() + " dbmsName=[" + dbmsName + "] sasName=[" + sasName + "] label=[" + label + "]");
        }
        String tableName = null;
        if (dbmsName != null && dbmsName.trim().length() != 0) {
            tableName = dbmsName;
            if (_logger.isDebugEnabled()) {
                _logger.debug("using dbmsName=[" + dbmsName + "]");
            }
        } else if (sasName != null && sasName.trim().length() != 0) {
            tableName = sasName;
            if (_logger.isDebugEnabled()) {
                _logger.debug("using sasName=[" + sasName + "]");
            }
        } else if (label != null && label.trim().length() != 0) {
            tableName = label;
            if (_logger.isDebugEnabled()) {
                _logger.debug("using label=[" + label + "]");
            }
        } else {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorGettingUnderlyingTable.fmt.txt", dsTable, dsTable.getIntraModelID()));
        }
        Schema schema = dsTable.getAccessPath().getSchema();
        String prefix = "";
        if (schema instanceof SASLibrary) {
            String libname = ((SASLibrary)schema).getLibref();
            if (libname != null && libname.trim().length() != 0) {
                prefix = libname + ".";
            } else if (_logger.isDebugEnabled()) {
                _logger.debug("libname is [" + libname + "] for " + schema.getIdentityString() + " will not include library prefix");
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("fully qualified name is [" + prefix + tableName + "]");
        }
        return prefix + tableName;
    }

    protected static String getRepositoryName(MetadataInterface smartObject) throws RemoteException, ServiceException, MdException {
        Object repositoryEntity;
        String repositoryName = null;
        String id = smartObject.getReposId();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Find repository for object=" + smartObject + " id=" + id);
        }
        PathUrl pathToObject = smartObject.getPathUrl();
        if (_logger.isDebugEnabled()) {
            _logger.debug("  Looking in smartObject.getPathUrl=" + pathToObject);
        }
        if (pathToObject != null && (repositoryName = pathToObject.getRepository()) != null && _logger.isDebugEnabled()) {
            _logger.debug("Returning smart object's repository, found=" + repositoryName);
        }
        if (repositoryName == null && (repositoryEntity = smartObject.getRepositoryEntity()) instanceof CMetadata) {
            CMetadata cmObject = (CMetadata)repositoryEntity;
            repositoryName = AbstractSecurityImpl.getRepositoryName((MdObjectBase)cmObject);
        }
        return repositoryName;
    }

    protected static String getRepositoryName(MdObjectBase mdObject) throws RemoteException, ServiceException, MdException {
        String repositoryName = null;
        if (mdObject != null) {
            String id = mdObject.getId();
            int index = id.indexOf(46);
            String suffix = id.substring(0, index);
            String lookforRepository = "A0000001." + suffix;
            if (_logger.isDebugEnabled()) {
                _logger.debug("   Looking in all repositories to find one with id=" + lookforRepository);
            }
            MdStore mdStore = mdObject.getObjectStore();
            if (_logger.isDebugEnabled()) {
                _logger.debug("   smartObject MdStore object=" + mdStore + (mdStore != null ? ", class=" + mdStore.getClass().getName() : ""));
            }
            MdFactory mdFactory = mdStore.getFactory();
            if (_logger.isDebugEnabled()) {
                _logger.debug("   smartObject MdFactory object=" + mdFactory + (mdFactory != null ? ", class=" + mdFactory.getClass().getName() : ""));
            }
            MdOMIUtil mdOMIUtil = mdFactory.getOMIUtil();
            if (_logger.isDebugEnabled()) {
                _logger.debug("   smartObject MdOMIUtil object=" + mdOMIUtil + (mdOMIUtil != null ? ", class=" + mdOMIUtil.getClass().getName() : ""));
            }
            List listCMetadataRepositories = mdOMIUtil.getRepositories();
            if (_logger.isDebugEnabled()) {
                _logger.debug("   smartObject MdOMIUtil CMetadataRepositories=" + listCMetadataRepositories + (listCMetadataRepositories != null ? ", class=" + listCMetadataRepositories.getClass().getName() : ""));
            }
            if (listCMetadataRepositories != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("   searching " + listCMetadataRepositories.size() + " repository defs");
                }
                Iterator iter = listCMetadataRepositories.iterator();
                while (iter.hasNext() && repositoryName == null) {
                    CMetadata repObject = (CMetadata)iter.next();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("     repository def object=" + repObject + (repObject != null ? ", class=" + repObject.getClass().getName() : ""));
                    }
                    if (!(repObject instanceof MdObjectBase)) continue;
                    CMetadata mdRepositoryObject = repObject;
                    String cmName = mdRepositoryObject.getName();
                    String cmID = mdRepositoryObject.getId();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("       CMetadata name=" + cmName + " id=" + cmID);
                    }
                    if (cmID == null || cmName == null || !cmID.equals(lookforRepository) || (repositoryName = cmName) == null || !_logger.isDebugEnabled()) continue;
                    _logger.debug("   MATCH found=" + repositoryName + " for id=" + lookforRepository);
                }
            }
        }
        return repositoryName;
    }

    public boolean isHonorTableSecurityEnabled(DataSourceTable dataSourceTable) throws MetadataException {
        OMAResource omaResource;
        CMetadata cMetadata;
        boolean ret = false;
        Table table = dataSourceTable.getTable();
        if (table instanceof OMAResource && (cMetadata = (omaResource = (OMAResource)((Object)table)).getOMAObject()) instanceof Root) {
            Root root = (Root)cMetadata;
            try {
                ret = this.isHonorTableSecurityEnabled(root);
            }
            catch (Throwable e) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorGettingTableInfo.fmt.txt", dataSourceTable, dataSourceTable.getIntraModelID());
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(msg.toString());
                }
                throw new MetadataException(msg, e);
            }
        }
        return ret;
    }

    private boolean isHonorTableSecurityEnabled(Root rootObject) throws RemoteException, MdException {
        boolean ret = false;
        List<Extension> extns = AssociationListUtil.filteredSnapshot(rootObject.getExtensions(true), Extension.class);
        if (!extns.isEmpty()) {
            boolean found = false;
            Iterator<Extension> iter = extns.iterator();
            while (iter.hasNext() && !found) {
                MessageFormatter msg;
                Extension extension = iter.next();
                String name = extension.getName();
                if (!name.equalsIgnoreCase("HonorTableSecurity") && !name.equalsIgnoreCase("Honor Table Security")) continue;
                found = true;
                String value = extension.getValue();
                if (value == null) {
                    ret = false;
                    msg = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.InfoHonorTableSecurityValueEmpty.fmt.txt", value, name, rootObject.getName());
                    if (!_logger.isInfoEnabled()) continue;
                    _logger.info(msg.toString());
                    continue;
                }
                if ((value = value.trim()).equalsIgnoreCase("Y")) {
                    ret = true;
                    if (!_logger.isDebugEnabled()) continue;
                    _logger.debug("Found value '" + value + "' for HonorTableSecurity extension '" + name + "' on OMR object '" + rootObject.getName() + "'.");
                    continue;
                }
                ret = false;
                if (value.length() > 0 && !value.equalsIgnoreCase("N")) {
                    msg = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.WarnHonorTableSecurityValueInvalid.fmt.txt", value, name, rootObject.getName());
                    if (!_logger.isEnabled(Level.WARN)) continue;
                    _logger.warn(msg.toString());
                    continue;
                }
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("Found value '" + value + "' for HonorTableSecurity extension '" + name + "' on OMR object '" + rootObject.getName() + "'.");
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("HonorTableSecurity for OMR object '" + rootObject.getName() + "' is " + ret + ".");
        }
        return ret;
    }
}

