/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl.security;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.security.AbstractSecurityImpl;
import com.sas.iquery.metadata.business.impl.security.EventBrokerCredentials;
import com.sas.iquery.metadata.business.impl.security.SolutionsRemoteContext;
import com.sas.iquery.metadata.business.impl.security.TableColumnInfo;
import com.sas.iquery.metadata.business.impl.security.TableInfoServiceRequest;
import com.sas.iquery.metadata.business.impl.security.TableInfoServiceResponse;
import com.sas.iquery.metadata.impl.SessionContextDependentCache;
import com.sas.iquery.metadata.impl.SessionContextDependentCacheException;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdObjectBase;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractEventBrokerImpl
extends AbstractSecurityImpl {
    private static final Logger _logger = LogManager.getLogger(AbstractEventBrokerImpl.class);
    public static final int TABLEINFO_ACTION_GET_IS_AUTHORIZED = 1;
    public static final int TABLEINFO_ACTION_GET_FILTER = 2;
    public static final int TABLEINFO_ACTION_GET_COLUMNS = 4;
    public static final int TABLEINFO_ACTION_UNLOCK_SESSION = 8;
    public static final int TABLEINFO_ACTION_GET_ALL = 7;
    EventBrokerCredentials _credentials = null;
    private SolutionsRemoteContext _remoteSessionAndUserContext = null;
    private String _remoteSessionAndUserContextCacheKey = null;
    private SessionContextDependentCache.SessionContextEndListener _cachedSessionListener = null;
    private static final SessionContextDependentCache _cachedSessionObjects = SessionContextDependentCache.getNewInstance();
    private static Map<String, Map<String, Object>> _contextsToAuthorizedColumns = Collections.synchronizedMap(new HashMap());
    private static Map<String, Map<String, Object>> _contextsToTableFilters = Collections.synchronizedMap(new HashMap());
    private static Map<String, Map<String, Object>> _contextsToTableAuthorizations = Collections.synchronizedMap(new HashMap());

    protected abstract boolean useEntityKeyForEvent() throws MetadataException;

    protected abstract TableInfoServiceResponse getTableInfo(EventBrokerCredentials var1, TableInfoServiceRequest var2, DiscoveryServiceInterface var3, DataSourceTable var4) throws MetadataException;

    public AbstractEventBrokerImpl(SessionContextInterface session) throws MetadataException {
        super(session);
    }

    @Override
    protected synchronized void cleanup(SessionContextInterface session) throws MetadataException {
        if (this._remoteSessionAndUserContext != null) {
            _logger.debug("cleanup RemoteUserContext and RemoteSessionContext");
            if (session != null) {
                _cachedSessionObjects.removeCachedValue(session, this._remoteSessionAndUserContextCacheKey);
            }
            this._remoteSessionAndUserContext.close();
            this._remoteSessionAndUserContext = null;
        }
        if (this._cachedSessionListener != null) {
            _logger.debug("Removed the CachedSessionEndListener.");
            if (session != null) {
                _cachedSessionObjects.removeSessionContextEndListener(session, this._cachedSessionListener, false);
            }
        }
        _contextsToAuthorizedColumns.clear();
        _contextsToTableFilters.clear();
        _contextsToTableAuthorizations.clear();
        super.cleanup(session);
    }

    @Override
    protected boolean isDataAccessible(QualifiedColumn qualifiedColumn) throws MetadataException {
        boolean isHonorTableSecurityEnabled;
        if (qualifiedColumn == null || qualifiedColumn.isUnresolved()) {
            return true;
        }
        DataSourceTable dataSourceTable = qualifiedColumn.getDataSource();
        if (dataSourceTable == null || dataSourceTable.isUnresolved()) {
            return true;
        }
        SessionContextInterface session = this.getSessionContext();
        if (session == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorSessionContextInvalid.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        String dbmsName = qualifiedColumn.getDbmsName();
        String sasName = qualifiedColumn.getSasName();
        String label = qualifiedColumn.getLabel();
        if (_logger.isDebugEnabled()) {
            _logger.debug("called isDataAccessible for " + qualifiedColumn.getIdentityString() + " dbmsName=[" + dbmsName + "] sasName=[" + sasName + "] label=[" + label + "]");
        }
        if (!(isHonorTableSecurityEnabled = this.isHonorTableSecurityEnabled(dataSourceTable))) {
            return true;
        }
        String columnName = null;
        if (dbmsName != null && dbmsName.trim().length() != 0) {
            columnName = dbmsName;
            if (_logger.isDebugEnabled()) {
                _logger.debug("using dbmsName=[" + dbmsName + "]");
            }
        } else if (sasName != null && sasName.trim().length() != 0) {
            columnName = sasName;
            if (_logger.isDebugEnabled()) {
                _logger.debug("using sasName=[" + sasName + "]");
            }
        } else if (label != null && label.trim().length() != 0) {
            columnName = label;
            if (_logger.isDebugEnabled()) {
                _logger.debug("using label=[" + label + "]");
            }
        } else {
            return false;
        }
        if (!this.isDataAccessible(dataSourceTable)) {
            return false;
        }
        ArrayList<String> authorizedColumns = (ArrayList<String>)this.getCachedObject(session, dataSourceTable, _contextsToAuthorizedColumns);
        if (authorizedColumns == null) {
            TableInfoServiceResponse infoResponse = this.getTableInfo(dataSourceTable, 4, session);
            authorizedColumns = new ArrayList<String>();
            List<TableColumnInfo> columns = infoResponse.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                TableColumnInfo column = columns.get(i);
                String authorizedColumn = column.getName();
                authorizedColumns.add(authorizedColumn);
            }
            this.putCachedObject(session, dataSourceTable, _contextsToAuthorizedColumns, authorizedColumns);
        }
        if (authorizedColumns == null || authorizedColumns.size() == 0) {
            return false;
        }
        return authorizedColumns.contains(columnName);
    }

    @Override
    protected boolean isDataAccessible(DataSourceTable dataSourceTable) throws MetadataException {
        if (dataSourceTable == null || dataSourceTable.isUnresolved()) {
            return true;
        }
        boolean isHonorTableSecurityEnabled = this.isHonorTableSecurityEnabled(dataSourceTable);
        if (!isHonorTableSecurityEnabled) {
            return true;
        }
        SessionContextInterface session = this.getSessionContext();
        if (session == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorSessionContextInvalid.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        Boolean isAuthorized = (Boolean)this.getCachedObject(session, dataSourceTable, _contextsToTableAuthorizations);
        if (isAuthorized == null) {
            TableInfoServiceResponse infoResponse = this.getTableInfo(dataSourceTable, 1, session);
            boolean tableAuthorized = infoResponse.isAuthorized();
            isAuthorized = tableAuthorized;
            this.putCachedObject(session, dataSourceTable, _contextsToTableAuthorizations, isAuthorized);
        }
        return isAuthorized;
    }

    @Override
    protected String getDataFilter(DataSourceTable dataSourceTable) throws MetadataException {
        if (dataSourceTable == null || dataSourceTable.isUnresolved()) {
            return "";
        }
        boolean isHonorTableSecurityEnabled = this.isHonorTableSecurityEnabled(dataSourceTable);
        if (!isHonorTableSecurityEnabled) {
            return "";
        }
        SessionContextInterface session = this.getSessionContext();
        if (session == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorSessionContextInvalid.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        String filterText = (String)this.getCachedObject(session, dataSourceTable, _contextsToTableFilters);
        if (filterText == null) {
            TableInfoServiceResponse infoResponse = this.getTableInfo(dataSourceTable, 2, session);
            filterText = infoResponse.getFilter();
            if (filterText == null) {
                filterText = "";
            }
            this.putCachedObject(session, dataSourceTable, _contextsToTableFilters, filterText);
        }
        return filterText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCachedObject(SessionContextInterface session, DataSourceTable dataSourceTable, Map<String, Map<String, Object>> contextTableObjectstMap) {
        String tableName;
        String contextKey = null;
        try {
            contextKey = session.getEntityKey();
        }
        catch (RemoteException e) {
            return null;
        }
        try {
            tableName = this.getFullyQualifiedTableName(dataSourceTable);
        }
        catch (MetadataException e) {
            tableName = null;
        }
        String tableKey = tableName;
        if (tableKey == null) {
            return null;
        }
        Object object = null;
        Map<String, Map<String, Object>> map = contextTableObjectstMap;
        synchronized (map) {
            Map<String, Object> tableObjects = contextTableObjectstMap.get(contextKey);
            if (tableObjects != null) {
                object = tableObjects.get(tableKey);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedObject(SessionContextInterface session, DataSourceTable dataSourceTable, Map<String, Map<String, Object>> contextTableObjectstMap, Object object) {
        String tableName;
        String contextKey = null;
        try {
            contextKey = session.getEntityKey();
        }
        catch (RemoteException e) {
            return;
        }
        try {
            tableName = this.getFullyQualifiedTableName(dataSourceTable);
        }
        catch (MetadataException e) {
            tableName = null;
        }
        String tableKey = tableName;
        if (tableKey == null) {
            return;
        }
        Map<String, Map<String, Object>> map = contextTableObjectstMap;
        synchronized (map) {
            Map<String, Object> tableObjects = contextTableObjectstMap.get(contextKey);
            if (tableObjects == null) {
                tableObjects = new HashMap<String, Object>();
                contextTableObjectstMap.put(contextKey, tableObjects);
            }
            tableObjects.put(tableKey, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInfoServiceResponse getTableInfo(DataSourceTable dsTable, int action, SessionContextInterface session) throws MetadataException {
        boolean useEntityKey = this.useEntityKeyForEvent();
        LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
        String tableQualifiedName = this.getFullyQualifiedTableName(dsTable);
        String tableRepositoryName = "";
        try {
            Table table = dsTable.getTable();
            if (table instanceof OMAWrapper) {
                OMAWrapper omaTableResource = (OMAWrapper)((Object)table);
                CMetadata omaTableObj = omaTableResource.getOMAObject();
                tableRepositoryName = AbstractEventBrokerImpl.getRepositoryName((MdObjectBase)omaTableObj);
            }
        }
        catch (Throwable e1) {
            MessageFormatter msg1 = IQMetadataResourceBundle.getMessageFormatter("AbstractSecurityImpl.ErrorGettingRepositoryName.fmt.txt", dsTable.getLabel(), dsTable.getIntraModelID());
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg1.toString(), e1);
            }
            throw new MetadataException(msg1, e1);
        }
        EventBrokerCredentials credentials = this.getEventBrokerCredentials(session);
        ArrayList<Integer> actions = new ArrayList<Integer>();
        if ((action & 8) > 0) {
            actions.add(99);
        }
        if ((action & 1) > 0) {
            actions.add(0);
        }
        if ((action & 2) > 0) {
            actions.add(1);
        }
        if ((action & 4) > 0) {
            actions.add(2);
        }
        TableInfoServiceRequest request = new TableInfoServiceRequest();
        request.setRepository(tableRepositoryName);
        request.setTableName(tableQualifiedName);
        request.setActions(actions);
        TableInfoServiceResponse infoResponse = null;
        try {
            if (useEntityKey) {
                String remoteSessionEntityKey = null;
                String remoteSessionLockID = null;
                try {
                    String remoteEntityKey = this.getRemoteEntityKey(credentials, session, (DiscoveryServiceInterface)discoveryService);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("remote entityKey: " + remoteEntityKey);
                    }
                    remoteSessionEntityKey = remoteEntityKey;
                    remoteSessionLockID = "SolutionsSecurityImpl - " + credentials.getUserid() + "@" + credentials.getDomain();
                }
                catch (Throwable e2) {
                    MessageFormatter msg2 = IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorGettingRemoteEntityKey.fmt.txt", credentials.getUserid(), credentials.getDomain());
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(msg2.toString(), e2);
                    }
                    throw new MetadataException(msg2, e2);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("entity=" + remoteSessionEntityKey + ", lockid=" + remoteSessionLockID);
                }
                request.setSessionContext(remoteSessionEntityKey);
                request.setSessionLockID(remoteSessionLockID);
            } else {
                request.setUserid(credentials.getUserid());
                request.setPassword(credentials.getPassword());
                request.setDomain(credentials.getDomain());
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("request=" + request.toString());
            }
            infoResponse = this.getTableInfo(credentials, request, (DiscoveryServiceInterface)discoveryService, dsTable);
        }
        finally {
            _logger.debug("getTableInfo() finally block - Removing remote session from cache, destroy user and session context and cleanup session entity key.");
            this.cleanup(session);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("response=" + infoResponse);
        }
        return infoResponse;
    }

    private EventBrokerCredentials getEventBrokerCredentials(SessionContextInterface session) throws MetadataException {
        if (this._credentials == null) {
            this._credentials = new EventBrokerCredentials(session);
        }
        return this._credentials;
    }

    private synchronized String getRemoteEntityKey(EventBrokerCredentials credentials, SessionContextInterface session, DiscoveryServiceInterface discoveryService) throws ServiceException, RemoteException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("1.newRemoteEntityKey() - " + this._remoteSessionAndUserContext);
        }
        if (this._remoteSessionAndUserContext == null) {
            String remoteSessionAndUserContextCacheKey = SolutionsRemoteContext.class.getName() + "-" + credentials.getDomain() + "/" + credentials.getUserid();
            this._remoteSessionAndUserContext = this.getCachedSessionAndUserContext(session, remoteSessionAndUserContextCacheKey);
            if (_logger.isDebugEnabled()) {
                _logger.debug("2.newRemoteEntityKey() - " + this._remoteSessionAndUserContext);
            }
            if (this._remoteSessionAndUserContext == null) {
                this._remoteSessionAndUserContextCacheKey = remoteSessionAndUserContextCacheKey;
                this._remoteSessionAndUserContext = new SolutionsRemoteContext(discoveryService, credentials.getUserContext());
                if (_logger.isDebugEnabled()) {
                    _logger.debug("3.newRemoteEntityKey() - " + this._remoteSessionAndUserContext);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("using session key=" + session);
                    _logger.debug("    and cache key=" + this._remoteSessionAndUserContextCacheKey);
                    _logger.debug("caching remote session=" + this._remoteSessionAndUserContext);
                }
                try {
                    this._cachedSessionListener = new SessionContextDependentCache.SessionContextEndListener(){

                        @Override
                        public void sessionEnd(SessionContextInterface session) {
                            _logger.debug("In SessionContextEndListener sessionEnd ");
                            try {
                                AbstractEventBrokerImpl.this.cleanup(session);
                            }
                            catch (Throwable e) {
                                _logger.error(e.getMessage(), e);
                            }
                        }
                    };
                    _cachedSessionObjects.put(session, this._remoteSessionAndUserContextCacheKey, this._remoteSessionAndUserContext, this._cachedSessionListener);
                }
                catch (SessionContextDependentCacheException e) {
                    _logger.debug("could not cache Remote Session and User Context", (Throwable)e);
                }
            }
        }
        String remoteEntityKey = this._remoteSessionAndUserContext.getRemoteEntityKey();
        return remoteEntityKey;
    }

    protected synchronized void removeCachedValueAndObjects(SessionContextInterface session, String cacheKey) {
        _cachedSessionObjects.removeCachedValue(session, cacheKey);
        if (_logger.isDebugEnabled()) {
            Object verify = _cachedSessionObjects.get(session, cacheKey);
            _logger.debug("Remove CachedSecurityBroker - " + verify);
        }
    }

    private synchronized SolutionsRemoteContext getCachedSessionAndUserContext(SessionContextInterface session, String cacheKey) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("using session key=" + session);
            _logger.debug("    and cache key=" + cacheKey);
        }
        SolutionsRemoteContext remoteSessionAndUserContext = (SolutionsRemoteContext)_cachedSessionObjects.get(session, cacheKey);
        if (_logger.isDebugEnabled()) {
            _logger.debug("cached remote session=" + remoteSessionAndUserContext);
        }
        return remoteSessionAndUserContext;
    }

    TableInfoServiceResponse newTableInfoServiceResponse(String eventReplyText) throws MetadataException {
        int end;
        if (_logger.isDebugEnabled()) {
            _logger.debug("EventReply=[" + eventReplyText + "]");
        }
        String bodyText = null;
        int start = eventReplyText.indexOf("<TableInfoServiceResponse ");
        if (start != -1 && (end = eventReplyText.indexOf("</TableInfoServiceResponse>", start)) != -1) {
            bodyText = eventReplyText.substring(start, end + 27);
        }
        if (bodyText == null) {
            ArrayMessageFormatter msg = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getMessageFormatter("SolutionsSecurityImpl.ErrorCannotParseResponse.txt", new Object[0]), eventReplyText);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString() + "\n" + eventReplyText);
            }
            throw new MetadataException(msg);
        }
        TableInfoServiceResponse infoResponse = new TableInfoServiceResponse(bodyText);
        return infoResponse;
    }
}

