/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.XMLV2;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class XMLV2PeepholeOptimizer {
    private Element _modelElement;
    private HashMap<String, String> _internalPersistenceIDsReferencedXMLWide;
    public static char POST_RELATIONSHIP_CHAR = (char)58;
    private static final String prefix = "Column:ReposColumn:x";

    XMLV2PeepholeOptimizer(Element modelElement, HashMap<String, String> internalPersistenceIDsReferencedXMLWide) {
        this._modelElement = modelElement;
        this._internalPersistenceIDsReferencedXMLWide = internalPersistenceIDsReferencedXMLWide;
    }

    void optimize() throws MetadataException {
        ExtraLoggingContexts.debugLogWriteFlowDetails("start peephole optimizations");
        ExtraLoggingContexts.debugLogWriteFlowDetails("start collapsing most Use-elements");
        this.collapseMostUseElements(this._modelElement);
        ExtraLoggingContexts.debugLogWriteFlowDetails("end   collapsing most Use-elements");
        ExtraLoggingContexts.debugLogWriteFlowDetails("start shrinking data source columns");
        this.shrinkDataSourceColumns(this._modelElement);
        ExtraLoggingContexts.debugLogWriteFlowDetails("end   shrinking data source columns");
        ExtraLoggingContexts.debugLogWriteFlowDetails("start removing unreferenced persistence IDs");
        this.removeUnreferencedInternalPersistenceIDs(this._modelElement);
        ExtraLoggingContexts.debugLogWriteFlowDetails("end   removing unreferenced persistence IDs");
        ExtraLoggingContexts.debugLogWriteFlowDetails("end   peephole optimizations");
    }

    private void collapseMostUseElements(Element objectElement) throws MetadataException {
        int nextRefIndex = 1;
        List<Element> relationshipElements = IQModelImplUtilities.getSubelements(objectElement);
        int relationshipElementCount = relationshipElements.size();
        for (int i = 0; i < relationshipElementCount; ++i) {
            Element relationshipElement = relationshipElements.get(i);
            List<Element> objOrObjUseElements = IQModelImplUtilities.getSubelements(relationshipElement);
            int objCount = objOrObjUseElements.size();
            boolean collapseThisRelationshipElement = true;
            for (int j = 0; j < objCount && collapseThisRelationshipElement; ++j) {
                Element objOrObjUseElement = objOrObjUseElements.get(j);
                collapseThisRelationshipElement = XMLV2.isIQObjectUseElement(objOrObjUseElement);
            }
            if (collapseThisRelationshipElement && objCount > 0) {
                String attrName = "ref" + nextRefIndex;
                this.collapseRelationshipElementIntoAttr(objectElement, relationshipElement, objOrObjUseElements, attrName);
                ++nextRefIndex;
                continue;
            }
            this.walkDownFurther(objOrObjUseElements);
        }
    }

    private void walkDownFurther(List<Element> objOrObjUseElements) throws MetadataException {
        int count = objOrObjUseElements.size();
        for (int i = 0; i < count; ++i) {
            Element objElement = objOrObjUseElements.get(i);
            if (!XMLV2.isIQObjectOrObjectUseElement(objElement)) continue;
            this.collapseMostUseElements(objElement);
        }
    }

    private void collapseRelationshipElementIntoAttr(Element objectElement, Element relationshipElement, List<Element> objUseElements, String attrName) {
        int size = objUseElements.size();
        StringBuffer attrValueBuf = new StringBuffer(size * 50);
        attrValueBuf.append(relationshipElement.getTagName());
        attrValueBuf.append(POST_RELATIONSHIP_CHAR);
        String runningType = "";
        for (int i = 0; i < size; ++i) {
            Element objUseElement = objUseElements.get(i);
            String useElementName = objUseElement.getTagName();
            String uselessElementName = useElementName.substring(0, useElementName.length() - 3);
            String persistenceID = IQModelImplUtilities.getAttr(objUseElement, "ref");
            if (persistenceID == null) {
                throw new IQueryServicesRuntimeException("no persistence ID found");
            }
            if (i == 0) {
                attrValueBuf.append(uselessElementName);
                attrValueBuf.append(':');
            } else if (IQModelImplUtilities.same(runningType, uselessElementName)) {
                attrValueBuf.append(',');
            } else {
                attrValueBuf.append(';');
                attrValueBuf.append(uselessElementName);
                attrValueBuf.append(':');
            }
            runningType = uselessElementName;
            attrValueBuf.append(persistenceID);
            relationshipElement.removeChild(objUseElement);
        }
        objectElement.removeChild(relationshipElement);
        IQModelImplUtilities.setAttr(objectElement, attrName, attrValueBuf.toString());
    }

    private void shrinkDataSourceColumns(Element objectElement) throws MetadataException {
        block9: {
            block10: {
                Element colElement;
                int i;
                List<Element> columnsElements;
                int size;
                if (!XMLV2.isIQObjectOrObjectUseElement(objectElement)) break block9;
                String elementName = objectElement.getTagName();
                if (!"DataSourceTable".equals(elementName)) break block10;
                Element dstElement = objectElement;
                Element columnsElement = IQModelImplUtilities.getFirstSubelementNamed(objectElement, "Columns");
                if (columnsElement == null || (size = (columnsElements = IQModelImplUtilities.getSubelements(columnsElement)).size()) <= 0) break block9;
                StringBuffer sb = new StringBuffer();
                boolean okToOptimize = true;
                for (i = 0; i < size && okToOptimize; ++i) {
                    colElement = columnsElements.get(i);
                    if (i != 0) {
                        sb.append(';');
                    }
                    if (!"DSColumn".equals(colElement.getTagName())) {
                        okToOptimize = false;
                        continue;
                    }
                    String objAttr = IQModelImplUtilities.getAttr(colElement, "obj");
                    if (objAttr == null) {
                        okToOptimize = false;
                        continue;
                    }
                    sb.append(objAttr);
                    sb.append(',');
                    String refnAttr = IQModelImplUtilities.getAttr(colElement, "ref1");
                    if (refnAttr == null) {
                        okToOptimize = false;
                        continue;
                    }
                    if (refnAttr.startsWith(prefix)) {
                        String physRef = refnAttr.substring(prefix.length() - 1);
                        sb.append(physRef);
                        continue;
                    }
                    okToOptimize = false;
                }
                if (!okToOptimize) break block9;
                IQModelImplUtilities.setAttr(dstElement, "dataSourceColumnMappings", sb.toString());
                for (i = 0; i < size && okToOptimize; ++i) {
                    colElement = columnsElements.get(i);
                    columnsElement.removeChild(colElement);
                }
                dstElement.removeChild(columnsElement);
                break block9;
            }
            List<Element> relationshipSubelements = IQModelImplUtilities.getSubelements(objectElement);
            int relCount = relationshipSubelements.size();
            for (int i = 0; i < relCount; ++i) {
                Element relationshipSubelement = relationshipSubelements.get(i);
                List<Element> objOrObjUseSubelements = IQModelImplUtilities.getSubelements(relationshipSubelement);
                int objCount = objOrObjUseSubelements.size();
                for (int j = 0; j < objCount; ++j) {
                    Element objOrObjUseSubelement = objOrObjUseSubelements.get(j);
                    this.shrinkDataSourceColumns(objOrObjUseSubelement);
                }
            }
        }
    }

    private void removeUnreferencedInternalPersistenceIDs(Element objOrObjUseElement) throws MetadataException {
        if (XMLV2.isIQObjectOrObjectUseElement(objOrObjUseElement)) {
            String persistenceID = IQModelImplUtilities.getAttr(objOrObjUseElement, "obj");
            if (persistenceID != null && persistenceID.startsWith("a") && !this._internalPersistenceIDsReferencedXMLWide.containsKey(persistenceID)) {
                IQModelImplUtilities.removeAttr(objOrObjUseElement, "obj");
            }
            List<Element> relationshipElements = IQModelImplUtilities.getSubelements(objOrObjUseElement);
            int relCount = relationshipElements.size();
            for (int i = 0; i < relCount; ++i) {
                Element relationshipElement = relationshipElements.get(i);
                List<Element> objOrObjUseSubelements = IQModelImplUtilities.getSubelements(relationshipElement);
                int objCount = objOrObjUseSubelements.size();
                for (int j = 0; j < objCount; ++j) {
                    Element objOrObjUseSubelement = objOrObjUseSubelements.get(j);
                    this.removeUnreferencedInternalPersistenceIDs(objOrObjUseSubelement);
                }
            }
        }
    }
}

