/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Base;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.QueryWriteOption;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.FlattenedExternalResources;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.StructuredExternalResources;
import com.sas.iquery.metadata.business.impl.UnsynchronizedStack;
import com.sas.iquery.metadata.business.impl.XMLV2;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.OMAResource;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.util.LocalizableString;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.impl.BaseIntegratedWritingContext;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public final class WritingContext
implements AbstractModel.ModelWritingInputInterface,
AbstractModel.ModelWritingResults {
    private AbstractModel _modelBeingWritten;
    private IdentityHashMap _objsWritten;
    private IdentityHashMap _persistenceIDAssignments;
    private HashMap<Locale, PropertyList> _localizablePropertyMap;
    private HashMap _internalPersistenceIDsReferenced;
    private FlattenedExternalResources _externalResources;
    private ArrayList _lazyWriteRequests = new ArrayList();
    private DataItemActionType _missingDataItemUsage = null;
    private IQIntegratedWritingContext _integratedWritingContext;
    private LoggerFactoryInterface _promptsLogger;
    private XMLWideWritingContext _xmlWideContext;
    private Element _modelElement;
    private PromptsWritingContext _reusedPromptsWritingContext;
    private static final Logger _logger = LogManager.getLogger(WritingContext.class);
    private static final Logger _perfWFDLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.writeflow.details");
    static final String INTERNAL_PERSISTENCEID_PREFIX = "a";
    static final String EXTERNAL_PERSISTENCEID_PREFIX = "x";

    public WritingContext(AbstractModel modelBeingWritten, AbstractModel.ModelWritingInput input) {
        this._modelBeingWritten = modelBeingWritten;
        this._xmlWideContext = new XMLWideWritingContext(modelBeingWritten, input);
        this.allocateStorage(modelBeingWritten);
    }

    private WritingContext(AbstractModel modelBeingWritten, WritingContext outerContext) {
        this._modelBeingWritten = modelBeingWritten;
        this._xmlWideContext = outerContext._xmlWideContext;
        this.allocateStorage(this._xmlWideContext.getOutermostModel());
    }

    WritingContext transitionToWritingInnerModel(AbstractModel innerModel, boolean writingOutermostModel) {
        WritingContext writingContextForModel = null;
        writingContextForModel = writingOutermostModel ? this : new WritingContext(innerModel, this);
        this._xmlWideContext._activeModelContexts.push(writingContextForModel);
        this._xmlWideContext._allModelContexts.add(writingContextForModel);
        return writingContextForModel;
    }

    void transitionToWritingOuterModel(Element innerModelElement) {
        List resources = this._externalResources.getMetadataRepositoryResourcesList();
        this._xmlWideContext._allReferencedReposResources.addAll(resources);
        WritingContext outerContext = (WritingContext)this._xmlWideContext._activeModelContexts.pop();
        outerContext._modelElement = innerModelElement;
    }

    private void allocateStorage(AbstractModel outermostModel) {
        int initialSize = 100;
        this._objsWritten = new IdentityHashMap(initialSize);
        this._persistenceIDAssignments = new IdentityHashMap(initialSize);
        this._internalPersistenceIDsReferenced = new HashMap(initialSize / 5);
        this._externalResources = new FlattenedExternalResources(this._modelBeingWritten, outermostModel);
        this._localizablePropertyMap = new HashMap(initialSize);
    }

    AbstractModel getModel() {
        return this._modelBeingWritten;
    }

    boolean hasBeenWritten(AbstractBase object) {
        return this._objsWritten.containsKey(object);
    }

    public void markObjAsWritten(Base object) {
        if (this._objsWritten.containsKey(object)) {
            MessageFormatter errMsg = IQMetadataResourceBundle.getMessageFormatter("WritingContext.WroteTwice.fmt.txt", object.getClass().getName());
            throw new IQueryServicesRuntimeException(errMsg);
        }
        this._objsWritten.put(object, null);
    }

    boolean testForAndAccumulateExternalObject(AbstractBase base) throws MetadataException {
        return this._externalResources.add(base);
    }

    StructuredExternalResources getStructuredExternalResources(IdentityHashMap resourceConstraints) throws MetadataException {
        return this._externalResources.getStructuredForm(resourceConstraints);
    }

    List getFlattenedOMAResources() {
        List out = this._externalResources.getMetadataRepositoryResourcesList();
        IQModelImplUtilities.filterListInPlace(out, OMAResource.class);
        return out;
    }

    public void markInternalPersistenceIDReferenced(String persistenceID) {
        this._internalPersistenceIDsReferenced.put(persistenceID, null);
        this._xmlWideContext._internalPersistenceIDsReferencedXMLWide.put(persistenceID, null);
    }

    HashMap trustedGetInternalPersistenceIDsReferencedXMLWide() {
        return this._xmlWideContext._internalPersistenceIDsReferencedXMLWide;
    }

    public String getInternalPersistenceIDFor(AbstractBase object) {
        String persistenceID = (String)this._persistenceIDAssignments.get(object);
        if (persistenceID == null && object.isReferrableToWithinModel()) {
            persistenceID = this.newInternalPersistenceID();
            this._persistenceIDAssignments.put(object, persistenceID);
        }
        return persistenceID;
    }

    String getInternalPersistenceIDForWritingReferenceTo(AbstractBase object) throws MetadataException {
        String persistenceID = this.getInternalPersistenceIDFor(object);
        if (persistenceID == null) {
            MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("WritingContext.UnexpectedPersistenceError.ReferredToUnreferrableObject.fmt.txt", object.getClass().getName());
            throw new MetadataException(message);
        }
        return persistenceID;
    }

    public String getExternalPersistenceIDFor(Base object) {
        String persistenceID = (String)this._persistenceIDAssignments.get(object);
        if (persistenceID == null) {
            persistenceID = this.newExternalPersistenceID();
            this._persistenceIDAssignments.put(object, persistenceID);
        }
        return persistenceID;
    }

    private String newInternalPersistenceID() {
        return INTERNAL_PERSISTENCEID_PREFIX + Integer.toString(this._xmlWideContext._nextInternalPersistenceIDNumber++);
    }

    private String newExternalPersistenceID() {
        return EXTERNAL_PERSISTENCEID_PREFIX + Integer.toString(this._xmlWideContext._nextExternalPersistenceIDNumber++);
    }

    private void verifyNoReferencesToNonexistingTargets(Element modelElement) throws MetadataException {
        Set keys = this._persistenceIDAssignments.keySet();
        for (AbstractBase base : keys) {
            if (this._objsWritten.containsKey(base)) continue;
            String persistenceID = (String)this._persistenceIDAssignments.get(base);
            if (_perfWFDLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogWriteFlowDetails(IQModelImplUtilities.toPrettyString(modelElement, 0));
            }
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("WritingContext.PersistenceIdReferencedButNotAssignedError.fmt.txt", persistenceID, base.getClass().getName()));
        }
    }

    public void adjustModelVersion(ModelVersion inputVersion) {
        if (this._xmlWideContext._modelVersionWhileWriting.earlierThan(inputVersion)) {
            this._xmlWideContext._modelVersionWhileWriting = inputVersion;
        }
    }

    @Override
    public boolean isWriteOperationToGetVersionOnly() {
        return this._xmlWideContext._input.isWriteOperationToGetVersionOnly();
    }

    @Override
    public boolean isWriteOperationToOMR() {
        return this._xmlWideContext._input.isWriteOperationToOMR();
    }

    String addReferencedPrivatePrompt(OMRPromptDefinitionInterface promptSmartObject) {
        this._xmlWideContext.addReferencedPrivatePrompt(promptSmartObject);
        String persistenceID = (String)this._xmlWideContext._persistenceIDAssignmentsForMetadataAssociatedObjects.get(promptSmartObject);
        if (persistenceID == null) {
            persistenceID = this.newExternalPersistenceID();
            this._xmlWideContext._persistenceIDAssignmentsForMetadataAssociatedObjects.put(promptSmartObject, persistenceID);
        }
        return persistenceID;
    }

    @Override
    public OMIRepositoryInterface getRepository() {
        return this._xmlWideContext._input.getRepository();
    }

    boolean shouldWriteExternalLocation(AbstractModel referencedModel) {
        return !this.isWriteOperationToGetVersionOnly() && this._xmlWideContext.getOutermostModel() != referencedModel;
    }

    public String getXMLTimestampToMillisecond(Date timestamp) {
        return this._xmlWideContext._timestampFormatter.format(timestamp);
    }

    void queueToWriteRelatedItemsOnlyIfUsedWithinModel(List objs, Element element, String newSubelementName) throws MetadataException {
        this._lazyWriteRequests.add(new LazyWriteRequest(objs, element, newSubelementName));
    }

    void processQueuedLazyWriteRequests() throws MetadataException {
        int size = this._lazyWriteRequests.size();
        for (int i = 0; i < size; ++i) {
            LazyWriteRequest request = (LazyWriteRequest)this._lazyWriteRequests.get(i);
            this.processOneRequest(request);
        }
    }

    private void processOneRequest(LazyWriteRequest request) throws MetadataException {
        List objs = request.getObjects();
        Element underElement = request.getUnderElement();
        String newSubelementName = request.getNewSubelementName();
        Element newSubelement = null;
        int size = objs.size();
        for (int i = 0; i < size; ++i) {
            AbstractBase base = (AbstractBase)objs.get(i);
            String persistenceID = (String)this._persistenceIDAssignments.get(base);
            if (persistenceID == null || !this._internalPersistenceIDsReferenced.containsKey(persistenceID)) continue;
            if (newSubelement == null) {
                newSubelement = IQModelImplUtilities.newSubelement(underElement, newSubelementName);
            }
            base.writeDefinitionUnder(newSubelement, this, persistenceID);
        }
    }

    public DataItemActionType getMissingDataItemUsage() {
        return this._missingDataItemUsage;
    }

    public void setMissingDataItemUsage(DataItemActionType usage) {
        this._missingDataItemUsage = usage;
    }

    void finalizeWritingOfModels() throws MetadataException {
        ExtraLoggingContexts.debugLogWriteFlowDetails("start handling lazy write requests");
        this.processQueuedLazyWriteRequests();
        ExtraLoggingContexts.debugLogWriteFlowDetails("end   handling lazy write requests");
        ExtraLoggingContexts.debugLogWriteFlowDetails("start writing external resources");
        int modelCount = this._xmlWideContext._allModelContexts.size();
        for (int i = 0; i < modelCount; ++i) {
            WritingContext writingContext = (WritingContext)this._xmlWideContext._allModelContexts.get(i);
            AbstractModel model = writingContext._modelBeingWritten;
            Element modelElement = writingContext._modelElement;
            IdentityHashMap resourceConstraints = model.getResourceConstraints();
            StructuredExternalResources extResources = writingContext.getStructuredExternalResources(resourceConstraints);
            if (extResources.topLevelResourceCount() > 0) {
                Element xrefElement = IQModelImplUtilities.newSubelement(modelElement, "ExternalResources");
                extResources.writeDirectlyUnderElement(xrefElement, writingContext);
            }
            if (model == this._modelBeingWritten) {
                this._xmlWideContext.writeExternalAssociatedPrompts(this._modelElement);
            }
            ExtraLoggingContexts.debugLogWriteFlowDetails("end   writing external resources");
            ExtraLoggingContexts.debugLogWriteFlowDetails("start verifying what was written references no unwritten targets");
            this.verifyNoReferencesToNonexistingTargets(modelElement);
            ExtraLoggingContexts.debugLogWriteFlowDetails("end   verifying what was written references no unwritten targets");
            ExtraLoggingContexts.debugLogWriteFlowDetails("start reordering main subelements");
            IQModelImplUtilities.reorderMainSubelements(modelElement, model.getStartingOrderOfMainSubelements());
            ExtraLoggingContexts.debugLogWriteFlowDetails("end   reordering main subelements");
        }
    }

    IQIntegratedWritingContext getIntegratedWritingContext() throws MetadataException {
        if (this._integratedWritingContext == null) {
            this._integratedWritingContext = new IQIntegratedWritingContext(this);
            this._integratedWritingContext.setServer(this._modelBeingWritten.getAuthServer());
        }
        return this._integratedWritingContext;
    }

    LoggerFactoryInterface getPromptsLogger() {
        if (this._promptsLogger == null) {
            SessionContextInterface session = this._modelBeingWritten.getSession();
            this._promptsLogger = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)session);
        }
        return this._promptsLogger;
    }

    PromptsWritingContext newPromptsWritingContext(Map optionsMap) throws MetadataException {
        LoggerFactoryInterface promptsLogger = this.getPromptsLogger();
        IQIntegratedWritingContext iqiwc = this.getIntegratedWritingContext();
        PromptsWritingContext promptWritingContext = PersistenceFactory.newWritingContext(null, (LoggerFactoryInterface)promptsLogger, (IntegratedWritingContext)iqiwc);
        promptWritingContext.setOptionsMap(optionsMap);
        return promptWritingContext;
    }

    PromptsWritingContext getReusedPromptsWritingContext(Map optionsMap) throws MetadataException {
        if (this._reusedPromptsWritingContext == null) {
            this._reusedPromptsWritingContext = this.newPromptsWritingContext(optionsMap);
        }
        this._reusedPromptsWritingContext.setOptionsMap(optionsMap);
        return this._reusedPromptsWritingContext;
    }

    void setElement(Element modelElement) {
        this._modelElement = modelElement;
    }

    public void addLocalizableString(String key, LocalizableString locStr) {
        List locales = locStr.getLocales();
        for (Locale loc : locales) {
            PropertyList propList = this._localizablePropertyMap.get(loc);
            if (propList == null) {
                propList = new PropertyList();
                this._localizablePropertyMap.put(loc, propList);
            }
            propList.addProperty(key, locStr.getText(loc));
        }
    }

    @Override
    public HashMap<Locale, PropertyList> getPropertyMap() {
        return this._localizablePropertyMap;
    }

    @Override
    public Element getElement() {
        return this._modelElement;
    }

    @Override
    public ModelVersion getModelVersion() {
        return this._xmlWideContext._modelVersionWhileWriting;
    }

    @Override
    public List getMetadataRepositoryResources() {
        List out = this._xmlWideContext._allReferencedReposResources.toList();
        IQModelImplUtilities.filterListInPlace(out, MetadataRepositoryResource.class);
        return out;
    }

    @Override
    public List getPrivateExternalPromptsNeedingAssociations() {
        return this._xmlWideContext.getReferencedPrivatePrompts();
    }

    void addReferencedBriefInfoMap(MetadataInterface smartObject) {
        if (smartObject instanceof BriefInformationMap) {
            this._xmlWideContext._refdBriefInfoMaps.add(smartObject);
        }
    }

    @Override
    public List getReferencedInfoMaps() {
        return this._xmlWideContext._refdBriefInfoMaps.toList();
    }

    public Map<QueryWriteOption, Object> getWritingOptions() {
        return this._xmlWideContext._input.getWritingOptions();
    }

    public void registerResources(AbstractBase base) throws MetadataException {
        this._externalResources.add(base);
    }

    private static class XMLWideWritingContext {
        private int _nextInternalPersistenceIDNumber = 2;
        private int _nextExternalPersistenceIDNumber = 1;
        private ModelVersion _modelVersionWhileWriting = ModelVersion.VERSION_92;
        private AbstractModel.ModelWritingInput _input;
        private HashMap _internalPersistenceIDsReferencedXMLWide = new HashMap();
        private UnsynchronizedStack _activeModelContexts = new UnsynchronizedStack();
        private ArrayList _allModelContexts = new ArrayList();
        private IdentityList _allReferencedReposResources = new IdentityList();
        private IdentityList _refdBriefInfoMaps = new IdentityList();
        private AbstractModel _outermostModel;
        private final SimpleDateFormat _timestampFormatter = XMLV2.newXMLTimestampFormatterParser();
        private IdentityList _referencedPrivatePrompts = new IdentityList();
        private IdentityHashMap _persistenceIDAssignmentsForMetadataAssociatedObjects = new IdentityHashMap();

        XMLWideWritingContext(AbstractModel outermostModel, AbstractModel.ModelWritingInput input) {
            this._outermostModel = outermostModel;
            this._input = input;
        }

        public List getReferencedPrivatePrompts() {
            return this._referencedPrivatePrompts.toList();
        }

        public void addReferencedPrivatePrompt(OMRPromptDefinitionInterface obj) {
            this._referencedPrivatePrompts.add(obj);
            this._input.getCleanupInfo().addNewPrivatePromptCreated(obj);
        }

        AbstractModel getOutermostModel() {
            return this._outermostModel;
        }

        private void writeExternalAssociatedPrompts(Element mostOuterElement) throws MetadataException {
            int size = this._referencedPrivatePrompts.size();
            if (size > 0) {
                Element privateResourcesElement = IQModelImplUtilities.newSubelement(mostOuterElement, "ExternalAssociatedPrompts");
                for (int i = 0; i < size; ++i) {
                    Element associatedPromptElement = IQModelImplUtilities.newSubelement(privateResourcesElement, "AssociatedPrompt");
                    Object prompt = this._referencedPrivatePrompts.get(i);
                    String persistenceID = (String)this._persistenceIDAssignmentsForMetadataAssociatedObjects.get(prompt);
                    IQModelImplUtilities.setAttr(associatedPromptElement, "obj", persistenceID);
                }
            }
        }
    }

    static class LazyWriteRequest {
        List _objs;
        Element _underElement;
        String _newSubelementName;

        LazyWriteRequest(List objs, Element underElement, String newSubelementName) {
            this._objs = objs;
            this._underElement = underElement;
            this._newSubelementName = newSubelementName;
        }

        List getObjects() {
            return this._objs;
        }

        Element getUnderElement() {
            return this._underElement;
        }

        String getNewSubelementName() {
            return this._newSubelementName;
        }
    }

    private class IQIntegratedWritingContext
    extends BaseIntegratedWritingContext
    implements IntegratedWritingContext {
        private WritingContext _internalWritingContext;

        private IQIntegratedWritingContext(WritingContext internalWritingContext) {
            this._internalWritingContext = internalWritingContext;
        }

        public String getReference(Object obj) {
            String out;
            block5: {
                out = null;
                try {
                    if (obj instanceof AbstractBase) {
                        String persistenceID;
                        AbstractBase ourObject = (AbstractBase)obj;
                        String type = ourObject.getDefinitionElementName();
                        if (WritingContext.this.testForAndAccumulateExternalObject(ourObject)) {
                            persistenceID = this._internalWritingContext.getExternalPersistenceIDFor(ourObject);
                        } else {
                            persistenceID = this._internalWritingContext.getInternalPersistenceIDForWritingReferenceTo(ourObject);
                            this._internalWritingContext.markInternalPersistenceIDReferenced(persistenceID);
                        }
                        out = type + ':' + persistenceID;
                    }
                }
                catch (MetadataException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return out;
        }
    }
}

