/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Base;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.FlattenedExternalResources;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.RelatedObjectList;
import com.sas.iquery.metadata.business.impl.ResourceConstraint;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class StructuredExternalResources {
    private AbstractModel _model;
    private IdentityHashMap _orderedStructureReflectedInXML;
    private IdentityList _topLevelResources;
    private static final Logger _logger = LogManager.getLogger(StructuredExternalResources.class);
    private ResourceConstraint _singleConstraint = new ResourceConstraint();

    StructuredExternalResources(AbstractModel externalResourcesForThisModel) {
        this._model = externalResourcesForThisModel;
    }

    void initializeWithUsedResources(FlattenedExternalResources resourcesUsedDuringWriting, IdentityHashMap resourceConstraints) throws MetadataException {
        this._orderedStructureReflectedInXML = new IdentityHashMap();
        this._topLevelResources = new IdentityList();
        this.initMetadataReposResources(resourcesUsedDuringWriting, resourceConstraints);
        this.initModelItemResources(resourcesUsedDuringWriting);
        this.initModelResources(resourcesUsedDuringWriting);
        this.validateResourceUsage();
    }

    void initializeWithUnresolvedResources(List topLevelUnresolvedExternalResources) {
        this._orderedStructureReflectedInXML = new IdentityHashMap();
        this._topLevelResources = new IdentityList(topLevelUnresolvedExternalResources);
        int size = topLevelUnresolvedExternalResources.size();
        for (int i = 0; i < size; ++i) {
            AbstractBase topLevelResource = (AbstractBase)topLevelUnresolvedExternalResources.get(i);
            topLevelResource.recursivelyNoteRelationshipsWithOtherUnresolvedResources(this._orderedStructureReflectedInXML);
        }
    }

    private void initMetadataReposResources(FlattenedExternalResources flattenedResources, IdentityHashMap resourceLocationConstraints) throws MetadataException {
        IdentityList reposResources = flattenedResources.getMetadataRepositoryResources();
        IdentityList objsAlreadyProcessed = new IdentityList(reposResources.size() + 20);
        for (int i = 0; i < reposResources.size(); ++i) {
            MetadataRepositoryResource reposResource = (MetadataRepositoryResource)reposResources.get(i);
            if (objsAlreadyProcessed.contains(reposResource)) continue;
            objsAlreadyProcessed.add(reposResource);
            ResourceConstraint constrainedLocation = this.getConstraint(reposResource, resourceLocationConstraints);
            if (constrainedLocation != null) {
                Base constrainer = constrainedLocation.getConstrainer();
                reposResources.add(constrainer);
                ArrayList<RelatedObjectList> listOfRols = (ArrayList<RelatedObjectList>)this._orderedStructureReflectedInXML.get(constrainer);
                if (listOfRols == null) {
                    listOfRols = new ArrayList<RelatedObjectList>();
                    this._orderedStructureReflectedInXML.put(constrainer, listOfRols);
                }
                String relationshipName = constrainedLocation.getRelationshipName();
                RelatedObjectList rolToUse = null;
                for (int j = 0; j < listOfRols.size(); ++j) {
                    RelatedObjectList rol = (RelatedObjectList)listOfRols.get(j);
                    if (!rol.getRelationshipName().equals(relationshipName)) continue;
                    rolToUse = rol;
                }
                if (rolToUse == null) {
                    rolToUse = new RelatedObjectList(relationshipName);
                    listOfRols.add(rolToUse);
                }
                Base constrainee = constrainedLocation.getConstrainee();
                rolToUse.add(constrainee);
            } else {
                this._topLevelResources.add(reposResource);
            }
            if (this._orderedStructureReflectedInXML.containsKey(reposResource)) continue;
            this._orderedStructureReflectedInXML.put(reposResource, null);
        }
    }

    private ResourceConstraint getConstraint(MetadataRepositoryResource reposResource, IdentityHashMap resourceLocationConstraints) throws MetadataException {
        String relationshipName;
        ModelItem constrainer;
        ResourceConstraint location = (ResourceConstraint)resourceLocationConstraints.get(reposResource);
        if (location == null && (constrainer = reposResource.getConstrainingResource()) != null && (relationshipName = reposResource.getRelationshipNameFromKnownConstrainer()) != null) {
            this._singleConstraint.setConstrainee(reposResource);
            this._singleConstraint.setConstrainer(constrainer);
            this._singleConstraint.setRelationshipName(relationshipName);
            location = this._singleConstraint;
        }
        return location;
    }

    private void initModelItemResources(FlattenedExternalResources flattenedResources) throws MetadataException {
        IdentityList flattenedModelItemResources = flattenedResources.getModelItemResources();
        AbstractModel baseModel = this._model.getParent();
        for (int i = 0; i < flattenedModelItemResources.size(); ++i) {
            AbstractModelItem modelItem = (AbstractModelItem)flattenedModelItemResources.get(i);
            AbstractBase constrainer = baseModel;
            String constrainedRelationshipName = "ReferencedItems";
            if (!this._orderedStructureReflectedInXML.containsKey(modelItem)) {
                this._orderedStructureReflectedInXML.put(modelItem, null);
            }
            if (modelItem instanceof QualifiedColumn) {
                QualifiedColumn qc = (QualifiedColumn)((Object)modelItem);
                DataSourceTable dst = (DataSourceTable)qc.getOwningTable();
                flattenedModelItemResources.add(dst);
                constrainer = (AbstractBase)((Object)dst);
                constrainedRelationshipName = "Columns";
            }
            if (constrainer == null) continue;
            ArrayList<RelatedObjectList> listOfROLs = (ArrayList<RelatedObjectList>)this._orderedStructureReflectedInXML.get(constrainer);
            if (listOfROLs == null) {
                listOfROLs = new ArrayList<RelatedObjectList>();
                this._orderedStructureReflectedInXML.put(constrainer, listOfROLs);
            }
            RelatedObjectList rolToUse = null;
            for (int j = 0; j < listOfROLs.size(); ++j) {
                RelatedObjectList rol = (RelatedObjectList)listOfROLs.get(j);
                if (!rol.getRelationshipName().equals(constrainedRelationshipName)) continue;
                rolToUse = rol;
                break;
            }
            if (rolToUse == null) {
                rolToUse = new RelatedObjectList(constrainedRelationshipName);
                listOfROLs.add(rolToUse);
            }
            rolToUse.add(modelItem);
        }
    }

    private void initModelResources(FlattenedExternalResources flattenedResources) {
        IdentityList flattenedModelResources = flattenedResources.getModelResources();
        int size = flattenedModelResources.size();
        for (int i = 0; i < size; ++i) {
            AbstractModel model = (AbstractModel)flattenedModelResources.get(i);
            if (!this._orderedStructureReflectedInXML.containsKey(model)) {
                this._orderedStructureReflectedInXML.put(model, null);
            }
            this._topLevelResources.add(model);
        }
    }

    private void validateResourceUsage() throws MetadataException {
        ArrayList<String> modelIDs = new ArrayList<String>();
        int size = this._topLevelResources.size();
        for (int i = 0; i < size; ++i) {
            Object obj = this._topLevelResources.get(i);
            if (obj instanceof AbstractModel) {
                AbstractModel model = (AbstractModel)obj;
                modelIDs.add(model.getID());
                continue;
            }
            if (!(obj instanceof MetadataRepositoryResource) || obj instanceof SoftwareServer) continue;
            MetadataRepositoryResource amrr = (MetadataRepositoryResource)obj;
            MessageFormatter mf = IQModelImplUtilities.getMessageFormatter("StructuredExternalResources.ObjectDoesNotHaveProperParentageToBeWritten.fmt.txt", amrr.getIdentityString());
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(mf.toString());
            }
            throw new MetadataException(mf);
        }
        if (modelIDs.size() > 1) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("StructuredExternalResources.CannotReferenceMoreThanOneExternalModel.fmt.txt", new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, modelIDs.toArray())));
        }
    }

    int topLevelResourceCount() {
        return this._topLevelResources.size();
    }

    void writeDirectlyUnderElement(Element parentElement, WritingContext writingContext) throws MetadataException {
        IdentityList writtenAlready = new IdentityList();
        int size = this._topLevelResources.size();
        for (int i = 0; i < size; ++i) {
            AbstractBase topLevelExternalObject = (AbstractBase)this._topLevelResources.get(i);
            this.writeExternalReferenceAndRelatedObjects(parentElement, topLevelExternalObject, this._orderedStructureReflectedInXML, writtenAlready, writingContext);
        }
    }

    private void writeExternalReferenceAndRelatedObjects(Node parentNode, AbstractBase objToWrite, IdentityHashMap externalReferencesToRelatedObjects, IdentityList writtenAlready, WritingContext writingContext) throws MetadataException {
        if (!writtenAlready.contains(objToWrite)) {
            Element xrefElement = objToWrite.writeExternalReferenceUnder(parentNode, writingContext);
            writtenAlready.add(objToWrite);
            List listOfRelatedObjectLists = (List)externalReferencesToRelatedObjects.get(objToWrite);
            if (listOfRelatedObjectLists != null) {
                for (int i = 0; i < listOfRelatedObjectLists.size(); ++i) {
                    RelatedObjectList rol = (RelatedObjectList)listOfRelatedObjectLists.get(i);
                    if (rol == null) continue;
                    String relationshipName = rol.getRelationshipName();
                    List<Object> contents = rol.getObjects();
                    if ((objToWrite instanceof OMATable || objToWrite instanceof InMemoryTable) && relationshipName.equals("Columns")) {
                        OMATable.writeReposColumns(xrefElement, contents, writingContext);
                        continue;
                    }
                    Element relationshipElement = IQModelImplUtilities.newSubelement(xrefElement, relationshipName);
                    for (int j = 0; j < contents.size(); ++j) {
                        AbstractModelItem subItem = (AbstractModelItem)contents.get(j);
                        this.writeExternalReferenceAndRelatedObjects(relationshipElement, subItem, externalReferencesToRelatedObjects, writtenAlready, writingContext);
                    }
                }
            }
        }
    }

    List getModelResources() {
        List out = this._topLevelResources.toList();
        IQModelImplUtilities.filterListInPlace(out, AbstractModel.class);
        return out;
    }

    List getMetadataRepositoryResources() {
        ArrayList out = new ArrayList(this._orderedStructureReflectedInXML.keySet());
        IQModelImplUtilities.filterListInPlace(out, MetadataRepositoryResource.class);
        return out;
    }

    List getModelItemResources(AbstractModel modelResource) throws MetadataException {
        List<Object> out = null;
        List listOfROLS = (List)this._orderedStructureReflectedInXML.get(modelResource);
        for (int j = 0; j < listOfROLS.size() && out == null; ++j) {
            RelatedObjectList rol = (RelatedObjectList)listOfROLS.get(j);
            if (!rol.getRelationshipName().equals("ReferencedItems")) continue;
            out = rol.getObjects();
        }
        if (out == null) {
            out = new ArrayList();
        }
        ArrayList<Column> allUnresolvedQualifiedColumns = new ArrayList<Column>();
        for (int i = 0; i < out.size(); ++i) {
            AbstractModelItem item = (AbstractModelItem)out.get(i);
            if (!(item instanceof DataSourceTable)) continue;
            List<Column> unresolvedCols = ((DataSourceTable)((Object)item)).getColumns();
            allUnresolvedQualifiedColumns.addAll(unresolvedCols);
        }
        if (allUnresolvedQualifiedColumns.size() > 0) {
            out.addAll(allUnresolvedQualifiedColumns);
        }
        return out;
    }
}

